
    <form method="post" style="display: none;">
        <input type="hidden" name="files">
    </form>
    <script src="<?=base_url()?>assets/js/jquery-1.12.4.min.js"></script>
    <script src="<?=base_url()?>assets/plugins/chartJs/chart.min.js"></script>
    <script src="<?=base_url()?>assets/plugins/html2canvas/html2canvas.min.js"></script>
    <!-- Bootstrap JavaScript -->
    <script src="<?=base_url()?>assets/js/bootstrap.min.js"></script>
    <script src="<?=base_url()?>assets/plugins/grid-chart/rating-chart.js"></script>
    <script>
    var objectives_summary_chart = behaviors_summary_chart = performance_summary_chart = final_rating_chart = null;
    var rChartColors = {
        1: 'red',
        2: 'blue'
    }
    images = {};
    var generated = 0;
    var rChart = new Rating_chart('rating-chart-summary', JSON.parse(
        '<?= addslashes(json_encode(array_column($rating['data'], 'label'))) ?>'));
    <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
    rChart.add(<?= $num ?>, '<?= $scoring_block ?>', rChartColors[<?= $num ?>])
    rChart.set(<?= $num ?>, <?= $objectives_average[$num] ?>, <?= $behavior_average[$num] ?? 0?>)
    <?php endforeach ?>

    function final_average() {
        let vals = {
            sum: 0,
            num: 0
        };
        let n = 0;
        <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
        n = parseFloat($('.final_rating_average_<?= $num ?>').text());
        vals.sum += (n ? n : 0);
        vals.num++;
        <?php endforeach ?>
        return vals.sum / vals.num
    }

    function objectives_dataset() {
        return [{
                label: '<?= display('Expected') ?>',
                backgroundColor: "#d04f58",
                data: [<?= implode(', ', array_fill(0, count($objectives), $max_score)) ?>]
            },
            <?php foreach ($scoring_blocks as $num => $scoring_block): ?> {
                label: '<?= $scoring_block ?>',
                backgroundColor: "#<?= $num < 2 ? '7a8aa9' : '05253a' ?>",
                data: [<?php foreach ($objectives as $c => $objective): ?>
                    parseFloat($('.objective_scoring_block_<?= $num ?><?= $objective->id ?>')
                        .text()) <?= $c < (count($objectives) - 1) ? ', ' : null ?>
                    <?php endforeach ?>
                ]
            },
            <?php endforeach ?>
        ];
    }

    function behaviors_dataset() {
        return [{
                label: '<?= display('Expected') ?>',
                backgroundColor: "#d04f58",
                data: [<?= implode(', ', array_fill(0, count($behaviors), $max_score)) ?>]
            },
            <?php foreach ($scoring_blocks as $num => $scoring_block): ?> {
                label: '<?= $scoring_block ?>',
                backgroundColor: "#<?= $num < 2 ? '7a8aa9' : '05253a' ?>",
                data: [<?php foreach ($behaviors as $c => $behavior): ?>
                    parseFloat($('.behavior_scoring_block_<?= $num ?><?= $behavior->id ?>')
                        .text()) <?= $c < (count($behaviors) - 1) ? ', ' : null ?>
                    <?php endforeach ?>
                ]
            },
            <?php endforeach ?>
        ]
    }

    function final_rating_dataset() {
        return [{
            label: '<?= display('Earned') ?>',
            backgroundColor: "#d04f58",
            data: [{
                x: final_average(),
                y: final_average(),
                r: 30
            }]
        }, {
            label: '<?= display('Rating') ?>',
            backgroundColor: "#7a8aa9",
            data: [
                <?php for ($i=0; $i <= $max_score + 1; $i++): ?> {
                    x: <?= $i ?>,
                    y: <?= $i ?>,
                    r: <?= $i == 0 || $i == ($max_score + 1) ? 0 : 30 ?>
                }
                <?= $i != ($max_score + 1) ? ', ' : null ?>
                <?php endfor ?>
            ]
        }]
    }

    function performance_dataset() {
        return [{
            label: '',
            data: [
                <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
                parseFloat($('.final_rating_average_<?= $num ?>')
                    .text()) <?= $num < count($scoring_blocks) ? ', ' : null ?>
                <?php endforeach ?>
            ]
        }]
    }
    function chart_done() {
        images[this.chart.canvas.id] = this.toBase64Image()
        generated++
    }
    $(function() {
        var $pages = $('.chart-for-images');
        $pages.each(function() {
            html2canvas(this).then((canvas) => {
                let width = $(this).innerWidth;
                let height = $(this).innerHeight;
                images[$(this).data('id')] = canvas.toDataURL('image/png')
                generated++
            }).catch((e) => {
                alert(
                    '<?= display(['Error', 'while', 'exporting', 'evaluation', 'report']) ?>, <?= display(['try', 'again']) ?>'
                );
                throw e
            })
        })
        const interval_timer = setInterval(() => {
            if (generated == ($pages.length + 4)) {
                clearInterval(interval_timer)
                $('[name=files]').val(btoa(JSON.stringify(images)))
                $('[name=files]').closest('form').trigger('submit')
                parent.hide_loader()
                setTimeout(() => {
                    parent.closeIFrame('report') 
                }, 2000);
            }
        }, 1000);
    });
    var ctx_objectives_summary_chart = document.getElementById("objectives_summary_chart").getContext("2d");
    var ctx_behaviors_summary_chart = document.getElementById("behaviors_summary_chart").getContext("2d");
    var ctx_performance_summary_chart = document.getElementById("performance_summary_chart").getContext("2d");
    var ctx_final_rating_chart = document.getElementById("final_rating_chart").getContext("2d");
    var objectives_data = {
        labels: JSON.parse('<?= addslashes(json_encode(array_column($objectives, 'label'))) ?>'),
        datasets: objectives_dataset()
    };
    var behaviors_data = {
        labels: JSON.parse('<?= addslashes(json_encode(array_column($behaviors, 'label'))) ?>'),
        datasets: behaviors_dataset()
    };
    var performance_data = {
        labels: JSON.parse('<?= addslashes(json_encode(array_values($scoring_blocks))) ?>'),
        datasets: performance_dataset()
    };
    var final_rating_data = {
        datasets: final_rating_dataset()
    };

    objectives_summary_chart = new Chart(ctx_objectives_summary_chart, {
        type: 'bar',
        data: objectives_data,
        options: {
            title: {
                display: true,
                text: '<?= display('Objectives') ?>'
            },
            scales: {
                yAxes: [{
                    ticks: {
                        min: 0,
                    }
                }]
            },
            animation: {
                onComplete: chart_done
            }
        }
    });
    behaviors_summary_chart = new Chart(ctx_behaviors_summary_chart, {
        type: 'bar',
        data: behaviors_data,
        options: {
            title: {
                display: true,
                text: '<?= display('Behaviors') ?>'
            },
            scales: {
                yAxes: [{
                    ticks: {
                        min: 0,
                    }
                }]
            },
            animation: {
                onComplete: chart_done
            }
        }
    });
    performance_summary_chart = new Chart(ctx_performance_summary_chart, {
        type: 'line',
        data: performance_data,
        options: {
            title: {
                display: true,
                text: '<?= display(['Change', 'in', 'performance', 'level']) ?>'
            },
            legend: {
                display: false
            },
            scales: {
                yAxes: [{
                    ticks: {
                        min: 0,
                    }
                }]
            },
            animation: {
                onComplete: chart_done
            }
        }
    });
    final_rating_chart = new Chart(ctx_final_rating_chart, {
        type: 'bubble',
        data: final_rating_data,
        options: {
            title: {
                display: true,
                text: '<?= display(['Final', 'Rating']) ?>'
            },
            scales: {
                yAxes: [{
                    ticks: {
                        min: 0,
                    }
                }]
            },
            animation: {
                onComplete: chart_done
            }
        }
    });
    </script>