<style>
td.custom_action_class>a {
    margin: 3px 0;
}
</style>
<div class="container-fluid">
    <div class="row">
        <form method="post" id="filter_form">
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="selNum"><?= display(['report', 'type']) ?></label>
                        <select class="form-control" name="num" id="selNum">
                            <option value=""><?= display(['Select', 'One']) ?></option>
                            <?php foreach ($scoring_blocks as $sc_num => $sc_block) :?>
                            <option value="<?= $sc_num ?>"><?= $sc_block ?></option>
                            <?php endforeach?>
                        </select>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="selPeriod"><?= display(['period']) ?></label>
                        <select class="form-control" name="period" id="selPeriod">
                            <option value=""><?= display(['Select', 'One']) ?></option>
                            <?php foreach ($selection_years as $sel_year) :?>
                            <option value="<?= $sel_year ?>"><?= $sel_year ?></option>
                            <?php endforeach?>
                        </select>
                    </div>
                </div>
                <div class="col-md-12 text-right">
                    <button type="submit" class="btn btn-primary"><?= display('Filter') ?></button>
                    <button type="button" class="btn btn-danger btn-reset"><?= display('Reset') ?></button>
                </div>
            </div>
        </form>
    </div>
    <br>
    <div class="row">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th><?= display('period') ?></th>
                    <th><?= display(['report', 'type']) ?></th>
                    <th><?= display('hrm_id') ?></th>
                    <th><?= display(['employee', 'name']) ?></th>
                    <th><?= display('status') ?></th>
                    <th><?= display('deadline') ?></th>
                    <th class="hideexport"><?= display('action') ?></th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>
<script>
$(document).ready(function() {
    window.dtable = $('table.table').DataTable($.extend({},
        window.default_datatable_opts, {
            responsive: false,
            processing: true,
            serverSide: true,
            ajax: {
                method: 'post',
                data: function(data) {
                    data.period = $('#selPeriod').val();
                    data.num = $('#selNum').val();
                },
                beforeSend: function() {},
                complete: function() {}
            },
            columns: [{
                    'data': 'year',
                },
                {
                    'data': 'type',
                },
                {
                    'data': 'hrm_id',
                },
                {
                    'data': 'first_name',
                },
                {
                    'data': 'status',
                },
                {
                    'data': 'next_deadline',
                },
                {
                    'data': 'action',
                    'sortable': false,
                    'className': 'custom_action_class'
                }
            ],
            order: [
                [5, 'asc']
            ]
        }
    ))
});
$('table.table').on('click', '.btn-download', function(e) {
    e.preventDefault()
    window.show_loader()
    $('body').append(
        `<iframe id="printframe-report" src="<?= base_url() ?>employee/evaluation/export/${$(this).data('id')}" style="hidden; width: 100%" frameborder="0"></iframe>`
    )
})
$('table.table').on('click', '.btn-reload-data', function(e) {
    if (confirm(
            '<?= display(['Are', 'you', 'sure', 'you', 'want', 'to', 'refresh', 'this', 'report', 'data', '?'], true) ?>'
        )) {
        myajax({
            type: "GET",
            url: "<?= base_url() ?>/employee/evaluation/refresh/" + $(this).data('id'),
            success: function(res) {

                if (res.success) {
                    Swal.fire(
                        '<?= display('success') ?>!',
                        res.success,
                        'success'
                    )
                    location.reload()
                } else if (res.error) {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error,
                        'error'
                    )
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        '<?= display(['Unknown', 'server', 'error', ',', 'try', 'again'], true) ?>',
                        'error'
                    )
                }
            }
        });
    }
})
$('form#filter_form').on('submit', function(e) {
    e.preventDefault();
    window.dtable.ajax.reload()
})
$('form#filter_form').on('click', '.btn-reset', function(e) {
    e.preventDefault();
    $('#selNum').val('').trigger('change')
    $('#selPeriod').val('').trigger('change')
    window.dtable.ajax.reload()
    toastr.info('<?= display(['Filter', 'is', 'cleared']) ?>')
})
</script>