<div class="container-fluid">
    <?php if($this->permission->method('eval_employee_roles', 'create')->access()): ?>
    <div class="row">
        <button type="button" class="btn btn-primary pull-right btn-add"><?= display('add') ?> <?= $title ?></button>
    </div>
    <br>
    <?php endif;?>
    <div class="row">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th><?= display('title') ?></th>
                    <th><?= display('description') ?></th>
                    <?php if ($this->permission->method('eval_employee_roles', 'update')->access() || $this->permission->method('eval_employee_roles', 'delete')->access()): ?>
                    <th class="hideexport"><?= display('action') ?></th>
                    <?php endif?>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="model-save" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><span class="action"></span> <?= $title ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="#" method="post">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="txtTitle" class="required"><?= display('title') ?></label>
                        <input type="text" class="form-control" name="label" id="txtTitle">
                    </div>
                    <div class="form-group">
                        <label for="txtDesc"><?= display('description') ?></label>
                        <textarea class="form-control" maxlength="45" name="description" id="txtDesc" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary"
                        data-dismiss="modal"><?= display('close') ?></button>
                    <button type="submit" class="btn btn-primary"><?= display('save') ?></button>
                </div>
            </form>
        </div>
    </div>
</div>
<script>
var item = {
    id: null,
    label: '',
    description: ''
}
$(document).ready(function() {
    window.dtable = $('table').DataTable($.extend({}, window.default_datatable_opts, {
        responsive: false,
        processing: true,
        serverSide: true,
        ajax: {
            method: 'post',
            beforeSend: function() {},
        },
        columns: [{
                'data': 'label',
            }, {
                'data': 'description',
            },
            <?php if ($this->permission->method('eval_employee_roles', 'update')->access() || $this->permission->method('eval_employee_roles', 'delete')->access()): ?> {
                'data': 'action',
                'className': 'action-buttons',
                'sortable': false
            },
            <?php endif ?>
        ],
    }))
    $('#model-save form').on('submit', function(e) {
        e.preventDefault();
        let $model = $('#model-save');
        let $form = $('#model-save form');
        item.label = $form.find('[name=label]').val();
        item.description = $form.find('[name=description]').val();
        myajax({
            type: "POST",
            url: "<?= base_url() ?>employee/evaluation/employee_roles_rest",
            data: item,
            beforeSend: () => {
                $form.find('span.error').remove()
            },
            success: function(res) {
                if (res.success) {
                    item = {
                        id: null,
                        label: '',
                        description: ''
                    }
                    window.dtable.ajax.reload()
                    $model.modal('hide')
                    Swal.fire(
                        '<?= display('success') ?>!',
                        res.success,
                        'success'
                    )
                } else if (res.error) {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error,
                        'error'
                    )
                } else if (res.errors) {
                    res.errors.forEach(err => {
                        $form.find(`[name=${err[0]}]`).closest('div').append(
                            `<span class="error">${err[1]}</span>`)
                    });
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        '<?= display('invalid_request') ?>',
                        'error'
                    )
                }
            }
        });
    })
    $('.btn-add').on('click', function(e) {
        let $model = $('#model-save');
        $model.find('.modal-title>.action').text('<?= display('add') ?>');
        $model.modal('show')
    })
    $('table').on('click', '.btn-edit', function(e) {
        e.preventDefault()
        let $model = $('#model-save');
        let $this = $(this);
        $model.find('.modal-title>.action').text('<?= display('update') ?>');
        myajax({
            type: "GET",
            url: "<?= base_url() ?>employee/evaluation/employee_roles_rest/" + $this.data('id'),
            success: function(res) {
                if (res.success) {
                    item = res.success;
                    window.dtable.ajax.reload()
                    $model.modal('show')
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error,
                        'error'
                    )
                }
            }
        });
    })
    $('table').on('click', '.btn-delete', function(e) {
        e.preventDefault()
        let $this = $(this);
        Swal.fire({
            title: '<?= addslashes(display('delete_confirm_title')) ?>',
            html: '<?= addslashes(display('delete_confirm_description')) ?>',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: '<?= addslashes(display('delete_confirm_yes_button')) ?>',
            confirmCancelText: '<?= addslashes(display('delete_confirm_cancel_button')) ?>'
        }).then((result) => {
            if (result.isConfirmed) {
                myajax({
                    type: "DELETE",
                    url: "<?= base_url() ?>employee/evaluation/employee_roles_rest/" +
                        $this.data('id'),
                    success: function(res) {
                        if (res.success) {
                            window.dtable.ajax.reload()
                            Swal.fire(
                                '<?= display('success') ?>!',
                                res.success,
                                'success'
                            )
                        } else {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                res.error,
                                'error'
                            )
                        }
                    }
                });
            }
        })
    })
    $("#model-save").on('show.bs.modal', function() {
        let $model = $(this);
        $model.find('[name=label]').val(item.label)
        $model.find('[name=description]').val(item.description)
    });
    $("#model-save").on('hidden.bs.modal', function() {
        item = {
            id: null,
            label: '',
            description: ''
        }
        $(this).find("span.error").remove()
    });
});
</script>