<div class="container-fluid">
    <form action="#" method="post">
        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <label for="txtTitle" class="required"><?= display('title') ?></label>
                    <input type="text" maxlength="45" class="form-control" name="label" id="txtTitle" value="<?= set_value('label') ?>">
                </div>
            </div>
            <div class="col-md-12">
                <div class="form-group">
                    <label for="txtDesc"><?= display('description') ?></label>
                    <textarea class="form-control" name="description" id="txtDesc"
                        rows="3"><?= set_value('description') ?></textarea>
                </div>
            </div>
        </div>
        <div class="row">
            <h4><?= display('applies_to') ?></h4>
            <hr>
            <div class="row">
                <div class="col-sm-4">
                    <div class="form-check">
                        <label class="form-check-label">
                            <input type="radio" class="form-check-input" name="all_departments" value="1" <?= set_radio('all_departments', 1, true) ?>>
                            <?= display('all_departments') ?>
                        </label>
                    </div>
                    <div class="form-check">
                        <label class="form-check-label">
                            <input type="radio" class="form-check-input" name="all_departments" value="0" <?= set_radio('all_departments', 0) ?>>
                            <?= display('selected_departments') ?>
                        </label>
                    </div>
                </div>
                <div class="col-sm-8 global-selections" style="display: none;">
                    <div class="form-group">
                        <select id="selDept" class="form-control dont-select-me" name="departments[]" multiple
                            style="width: 100%;">
                            <?php foreach ($departments as $department) :?>
                            <option value="<?= $department->id ?>" <?= set_select('departments', $department->id) ?>><?= $department->name ?></option>
                            <?php endforeach?>
                        </select>
                    </div>
                </div>
            </div>
            <br>
            <div class="row global-selections" style="display: none;">
                <div class="col-sm-4">
                    <div class="form-check">
                        <label class="form-check-label">
                            <input type="radio" class="form-check-input" name="all_positions" value="1" <?= set_radio('all_positions', 1, true) ?>>
                            <?= display('all_positions') ?>
                        </label>
                    </div>
                    <div class="form-check">
                        <label class="form-check-label">
                            <input type="radio" class="form-check-input" name="all_positions" value="0" <?= set_radio('all_positions', 0) ?>>
                            <?= display('selected_positions') ?>
                        </label>
                    </div>
                </div>
                <div class="col-sm-8 global-selections-positions" style="display: none;">
                    <div class="form-group">
                        <select id="selPos" class="form-control dont-select-me" name="positions[]" multiple style="width: 100%;">
                            <?php foreach ($positions as $position) :?>
                            <option value="<?= $position->id ?>"<?= set_select('positions', $position->id) ?>><?= $position->name ?></option>
                            <?php endforeach?>
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <?php if($roles): ?>
        <br>
        <br>
        <div class="row">
            <h4><?= display('role_specific_behavioral_definitions') ?></h4>
            <hr>
            <?php foreach ($roles as $role) :?>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="txtDesc<?= $role->id ?>"><?= $role->label ?></label>
                    <textarea class="form-control tiny_textarea" name="role[<?= $role->id ?>]"
                        id="txtDesc<?= $role->id ?>" rows="3"><?= set_value('role[' . $role->id .']') ?></textarea>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif?>
        <button type="submit" class="btn btn-success pull-right"><?= display('save') ?></button>
    </form>
</div>
<script src="<?= base_url() ?>assets/plugins/tinymce/tinymce.min.js"></script>
<script src="<?= base_url() ?>assets/plugins/tinymce/jquery.tinymce.min.js"></script>
<script>
tinymce.init({
    selector: 'textarea.tiny_textarea',
    height: 300,
    paste_remove_styles: true,
    paste_as_text: true,
    plugins: 'print preview paste importcss searchreplace autolink autosave save directionality code visualblocks visualchars fullscreen table charmap hr pagebreak nonbreaking anchor toc insertdatetime advlist lists wordcount textpattern noneditable help charmap emoticons',
    menubar: false,
    toolbar: 'undo redo | numlist bullist | bold italic underline strikethrough | forecolor backcolor removeformat | pagebreak | charmap emoticons | fullscreen  preview save print | ltr rtl',
    toolbar_sticky: true,
    remove_script_host: false,
    autosave_ask_before_unload: true,
    autosave_interval: '30s',
    autosave_prefix: '{path}{query}-{id}-',
    autosave_restore_when_empty: true,
    autosave_retention: '2m',
    noneditable_noneditable_class: 'mceNonEditable',
    toolbar_mode: 'sliding',
    contextmenu: false,
    content_style: 'body { font-family:Helvetica,Arial,sans-serif; font-size:14px }',
});
</script>
<?php $this->load->view('employee/evaluation/scripts/dept_multi_selection') ?>