<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12" id="action_btns" style="display:none">
            <button type="button" class="btn btn-warning btn-sm btn-sendselected">Resend Selected</button>
            <button type="button" class="btn btn-danger btn-sm btn-uncheckall">Unselect All</button>
        </div>
    </div>
    <br>
    <table class="table table-hover">
        <thead>
            <tr>
                <th>#</th>
                <th><?=display('employee_id')?></th>
                <th><?=display('employee_name')?></th>
                <th><?=display('department')?></th>
                <th><?=display('division')?></th>
                <th><?=display('status')?></th>
                <th><?=display('added_at')?></th>
                <th><?=display('processed_by')?></th>
                <th><?=display('processed_at')?></th>
                <th class="hideexport">Action</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>
<!-- Modal -->
<div class="modal fade" id="form-process" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?=$title?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="#" method="post">
                <div class="modal-body">
                    <h4></h4>
                    <br>
                    <input type="hidden" name="id" value="">
                    <div class="form-group">
                        <label for="domain_name"><?=display('domain_name')?></label>
                        <input type="text" class="form-control" name="domain_name" id="domain_name">
                    </div>
                    <div class="form-group">
                        <label for="domain_password"><?=display('domain_password')?></label>
                        <input type="password" class="form-control" name="domain_password" id="domain_password">
                        <div class="pretty p-icon p-toggle p-plain">
                            <input type="checkbox" class="show_password" value="1" checked="checked" />
                            <div class="state p-off">
                                <i class="icon fa fa-eye-slash"></i>
                                <label><?= display('hide_password') ?></label>
                            </div>
                            <div class="state p-success-o p-on">
                                <i class="icon fa fa-eye" aria-hidden="true"></i>
                                <label><?= display('show_password') ?></label>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="conf_domain_password"><?=display('confirm')?>
                            <?=display('domain_password')?></label>
                        <input type="password" class="form-control" name="conf_domain_password"
                            id="conf_domain_password">
                        <div class="pretty p-icon p-toggle p-plain">
                            <input type="checkbox" class="show_password" value="1" checked="checked" />
                            <div class="state p-off">
                                <i class="icon fa fa-eye-slash"></i>
                                <label><?= display('hide_password') ?></label>
                            </div>
                            <div class="state p-success-o p-on">
                                <i class="icon fa fa-eye" aria-hidden="true"></i>
                                <label><?= display('show_password') ?></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>
<script>
$(document).ready(function() {
    window.dtable = $('table.table').DataTable($.extend({},
        window.default_datatable_opts, {
            responsive: false,
            processing: true,
            serverSide: true,
            ajax: {
                method: 'post',
                beforeSend: function() {},
                complete: function() {}
            },
            columns: [{
                'data': 'id',
            }, {
                'data': 'hrm_id',
            }, {
                'data': 'full_name',
            }, {
                'data': 'department',
            }, {
                'data': 'division'
            }, {
                'data': 'status',
            }, {
                'data': 'added_at',
            }, {
                'data': 'updater_name',
            }, {
                'data': 'updated_at',
            }, {
                'data': 'action',
                'sortable': false
            }, ],
            columnDefs: [{
                targets: [6, 8],
                type: "date",
                render: function(data, type) {
                    if (type === 'sort') {
                        return moment(data, 'DD-MM-YYYY hh:mm:ss A')
                    }
                    return data;
                }
            }],
            order: [
                [6, 'desc']
            ]
        }
    ))
});
$('table').on('click', '.btn-process', function(e) {
    e.preventDefault();
    let $modal = $('#form-process');
    $modal.find('h4').text($(this).data('name'))
    $modal.find('input[name=id]').val($(this).data('id'))
    $modal.modal('show')
})
$('#form-process form').on('submit', function(e) {
    e.preventDefault();
    let $modal = $('#form-process');
    let $form = $(this)
    myajax({
        type: "POST",
        url: "<?=base_url('employee/domain_request/process')?>",
        data: $form.serialize(),
        beforeSend: function() {
            $form.find('span.error').remove()
        },
        success: function(res) {
            if (res.success) {
                Swal.fire(
                    '<?= display('success') ?>!',
                    res.success,
                    'success'
                )
                window.dtable.ajax.reload()
                $modal.modal('hide')
            } else if (res.error) {
                Swal.fire(
                    '<?= display('error') ?>!',
                    res.error,
                    'error'
                )
            } else if (res.errors) {
                res.errors.forEach(err => {
                    $form.find(`[name=${err[0]}]`).closest('div').append(
                        `<span class="error">${err[1]}</span>`)
                });
            } else {
                Swal.fire(
                    '<?= display('error') ?>!',
                    '<?= display('invalid_request') ?>',
                    'error'
                )
            }
        }
    });
})
$('input.show_password').on('click', function() {
    if(!this.checked) {
        $(this).closest('div.form-group').children('input').attr('type', 'text')
    } else {
        $(this).closest('div.form-group').children('input').attr('type', 'password')
    }
});
</script>