<?php
class Evaluation_instance_model extends CI_Model
{
    public function verify($id)
    {
        $report = $this->get_report($id);
        if ($this->permission->method('evaluations_pending', 'update')->access()) {
            return true;
        } elseif ($report->employee_id == $this->session->userdata('employee_id')) {
            return true;
        } elseif ($report->dm_id == $this->session->userdata('employee_id')) {
            return true;
        } elseif ($report->idm_id == $this->session->userdata('employee_id')) {
            return true;
        }
        return false;
    }
    public function verify_update($id)
    {
        $report = $this->get_report($id);
        if ($report->status == 'completed') {
            return false;
        }
        if ($this->permission->method('evaluations_pending', 'update')->access()) {
            return true;
        } elseif ($report->status == 'pending-employee' && $report->employee_id == $this->session->userdata('employee_id')) {
            return true;
        } elseif ($report->status == 'pending-dm' && $report->dm_id == $this->session->userdata('employee_id')) {
            return true;
        } elseif ($report->status == 'pending-idm' && $report->idm_id == $this->session->userdata('employee_id')) {
            return true;
        }
        return false;
    }
    public function get_report($id)
    {
        return decrypt_employee_data($this->db->select('evaluation_report_instance.*,
        evaluation_report.id as parent_id,
        evaluation_report.year')
                ->from('evaluation_report_instance')
                ->join('evaluation_report', 'evaluation_report_instance.ev_id = evaluation_report.id', 'left')
                ->where('evaluation_report_instance.id', $id)
                ->get()
                ->row(), [], true, 'evaluation_report_instance');
    }
    public function get_sub_reports($parent_id, $employee_id, $approved_only = false)
    {
        if ($approved_only) {
            $this->db->where('evaluation_report_instance.status', 'completed');
        }
        $data = $this->db
            ->select(
                'evaluation_report_instance.id,
                evaluation_report_instance.num,
                evaluation_report_instance.type,
                evaluation_report_instance.status,
                evaluation_report_instance.manager_comments,
                evaluation_report_instance.employee_comments,
                evaluation_report_instance.next_deadline'
            )
            ->where(['evaluation_report_instance.ev_id' => $parent_id, 'evaluation_report_instance.employee_id' => $employee_id])
            ->order_by('evaluation_report_instance.num', 'asc')
            ->get('evaluation_report_instance')
            ->result();
        return array_map(function ($v) {
            return decrypt_employee_data($v, [], true, 'evaluation_report_instance');
        }, $data);
    }
    public function get_employee($id, $employee_id)
    {
        return $this->db
            ->select(
                'employee_details.employee_id,
            employee_details.hrm_id,
            employee_details.full_name,
            employee_details.pseudo,
            employee_details.hire_date,
            employee_details.division_id,
            report_employee.department,
            report_employee.position,
            report_employee.pos_id,
            report_employee.dept_id')
            ->join('employee_details', 'report_employee.employee_id = employee_details.employee_id', 'left')
            ->where(['report_employee.employee_id' => $employee_id, 'report_employee.report_id' => $id])
            ->get('report_employee')
            ->row();
    }
    public function get_rating_scale($id)
    {
        $rating['range'] = array_values($this->db->select('min(score), max(score)')->get('report_rating_scale')->row_array());
        $rating['data'] = $this->db
            ->select('*')
            ->where('report_rating_scale.report_id', $id)
            ->order_by('score', 'desc')
            ->get('report_rating_scale')
            ->result();
        return $rating;
    }
    public function get_behaviors($id, $dept_id, $pos_id)
    {
        $data = $this->db->query(
            'CALL get_evaluation_behaviors(?, ?, ?)',
            [$id, $dept_id, $pos_id]
        )->result();
        $this->db->next_result();
        return $data;
    }
    public function get_objectives($id, $report_instance, $dept_id, $pos_id)
    {
        $data = $this->db->query(
            'CALL get_evaluation_objectives(?, ?, ?)',
            [$id, $dept_id, $pos_id]
        )->result();
        $this->db->next_result();
        foreach ($data as $obj) {
            if (!isset($obj->scores)) {
                $obj->scores = [];
            }
            $scores_rec = $this->db->select('rating_id, threshold')->where(['report_id' => $id, 'objective_id' => $obj->id])->get('report_rel_rating_objectives')->result();
            foreach ($scores_rec as $score_rec) {
                $obj->scores[$score_rec->rating_id] = $score_rec->threshold;
            }
            if ($report_instance->status == 'pending-employee' && $obj->data_model) {
                $system_opt_slug = sprintf('eval_obj_data_fetch_%s_%s', $report_instance->id, $obj->id);
                if ($this->options->get_system($system_opt_slug) != 1) {
                    $this->load->model('Eval_' . $obj->data_model . '_model');
                    $res = $this->{'Eval_' . $obj->data_model . '_model'}->get($report_instance);
                    if ($this->save_result('objective', $report_instance->id, $obj->id, $res['value'], $res['percentage'])) {
                        $this->options->set_system($system_opt_slug, 1);
                    }
                }
            }
        }
        return $data;
    }
    public function get_roles($id)
    {
        $data = $this->db->where('report_id', $id)->get('report_employee_roles')->result();
        foreach ($data as &$dt) {
            if (!isset($dt->behavior_description)) {
                $dt->behavior_description = [];
            }
            $b_desc = $this->db->where(['role_id' => $dt->id, 'report_id' => $id])->get('report_rel_role_behaviors')->result();
            foreach ($b_desc as $b_d) {
                $dt->behavior_description[$b_d->behavior_id] = $b_d->description;
            }
        }
        return $data;
    }
    public function get_objective_results(int $instance_id): array
    {
        $recs = $this->db->select('item_id, result, value')->where(['type' => 'objective', 'report_instance_id' => $instance_id])->get('report_results')->result();
        $data = [];
        foreach ($recs as $rec) {
            $data[$rec->item_id] = [
                'result' => $rec->result,
                'value' => $rec->value,
            ];
        }
        return $data;
    }
    public function get_behavior_results(int $instance_id): array
    {
        $recs = $this->db->select('item_id, result, value')->where(['type' => 'behavior', 'report_instance_id' => $instance_id])->get('report_results')->result();
        $data = [];
        foreach ($recs as $rec) {
            $data[$rec->item_id] = $rec->result;
        }
        return $data;
    }
    public function get_objective_remarks(int $instance_id): array
    {
        $recs = $this->db->select('report_remarks.*, employee_details.hrm_id, employee_details.full_name')->where(['report_remarks.type' => 'objective', 'report_remarks.report_instance_id' => $instance_id])
            ->join('employee_details', 'report_remarks.author = employee_details.user_id', 'left')
            ->order_by('report_remarks.added_at', 'asc')
            ->get('report_remarks')->result();
        $data = [];
        foreach ($recs as $rec) {
            if (!$rec->full_name && $rec->author == 1) {
                $rec->full_name = 'HR Admin';
            }
            $data[$rec->item_id][] = $rec;
        }
        return $data;
    }
    public function get_behavior_remarks(int $instance_id): array
    {
        $recs = $this->db->select('report_remarks.*, employee_details.hrm_id, employee_details.full_name')->where(['report_remarks.type' => 'behavior', 'report_remarks.report_instance_id' => $instance_id])
            ->join('employee_details', 'report_remarks.author = employee_details.user_id', 'left')
            ->order_by('report_remarks.added_at', 'asc')
            ->get('report_remarks')->result();
        $data = [];
        foreach ($recs as $rec) {
            if (!$rec->full_name && $rec->author == 1) {
                $rec->full_name = 'HR Admin';
            }
            $data[$rec->item_id][] = $rec;
        }
        return $data;
    }
    public function get_fields_data(int $instance_id): array
    {
        $data = [];
        $recs = $this->db->select('option_key, value')->where('report_instance_id', $instance_id)->get('report_internal_results')->result();
        foreach ($recs as $rec) {
            $data[$rec->option_key] = $rec->value;
        }
        return $data;
    }
    public function save_report($id, $data)
    {
        $report = $this->get_report($id);
        if ($report->status != $data['status']) {
            sendJson(['error' => display(['Report', 'is', 'already', 'updated'], true), 'reload' => true]);
        }
        if ($report->employee_id == $this->session->userdata('employee_id')) {
            unset($data['objective']);
        }
        $this->db->trans_start();
        foreach ($data['inputs'] as $type => $results) {
            foreach ($results as $item_id => $result) {
                $this->save_result($type, $id, $item_id, $result);
            }
        }
        foreach ($data['reasons'] as $type => $results) {
            foreach ($results as $item_id => $result) {
                $this->save_reason($id, $type, $item_id, $result['old_value'], $result['new_value'], $result['remarks']);
            }
        }
        switch ($report->status) {
            case 'pending-employee':{
                    $rec = $this->db->select('hrm_id, first_name, last_name')->where('employee_id', $report->employee_id)->get('employee_history')->row();
                    if ($report->dm_id) {
                        $supervisor = $this->db->select('employee_id, hrm_id, first_name, last_name, shift, division_id, business_email')->where('employee_id', $report->dm_id)->get('employee_history')->row();
                        if ($supervisor) {
                            $deadline = getWeekdayPeriod($supervisor->shift, 5)['end'];
                            $this->db->where('id', $id)->update('evaluation_report_instance', [
                                'employee_date' => date('Y-m-d H:i:s'),
                                'updated_at' => date('Y-m-d H:i:s'),
                                'dm_id' => $supervisor->employee_id,
                                'status' => 'pending-dm',
                                'next_deadline' => $deadline . ' 23:59:59',
                                'deadline_notified' => 0,
                            ]);
                            if(!$this->options->get_system('evaluation.test.mode')) {
                                $this->notify
                                    ->employee($supervisor->employee_id)
                                    ->send(
                                        [
                                            'evaluation_generated_dm',
                                            $rec->first_name,
                                            $rec->last_name,
                                            $rec->hrm_id,
                                            $deadline,
                                        ],
                                        'employee/evaluation/pending/' . $id
                                    );
                                if ($this->options->get_system('evaluation.notifications.email') && $supervisor->business_email) {
                                    $this->template_mail
                                        ->config($supervisor->division_id)
                                        ->_send(
                                            $supervisor->business_email,
                                            null,
                                            display(['Evaluation', 'Report', 'Submitted']) . sprintf(': %s %s (%s)', $rec->first_name, $rec->last_name, $rec->hrm_id),
                                            $this->load->view('employee/email/report_generated_dm', ['employee' => (array) $rec, 'supervisor' => (array) $supervisor, 'deadline' => $deadline], true),
                                        );
                                }
                            }
                            break;
                        }
                    }
                }
            case 'pending-dm':{
                    $rec = $this->db->select('hrm_id, first_name, last_name')->where('employee_id', $report->employee_id)->get('employee_history')->row();
                    if ($report->idm_id) {
                        $supervisor = $this->db->select('employee_id, hrm_id, first_name, last_name, shift, division_id, business_email')->where('employee_id', $report->idm_id)->get('employee_history')->row();
                        if ($supervisor) {
                            $deadline = getWeekdayPeriod($supervisor->shift, 5)['end'];
                            $this->db->where('id', $id)->update('evaluation_report_instance', encrypt_employee_data([
                                'dm_date' => date('Y-m-d H:i:s'),
                                'updated_at' => date('Y-m-d H:i:s'),
                                'idm_id' => $supervisor->employee_id,
                                'status' => 'pending-idm',
                                'next_deadline' => $deadline . ' 23:59:59',
                                'deadline_notified' => 0,
                                'employee_comments' => base64_decode($data['employee_comments']),
                                'manager_comments' => base64_decode($data['manager_comments']),
                            ], [], 'evaluation_report_instance'));
                            if(!$this->options->get_system('evaluation.test.mode')) {
                                $this->notify
                                    ->employee($supervisor->employee_id)
                                    ->send(
                                        [
                                            'evaluation_generated_dm',
                                            $rec->first_name,
                                            $rec->last_name,
                                            $rec->hrm_id,
                                            $deadline,
                                        ],
                                        'employee/evaluation/pending/' . $id
                                    );
                                if ($this->options->get_system('evaluation.notifications.email') && $supervisor->business_email) {
                                    $this->template_mail
                                        ->config($supervisor->division_id)
                                        ->_send(
                                            $supervisor->business_email,
                                            null,
                                            display(['Evaluation', 'Report', 'Submitted']) . sprintf(': %s %s (%s)', $rec->first_name, $rec->last_name, $rec->hrm_id),
                                            $this->load->view('employee/email/report_generated_dm', ['employee' => (array) $rec, 'supervisor' => (array) $supervisor, 'deadline' => $deadline], true),
                                        );
                                }
                            }
                            break;
                        }
                    }
                }
            case 'pending-idm':{
                    $rec = $this->db->select('hrm_id, first_name, last_name, division_id')->where('employee_id', $report->employee_id)->get('employee_history')->row();
                    $this->db->where('id', $id)->update('evaluation_report_instance', encrypt_employee_data([
                        'idm_date' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                        'status' => 'pending-hr',
                        'next_deadline' => null,
                        'deadline_notified' => 1,
                        'employee_comments' => base64_decode($data['employee_comments']),
                        'manager_comments' => base64_decode($data['manager_comments']),
                    ], [], 'evaluation_report_instance'));
                    if(!$this->options->get_system('evaluation.test.mode')) {
                        $this->notify
                            ->department('hr')
                            ->send(
                                [
                                    'evaluation_generated_hr',
                                    $rec->first_name,
                                    $rec->last_name,
                                    $rec->hrm_id,
                                ],
                                'employee/evaluation/pending/' . $id
                            );
                        if ($this->options->get_system('evaluation.notifications.email')) {
                            $this->template_mail
                                ->send_to_hr(
                                    $rec->division_id,
                                    display(['Evaluation', 'Report', 'Submitted']) . sprintf(': %s %s (%s)', $rec->first_name, $rec->last_name, $rec->hrm_id),
                                    $this->load->view('employee/email/report_generated_hr', ['employee' => (array) $rec], true),
                                    [],
                                    [],
                                    true,
                                    true
                                );
                        }       
                    }
                    break;
                }
            case 'pending-hr':{
                    $this->db->where('id', $id)->update('evaluation_report_instance', encrypt_employee_data([
                        'hr_id' => $this->session->userdata('employee_id'),
                        'hr_date' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                        'status' => 'completed',
                        'next_deadline' => null,
                        'deadline_notified' => 1,
                        'employee_comments' => base64_decode($data['employee_comments']),
                        'manager_comments' => base64_decode($data['manager_comments']),
                    ], [], 'evaluation_report_instance'));

                    $rec = $this->db->select('hrm_id, first_name, last_name, division_id')->where('employee_id', $report->employee_id)->get('employee_history')->row();
                    if(!$this->options->get_system('evaluation.test.mode')) {
                        $this->notify
                            ->employee($report->employee_id)
                            ->send(
                                [
                                    'evaluation_approved_hr',
                                    $report->year,
                                    $report->type,
                                ],
                                'employee/evaluation/pending/' . $id
                            );
                        if ($this->options->get_system('evaluation.notifications.email')) {
                            $this->template_mail
                                ->send_to_employee(
                                    display(['Evaluation', 'Report', 'Approved']) . sprintf(': %s %s (%s)', $rec->first_name, $rec->last_name, $rec->hrm_id),
                                    $this->load->view('employee/email/report_approved_hr', ['employee' => (array) $rec, 'report' => $report], true),
                                    $report->employee_id,
                                    true,
                                    true
                                );
                        }       
                    }
                    break;
                }
        }
        $this->db->trans_complete();
        $res = $this->db->trans_status();
        if ($res && $report->status == 'pending-hr') {
            $this->load->model(['incident/letter_model', 'employees_model']);
            $inputs_data = base64_decode($data['letter_data']['input']);
            parse_str($inputs_data, $inputs_data);
            $res2 = $res3 = true;
            if ($data['promotion_required'] && $data['letter_data'] && $data['letter_data']['letter_id']) {
                $res2 = $this->letter_model->add_letter(
                    [$report->employee_id],
                    $data['letter_data']['letter_id'],
                    display(['Auto', 'Generated', 'via', 'Evaluation', 'Report'], true),
                    $data['letter_data']['input']);
                if ($res2) {
                    $this->db->trans_start();
                    $old_data = $this->db->select('pos_id, dept_id')->where('employee_id', $report->employee_id)->get('employee_history')->row_array();
                    $new_data = [
                        'dept_id' => $this->db->select('dept_id as id')->where('department_name', $inputs_data['new_department'])->get('department')->row_array()['id'],
                        'pos_id' => $this->db->select('pos_id as id')->where('position_name', $inputs_data['designation'])->get('position')->row_array()['id'],
                    ];
                    $this->db->where('employee_id', $report->employee_id)->update('employee_history', $new_data);
                    $this->employees_model->log_employee_change(
                        $report->employee_id,
                        $new_data,
                        $old_data
                    );
                    $this->db->trans_complete();
                    $res2 = $this->db->trans_status();
                }
            }
            if ($data['increment_required'] && $data['letter_data']) {
                $this->load->model('employee_increments_model');
                $this->db->trans_start();
                $this->employee_increments_model->add($report->employee_id, $inputs_data['inc_amount'], $inputs_data['inc_effective_date']);
                $this->db->trans_complete();
                $res3 = $this->db->trans_status();
            }

            if (!($res2 && $res3)) {
                $this->db->where('id', $id)->update('evaluation_report_instance', encrypt_employee_data([
                    'updated_at' => date('Y-m-d H:i:s'),
                    'status' => 'pending-hr',
                    'deadline_notified' => 1,
                ], [], 'evaluation_report_instance'));
            }
            return $res2 && $res3;
        }
        return $res;
    }
    public function save_val_data($id, $data)
    {
        $internal_fields = [
            'target_monthly',
            'target_achieved',
            'files_target',
            'files_touched',
            'followup_target',
            'followup_achieved',
            'ar_target',
            'ar_achieved',
            'calls_target',
            'calls_achieved',
            'fax_target',
            'fax_achieved',
        ];
        $this->db->trans_start();
        $this->db->where(['report_instance_id' => $id])->delete('report_internal_results');
        foreach ($internal_fields as $internal_field) {
            if ($data[$internal_field]) {
                $this->db->insert('report_internal_results', [
                    'report_instance_id' => $id,
                    'option_key' => $internal_field,
                    'value' => $data[$internal_field],
                ]);
            }
        }
        $report = $this->get_report($id);
        $emp_rec = $this->db->select('CONCAT_WS(\' \', first_name, last_name) as full_name')->where('employee_id', $report->employee_id)->get('employee_history')->row();
        $this->activity->log([
            'evaluation_val_db_updated',
            $emp_rec->full_name,
            $report->type,
            $report->year,
        ]);
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function save_reason($id, $type, $item_id, $old_val, $new_val, $remarks)
    {
        return $this->db->insert('report_remarks', [
            'type' => $type,
            'report_instance_id' => $id,
            'item_id' => $item_id,
            'old_value' => $old_val,
            'new_value' => $new_val,
            'remarks' => $remarks,
            'author' => $this->session->userdata('id'),
            'added_at' => date('Y-m-d H:i:s'),
        ]);
    }
    public function save_result($type, $instance_id, $item_id, $result, $value = null)
    {
        if(is_nan($value)) {
            $value = 0;
        }
        $exits = $this->db->where([
            'type' => $type,
            'report_instance_id' => $instance_id,
            'item_id' => $item_id,
        ])->count_all_results('report_results');
        if ($exits) {
            return $this->db->where([
                'type' => $type,
                'report_instance_id' => $instance_id,
                'item_id' => $item_id,
            ])->update('report_results', [
                'result' => $result,
                'value' => $value,
            ]);
        } else {
            return $this->db->insert('report_results', [
                'type' => $type,
                'report_instance_id' => $instance_id,
                'item_id' => $item_id,
                'result' => $result,
                'value' => $value,
            ]);
        }
    }
}
