<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Employee_increments_model extends CI_Model
{
    public function single($employee_id, $num)
    {
        $rec = $this->db->select('amount, date')->where(['employee_id' => $employee_id, 'num' => $num])->get('employee_increments')->row();
        if (!$rec) {
            return null;
        }
        $rec = decrypt_employee_data($rec, [], false, 'employee_increments');
        return [
            'amount' => $rec->amount ? $rec->amount : 0,
            'date' => $rec->date,
        ];
    }
    public function get($employee_id, $bypass = false)
    {
        $data = [];

        $recs = $this->db->select('num, amount, date')->where('employee_id', $employee_id)->get('employee_increments')->result();
        foreach ($recs as $rec) {
            $rec = decrypt_employee_data($rec, [], $bypass, 'employee_increments');
            $data[$rec->num] = [
                'amount' => $rec->amount ? $rec->amount : 0,
                'date' => $rec->date,
            ];
        }
        return $data;
    }
    public function save($employee_id, $increments)
    {
        $this->db->where('employee_id', $employee_id)->delete('employee_increments');
        foreach ($increments as $num => $increment) {
            $increment['amount'] = preg_replace('#\,#', '', $increment['amount']);
            $this->db->insert('employee_increments', encrypt_employee_data([
                'employee_id' => $employee_id,
                'num' => $num,
                'amount' => $increment['amount'] ? $increment['amount'] : 0,
                'date' => sql_date($increment['date']),
            ], [], 'employee_increments'));
        }
        return true;
    }
    public function update($employee_id, $increments)
    {
        $old_recs = $this->get($employee_id);
        $this->db->where('employee_id', $employee_id)->delete('employee_increments');
        foreach ($increments as $num => $value) {
            $value['amount'] = preg_replace('#\,#', '', $value['amount']);
            if (!trim($value['amount']) || !trim($value['date'])) {
                continue;
            }
            if (isset($old_recs[$num])) {
                if (($old_recs[$num]['amount'] != $value['amount'] || strtotime($old_recs[$num]['date']) != strtotime($value['date']))) {
                    $this->activity->log([
                        'employee_update_increment',
                        addOrdinalNumberSuffix($num + 1),
                        number_format($old_recs[$num]['amount']),
                        formatted_date($old_recs[$num]['date']),
                        number_format($value['amount']),
                        $value['date'],
                    ], $employee_id, 'employee', 'employee_history', 'increment_amount');
                }
            } else {
                $this->activity->log([
                    'employee_add_increment',
                    addOrdinalNumberSuffix($num + 1),
                    number_format($value['amount']),
                    $value['date'],
                ], $employee_id, 'employee', 'employee_history', 'increment_amount');
            }
            $this->db->insert('employee_increments', encrypt_employee_data([
                'employee_id' => $employee_id,
                'num' => $num,
                'amount' => $value['amount'] ? $value['amount'] : 0,
                'date' => sql_date($value['date']),
            ], [], 'employee_increments'));
        }
        foreach ($old_recs as $num => $value) {
            if (!isset($increments[$num])) {
                $this->activity->log([
                    'employee_remove_increment',
                    addOrdinalNumberSuffix($num + 1),
                    number_format($value['amount']),
                    formatted_date($value['date']),
                ], $employee_id, 'employee', 'employee_history', 'increment_amount');
            }
        }
    }
    public function add($employee_id, $amount, $date)
    {
        $num = $this->db->where('employee_id', $employee_id)->count_all_results('employee_increments');
        $amount = preg_replace('#\,#', '', $amount);
        $this->activity->log([
            'employee_add_increment',
            addOrdinalNumberSuffix($num),
            number_format($amount),
            $date,
        ], $employee_id, 'employee', 'employee_history', 'increment_amount');
        $this->db->insert('employee_increments', encrypt_employee_data([
            'employee_id' => $employee_id,
            'num' => $num,
            'amount' => $amount ? $amount : 0,
            'date' => sql_date($date),
        ], [], 'employee_increments'));
    }
    public function delete($employee_id, $num)
    {
        return $this->db->where(['employee_id' => $employee_id, 'num' => $num])->delete('employee_increments');
    }
}
