<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Documents_model extends CI_Model
{
    public function document_create($data = array(), $post = array())
    {
        return;
        $this->db->insert('employee_document', $data);
        $insert_id = $this->db->insert_id();
        for ($i = 0; $i < count($post['department_id']); $i++) {
            $add_fields = array("department_id" => $post['department_id'][$i], "required_status" => $post['required_status'][$i], "employee_document_id" => $insert_id);
            $this->db->insert('employee_document_fields', $add_fields);
        }
        return true;
    }

    public function document_list()
    {
        $this->db->select('*');
        $this->db->from('employee_document');
        $query = $this->db->get();
        return $query->result();
    }

    public function document_delete($id = null)
    {
        $this->db->where('department_id', $id)->delete('employee_document_fields');
        $this->db->where('id', $id)->delete('employee_document');
        return true;
    }

    public function get_document($id)
    {
        $query = $this->db->get_where('employee_document', array('id' => $id));
        return $query->row();
    }

    public function get_document_fields($id)
    {
        $query = $this->db->get_where('employee_document_fields', array('employee_document_id' => $id));
        return $query->result();
    }
    public function document_types($id = null)
    {
        $this->db->from('upload_documents_type');
        if ($id) {
            return $this->db->where('id', $id)->get()->row();
        }
        return $this->db->order_by('id', 'asc')->get()->result();
    }
    public function document_type_save($data)
    {
        $id = null;
        if (isset($data['id'])) {
            $id = $data['id'];
            unset($data['id']);
        }
        $update_data = [
            'title' => strip_tags($data['title']),
            'is_required' => $data['is_required'] == 'yes' ? 1 : 0,
            'has_deadline' => $data['has_deadline'] == 'yes' ? 1 : 0,
        ];
        if ($id) {
            $this->activity->log([
                'employee_document_type_updated',
                $data['title'],
                $id,
            ]);
            return $this->db->where('id', $id)->update('upload_documents_type', $update_data);
        } else {
            $this->activity->log([
                'employee_document_type_added',
                $data['title'],
                $id,
            ]);
            return $this->db->insert('upload_documents_type', $update_data);
        }
    }
    public function document_type_delete($id)
    {
        $rec = $this->document_types($id);
        $this->activity->log([
            'employee_document_type_deleted',
            $rec->title,
            $id,
        ]);
        return $this->db->where('id', $id)->delete('upload_documents_type');
    }
    public function get_pending()
    {
        return $this->db
            ->select('upload_documents.*, upload_documents_type.title, CONCAT_WS(\' \', employee_history.first_name, employee_history.last_name, employee_history.middle_name) as employee_name, employee_history.hrm_id')
            ->where_in('upload_documents.status', ['uploaded'])
            ->join('upload_documents_type', 'upload_documents_type.id=upload_documents.document_type', 'left')
            ->join('employee_history', 'employee_history.employee_id=upload_documents.employee_id', 'left')
            ->get('upload_documents')->result();
    }
    public function check_for_missing_documents($employee_id)
    {
        $missing_docs = $this->count_missing_documents($employee_id);
        if ($missing_docs > 0) {
            $missing_doc_recs = $this->get_missing_documents($employee_id);

            $highest_deadline = null;
            $extended = false;
            $last_notified = null;
            $hr_notified = false;

            foreach ($missing_doc_recs as $missing_doc_rec) {
                if (!$missing_doc_rec->period_end) {
                    continue;
                }
                $time_end = strtotime($missing_doc_rec->period_end);
                if (!$highest_deadline || $time_end > $highest_deadline) {
                    $highest_deadline = $time_end;
                }
                if ($missing_doc_rec->notified_at && strtotime($missing_doc_rec->notified_at) > $last_notified) {
                    $last_notified = strtotime($missing_doc_rec->notified_at);
                }
                if ($time_end < time()) {
                    if (!$missing_doc_rec->extension_alloted) {
                        $this->extend_deadline($missing_doc_rec->id, 2);
                        $extended = true;
                    }
                }
                $hr_notified = $hr_notified && $missing_doc_rec->hr_notified;
            }
            if ($extended) {
                $highest_deadline += 172800;
            }
            if (!$hr_notified && $highest_deadline) {
                if ($highest_deadline < time()) {
                    // HR notification block
                    $emp_rec = $this->db->select('first_name, middle_name, last_name, hrm_id, division_id, business_email, hire_date, employee_id, super_visor_id, indirect_super_visor_id')->where('employee_id', $employee_id)->get('employee_history')->row();
                    $this->notify->department('hr')->send(
                        sprintf('Document Deadline Expired: %s %s (%s)', $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id),
                        'employee/Employees/documents_update/' . $employee_id
                    );
                    $this->notify->employee([
                        $emp_rec->super_visor_id,
                        $emp_rec->indirect_super_visor_id,
                    ])->send(
                        sprintf('%s %s (%s) failed to upload required documents in provided time period. The case is sent to HR for further action.', $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id),
                        'employee/Employees/documents_update/' . $employee_id
                    );
                    $this->template_mail->send_to_hr(
                        $emp_rec->division_id,
                        sprintf('Document Deadline Expired: %s %s (%s)', $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id),
                        $this->load->view('employee/email/doc_hr_escalation', ['employee' => $emp_rec, 'period_end' => date('Y-m-d', $highest_deadline)], true),
                        [],
                        [],
                        true,
                        true
                    );
                    $this->db->where(['employee_id' => $employee_id])->update('upload_documents', [
                        'hr_notified' => 1,
                    ]);
                } elseif ((time() - $last_notified) > 82000) {
                    // Employee & Supervisor notification block
                    if ($extended) {
                        $emp_rec = $this->db->select('first_name, last_name, hrm_id, super_visor_id')->where('employee_id', $employee_id)->get('employee_history')->row();
                        $this->notify->employee($emp_rec->super_visor_id)->send(
                            sprintf('%s %s (%s) has not uploaded the required documents. Their deadline is extended by 2 days.', $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id),
                        );
                    }
                    $this->notify->employee($employee_id)->send(
                        ($extended ? '[Extended] ' : '') . 'You haven\'t uploaded all the required documents. Deadline: ' . date('d-m-Y', $highest_deadline),
                        'employee/employees_documents/upload'
                    );
                    $this->db->where(['employee_id' => $employee_id])->update('upload_documents', [
                        'notified_at' => date('Y-m-d H:i:s'),
                    ]);
                }
            }
        }
        $this->session->set_userdata('missing_documents', $missing_docs);
    }
    public function extend_deadline($id, $days)
    {
        return $this->db->query("UPDATE upload_documents SET period_end = DATE_ADD(period_end, INTERVAL ? DAY), extension_alloted = 1 WHERE id = ?;", [$days, $id]);
    }
    public function count_missing_documents($employee_id, $additional_status = [])
    {
        $additional_status = array_merge($additional_status, ['missing', 'rejected']);
        return $this->db
            ->where('employee_id', $employee_id)
            ->where_in('status', $additional_status)
            ->where('hr_notified !=', 1)
            ->count_all_results('upload_documents');
    }
    public function get_missing_documents($employee_id)
    {
        return $this->db
            ->select('upload_documents.*, upload_documents_type.title')
            ->where('upload_documents.employee_id', $employee_id)
            ->where_in('upload_documents.status', ['missing', 'rejected'])
            ->join('upload_documents_type', 'upload_documents_type.id=upload_documents.document_type', 'left')
            ->get('upload_documents')->result();
    }
    public function get_by_name($file_name)
    {
        return $this->db->select([
            'upload_documents.*',
            'drive_ids.drive_id',
        ])
            ->where('BINARY upload_documents.documents = ', "'{$file_name}'", false)
            ->join('drive_ids', 'upload_documents.id = drive_ids.row_id AND drive_ids.table = \'upload_documents\'', 'left')
            ->get('upload_documents')->row();
    }
    public function get_by_id($id)
    {
        return $this->db
            ->select('upload_documents.*, upload_documents_type.title, CONCAT_WS(\' \', employee_history.first_name, employee_history.last_name, employee_history.middle_name) as employee_name, employee_history.hrm_id, employee_history.employee_id')
            ->where('upload_documents.id', $id)
            ->join('upload_documents_type', 'upload_documents_type.id=upload_documents.document_type', 'left')
            ->join('employee_history', 'employee_history.employee_id=upload_documents.employee_id', 'left')
            ->get('upload_documents')->row();
    }
    public function upload_missing($id, $file_name)
    {
        $this->db->trans_begin();
        $doc_rec = $this->get_by_id($id);
        $this->db->where('id', $id)->update('upload_documents', [
            'documents' => $file_name,
            'status' => $doc_rec->employee_id == $this->session->userdata('employee_id') ? 'uploaded' : 'profile-upload',
            'rejection_reason' => null,
        ]);
        if ($doc_rec->employee_id != $this->session->userdata('employee_id')) {
            $this->activity->set_url('employee/Employees/documents_update/' . $doc_rec->employee_id)->log([
                'employee_document_added_missing',
                $file_name,
            ], $doc_rec->employee_id, 'employee', 'employee_history');
        }
        $remaining = $this->count_missing_documents($doc_rec->employee_id, ['uploaded']);
        if ($remaining < 1) {
            $this->notify->department('hr')->send(
                sprintf('On-boarding Completed: %s (%s)', $doc_rec->employee_name, $doc_rec->hrm_id),
                'employee/employees/cv/' . $doc_rec->employee_id
            );
        }
        if ($this->db->trans_status() === true) {
            $this->db->trans_commit();
            return true;
        } else {
            $this->db->trans_rollback();
        }
        return false;
    }
    public function process_document($id, $type, $remarks = null)
    {
        $doc_rec = $this->get_by_id($id);
        $this->db->trans_start();
        $this->db->where('id', $id)->update('upload_documents', [
            'status' => $type == 'approve' ? 'approved' : 'rejected',
            'reviewed_by' => $this->session->userdata('id'),
            'period_end' => $doc_rec->period_end ? date('Y-m-d', strtotime('+7 days')) . ' 23:59:59' : null,
            'rejected_on' => date('Y-m-d'),
            'rejection_reason' => $remarks,
            'extension_alloted' => 1,
        ]);
        if ($type != 'approve') {
            $this->notify->employee($doc_rec->employee_id)->send(
                sprintf('Your document "%s" is rejected.<br><p>Reason: %s</p>', $doc_rec->title, strip_tags($remarks)),
                'employee/employees_documents/upload'
            );
        }
        $remaining = $this->count_missing_documents($doc_rec->employee_id, ['uploaded']);
        if ($remaining < 1) {
            $this->notify->department('hr')->send(
                sprintf('On-boarding Completed: %s (%s)', $doc_rec->employee_name, $doc_rec->hrm_id),
                'employee/employees/cv/' . $doc_rec->employee_id
            );
        }
        if ($type == 'approve') {
            $this->activity->set_url('employee/Employees/documents_update/' . $doc_rec->employee_id)->log([
                'employee_document_approved',
                $doc_rec->title,
            ], $doc_rec->employee_id, 'employee', 'employee_history');
            if (stripos($doc_rec->title, 'photograph') !== false) {
                $this->db->where('employee_id', $doc_rec->employee_id)->update('employee_history', [
                    'picture' => './assets/employee_pictures/' . $doc_rec->documents,
                ]);
            }
        } else {
            $this->activity->set_url('employee/Employees/documents_update/' . $doc_rec->employee_id)->log([
                'employee_document_rejected',
                $doc_rec->title,
                $remarks,
            ], $doc_rec->employee_id, 'employee', 'employee_history');
        }
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function deleteMissingRecord($employee_id, $document_type_id)
    {
        return $this->db->where(['status' => 'missing', 'employee_id' => $employee_id, 'document_type' => $document_type_id])->delete('upload_documents');
    }
}
