<?php
class Behaviors_model extends CI_Model
{
    private $table = 'evaluation_behaviors';
    public function get($id = null)
    {
        $this->db->from($this->table);
        if ($id) {
            $rec = $this->db->where('id', $id)->get()->row();
            if (!$rec->all_departments) {
                $departments = $this->db->select('dept_id')->where('behavior_id', $id)->get('eval_rel_dept_behaviors')->result();
                $rec->departments = array_column($departments, 'dept_id');
                if (!$rec->all_positions) {
                    $departments = $this->db->select('pos_id')->where('behavior_id', $id)->get('eval_rel_pos_behaviors')->result();
                    $rec->positions = array_column($departments, 'pos_id');
                }
            }
            return $rec;
        }
        return $this->db->get()->result();
    }
    public function get_children($id)
    {
        return $this->db->select('evaluation_employee_roles.id, evaluation_employee_roles.label, eval_rel_role_behaviors.description')
            ->from('evaluation_behaviors, evaluation_employee_roles')
            ->join('eval_rel_role_behaviors', 'evaluation_behaviors.id = eval_rel_role_behaviors.behavior_id AND evaluation_employee_roles.id = eval_rel_role_behaviors.role_id', 'left')
            ->where('evaluation_behaviors.id', $id)
            ->order_by('evaluation_employee_roles.id')
            ->get()->result();
    }
    public function save($id = null, $data)
    {
        $this->db->trans_start();
        if (!$id) {
            $this->db->insert($this->table, [
                'label' => $data['label'],
                'description' => $data['description'],
                'all_departments' => $data['all_departments'] == 1 ? 1 : 0,
                'all_positions' => $data['all_positions'] == 1 ? 1 : 0,
            ]);
            $id = $this->db->insert_id();
            $this->activity->log([
                'evaluation_behavior_added',
                $data['label'],
                $id,
            ]);
        } else {
            $this->db->where('id', $id)->update($this->table, [
                'label' => $data['label'],
                'description' => $data['description'],
                'all_departments' => $data['all_departments'] == 1 ? 1 : 0,
                'all_positions' => $data['all_positions'] == 1 ? 1 : 0,
            ]);
            $this->activity->log([
                'evaluation_behavior_updated',
                $data['label'],
                $id,
            ]);
        }
        $this->db->where('behavior_id', $id)->delete('eval_rel_role_behaviors');
        $this->db->where('behavior_id', $id)->delete('eval_rel_dept_behaviors');
        $this->db->where('behavior_id', $id)->delete('eval_rel_pos_behaviors');

        foreach ($data['role'] as $role_id => $behavior_description) {
            $this->db->insert('eval_rel_role_behaviors', [
                'behavior_id' => $id,
                'role_id' => $role_id,
                'description' => $behavior_description,
            ]);
        }
        if ($data['all_departments'] != 1) {
            $department_data = [];
            foreach ($data['departments'] as $department) {
                $department_data[] = [
                    'behavior_id' => $id,
                    'dept_id' => $department,
                ];
            }
            $this->db->insert_batch('eval_rel_dept_behaviors', $department_data);
        }
        if ($data['all_positions'] != 1) {
            $position_data = [];
            foreach ($data['positions'] as $position) {
                $position_data[] = [
                    'behavior_id' => $id,
                    'pos_id' => $position,
                ];
            }
            $this->db->insert_batch('eval_rel_pos_behaviors', $position_data);
        }
        $this->db->trans_complete();
        if ($this->db->trans_status()) {
            return $id;
        }
        return false;
    }
    public function delete($id)
    {
        $rec = $this->get($id);
        if ($rec) {
            $this->db->trans_start();
            $this->db->where('id', $id)->delete($this->table);
            $this->db->where('behavior_id', $id)->delete('eval_rel_role_behaviors');
            $this->activity->log([
                'evaluation_behavior_deleted',
                $rec->label,
                $id,
            ]);
            $this->db->trans_complete();
            return $this->db->trans_status();
        }
        return false;
    }
    public function countAllRows()
    {
        return $this->db->count_all($this->table);
    }
    public function countDatatable($orWhere = [])
    {
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        return $this->db->count_all_results($this->table);
    }
    public function getDatatable($orWhere = [])
    {
        $post = $this->input->post();

        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        $this->db->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);

        return $this->db->get($this->table)->result_array();
    }
    public function get_departments()
    {
        return $this->db->select('dept_id as id, department_name as name')->order_by('department_name')->get('department')->result();
    }
    public function get_positions()
    {
        return $this->db->select('pos_id as id, position_name as name')->order_by('position_name')->get('position')->result();
    }
}
