<?php
class Reports extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (!defined('INTERNAL_HRM') || $this->session->userdata('employee_id') != 277) {
            show_404();
        }
    }
    public function pbi()
    {
        $db = $this->load->database('pbi', true);
        $tables = $db->list_tables();

        $header = [];
        $data = [];
        foreach ($tables as $table_key => $table) {
            $header[] = $table;

            $fields = $db->list_fields($table);
            foreach ($fields as $field_key => $field) {
                $data[$field_key][$table_key] = $field;
            }
        }

        $this->load->library('better_excel');

        $this->better_excel->download($header, $data, [], [], [], 'PBI');
    }
    public function collections()
    {
        $db = $this->load->database('collections', true);
        $tables = $db->list_tables();

        $header = [];
        $data = [];
        foreach ($tables as $table_key => $table) {
            $header[] = $table;

            $fields = $db->list_fields($table);
            foreach ($fields as $field_key => $field) {
                $data[$field_key][$table_key] = $field;
            }
        }

        $this->load->library('better_excel');

        $this->better_excel->download($header, $data, [], [], [], 'Collections');
    }
    public function fix_image_path()
    {
        $recs = $this->db->select('employee_id, picture')->like('picture', FCPATH, 'after')->get('employee_history')->result();
        $this->db->trans_start();
        foreach ($recs as $rec) {
            $this->db->where('employee_id', $rec->employee_id)->update('employee_history', [
                'picture' => str_replace(FCPATH, './', $rec->picture),
            ]);
        }
        $this->db->trans_complete();
        echo $this->db->trans_status() ? 'done' : 'failed';
    }
}
