<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Pending_changes extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(array(
            'fields_model'
        ));
        $this->permission->method('pending_changes', 'read')->redirect();
    }
    public function list()
    {
        $this->permission->method('pending_changes', 'read')->redirect();
        $data['title'] = display('pending_changes');
        $data['rows'] = $this->fields_model->get_all();
        $data['field_alias'] = $this->fields_model->get_aliases();
        $data['module'] = "employee";
        $data['page'] = "pending_changes";
        echo Modules::run('template/layout', $data);
    }
    public function process()
    {
        $this->permission->method('pending_changes', 'update')->redirect();
        if($this->input->post('process')){
            if($this->fields_model->process($this->input->post('process'), $this->input->post())){
                $this->session->set_flashdata('success', sprintf('Change request has been %s and added to employee record.', $this->input->post('process') == 'approve' ? 'approved' : 'rejected'));
            } else {
                $this->session->set_flashdata('exception', sprintf('Unable to %s change requested, try again later.', $this->input->post('process')));
            }
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
}
