<?php

use PhpOffice\PhpSpreadsheet\Shared\Date;

defined('BASEPATH') or exit('No direct script access allowed');
class Increments extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model([
            'Employee_increments_model' => 'increments',
        ]);

    }
    public function bulk()
    {
        $this->permission->method('bulk_increment_update', 'create')->redirect();
        if ($this->input->method() != 'post') {
            $data['title'] = display('bulk_increment_update');
            $data['module'] = "employee";
            $data['page'] = "bulk_update_increments";
            echo Modules::run('template/layout', $data);return;
        }
        $this->load->library('myupload');
        $file = $this->myupload->do_upload(FCPATH . 'uploads/temp/', 'file', true);
        if (!$file) {
            $this->session->set_flashdata('exception', 'File upload failed, try again later!');
            redirect($_SERVER['HTTP_REFERER']);
        }
        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        $spreadsheet = $reader->load($file);
        $sheet = $spreadsheet->getActiveSheet();

        $heading = [];

        $this->db->trans_start();
        foreach ($sheet->getRowIterator() as $row) {
            if ($row->getRowIndex() == 1) {
                foreach ($row->getCellIterator() as $cell) {
                    $value = trim($cell->getValue());
                    if ($cell->getColumn() == 'A') {
                        if (empty($value) || strtolower($value) != 'hrm id') {
                            $this->session->set_flashdata('exception', 'Required "HRM ID" Column not found in sheet. Make sure first row is heading');
                            redirect($_SERVER['HTTP_REFERER']);return;
                        }
                        $heading[$cell->getColumn()] = $value;
                    } elseif ($value) {
                        $type = [];

                        $value = str_ireplace('increment ', '', $cell->getValue());
                        $value = explode(' ', $value);
                        $type['num'] = intval(preg_replace('#[^\d]+#', '', $value[0])) - 1;
                        $type['type'] = strtolower($value[1]);
                        $heading[$cell->getColumn()] = $type;
                    }
                }
                continue;
            }

            $employee_id = null;
            $increments = [];
            foreach ($row->getCellIterator() as $cell) {
                $value = $cell->getValue();
                if (is_string($value)) {
                    $value = trim($value);
                }
                if ($cell->getColumn() == 'A') {
                    if (empty($value)) {
                        $this->session->set_flashdata('exception', 'Required "HRM ID" Column is empty on: ' . $cell->getCoordinate());
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }
                    $rec = $this->db->select('employee_id')->where('hrm_id', $value)->get('employee_history')->row();
                    if (!$rec) {
                        $this->session->set_flashdata('exception', sprintf('No employee found with HRM ID "%s" on %s', $value, ));
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }
                    $employee_id = $rec->employee_id;
                } else {
                    $type = $heading[$cell->getColumn()];
                    if (!$type) {
                        continue;
                    }
                    if ($type['type'] == 'date') {
                        if ($value) {
                            $increments[$type['num']]['date'] = date('Y-m-d', Date::excelToTimestamp($value));
                        } else {
                            $increments[$type['num']]['date'] = date('Y-m-d');
                        }
                    } else {
                        $increments[$type['num']]['amount'] = $value;
                    }
                }
            }
            foreach ($increments as $num => $increment) {
                $rec = $this->increments->single($employee_id, $num);
                if ($increment['amount'] === 0) {
                    if ($rec) {
                        $this->increments->delete($employee_id, $num);
                        $this->activity->log([
                            'employee_remove_increment',
                            addOrdinalNumberSuffix($num + 1),
                            number_format($value['amount']),
                            formatted_date($value['date']),
                        ], $employee_id, 'employee', 'employee_history', 'increment_amount');
                    }
                } elseif (empty($increment['amount'])) {
                    continue;
                } elseif ($rec) {
                    $this->db->where([
                        'employee_id' => $employee_id,
                        'num' => $num,
                    ])->update('employee_increments', encrypt_employee_data([
                        'amount' => $increment['amount'] ? $increment['amount'] : 0,
                        'date' => $increment['date'],
                    ], [], 'employee_increments'));

                    if ($rec['amount'] != $increment['amount'] && $rec['date'] != $increment['date']) {
                        $this->activity->log([
                            'employee_update_increment',
                            addOrdinalNumberSuffix($num + 1),
                            number_format($rec['amount']),
                            formatted_date($rec['date']),
                            number_format($increment['amount']),
                            formatted_date($increment['date']),
                        ], $employee_id, 'employee', 'employee_history', 'increment_amount');
                    }
                } else {
                    $this->db->insert('employee_increments', encrypt_employee_data([
                        'employee_id' => $employee_id,
                        'num' => $num,
                        'amount' => $increment['amount'] ? $increment['amount'] : 0,
                        'date' => $increment['date'],
                    ], [], 'employee_increments'));

                    $this->activity->log([
                        'employee_add_increment',
                        addOrdinalNumberSuffix($num + 1),
                        number_format($increment['amount']),
                        formatted_date($increment['date']),
                    ], $employee_id, 'employee', 'employee_history', 'increment_amount');
                }
            }
        }
        $this->db->trans_complete();
        if ($this->db->trans_status()) {
            $this->session->set_flashdata('message', 'Salary increment records updated successfully');
        } else {
            $this->session->set_flashdata('exception', 'Error updating salary increment, try again later');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function migrate()
    {
        if (!isset($_GET['rz'])) {
            show_404();
        }
        $recs = $this->db->select('employee_id, hired_salary, first_salary, second_salary, third_salary')->get('employee_history')->result_array();

        $this->db->trans_start();
        foreach ($recs as $rec) {
            $rec = decrypt_employee_data($rec, [], true);
            $increments = [];
            foreach ($rec as $key => $value) {
                $rec['hired_salary'] = floatval($rec['hired_salary']);
                if (in_array($key, ['employee_id', 'hired_salary'])) {
                    continue;
                }
                $value = floatval(trim(preg_replace('#[^\d]#', '', $value)));
                if (empty($value)) {
                    $value = 0;
                }

                if ($value) {
                    if ($value >= $rec['hired_salary']) {
                        $value = $value - $rec['hired_salary'];
                        $rec['hired_salary'] += $value;
                    }
                    $increments[] = [
                        'amount' => $value,
                        'date' => date('Y-m-01'),
                    ];
                }
            }
            $this->increments->save($rec['employee_id'], $increments);
        }
        $this->db->trans_complete();
        if ($this->db->trans_status()) {
            echo 'done';
        } else {
            echo 'failed';
        }
    }
}
