<?php
class Evaluation_behaviors extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model([
            'behaviors_model',
            'employee_roles_model',
        ]);
    }
    public function add()
    {
        $this->permission->method('evaluation_behaviors', 'create')->redirect();
        if ($this->input->post()) {
            $this->__save();
        }
        $data['title'] = display('add') . ' ' . display('evaluation_behaviors');
        $data['roles'] = $this->employee_roles_model->get(null, 'id, label');
        $data['departments'] = $this->behaviors_model->get_departments();
        $data['positions'] = $this->behaviors_model->get_positions();
        $data['module'] = "employee";
        $data['page'] = "evaluation/behavior_add";
        echo Modules::run('template/layout', $data);
    }
    public function edit($id)
    {
        $this->permission->method('evaluation_behaviors', 'update')->redirect();
        if ($this->input->post()) {
            $this->__save($id);
        }
        $data['behavior'] = $this->behaviors_model->get($id);
        if (!$data['behavior']) {
            show_404();
        }
        $data['title'] = display('update') . ' ' . display('evaluation_behaviors') . ' - ' . $data['behavior']->label;
        $data['id'] = $id;
        $data['roles'] = $this->behaviors_model->get_children($id);
        $data['departments'] = $this->behaviors_model->get_departments();
        $data['positions'] = $this->behaviors_model->get_positions();
        $data['_after_submit'] = count($_POST) > 0;
        $data['module'] = "employee";
        $data['page'] = "evaluation/behavior_update";
        echo Modules::run('template/layout', $data);
    }
    private function __save($id = null)
    {
        $rules_config = array(
            array(
                'field' => 'label',
                'label' => display('title'),
                'rules' => 'trim|required|alpha_numeric_spaces|max_length[45]',
            ),
        );
        if ($this->input->post('all_departments') == 0) {
            $rules_config[] = array(
                'field' => 'departments[]',
                'label' => display('departments'),
                'rules' => 'required',
            );
        }
        if ($this->input->post('all_positions') == 0) {
            $rules_config[] = array(
                'field' => 'positions[]',
                'label' => display('positions'),
                'rules' => 'required',
            );
        }
        $this->form_validation->set_rules($rules_config);
        if ($this->form_validation->run() === false) {
            return;
        }
        if ($this->behaviors_model->save($id, $this->input->post())) {
            $this->session->set_flashdata('success', sprintf(display('data_saved_successfully'), display('evaluation_behaviors')));
            redirect('employee/evaluation/behaviors');
        } else {
            $this->session->set_flashdata('exception', sprintf(display('data_try_again'), display('evaluation_behaviors')));
            return;
        }
    }
}
