<?php
$HmvcMenu["employee"] = array(
    "icon" => "<i class='fa fa-users'></i>",
    "position" => array(
        "controller" => "Employees",
        "method" => "create_position",
        "permission" => "read",
    ),
    'my_profile' => [
        "controller" => "Employees",
        "method" => "cv",
        "permission" => "all",
    ],
    "direct_empl" => array(
        "add_employee" => array(
            "controller" => "employees",
            "method" => "create_employee",
            "permission" => "create",
        ),
        "manage_employee" => array(
            "controller" => "Employees",
            "method" => "manageemployee",
            "permission" => "read",
        ),
        "employee_credentials" => array(
            "controller" => "Employees",
            "method" => "credentials",
            "permission" => "read",
        ),
        'employee_settings' => [
            'employee_form_options' => [
                'controller' => 'form_options',
                'method' => 'list',
                'permission' => 'read',
            ],
        ],
    ),
    /* 'performance_management' => [
        'evaluations_generate' => [
            'controller' => 'evaluation',
            'method' => 'generate',
            'permission' => 'create'
        ],
        'evaluations_pending' => [
            'controller' => 'evaluation',
            'method' => 'pending',
            'permission' => 'read'
        ],
        'evaluations_approved' => [
            'controller' => 'evaluation',
            'method' => 'approved',
            'permission' => 'read'
        ],
        'evaluation_setting' => [
            'general_settings' => [
                'controller' => 'evaluation',
                'method' => 'settings',
                'permission' => 'read'
            ],
            'evaluation_behaviors' => [
                'controller' => 'evaluation',
                'method' => 'behaviors',
                'permission' => 'read'
            ],
            'evaluation_objectives' => [
                'controller' => 'evaluation',
                'method' => 'objectives',
                'permission' => 'read'
            ],
            'eval_employee_roles' => [
                'controller' => 'evaluation',
                'method' => 'employee_roles',
                'permission' => 'read'
            ],
            'eval_rating_scale' => [
                'controller' => 'evaluation',
                'method' => 'rating_scale',
                'permission' => 'read'
            ]
        ]
    ], */
    'bulk_emp_menu' => array(
        "add_employee_bulk" => array(
            "controller" => "bulk",
            "method" => "import",
            "permission" => "create",
        ),
        "update_employee_bulk" => array(
            "controller" => "bulk",
            "method" => "update",
            "permission" => "create",
        ),
        "bulk_leave_update" => array(
            "controller" => "bulk",
            "method" => "leave_update",
            "permission" => "create",
        ),
        "bulk_doc_update" => array(
            "controller" => "Employees_documents",
            "method" => "bulk_upload",
            "permission" => "create",
        ),
        "bulk_increment_update" => array(
            "controller" => "increments",
            "method" => "bulk",
            "permission" => "create",
        ),
    ),
    "pending_changes" => array(
        "controller" => "Pending_changes",
        "method" => "list",
        "permission" => "read",
    ),
    'domain_requests' => array(
        "controller" => "domain_request",
        "method" => "list",
        "permission" => "read",
    ),
    'employee_documents' => array(
        "employee_documents_pending" => array(
            "controller" => "Employees_documents",
            "method" => "pending",
            "permission" => "read",
        ),
        "employee_document_types" => array(
            "controller" => "Employees_documents",
            "method" => "types",
            "permission" => "read",
        ),
    ),
);
