<?php
class Logs_model extends CI_Model
{
    private $_exclude = [ '.', '..', 'index.html', '.gitkeep'];
    private $_root = 'application/logs/';
    public function get_files($path)
    {
        $path = $this->_root . $path;
        $path = rtrim($path, '/') . '/';
        $_files = scandir(FCPATH . $path);
        $_files = array_diff($_files, $this->_exclude);

        $files = [];
        foreach ($_files as $file) {
            if(is_dir(FCPATH . $path . $file)) {
                continue;
            }
            $stats = stat(FCPATH . $path . $file);
            $files[] = [
                'name' => $file,
                'path' => $path . $file,
                'size' => $stats['size'],
                'modified' => $stats['mtime']
            ];
        }
        return $files;
    }
    public function get_file($dir, $name)
    {
        $dir = preg_replace('#[^\w]+#is', '', $dir);
        $dir = rtrim($dir, '/') . '/';
        header('Content-Type: application/octet-stream');
        header("Content-Transfer-Encoding: Binary"); 
        header("Content-disposition: attachment; filename=\"" . basename($name) . "\"");
        readfile($this->_root . $dir  . $name);
    }
}
