<?php $this->load->view('dashboard/partials/angular') ?>
<script>
hrmApp.controller('dashboard_ctrl', function($scope, $http, $interval, $cookies, $uibModal) {

    let current_date = new Date();
    let current_year = current_date.getFullYear();
    let current_month = ("0" + (current_date.getMonth() + 1)).slice(-2);
    $scope.value = {
        currentDate: `${current_year}-${current_month}`
    };

    $scope.get_saved_chart_type = function() {
        let obj = $cookies.getObject('hrm_dashboard_chart_type')
        if(obj) {
            if(obj.id == '<?=$this->session->userdata('id')?>') {
                return obj.type
            }
            $cookies.remove('hrm_dashboard_chart_type')
        }
        return null
    }
    $scope.is_admin = '<?= $this->session->userdata('isAdmin')==1 || $this->session->userdata('supervisor')==1 ? '1' : '0'?>';
    $scope.base_url = '<?=base_url()?>';
    $scope.exempted_employee = false;
    $scope.employees = {
        loading: false,
        data: {},
        error: null
    }
    $scope.summary = {
        loading: false,
        data: {},
        error: null
    }
    $scope.this_month = {
        loading: false,
        attrition_rate: -1,
        data: {},
        error: null
    }
    $scope.attendance = {
        worked_hours: 0,
        checked_in: false,
        work_timer: null,
        loading: true,
        error: null
    }
    $scope.leave_types = {
        loading: false,
        data: [],
        error: null
    }
    $scope.departments = {
        loading: false,
        data: []
    }
    $scope.notices = {
        loading: false,
        error: null,
        data: [],
        page: 0,
        limit: 7,
        end: false,
        previous: () => {
            if($scope.notices.page > 0) {
                $scope.notices.end = false;
                $scope.notices.page--;
                $scope.notices._load()
            }
        },
        next: () => {
            if($scope.notices.data.length == $scope.notices.limit) {
                $scope.notices.page++;
                $scope.notices._load()
            }
        },
        _load: () => {
            $scope.notices.loading = true;
            $http.get('<?= base_url('dashboard/home/stats') ?>', {params: {type: 'notices', page: $scope.notices.page, limit: $scope.notices.limit}})
            .then((res) => {
                $scope.notices.loading = false;
                if(res.data && res.data.notices) {
                    if(res.data.notices && res.data.notices.posts.length > 0) {
                        $scope.notices.data = res.data.notices.posts
                    }
                    if(res.data.notices && res.data.notices.next < 1) {
                        $scope.notices.end = true;
                    }
                }
            }, () => {
                $scope.notices.loading = false;
                $scope.notices.error = '<?= display('unable_load_notices') ?>';
            })
        }
    }
    $scope.break_exceeeded_emps = {
        loading: false,
        error: null,
        data: [],
        page: 0,
        limit: 18,
        end: false,
        previous: () => {
            if($scope.break_exceeeded_emps.page > 0) {
                $scope.break_exceeeded_emps.end = false;
                $scope.break_exceeeded_emps.page--;
                $scope.break_exceeeded_emps._load()
            }
        },
        next: () => {
            if($scope.break_exceeeded_emps.data.length == $scope.break_exceeeded_emps.limit) {
                $scope.break_exceeeded_emps.page++;
                $scope.break_exceeeded_emps._load()
            }
        },
        _load: () => {
            $scope.break_exceeeded_emps.loading = true;
            $http.get('<?= base_url('dashboard/home/stats') ?>', {params: {type: 'break_exceeeded_emps', page: $scope.break_exceeeded_emps.page, limit: $scope.break_exceeeded_emps.limit}})
            .then((res) => {
                $scope.break_exceeeded_emps.loading = false;
                if(res.data && res.data.break_time) {
                    if(res.data.break_time && res.data.break_time.exceeeded_emps.length > 0) {
                        $scope.break_exceeeded_emps.data = res.data.break_time.exceeeded_emps
                    }
                    if(res.data.break_time && res.data.break_time.next < 1) {
                        $scope.break_exceeeded_emps.end = true;
                    }
                }
            }, () => {
                $scope.break_exceeeded_emps.loading = false;
                $scope.break_exceeeded_emps.error = '<?= display('unable_load_break_exceeeded_emps') ?>';
            })
        }
    }
    $scope.absent_employee_list = {
        loading: false,
        error: null,
        data: [],
        page: 0,
        limit: 18,
        end: false,
        previous: () => {
            if($scope.absent_employee_list.page > 0) {
                $scope.absent_employee_list.end = false;
                $scope.absent_employee_list.page--;
                $scope.absent_employee_list._load()
            }
        },
        next: () => {
            if($scope.absent_employee_list.data.length == $scope.absent_employee_list.limit) {
                $scope.absent_employee_list.page++;
                $scope.absent_employee_list._load()
            }
        },
        _load: () => {
            $scope.absent_employee_list.loading = true;
            $http.get('<?= base_url('dashboard/home/stats') ?>', {params: {type: 'absent_employee_list', page: $scope.absent_employee_list.page, limit: $scope.absent_employee_list.limit}})
            .then((res) => {
                $scope.absent_employee_list.loading = false;
                if(res.data && res.data.attendance) {
                    if(res.data.attendance && res.data.attendance.absent.length > 0) {
                        $scope.absent_employee_list.data = res.data.attendance.absent
                    }
                    if(res.data.attendance && res.data.attendance.next < 1) {
                        $scope.absent_employee_list.end = true;
                    }
                }
            }, () => {
                $scope.absent_employee_list.loading = false;
                $scope.absent_employee_list.error = '<?= display('unable_load_absent_employee_list') ?>';
            })
        }
    }
    $scope.present_employee_list = {
        loading: false,
        error: null,
        data: [],
        page: 0,
        limit: 18,
        end: false,
        previous: () => {
            if($scope.present_employee_list.page > 0) {
                $scope.present_employee_list.end = false;
                $scope.present_employee_list.page--;
                $scope.present_employee_list._load()
            }
        },
        next: () => {
            if($scope.present_employee_list.data.length == $scope.present_employee_list.limit) {
                $scope.present_employee_list.page++;
                $scope.present_employee_list._load()
            }
        },
        _load: () => {
            $scope.present_employee_list.loading = true;
            $http.get('<?= base_url('dashboard/home/stats') ?>', {params: {type: 'present_employee_list', page: $scope.present_employee_list.page, limit: $scope.present_employee_list.limit}})
            .then((res) => {
                $scope.present_employee_list.loading = false;
                if(res.data && res.data.attendance) {
                    if(res.data.attendance && res.data.attendance.present.length > 0) {
                        $scope.present_employee_list.data = res.data.attendance.present
                    }
                    if(res.data.attendance && res.data.attendance.next < 1) {
                        $scope.present_employee_list.end = true;
                    }
                }
            }, () => {
                $scope.present_employee_list.loading = false;
                $scope.present_employee_list.error = '<?= display('unable_load_present_employee_list') ?>';
            })
        }
    }
    $scope.today_leaves = {
        loading: false,
        error: null,
        data: [],
        page: 0,
        limit: 18,
        end: false,
        previous: () => {
            if($scope.today_leaves.page > 0) {
                $scope.today_leaves.end = false;
                $scope.today_leaves.page--;
                $scope.today_leaves._load()
            }
        },
        next: () => {
            if($scope.today_leaves.data.length == $scope.today_leaves.limit) {
                $scope.today_leaves.page++;
                $scope.today_leaves._load()
            }
        },
        _load: () => {
            $scope.today_leaves.loading = true;
            $http.get('<?= base_url('dashboard/home/stats') ?>', {params: {type: 'today_leaves', page: $scope.today_leaves.page, limit: $scope.today_leaves.limit}})
            .then((res) => {
                $scope.today_leaves.loading = false;
                if(res.data && res.data.leave) {
                    if(res.data.leave && res.data.leave.today.length > 0) {
                        $scope.today_leaves.data = res.data.leave.today
                    }
                    if(res.data.leave && res.data.leave.next < 1) {
                        $scope.today_leaves.end = true;
                    }
                }
            }, () => {
                $scope.today_leaves.loading = false;
                $scope.today_leaves.error = '<?= display('unable_load_today_leaves') ?>';
            })
        }
    }
    $scope.tomorrow_leaves = {
        loading: false,
        error: null,
        data: [],
        page: 0,
        limit: 18,
        end: false,
        previous: () => {
            if($scope.tomorrow_leaves.page > 0) {
                $scope.tomorrow_leaves.end = false;
                $scope.tomorrow_leaves.page--;
                $scope.tomorrow_leaves._load()
            }
        },
        next: () => {
            if($scope.tomorrow_leaves.data.length == $scope.tomorrow_leaves.limit) {
                $scope.tomorrow_leaves.page++;
                $scope.tomorrow_leaves._load()
            }
        },
        _load: () => {
            $scope.tomorrow_leaves.loading = true;
            $http.get('<?= base_url('dashboard/home/stats') ?>', {params: {type: 'tomorrow_leaves', page: $scope.tomorrow_leaves.page, limit: $scope.tomorrow_leaves.limit}})
            .then((res) => {
                $scope.tomorrow_leaves.loading = false;
                if(res.data && res.data.leave) {
                    if(res.data.leave && res.data.leave.tomorrow.length > 0) {
                        $scope.tomorrow_leaves.data = res.data.leave.tomorrow
                    }
                    if(res.data.leave && res.data.leave.next < 1) {
                        $scope.tomorrow_leaves.end = true;
                    }
                }
            }, () => {
                $scope.tomorrow_leaves.loading = false;
                $scope.tomorrow_leaves.error = '<?= display('unable_load_tomorrow_leaves') ?>';
            })
        }
    }
    $scope.this_week_leaves = {
        loading: false,
        error: null,
        data: [],
        page: 0,
        limit: 18,
        end: false,
        previous: () => {
            if($scope.this_week_leaves.page > 0) {
                $scope.this_week_leaves.end = false;
                $scope.this_week_leaves.page--;
                $scope.this_week_leaves._load()
            }
        },
        next: () => {
            if($scope.this_week_count == $scope.this_week_leaves.limit) {
                $scope.this_week_leaves.page++;
                $scope.this_week_leaves._load()
            }
        },
        _load: () => {
            $scope.this_week_leaves.loading = true;
            $http.get('<?= base_url('dashboard/home/stats') ?>', {params: {type: 'this_week_leaves', page: $scope.this_week_leaves.page, limit: $scope.this_week_leaves.limit}})
            .then((res) => {
                $scope.this_week_leaves.loading = false;
                if(res.data && res.data.leave) {
                    if(res.data.leave && res.data.leave.this_week_count > 0) {
                        $scope.this_week_leaves.data = res.data.leave.this_week
                        $scope.this_week_count = res.data.leave.this_week_count;
                    }
                    if(res.data.leave && res.data.leave.next < 1) {
                        $scope.this_week_leaves.end = true;
                    }
                }
            }, () => {
                $scope.this_week_leaves.loading = false;
                $scope.this_week_leaves.error = '<?= display('unable_load_up_coming_dates') ?>';
            })
        }
    }
    $scope.leaves = {
        total: 0
    }
    $scope.overview = {
        labels: [],
        data: []
    }
    $scope.pie = {
        colors: ['#C8E6C9', '#FFC0CB', '#803690', '#00ADF9', '#DCDCDC', '#FF0000', '#FFE0B2', '#FDB45C', '#949FB1', '#4D5360'],
        options: {
            animationEnabled: true,
            title: {
                display: true,
                fontColor: "#607D8B",
                fontSize: 15,
                fontFamily: 'serif',
                text: "<?= display('present_employees') ?>"
            },
            legend: {
                display: true,
                position: 'right'
            }
        },
        type: $scope.get_saved_chart_type() ?? 'pie',
        dropdown: []
    }
    $scope.type_details = {}
    $scope.change_chart = function() {
        switch ($scope.pie.type) {
            case 'pie':
            case 'doughnut':
            case 'polarArea':{
                $scope.pie.options.legend.display = true
                break;
            }
            default: {
                $scope.pie.options.legend.display = false
                break;
            }
        }
        $cookies.putObject('hrm_dashboard_chart_type', {type: $scope.pie.type, id: '<?=$this->session->userdata('id')?>'}, {
            'expires':"Mon, 31 Dec 9999 23:59:59 GMT"
        })
    }
    $scope.chart_departments = function(item) {
        $scope.pie.options.title.text = `${item.label}`;
        $scope.pie.labels = Object.keys(item.attendance).map((str) => {
                    return str.replace(/[\_\-]+/gi, '_').split('_').map((s) => {
                        return s.charAt(0).toUpperCase() + s.substr(1)
                    }).join(' ')
                })
        $scope.pie.data = Object.values(item.attendance)
    }
    <?php if($this->permission->method('manage_employee', 'update')->access() || $this->session->userdata('supervisor')):?>
    $scope.fetch_employees = function() {
        $scope.employees.loading = true
        $http.get('<?=base_url('dashboard/home/stats')?>', {params: {type: 'employees'}}).then((res) => {
            $scope.employees.loading = false;
            if (res.data) {
                $scope.employees.data = res.data.employees
            }
        }, () => {
            $scope.employees.loading = false;
            $scope.employees.error = '<?= display('unable_load_stats') ?>'
        })
    }
    $scope.fetch_attendance = function() {
        $scope.summary.loading = $scope.leave_types.loading = true
        $http.get('<?=base_url('dashboard/home/stats')?>', {params: {type: 'attendance,departments'}}).then((res) => {
            $scope.summary.loading = $scope.leave_types.loading = false;
            if (res.data) {
                $scope.summary.data = res.data.attendance.summary
                $scope.leave_types.data = res.data.attendance.leave_types
                $scope.departments.data = res.data.departments
                $scope.pie.dropdown = angular.copy(res.data.departments)
                $scope.pie.dropdown.unshift({
                    label: 'All Departments',
                    attendance: angular.copy(res.data.attendance.summary)
                })
                $scope.selected_chart_department = $scope.pie.dropdown[0]
                if (res.data.attendance.summary.paid_leave) {
                    $scope.leaves.total = res.data.attendance.summary.paid_leave
                }
                $scope.pie.labels = $scope.overview.labels = Object.keys(res.data.attendance.summary).map((str) => {
                    return str.replace(/[\_\-]+/gi, '_').split('_').map((s) => {
                        return s.charAt(0).toUpperCase() + s.substr(1)
                    }).join(' ')
                })
                $scope.pie.data = $scope.overview.data = Object.values(res.data.attendance.summary)
            }
        }, () => {
            $scope.summary.loading = $scope.leave_types.loading = false;
            $scope.summary.error = $scope.leave_types.error = '<?= display('unable_load_stats') ?>'
        })
    }
    $scope.fetch_this_month = function(date_filter = null) {
        $scope.this_month.loading = true
        $http.get('<?=base_url('dashboard/home/stats')?>', {params: {type: 'this_month,attrition_rate',date: date_filter}}).then((res) => {
            $scope.this_month.loading = false;
            if (res.data) {
                $scope.this_month.data = res.data.this_month
                $scope.this_month.attrition_rate = res.data.attrition_rate
            }
        }, () => {
            $scope.this_month.loading = false;
            $scope.this_month.error = '<?= display('unable_load_stats') ?>'
        })
    }
    $scope.fetch_employees()
    $scope.fetch_attendance()
    $scope.fetch_this_month()
    $scope.change_chart()

    $scope.dashboard_filter = function() {

        let selected_date = $scope.date_filter ?? new Date();
        let selectd_year = selected_date.getFullYear();
        let selectd_month = ("0" + (selected_date.getMonth() + 1)).slice(-2);
        
        $scope.fetch_this_month(`${selectd_year}-${selectd_month}`)
    }
    <?php endif ?>
    <?php if($this->session->userdata('employee_id')): ?>
    $scope.fetch_work_time = function() {
        $http.get('<?=base_url('dashboard/home/stats')?>', {params: {type: 'work_time'}}).then((res) => {
            if (!res.data) {
                console.log('Error no data received');
                return
            }
            let remote_worked_hours = res.data.work_time.reduce((sum, item) => {
                return sum + parseInt(item.duration)
            }, 0);
            if($scope.attendance.worked_hours > 0 && Math.abs(remote_worked_hours - $scope.attendance.worked_hours) > 300) {
                $scope.attendance.worked_hours = remote_worked_hours;
            } else {
                $scope.attendance.worked_hours = remote_worked_hours;
            }
            $scope.attendance.checked_in = res.data.work_time.some((item) => {
                return item.punchout_time == null
            });
            $scope.attendance.work_timer && $interval.cancel($scope.attendance.work_timer);
            if (res.data.work_time && $scope.attendance.checked_in) {
                $scope.attendance.work_timer = $interval(() => {
                    $scope.attendance.worked_hours++;
                }, 1000);
            }
            $scope.attendance.loading = false;
        }, () => {
            console.log('Attendance fetch failed');
        })
    }
    $interval($scope.fetch_work_time, 60000)
    $scope.fetch_work_time()
    <?php endif ?>
    $scope.get_data = function(type, key, callback) {
        if(!$scope.type_details[type]) {
            $scope.type_details[type] = {}
        }
        if(!$scope.type_details[type][key]) {
            $scope.type_details[type][key] = {
                loading: false,
                data: null,
                error: null
            }
        }
        if($scope.type_details[type][key].loading) {
            return
        }
        
        $scope.type_details[type][key].loading = true
       
        if($scope.type_details[type][key].data && type != 'this_month') {
            $scope.type_details[type][key].loading = false
            return callback($scope.type_details[type][key].data)
        }

        let datefilter = '';
        
        if (type == 'this_month') {
            let selected_date = $scope.date_filter ?? new Date();
            let selectd_year = selected_date.getFullYear();
            let selectd_month = ("0" + (selected_date.getMonth() + 1)).slice(-2);
            datefilter = `${selectd_year}-${selectd_month}` ;
        }

        $http.post('<?= base_url('dashboard/home/details') ?>', {type, key, datefilter})
        .then((res) => {
            $scope.type_details[type][key].loading = false;
            if(res.data.success) {
                $scope.type_details[type][key].data = res.data.success
                callback($scope.type_details[type][key].data);
            }
        }, () => {
            $scope.type_details[type][key].loading = false;
            alert('<?= display('unable_load_stats') ?>')
        })
    }
    $scope.show_stat_detail = function(type, key) {

        $scope.exempted_employee = false;
        if(type == 'employee') {
            switch (key) {
                case 'total':
                    return;
                    break;
            }
        }
        $scope.get_data(type, key, (data) => {
            if(data) {
                $uibModal.open({
                    templateUrl: 'myModalContent.html',
                    controller: function ($uibModalInstance, title, headings, items, type, key, sortBy, sortOrder) {
                        var dm = this;
                        dm.filter = [];
                        dm.type = type;
                        dm.key = key;
                        dm.title = title;
                        dm.headings = headings;
                        dm.items = items;
                        dm.sortBy = sortBy
                        dm.reverseSort = sortOrder == 'asc'
                        dm.remove_item_index = '';

                        dm.myFilter = () => {
                            return (item) => {
                                if(dm.filter.length < 1 || dm.filter.filter((v) => {return !!v}).length < 1) {
                                    return true;
                                }
                                let returnVal = true;
                                for (const dataKey in dm.filter) {
                                    if(!dm.filter[dataKey]) {
                                        continue;
                                    }
                                    let val = (item[dataKey] ?? '').toLowerCase();
                                    returnVal = returnVal && val.indexOf(dm.filter[dataKey].toLowerCase()) >= 0
                                }
                                return returnVal;
                            }
                        }
                        dm.sortByIndex = function (index) {
                            dm.orderByField = ((index ?? dm.sortBy) ?? 0).toString();
                            dm.reverseSort = !dm.reverseSort
                        }
                        dm.exclude_attendance = function (key, value) {
                            //dm.items[index][0]
                            //var remove_item_index;
                            dm.items.find(function(item,index){
                               if(item[0]==value[0]){
                                dm.remove_item_index = index;
                                return;
                               }
                            });

                            $http.post('<?= base_url('dashboard/home/exempt') ?>', {key, id: value[0]}).then((res) => {
                                if(res.data.success) {
                                    $scope.exempted_employee = true;
                                    //dm.items.splice(index, 1)
                                    dm.items.splice(dm.remove_item_index, 1);
                                }
                            });
                        };
                        dm.close = function () {
                            $uibModalInstance.dismiss('cancel');
                        };
                        dm.sortByIndex()
                    },
                    size: 'lg',
                    controllerAs: 'dm',
                    resolve: {
                        title: () => {
                            return data.title;
                        },
                        headings: () => {
                            return data.headings;
                        },
                        items: () => {
                            return data.items
                        },
                        sortBy: () => {
                            return data.sortBy ?? 0
                        },
                        sortOrder: () => {
                            return data.sortOrder ?? 'asc'
                        },
                        type: () => {
                            return type
                        },
                        key: () => {
                            return key
                        }
                    }
                }).result.then(() => {}, () => {
                    if($scope.exempted_employee) {
                        $scope.fetch_attendance()
                        try {
                           $scope.type_details['attendance'] = null
                        } catch (error) {
                            
                        }
                    }
                })
            }
        })
    }
    $scope.notices._load()

    if ($scope.is_admin == '1') {
        $scope.break_exceeeded_emps._load()
        $scope.absent_employee_list._load()
        $scope.present_employee_list._load()
        $scope.today_leaves._load()
        $scope.tomorrow_leaves._load()
        $scope.this_week_leaves._load()
    }
    
})
</script>