<style type="text/css">
/*Graph/Chart Styling*/
.pretty .state label{display: flex;}

@media only screen and (min-width:1600px)
{
.chart-base.ng-isolate-scope {max-width: 75% !important;}
}

@media only screen and (min-width:1200px)
{
 .fixed-height-panel {
    min-height: 450px;
    max-height: 450px;
}
.chart-base.ng-isolate-scope {
    width: 100% !important;
    height: 100% !important;
    margin-left: auto;
    margin-right: auto;
}
#pie-panel{position:relative;}
#pie-panel .panel-footer{position: absolute;bottom: 0px;width: 100%;}

}

@media only screen and (max-width:1199px) and (min-width:992px)
{
.chart-base.ng-isolate-scope {
    width: 75% !important;
    height: 100% !important;
    margin-left: auto;
    margin-right: auto;
}
}

@media only screen and (max-width:991px) and (min-width:640px)
{
#stat-panels{display: grid;
grid-template-columns: 50% 50%;}
#stat-panels::before,#stat-panels::after{display:none;}

}


.attendance-status-align {
    margin-right: 5px;
}


#ui-datepicker-div {
    top: 317px;
    left: 1081.75px;
    display: block;
    width: 180px;
    z-index: 1;
}
.chart_type_switch label {
    font-size: 12px;
}
.ui-datepicker-calendar {
    display: none;
}

.ui-datepicker-title {
    width: 100%;
    float: center;
}

.box-widget {
    border: none;
    position: relative;
}
.box {
    position: relative;
    border-radius: 3px;
    background: #ffffff;
    border-top: 3px solid #d2d6de;
    margin-bottom: 20px;
    width: 100%;
    box-shadow: 0 1px 1px rgba(0,0,0,0.1);
}
.box-widget .widget-user-header {
    padding: 20px;
    border-top-right-radius: 3px;
    border-top-left-radius: 3px;
}

.widget-user-desc {
    margin-left: 75px;
    color:#fff;
    margin-top: 15px;
    margin-bottom: 15px;
    white-space: nowrap;
}
.widget-user-username {
    margin-top: 5px;
    margin-bottom: 5px;
    font-size: 20px;
    font-weight: 300;
    color:#fff;
    white-space: nowrap;
}
.widget-user-image>i {
    width: 65px;
    height: auto;
    float: left;
    font-size: 50px;
}
.no-padding {
    padding: 0 !important;
}
.box-footer {
    border-top-left-radius: 0;
    border-top-right-radius: 0;
    border-bottom-right-radius: 3px;
    border-bottom-left-radius: 3px;
    border-top: 1px solid #f4f4f4;
    padding: 10px;
    background-color: #fff;
}
.box .nav-stacked>li {
    border-bottom: 1px solid #f4f4f4;
    margin: 0;
}
.box .nav-stacked>li:first-child {
    border-bottom: 1px solid black;
}
.nav-stacked>li>a {
    border-radius: 0;
    border-top: 0;
    border-left: 3px solid transparent;
    color: #444;
}
.payment {
    max-height: 450px;
    overflow-y: auto;
}
.active_date_event,
.date_event {
    background-color: orange;
 /*   height: fit-content !important;*/
}
.active_date_event>.event,
.date_event>.event{
    color: white;
    font-size: 10px;
    text-align: left;
    margin-left: 0px;
    font-weight: normal;
}
#stat-panels i.fa {
    font-size: 10px;
    color: #05253a;
}
.lds-ellipsis {
  display: inline-block;
}
.lds-ellipsis div {
  position: absolute;
  width: 13px;
  height: 13px;
  border-radius: 50%;
  background: #000;
  animation-timing-function: cubic-bezier(0, 1, 1, 0);
  top: 12px
}
.lds-ellipsis div:nth-child(1) {
  left: 8px;
  animation: lds-ellipsis1 0.6s infinite;
}
.lds-ellipsis div:nth-child(2) {
  left: 8px;
  animation: lds-ellipsis2 0.6s infinite;
}
.lds-ellipsis div:nth-child(3) {
  left: 32px;
  animation: lds-ellipsis2 0.6s infinite;
}
.lds-ellipsis div:nth-child(4) {
  left: 56px;
  animation: lds-ellipsis3 0.6s infinite;
}
@keyframes lds-ellipsis1 {
  0% {
    transform: scale(0);
  }
  100% {
    transform: scale(1);
  }
}
@keyframes lds-ellipsis3 {
  0% {
    transform: scale(1);
  }
  100% {
    transform: scale(0);
  }
}
@keyframes lds-ellipsis2 {
  0% {
    transform: translate(0, 0);
  }
  100% {
    transform: translate(24px, 0);
  }
}
#noticeboard li{
    border-bottom: 1px solid;
    padding: 3px 0px;
}
#pie-panel {
    overflow: visible;
}
.counter-hours .timer {
    top: 12px
}
.counter-hours .break-time {
    margin-top: 24px
}
.counter-hours .today-work-hour{
    margin-top: 48px
}
.counter-hours .card-details {
    width: fit-content;
    margin-top: 12px;
}
.bg-danger-panel {
    background-color: #d04f58e6;
}
.box-size {
    display: flex;
    flex-wrap: wrap;
}
.box-size-hight {
    display: grid;
}

.emp-image {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    margin-right: 5px;
    margin-bottom: 20px;
}
.border-danger {
    border: solid 2px #d04f58; 
}
.border-success {
    border: solid 2px green; 
}
.border-warning {
    border: solid 2px yellow;
}

.ui-tooltip {
    display: block !important;
}

.absent-modal-title {
    font-size: 20px;
    font-weight: 600;
    color: #000;
    padding-top: 15px;
    text-align: center;
}
.ps-3 {
    padding-top: 15px;
}

.alert-style {
    font-size: 18px;
}
.dt-refresh-btn {
    display: flex;
    align-items: center;
    justify-content: space-between;
}
.cardbox-icon  {
    top: 60% !important;
}
.modal-mark-status span.select2 {
    min-width: 100%;
}
#breaks_detail .modal-body {
    padding: 0px !important;
}
.status_icon span {
    margin-right: 2px;
}
.status_icon {
    display: flex;
    align-items: center;
}
.icon-warning::before {
        color: yellow !important;
}
.not-available-color::before {
    color: red !important;
}
.break-type i::before{
    color: yellow !important;
}
.punch-time {
        color: #fff;
        background-color: #de4e57;
        padding: 1px 2px;
}

</style>
<div class="se-pre-con">
    <div class="loader">Loading...</div>
</div>
<div ng-controller="dashboard_ctrl">
<?php if(($this->session->userdata('employee_id') || $this->session->userdata('supervisor')) && $unmarked_attendance == 0): ?>
        <div class="row">
            <div class="col-xs-12">
                <div class="alert alert-success alert-dismissible alert-style">
                    <p>Please mark today attendance</p>
                </div>
            </div>
        </div>
    <?php endif?>
    
    <div class="row counter-hours box-size- ">
        <?php if($this->session->userdata('employee_id') || $this->session->userdata('supervisor')): ?>
            <div class="col-xs-12 box-size-hight">
                <div class="panel cardbox bg-success">
                    <div class="panel-body card-item panel-refresh">
                    <div class="refresh-container" ng-show="attendance.loading"><i class="refresh-spinner fa fa-spinner fa-spin fa-5x"></i></div>
                        <div class="cardbox-icon">
                            <i class="material-icons">schedule</i>
                        </div>
                            <div class="card-details">
                                <h4>Total Login Time</h4>
                            </div>
                            <div class="timer">{{attendance.worked_hours | formatTimer}}</div>

                            <div class="card-details">
                                <h4>Total Break Time</h4>
                            </div>
                            <div class="timer break-time"><?= $break_time ?></div>

                            <div class="card-details">
                                <h4>Total Work Time</h4>
                            </div>
                            <div class="timer today-work-hour"><?= $totalWorkHours ?></div>
                        <div ng-show="attendance.checked_in"><br>Checked In</div>
                        <div ng-hide="attendance.checked_in"><br>Checked Out</div>
                    </div>
                </div>
            </div>
        <?php endif?>
    </div>
    
    <div class="row stat_panels_section box-size" id="stat-panels">
        <?php if($this->permission->method('manage_employee', 'update')->access() || $this->session->userdata('supervisor')):?>
            <div class="col-md-12 panel panel-bd ps-3">
                <div class="col-md-3">
                    <div class="box box-widget widget-user-2">
                        <div class="refresh-container" ng-show="employees.loading"><i class="refresh-spinner fa fa-spinner fa-spin fa-5x"></i></div>
                        <div class="widget-user-header bg-primary">
                            <div class="widget-user-image">
                                <i class="material-icons">people</i>
                            </div>
                            <h5 class="widget-user-desc"><?= display('total_employees') ?></h5>
                        </div>
                        <div class="box-footer no-padding">
                            <ul class="nav nav-stacked" ng-hide="employees.error">
                                <li ng-repeat="(key, value) in employees.data">
                                    <a href="#" ng-click="show_stat_detail('employee', key);$event.preventDefault();">
                                        <div ng-show="type_details['employee'][key].loading" class="lds-ellipsis"><div></div><div></div><div></div><div></div></div>
                                        <span ng-hide="type_details['employee'][key].loading">{{key | slug_to_readable}} <i ng-if="key != 'total'" class="fa fa-external-link" aria-hidden="true"></i></span><span class="pull-right badge bg-red">{{value}}</span>
                                    </a>
                                </li>
                            </ul>
                            <p ng-show="employees.error" class="error">{{employees.error}}</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="box box-widget widget-user-2">
                        <div class="refresh-container" ng-show="summary.loading"><i class="refresh-spinner fa fa-spinner fa-spin fa-5x"></i></div>
                        <div class="widget-user-header bg-warning">
                        <div class="widget-user-image">
                            <i class="material-icons">schedule</i>
                        </div>
                        <h5 class="widget-user-desc"><?= display('present_employees') ?></h5>
                        </div>
                        <div class="box-footer no-padding">
                            <ul class="nav nav-stacked" ng-hide="summary.error">
                                <li ng-repeat="(key, value) in summary.data" ng-if="value > 0">
                                    <a href="#" ng-click="show_stat_detail('attendance', key);$event.preventDefault();">
                                        <div ng-show="type_details['attendance'][key].loading" class="lds-ellipsis"><div></div><div></div><div></div><div></div></div>
                                        <span ng-hide="type_details['attendance'][key].loading">{{key | slug_to_readable}} <i class="fa fa-external-link" aria-hidden="true"></i></span><span class="pull-right badge bg-red">{{value}}</span>
                                    </a>
                                </li>
                            </ul>
                            <p ng-show="summary.error" class="error">{{summary.error}}</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="box box-widget widget-user-2">
                        <div class="refresh-container" ng-show="summary.loading"><i class="refresh-spinner fa fa-spinner fa-spin fa-5x"></i></div>
                        <div class="widget-user-header bg-success">
                        <div class="widget-user-image">
                            <i class="material-icons">perm_contact_calendar</i>
                        </div>
                        <h5 class="widget-user-desc"><?= display('leave_employees') ?></h5>
                        </div>
                        <div class="box-footer no-padding">
                            <ul class="nav nav-stacked" ng-hide="leave_types.error">
                                <li ng-if="leave_types.data.length != 1">
                                    <a href="#" ng-click="leaves.total > 0 && show_stat_detail('leave', 'all');$event.preventDefault();">
                                        <div ng-show="type_details['leave']['all'].loading" class="lds-ellipsis"><div></div><div></div><div></div><div></div></div>
                                        <span ng-hide="type_details['leave']['all'].loading">Total <i ng-if="leaves.total > 0" class="fa fa-external-link" aria-hidden="true"></i></span><span class="pull-right badge bg-red" >{{leaves.total}}</span>
                                    </a>
                                </li>
                                <li ng-repeat="leave_type in leave_types.data">
                                    <a href="#" ng-click="show_stat_detail('leave', leave_type.id);$event.preventDefault();">
                                        <div ng-show="type_details['leave'][leave_type.id].loading" class="lds-ellipsis"><div></div><div></div><div></div><div></div></div>    
                                        <span ng-hide="type_details['leave'][leave_type.id].loading">{{leave_type.label | slug_to_readable}} <i class="fa fa-external-link" aria-hidden="true"></i></span><span class="pull-right badge bg-red">{{leave_type.count}}</span>
                                    </a>
                                </li>
                            </ul>
                            <p ng-show="leave_types.error" class="error">{{leave_types.error}}</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="box box-widget widget-user-2">
                        <div class="refresh-container" ng-show="this_month.loading"><i class="refresh-spinner fa fa-spinner fa-spin fa-5x"></i></div>
                        <div class="widget-user-header bg-danger-panel">
                        <div class="widget-user-image">
                            <i class="material-icons">event_available</i>
                        </div>
                        <h5 class="widget-user-desc"><?= display('this_month') ?></h5>
                        <input type="month" name="date_filter" ng-value="value.currentDate"
                            class="form-control date_filter" id="date_filter" ng-model="date_filter" ng-change="dashboard_filter('date_filter');$event.preventDefault();">
                        </div>
                        <div class="box-footer no-padding">
                            <ul class="nav nav-stacked" ng-hide="this_month.error">
                                <li ng-repeat="(key, val) in this_month.data">
                                    <a href="#" ng-click="val && show_stat_detail('this_month', key);$event.preventDefault();">
                                        <div ng-show="type_details['this_month'][key].loading" class="lds-ellipsis"><div></div><div></div><div></div><div></div></div>
                                        <span ng-hide="type_details['this_month'][key].loading">{{key | slug_to_readable}} <span ng-show="key == 'separations' && this_month.attrition_rate >= 0">({{this_month.attrition_rate}}%)</span> <i ng-show="val" class="fa fa-external-link" aria-hidden="true"></i></span><span class="pull-right badge bg-red">{{val}}</span>
                                    </a>
                                </li>
                            </ul>
                            <p ng-show="this_month.error" class="error">{{this_month.error}}</p>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif?>
        <?php if($this->session->userdata('position_id') == 101 || $this->session->userdata('isAdmin') == 1): ?>
            <div class="box-size-hight col-sm-12">
                <div class="panel panel-bd">
                    <div class="panel-heading dt-refresh-btn">
                        <div class="panel-title">Break Time</div>
                        <div><button type="submit" class="btn btn-success btn-sm dt-refresh">Refresh</button></div>
                        
                    </div>
                    <div class="panel-body table-responsive">
                        <!-- <div class="row" >
                            <div class="col-lg-6 col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="filter_by_date"><?=display('date')?>:</label>
                                    <input type="date" name="filter_by_date" class="form-control filter_by_date" value="<?= date('Y-m-d') ?>" id="filter_by_date">
                                </div>
                            </div>
                        </div> -->
                        <table width="100%" class="table table-striped table-bordered table-hover" id="break_time_table">
                            <thead>
                                <tr>
                                    <th><?php echo display('employee') ?></th>
                                    <th><?php echo display('Break Type') ?></th>
                                    <th><?php echo display('date') ?></th>
                                    <th><?php echo display('start') ?></th>
                                    <th><?php echo display('end') ?></th>
                                    <th><?php echo display('duration') ?></th>
                                    <th><?php echo display('started_by') ?></th>
                                    <th><?php echo display('ended_by') ?></th>
                                </tr>
                            </thead>
                            <tbody id="table-body">
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        <?php endif?>

        <?php if($this->session->userdata('isAdmin') == 1 || $this->session->userdata('supervisor')):?>
            <input type="hidden" value="<?= $this->session->userdata('isAdmin') == 1 ? 'is_admin' : '' ?>" id="action-permition">
        
            <div id="team-status" class="box-size-hight col-md-6 col-lg-6 col-sm-12">
                <div class="panel panel-bd">
                <div class="panel-heading text-center">
                    <div class="panel-title">Team Status</div>
                </div>

                    <div class="panel-heading">
                            <div class="panel-title">Available</div>
                    </div>
                    <div class="panel-body">
                        <div class="refresh-container" ng-show="present_employee_list.loading"><i class="refresh-spinner fa fa-spinner fa-spin fa-5x"></i></div>
                        <div style="margin-right: 0px;" class="row emp-attendance-status text-center" ng-hide="present_employee_list.error">
                            <div class="col-lg-2 col-md-2 col-sm-2" ng-repeat="employee in present_employee_list.data track by $index">
                                    <div style="display: flex;align-items: center;">
                                        <img data-toggle="tooltip" title="{{ employee.first_name }}  {{ employee.last_name }}  ({{ employee.hrm_id }})" 
                                        ng-src="{{base_url}}{{employee.picture_thumbnail != '' && employee.picture_thumbnail || 'assets/img/icons/user.png' }}" class="emp-image border-success" alt="User Image">
                                    </div>
                            </div>
                        </div>
                        <p class="text-center" ng-if="present_employee_list.data.length == 0">No Records Found</p>
                        <div style="margin-top: 10px;">
                            <a ng-show="present_employee_list.page > 0" href="#" ng-click="present_employee_list.previous();$event.preventDefault();"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</a>
                            <a ng-hide="present_employee_list.end" class="pull-right" href="#" ng-click="present_employee_list.next();$event.preventDefault();">Next <i class="fa fa-arrow-right" aria-hidden="true"></i></a>
                        </div>
                        <p ng-show="present_employee_list.error" class="error">{{present_employee_list.error}}</p>
                    </div>
                    <div class="panel-heading">
                        <div class="panel-title">Not Available</div>
                    </div>
                    <div class="panel-body">
                        <div class="refresh-container" ng-show="absent_employee_list.loading"><i class="refresh-spinner fa fa-spinner fa-spin fa-5x"></i></div>
                        <div style="margin-right: 0px;" class="row emp-attendance-status text-center" ng-hide="absent_employee_list.error">
                            <div class="col-lg-2 col-md-2 col-sm-2" ng-repeat="employee in absent_employee_list.data track by $index">
                                
                                <a href="Javascript:void(0)" class="add-attendance-status" data-employee_name="{{ employee.first_name }}  {{ employee.last_name }}  ({{ employee.hrm_id }})" data-employee_id="{{ employee.employee_id }}">
                                    <div style="/*display: flex;*/ /*align-items: center;*/">
                                        <img data-toggle="tooltip" title="{{ employee.first_name }}  {{ employee.last_name }}  ({{ employee.hrm_id }}) ({{ (employee.status == null) ? '---' : ((employee.status == '3') ? 'Informed' : ((employee.status == 1) ? 'NCNS' : 'Late Arrival')) }})" 
                                        ng-src="{{base_url}}{{employee.picture_thumbnail != '' && employee.picture_thumbnail || 'assets/img/icons/user.png' }}" 
                                        class="emp-image border-danger" alt="User Image">
                                    </div>
                                </a>
                            </div>
                        </div>
                        <p class="text-center" ng-if="absent_employee_list.data.length == 0">No Records Found</p>
                        <div style="margin-top: 10px;">
                            <a ng-show="absent_employee_list.page > 0" href="#" ng-click="absent_employee_list.previous();$event.preventDefault();"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</a>
                            <a ng-hide="absent_employee_list.end" class="pull-right" href="#" ng-click="absent_employee_list.next();$event.preventDefault();">Next <i class="fa fa-arrow-right" aria-hidden="true"></i></a>
                        </div>
                        <p ng-show="absent_employee_list.error" class="error">{{absent_employee_list.error}}</p>
                    </div>

                    <div class="panel-heading">
                        <div class="panel-title">Break Times</div>
                    </div>
                    <div class="panel-body">
                        <div class="refresh-container" ng-show="break_exceeeded_emps.loading"><i class="refresh-spinner fa fa-spinner fa-spin fa-5x"></i></div>
                        <div style="margin-right: 0px;" class="row emp-brak-time-view text-center" ng-hide="break_exceeeded_emps.error">
                            <div class="col-lg-2 col-md-2 col-sm-2" ng-repeat="employee in break_exceeeded_emps.data track by $index">

                                <a href="Javascript:void(0)" class="view-break-time-status" data-employee_id="{{ employee.employee_id }}">
                                    <div style="/*display: flex;*/ /*align-items: center;*/">
                                        <img data-toggle="tooltip" title="{{ employee.first_name }}  {{ employee.last_name }}  ({{ employee.hrm_id }}) {{ employee.duration | formatTimer}}" 
                                        ng-src="{{base_url}}{{employee.picture != '' && employee.picture || 'assets/img/icons/user.png' }}" 
                                        class="emp-image {{(employee.duration > 3600) ? 'border-warning' : 'border-success'}}" alt="User Image">
                                    </div>
                                </a>
                            </div>
                        </div>
                        <p class="text-center" ng-if="break_exceeeded_emps.data.length == 0">No Records Found</p>
                        <div style="margin-top: 10px;">
                            <a ng-show="break_exceeeded_emps.page > 0" href="#" ng-click="break_exceeeded_emps.previous();$event.preventDefault();"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</a>
                            <a ng-hide="break_exceeeded_emps.end" class="pull-right" href="#" ng-click="break_exceeeded_emps.next();$event.preventDefault();">Next <i class="fa fa-arrow-right" aria-hidden="true"></i></a>
                        </div>
                        <p ng-show="break_exceeeded_emps.error" class="error">{{break_exceeeded_emps.error}}</p>
                    </div>
                </div>
            </div>
            <div id="team-leave-status" class="box-size-hight col-md-6 col-lg-6 col-sm-12">
                <div class="panel panel-bd">
                <div class="panel-heading text-center">
                    <div class="panel-title">Team Leave Status</div>
                </div>
                    <div class="panel-heading">
                        <div class="panel-title">Today</div>
                    </div>
                    <div class="panel-body">
                        <div class="refresh-container" ng-show="today_leaves.loading"><i class="refresh-spinner fa fa-spinner fa-spin fa-5x"></i></div>
                        <div style="margin-right: 0px;" class="row emp-attendance-status text-center" ng-hide="today_leaves.error">
                            <div class="col-lg-2 col-md-2 col-sm-2" ng-repeat="employee in today_leaves.data track by $index">
                                
                                <a href="Javascript:void(0)" class="add-attendance-status" data-employee_name="{{ employee.first_name }}  {{ employee.last_name }}  ({{ employee.hrm_id }})" data-employee_id="{{ employee.employee_id }}">
                                    <div style="display: flex;align-items: center;">
                                        <img data-toggle="tooltip" title="{{ employee.first_name }}  {{ employee.last_name }}  ({{ employee.hrm_id }})" 
                                        ng-src="{{base_url}}{{employee.picture != '' && employee.picture || 'assets/img/icons/user.png' }}" class="emp-image border-danger" alt="User Image">
                                        
                                        <!-- {{employee.picture != '' && employee.picture || 'assets/img/icons/user.png' }} -->
                                    </div>
                                </a>
                            </div>
                        </div>
                        <p class="text-center" ng-if="today_leaves.data.length == 0">No Records Found</p>
                        <div style="margin-top: 10px;">
                            <a ng-show="tomorrow_leaves.page > 0" href="#" ng-click="today_leaves.previous();$event.preventDefault();"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</a>
                            <a ng-hide="tomorrow_leaves.end" class="pull-right" href="#" ng-click="today_leaves.next();$event.preventDefault();">Next <i class="fa fa-arrow-right" aria-hidden="true"></i></a>
                        </div>
                        <p ng-show="tomorrow_leaves.error" class="error">{{today_leaves.error}}</p>
                    </div>

                    <div class="panel-heading">
                        <div class="panel-title">Tomorrow</div>
                    </div>
                    <div class="panel-body">
                        <div class="refresh-container" ng-show="tomorrow_leaves.loading"><i class="refresh-spinner fa fa-spinner fa-spin fa-5x"></i></div>
                        <div style="margin-right: 0px;" class="row emp-attendance-status text-center" ng-hide="tomorrow_leaves.error">
                            <div class="col-lg-2 col-md-2 col-sm-2" ng-repeat="employee in tomorrow_leaves.data track by $index">
                                <div style="display: flex;align-items: center;">
                                    <img data-toggle="tooltip" title="{{ employee.first_name }}  {{ employee.last_name }}  ({{ employee.hrm_id }})" 
                                    ng-src="{{base_url}}{{employee.picture != '' && employee.picture || 'assets/img/icons/user.png' }}" class="emp-image border-warning" alt="User Image">
                                    
                                    <!-- {{employee.picture != '' && employee.picture || 'assets/img/icons/user.png' }} -->
                                </div>
                            </div>
                        </div>
                        <p class="text-center" ng-if="tomorrow_leaves.data.length == 0">No Records Found</p>
                        <div style="margin-top: 10px;">
                            <a ng-show="tomorrow_leaves.page > 0" href="#" ng-click="tomorrow_leaves.previous();$event.preventDefault();"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</a>
                            <a ng-hide="tomorrow_leaves.end" class="pull-right" href="#" ng-click="tomorrow_leaves.next();$event.preventDefault();">Next <i class="fa fa-arrow-right" aria-hidden="true"></i></a>
                        </div>
                        <p ng-show="tomorrow_leaves.error" class="error">{{tomorrow_leaves.error}}</p>
                    </div>

                    <div class="panel-heading">
                        <div class="panel-title">Up Coming Days</div>
                    </div>
                    <div class="panel-body text-center">
                        <div class="refresh-container" ng-show="this_week_leaves.loading"><i class="refresh-spinner fa fa-spinner fa-spin fa-5x"></i></div>

                        <div class="row emp-attendance-status" ng-hide="this_week_leaves.error">
                            <div class="col-lg-12 col-md-12 col-sm-12 text-left" ng-repeat="(key, values) in this_week_leaves.data">
                                <h5>{{ key }}</h5>
                                <div class="row emp-attendance-status" ng-hide="this_week_leaves.error">
                                    <div class="col-lg-2 col-md-2 col-sm-2" ng-repeat="(i, employee) in values">
                                            <div style="display: flex;align-items: center;">
                                                <img data-toggle="tooltip" title="{{ employee.first_name }}  {{ employee.last_name }}  ({{ employee.hrm_id }})" 
                                                ng-src="{{base_url}}{{employee.picture != '' && employee.picture || 'assets/img/icons/user.png' }}" class="emp-image border-warning" alt="User Image">
                                                
                                                <!-- {{employee.picture != '' && employee.picture || 'assets/img/icons/user.png' }} -->
                                            </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <p class="text-center" ng-if="this_week_count == 0">No Records Found</p>
                        <div style="margin-top: 10px;">
                            <a ng-show="this_week_leaves.page > 0" href="#" ng-click="this_week_leaves.previous();$event.preventDefault();"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</a>
                            <a ng-hide="this_week_leaves.end" class="pull-right" href="#" ng-click="this_week_leaves.next();$event.preventDefault();">Next <i class="fa fa-arrow-right" aria-hidden="true"></i></a>
                        </div>
                        <p ng-show="this_week_leaves.error" class="error">{{this_week_leaves.error}}</p>
                    </div>
                </div>
            </div>
        <?php endif?>

        <?php if($this->session->userdata('supervisor') || $this->session->userdata('employee_id')):?>
            <div id="leave_apply" class="col-md-12 col-lg-12 col-sm-12">
                <div class="panel panel-default thumbnail">
                    <div class="panel-heading">
                        <div class="panel-title">Pending Leave</div>
                    </div>
                    <div class="panel-body table-responsive">
                        <table width="100%" class="table table-striped table-bordered table-hover applications">
                            <thead>
                                <tr>
                                    <th><?php echo display('cid') ?></th>
                                    <th><?php echo display('name') ?></th>
                                    <th><?php echo display('leave_type') ?></th>
                                    <th><?php echo display('apply_strt_date') ?></th>
                                    <th><?php echo display('apply_end_date') ?></th>
                                    <th><?php echo display('leave_aprv_strt_date') ?></th>
                                    <th><?php echo display('leave_aprv_end_date') ?></th>
                                    <th><?php echo display('num_aprv_day') ?></th>
                                    <th>Submitted</th>
                                    <th><?php echo display('status')?></th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table> <!-- /.table-responsive -->
                    </div>
                </div>
            </div>
            <div id="time_adjustment" class="col-md-12 col-lg-12 col-sm-12">
                <div class="panel panel-default thumbnail">
                    <div class="panel-heading">
                        <div class="panel-title">Pending Time Adjustment</div>
                    </div>
                    <div class="panel-body" id="result_data">
                        <table class="table table-striped table-bordered table-hover time_adjustment" width="100%">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>In Time</th>
                                    <th>Out Time</th>
                                    <th>Reason</th>
                                    <th>Status</th>
                                    <th>Submitted</th>
                                    <th class="hideexport">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        <?php endif?>

    <!-- Absent Employee Mark Status Modal Start -->
    <div class="modal fade" id="add_absent_emp_status" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <span class="absent-modal-title absent_emp_title" style="padding-left: 10px;color:white;font-family:serif;">
                        </span>
                    </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="panel panel-bd lobidisable">
                        <div class="panel-body text-center">
                            <input type="hidden" id="absent_emp_id">
                            <a href="JavaScript:void(0)" data-status="informed"  class="btn btn-primary btn-sm save-attendance-status">Informed</a>
                            <a href="JavaScript:void(0)" data-status="ncns" class="btn btn-danger btn-sm save-attendance-status">NCNS</a>
                            <a href="JavaScript:void(0)" data-status="la" class="btn btn-info btn-sm save-attendance-status">Late Arrival</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Absent Employee Mark Status Modal End -->

    <!-- Unmarked Attendance datatable -->
        <!-- <div class="row">
            <?php if($this->session->userdata('supervisor')):?>
            <div class="col-md-12 col-lg-12">
                <div class="refresh-container" ng-show="summary.loading"><i class="refresh-spinner fa fa-spinner fa-spin fa-5x"></i></div>
                <div class="panel panel-default thumbnail">
                    <div class="panel-heading">
                        Today Unmarked Attendance Overview
                    </div>
                    <div class="panel-body table-responsive">
                    <table width="100%" class="table table-striped table-bordered table-hover" id="unmarked_attendance">
                        <thead>
                            <tr>
                                <th><?php echo display('name') ?></th>
                                <th><?php echo display('hrm_id') ?></th>
                                <th>Attendance <?php echo display('status') ?></th>
                                <th>Submitted</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                    </div>
                </div>
            </div>
            <?php endif?>
        </div> -->
        <?php if($this->permission->method('manage_employee', 'update')->access() || $this->session->userdata('supervisor')):?>
        <div class="col-md-12 col-lg-6">
            <div class="refresh-container" ng-show="summary.loading"><i class="refresh-spinner fa fa-spinner fa-spin fa-5x"></i></div>
            <div class="panel panel-bd fixed-height-panel" id="pie-panel">
                <div class="panel-heading">
                    Attendance Overview
                </div>
                <div class="panel-body" ng-hide="summary.error">
                    <ui-select ng-if="pie.dropdown.length > 2" ng-model="selected_chart_department" on-select="chart_departments($item)">
                        <ui-select-match>
                            <span ng-bind="$select.selected.label"></span>
                        </ui-select-match>
                        <ui-select-choices repeat="department in (pie.dropdown | filter: $select.search) track by $index">
                            <span ng-bind="department.label"></span>
                        </ui-select-choices>
                    </ui-select>
                    <canvas class="chart-base" chart-type="pie.type" chart-colors="pie.colors" chart-data="pie.data" chart-labels="pie.labels" chart-options="pie.options" style="width:300px;height:300px"></canvas>
                </div>
                <div class="panel-footer">
                    <div class="chart_type_switch" ng-hide="summary.error">
                        <div class="pretty p-default p-curve">
                            <input type="radio" ng-model="pie.type" ng-change="change_chart()" value="pie"/>
                            <div class="state p-primary-o">
                                <label>Pie Chart</label>
                            </div>
                        </div>
                        <div class="pretty p-default p-curve">
                            <input type="radio" ng-model="pie.type" ng-change="change_chart()" value="doughnut"/>
                            <div class="state p-info-o">
                                <label>Doughnut Chart</label>
                            </div>
                        </div>
                        <div class="pretty p-default p-curve">
                            <input type="radio" ng-model="pie.type" ng-change="change_chart()" value="bar"/>
                            <div class="state p-success-o">
                                <label>Bar Chart</label>
                            </div>
                        </div>
                        <div class="pretty p-default p-curve">
                            <input type="radio" ng-model="pie.type" ng-change="change_chart()" value="horizontalBar"/>
                            <div class="state p-danger-o">
                                <label>Horizontal Bar Chart</label>
                            </div>
                        </div>
                    </div>
                    <p ng-show="summary.error" class="error">{{summary.error}}</p>
                </div>
            </div>
        </div>
        <?php endif?>
        <div id="noticeboard" class="<?= $this->session->userdata('employee_id') && $this->session->userdata('supervisor') != 1 ? 'col-lg-12 col-md-12' : 'col-lg-6 col-md-6' ?>">
            <div class="panel panel-bd fixed-height-panel">
                <div class="panel-heading">
                    <div class="panel-title"><?= display('noticeboard') ?></div>
                </div>
                <div class="panel-body">
                    <div class="refresh-container" ng-show="notices.loading"><i class="refresh-spinner fa fa-spinner fa-spin fa-5x"></i></div>
                    <ul class="nav nav-stacked" ng-hide="notices.error">
                        <li ng-repeat="notice in notices.data track by $index">
                            <a href="<?= base_url('noticeboard/Notice_controller/view_details/') ?>{{notice.id}}">
                                {{notice.title}} <span ng-show="notice.viewed < 1" class="blink-text" style="color: red">New</span>
                            </a>
                        </li>
                    </ul>
                    <div style="margin-top: 10px;">
                        <a ng-show="notices.page > 0" href="#" ng-click="notices.previous();$event.preventDefault();"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</a>
                        <a ng-hide="notices.end" class="pull-right" href="#" ng-click="notices.next();$event.preventDefault();">Next <i class="fa fa-arrow-right" aria-hidden="true"></i></a>
                    </div>
                    <p ng-show="notices.error" class="error">{{notices.error}}</p>
                </div>
            </div>
       </div>
    </div>

    <!-- Modal Start -->
    <div id="breaks_detail" class="modal fade custom_modal" role="dialog" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header" style="color:white">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <center><strong class="break_modal_title"></strong></center>
                </div>
                <div class="modal-body">
                    <div class="panel panel-default thumbnail">
                        <div class="panel-body table-responsive" >
                            <div class="row" >
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group d-flex status_icon">
                                    <span class="icon-color"><i class="fa fa-circle"></i></span>
                                        <h4 class="text-capitalize"id="current_break_type"></h4>
                                    </div>
                                </div>
                                <!-- <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group"> 
                                        <span class="text-capitalize"id="current_break_status"></span>
                                    </div>
                                </div> -->
                            </div>
                            <div class="row" >
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="filter_by_date"><?=display('date')?>:</label>
                                        <input type="date" name="filter_by_date" class="form-control filter_by_date" value="<?= date('Y-m-d') ?>" id="filter_by_date">
                                    </div>
                                </div>
                                <?php if($this->session->userdata('supervisor')):?>
                                    <div class="col-lg-6 col-md-6 col-sm-12 modal-mark-status">
                                        <div class="form-group">
                                            <label for="filter_by_date">Mark Break Type</label>
                                            <select name="break_status" id="break_status" class="form-control">
                                                <option value="">Select Break Type</option>
                                                <option value="meal">Meal Break</option>
                                                <option value="tea">Tea Break</option>
                                                <option value="pray">Pray Break</option>
                                                <option value="play">Play Break</option>
                                                <option value="washroom">Washroom Break</option>
                                                <option value="smoking">Smoking Break</option>
                                            </select>
                                            <p class="text-danger brek-type-error">Select Break Type First</p>
                                            <button type="submit" class="btn btn-success btn-sm modal-mark-status-btn" style="margin-top: 5px; float: right;">Break</button>
                                        </div>
                                    </div>
                                <?php endif?>
                            </div>
                            <?php if($this->session->userdata('supervisor') || $this->session->userdata('isAdmin')):?>
                                <table width="100%" class="table table-striped table-bordered table-hover" id="modal_break_time_table">
                                    <thead>
                                        <tr>
                                            <th><?php echo display('employee') ?></th>
                                            <th><?php echo display('Break Type') ?></th>
                                            <th><?php echo display('date') ?></th>
                                            <th><?php echo display('start') ?></th>
                                            <th><?php echo display('end') ?></th>
                                            <th><?php echo display('duration') ?></th>
                                            <th><?php echo display('started_by') ?></th>
                                            <th><?php echo display('ended_by') ?></th>
                                        </tr>
                                    </thead>
                                    <tbody id="table-body">
                                    </tbody>
                                </table>
                            <?php endif?>
                        </div>
                    </div>        
                </div>
            </div>
        </div>
    </div>
    <!-- Modal End -->

    <div class="row">
        <!-- Radar Chart -->
        <div class="col-sm-12 col-md-12">
            <div class="refresh-container" id="calendar-spinner" style="display: none;"><i class="refresh-spinner fa fa-spinner fa-spin fa-5x"></i></div>
            <div class="panel panel-bd lobidisable">
                <div class="panel-body">
                    <div class="calendar"><?php echo $notes ?></div>
                </div>
            </div>
        </div><!-- Calender -->
    </div>
</div>
<?php if(@$promo_video) : ?>
<?php if($promo_video['size'] == 'small' ): ?>
<div class="modal fade" id="modal-video" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header" style="padding: 2px 10px;">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
            </div>
            <div class="modal-body">
                <div class="embed-responsive embed-responsive-4by3" style="padding-bottom: 100%">
                    <video controls muted loop autoplay src="<?= base_url() ?>uploads/video/<?= $promo_video['file'] ?>"></video>
                </div>
            </div>
        </div>
    </div>
</div>
<?php elseif ($promo_video['size'] == 'large') :?>
<div class="modal fade" id="modal-video" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <video style="width:100%" controls muted loop autoplay src="<?= base_url() ?>uploads/video/<?= $promo_video['file'] ?>"></video>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<?php endif?>
<script>
    $(document).ready(function () {
        $('#modal-video').modal('show')
    });
</script>
<?php endif?>
<div class="modal fade" id="leaveDetail" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <span class="s_date" style="padding-left: 10px;color:white;font-family:serif;">
                        <?php echo display('details') ?> for <span class="calendar_name"><?php echo "$month $day, $year"; ?></span>
                    </span>
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="panel panel-bd lobidisable">
                    <div class="panel-body" style="padding-top: 0px">
                        <h4 class="text-center"></h4>
                        <h4 style="color: #78909C;font-family:serif;"><b><?=display('leaves')?></b></h4>
                        <div class="payment">
                            <div class="detail_leave"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/ng-template" id="myModalContent.html">
    <div class="modal-header">
        <h3 class="modal-title">{{dm.title}}</h3>
    </div>
    <div class="modal-body">
        <table class="table table-striped table-inverse table-responsive">
            <thead class="thead-inverse">
                <tr>
                    <th ng-repeat="heading in dm.headings track by $index">
                        <a href="#" ng-click="dm.sortByIndex($index)">
                            {{heading}}
                            <span ng-show="dm.orderByField == $index">
                                <span ng-show="!dm.reverseSort"><i class="fa fa-sort-asc" aria-hidden="true"></i></span>
                                <span ng-show="dm.reverseSort"><i class="fa fa-sort-desc" aria-hidden="true"></i></span>
                            </span>
                        </a>
                        <br>
                        <input type="text" ng-model="dm.filter[$index]" style="margin-top: 15px" class="form-control">
                    </th>
                    <th ng-if="dm.type=='attendance'">Hide</th>
                </tr>
            </thead>
            <tbody>
                <tr ng-repeat="tds in dm.items | orderBy:dm.orderByField:dm.reverseSort | filter:dm.myFilter(tds) track by $index">
                    <td ng-repeat="td in tds track by $index">{{td}}</td>
                    <td ng-if="dm.type=='attendance'"><button type="button" class="btn btn-danger" ng-click="dm.exclude_attendance(dm.key, tds)"><i class="fa fa-minus-circle" aria-hidden="true"></i></button></td>
                </tr>
            </tbody>
        </table>
    </div>
    <div class="modal-footer">
        <button class="btn btn-warning" ng-click="dm.close()">close</button>
    </div>
</script>

<?php $this->load->view('dashboard/scripts/dashboard') ?>
<script>

var calendar = {
        month: <?= intval($mon) ?>,
        year: <?= intval($year) ?>,
        full_month: '<?= $month ?>'
    }
    $(document).ready(function () {
        $('.brek-type-error').hide();
        $('#stop-btn').hide();
        $('#timer').text('00:00:00');

        if ($('#employee_id').val() == 0){
            $('.disable-stop').attr("disabled", true);
        }
        var page_length, length_menu;
        var role = <?= $this->session->userdata('isAdmin') == 1 ? 1 : 0 ?>;

        if (role == 1 ) {
            page_length = 50;
            length_menu = [ [50, 75,100, -1], [50, 75, 100, "All"] ];
        }
        else {
            page_length = 10;
            length_menu = [ [10,25,50, 75, -1], [10, 25, 50, 75, "All"] ];
        }
        // $.extend({},  , window.default_datatable_opts)
        window.break_time_table = $('#break_time_table').dataTable({
            responsive: false,
            processing: true,
            language: {
                processing: '<i class="fa fa-spinner fa-spin fa-3x fa-fw"></i><span class="sr-only">Loading...</span> '
            },
            serverSide: true,
            searching: false,
            ordering: false,
            pageLength: page_length,
            lengthMenu: length_menu,
            ajax: {
                method: 'post',
                data: function(d) {
                    d.emp_id = $('#employee_id').val()
                    d.date = $('.filter_by_date').val()
                },
                url: '<?= base_url('dashboard/home/break_list_datatable') ?>',
                beforeSend: () => {},
            },
            columns: [
                {
                    'data': 'employee',
                }, {
                    'data': 'break_type',
                }, {
                    'data': 'date',
                }, {
                    'data': 'start',
                }, {
                    'data': 'end',
                }, {
                    'data': 'duration',
                }, {
                    'data': 'started_by',
                }, {
                    'data': 'ended_by',
                }
            ],
            "columnDefs": [ {
                // "targets": [3, 4, 5, 6, 8],
                "type": "date",
                "render": function ( data, type ) {
                    if(type === 'sort'){
                        return moment(data, 'DD-MM-YYYY')
                    }
                    return data;
                }
            } ],
            "order": [[ 4, "desc" ]]
        });

        // modal_break_time_table
        window.modal_break_time_table = $('#modal_break_time_table').dataTable({
            responsive: false,
            processing: true,
            language: {
                processing: '<i class="fa fa-spinner fa-spin fa-3x fa-fw"></i><span class="sr-only">Loading...</span> '
            },
            serverSide: true,
            searching: false,
            ordering: false,
            pageLength: page_length,
            lengthMenu: length_menu,
            ajax: {
                method: 'post',
                data: function(d) {
                    d.emp_id = $('#employee_id').val()
                    d.date = $('.filter_by_date').val()
                },
                url: '<?= base_url('dashboard/home/break_list_datatable') ?>',
                beforeSend: () => {},
            },
            columns: [
                {
                    'data': 'employee',
                }, {
                    'data': 'break_type',
                }, {
                    'data': 'date',
                }, {
                    'data': 'start',
                }, {
                    'data': 'end',
                }, {
                    'data': 'duration',
                }, {
                    'data': 'started_by',
                }, {
                    'data': 'ended_by',
                }
            ],
            "columnDefs": [ {
                // "targets": [3, 4, 5, 6, 8],
                "type": "date",
                "render": function ( data, type ) {
                    if(type === 'sort'){
                        return moment(data, 'DD-MM-YYYY')
                    }
                    return data;
                }
            } ],
            "order": [[ 4, "desc" ]]
        });

        $(".calendar").on('click', '.detail', function() {
            $(".s_date").html(`Details of ${$(this).attr('val')} ${calendar.full_month} ${calendar.year}`);
            var $this = $(this)
            var day = $(this).attr('val');
            var add = '<input type="hidden" name="add" value="Add New" val="' + day + '" class="add_event"/>';
            $.ajax({
                type: 'post',
                dataType: 'json',
                url: "<?php echo site_url("dashboard/home/detail_leave"); ?>",
                data: {
                    year: calendar.year,
                    mon: calendar.month,
                    day: day
                },
                beforeSend: function() {
                    $('#calendar-spinner').show()
                },
                complete: function() {
                    $('#calendar-spinner').hide()
                },
                success: function(data) {
                    var $modal = $('#leaveDetail');
                    $this.closest('table').find('.active_no_event').removeClass('active_no_event').addClass('no_event')
                    $this.addClass('active_no_event')
                    var html = '<div class="info5"><table class="table table-bordered"><thead><tr><th>Employee Name</th><th>Leave Day</th><th>Leave finish</th></tr></thead><tbody>';
                    if (data.status) {
                        var i = 1;
                        $.each(data.data, function(index, value) {
                            if (i % 2 == 0) {
                                html +=`<tr><td>${value.first_name} ${value.last_name} (${value.hrm_id})</td><td>` + value
                                    .num_aprv_day + '</td><td>' + moment(value.leave_aprv_end_date).format('DD-MM-YYYY') +
                                    '</td></tr>';
                            } else {
                                html = html +
                                    `<tr><td>${value.first_name} ${value.last_name} (${value.hrm_id})</td><td>` + value
                                    .num_aprv_day + '</td><td>' + moment(value.leave_aprv_end_date).format('DD-MM-YYYY') +
                                    '</td></tr>';
                            }
                            i++;
                        });
                    } else {
                        html = '<div class="message"><h4>' + data.title_msg + '</h4><p>' + data.msg +
                            '</p></div>';
                    }
                    html += '</tbody></table></div>';
                    $modal.find(".detail_leave").html(html);
                    $modal.modal('show')
                }
            });
        });
        $('.calendar').on('click', '.next_date, .prev_date', function () {
            let date = this.href.split('/');
            let month = date.pop()
            let year = date.pop()
            $.ajax({
                type: "POST",
                data: {
                    month: month,
                    year: year
                },
                beforeSend: function() {
                    $('#calendar-spinner').show()
                },
                complete: function() {
                    $('#calendar-spinner').hide()
                },
                success: function (res) {
                    if(res.success) {
                        calendar.month = res.success.month;
                        calendar.year = res.success.year;
                        calendar.full_month = res.success.full_month;
                        $('.calendar_name').text(`${calendar.full_month} 01, ${calendar.year}`)
                        $('.calendar').html(res.success.html)
                    }
                }
            });
        });
        // $('.punch_break_time').on('click',function(e) {
        //     e.preventDefault();

        //     var type = $(this).attr('data-type');
        //     var employee_id = $('#employee_id').val();

        //     var checkAction = $(this).attr('data-status');

        //     var data = {
        //         id: $('#break_time_id').val(),
        //         type: type,
        //         employee_id: employee_id,
        //         date: $('#date').val(),
        //         start_time: $('#start_time').val(),
        //         status: checkAction == 'end' ? 'end' : $('#status').val(),
        //         checkAction: checkAction
        //     }
        //     $.ajax({
        //         type: "POST",
        //         url: '<?= base_url('dashboard/home/punch_break_time') ?>',
        //         // url: "/dashboard/home/punch_break_time",
        //         data: data,
        //         success: function (res) {
        //             if(res.success) {
        //                 Swal.fire(
        //                     '<?= display('success') ?>!',
        //                     res.success,
        //                     'success'
        //                 )
        //                 punch_break_time();
        //                 // window.break_time_table.fnDraw();
        //             } else if(res.info) {
        //                 Swal.fire(
        //                     '<?= display('Info') ?>!',
        //                     res.info,
        //                     'info'
        //                 )
        //             } else if (res.error) {
        //                 Swal.fire(
        //                     '<?= display('error') ?>!',
        //                     res.error,
        //                     'error'
        //                 )
        //             }
        //         }
        //     });
        // })
        // var timer = null;
        // function punch_break_time() {
        //     var count = 0;
        //     var time = '';
        //     $.ajax({
        //         type: "get",
        //         url: '<?= base_url('dashboard/home/punch_break_time') ?>',
        //         data: {employee_id: $('#employee_id').val()},
        //         // url: "/dashboard/home/punch_break_time",
        //         success: function (res) {
        //             if (res.data != null) {
                        
        //                 $('#break_time_id').val(res.data.id);
        //                 $('#date').val(res.data.date);
        //                 $('#start_time').val(res.data.start_time);
        //                 $('#status').val(res.data.status == 'start' ? 'end' : '');

        //                 $('#type-display').text(res.data.break_type+ ' Time');

        //                 if (res.data.status == 'start') {
        //                     clearInterval(timer);
        //                     $('#timer').show();
        //                     timer = setInterval(function() {
        //                     count = (new Date() - new Date(res.data.start_time)) / 1000;
        //                     var minutes = Math.floor(count / 60);
        //                     var hours = Math.floor(minutes / 60);
        //                     time = (hours < 10 ? "0" + hours : hours) + ":" +
        //                                 (minutes % 60 < 10 ? "0" + (minutes % 60) : minutes % 60) + ":" +
        //                                 ((count % 60).toFixed(0) < 10 ? "0" + (count % 60).toFixed(0) : (count % 60).toFixed(0));
        //                     $('#timer').text(time);
        //                     }, 1000); // 1000 milliseconds = 1 second

                            
        //                     $('#stop-btn').show();
        //                     $('.disable-stop').attr("disabled", true);
        //                 }            
        //             }
        //             else {
        //                 clearInterval(timer);
        //                 $('#timer').text('00:00:00');
        //                 $('#stop-btn').hide();
        //                 $('#type-display').text('');
        //                 $('#break_time_id').val('');
        //                 $('#date').val('');
        //                 $('#start_time').val('');
        //                 $('#status').val('');
        //                 $('.disable-stop').attr("disabled", $('#employee_id').val() == 0 ? true : false);
        //                 $('#stop-btn').hide();
        //             }
        //         }
        //     });
        // }
        
        // if ($('#is_admin').val() == '') {
        //     punch_break_time();
        // }

        $('.emp-brak-time-view').on('click','.view-break-time-status',function() {
            var employee_id = $(this).data('employee_id');

            $('#employee_id').val(employee_id);
            if ($('#employee_id').val() == 0) {
                $('.modal-mark-status').hide();
            }
            else {
                $('.modal-mark-status').show();
            }
            window.modal_break_time_table.fnDraw();
            employee_current_break_status(employee_id);
            $('#breaks_detail').modal('show');
        })

        $('#employee_id').on('change',function() {
            // if ($('#is_admin').val() == '') {
                if ($(this).val() == 0 || $(this).val() == null) {
                    $(this).val('0');
                    // $('.disable-stop').attr("disabled", true);
                }
                // else{
                //     $('.disable-stop').attr("disabled", false);
                // }
                // punch_break_time();
            // }
            if ($('#employee_id').val() == 0) {
                $('.modal-mark-status').hide();
            }
            else {
                $('.modal-mark-status').show();
            }
            window.modal_break_time_table.fnDraw();
            employee_current_break_status($(this).val());
            $('#breaks_detail').modal('show');
        })
        
        $('#filter_by_date').on('change',function() {
            window.modal_break_time_table.fnDraw();
        })
    });

    var timer = null;
    var status = '';
    var type = '';
    function employee_current_break_status(employee_id) {
        if(employee_id == 0) {
            $('.break_modal_title').text('On Break Employees');
        }
        else {
            $.ajax({
            type: "get",
            url: '<?= base_url('dashboard/home/employee_current_break_status') ?>',
            data: {emp_id: employee_id},
            success: function (res) {
                if(res.break_detail) {
                    var full_name = res.break_detail.first_name + ' ' + res.break_detail.last_name + ' (' + res.break_detail.hrm_id + ')';
                    $('.break_modal_title').text(full_name);
                    var actual_time = null;
                    var actual_time_status = '';

                    if (res.break_detail.status == 'end') {
                        actual_time = res.break_detail.end_time;
                        actual_time_status = 'Available';
                        type = ' ';
                        $('.icon-color i').removeClass('icon-warning');
                        $('.icon-color i').removeClass('not-available-color');
                        // $('#current_break_type_label').text('Last Break');
                    }
                    else {
                        actual_time = res.break_detail.start_time;
                        actual_time_status = '';
                        type = res.break_detail.break_type + ' Break';
                        $('.icon-color i').addClass('icon-warning');
                        $('.icon-color i').removeClass('not-available-color');
                        // $('#current_break_type_label').text('Current Break');
                    }
                    clearInterval(timer);
                        timer = setInterval(function() {
                        count = (new Date() - new Date(actual_time)) / 1000;
                        var minutes = Math.floor(count / 60);
                        var hours = Math.floor(minutes / 60);

                        if (minutes >= 60) {
                            time = (hours < 10 ? "0" + hours : hours) + ":" +
                                        (minutes % 60 < 10 ? "0" + (minutes % 60) : minutes % 60) + ":" +
                                        ((count % 60).toFixed(0) < 10 ? "0" + (count % 60).toFixed(0) : (count % 60).toFixed(0));
                        }
                        else {
                            time = (minutes < 10 ? "0" + (minutes) : minutes) + ":" +
                                    ((count % 60).toFixed(0) < 10 ? "0" + (count % 60).toFixed(0) : (count % 60).toFixed(0));
                        }

                        // $('#timer').text(time);
                            status = actual_time_status + ' (' + time + ')';
                            $('#current_break_type').text(type + status);
                        }, 1000); // 1000 milliseconds = 1 second

                }
                if (res.check_attendance) {
                    clearInterval(timer);
                    var full_name = res.check_attendance.first_name + ' ' + res.check_attendance.last_name + ' (' + res.check_attendance.hrm_id + ')';
                    $('.break_modal_title').text(full_name);

                    $('.icon-color i').removeClass('icon-warning');
                    $('.icon-color i').addClass('not-available-color');
                    $('#current_break_type').text('Not Available');
                }
                if (res.no_breaks) {
                    clearInterval(timer);
                    var full_name = res.no_breaks.first_name + ' ' + res.no_breaks.last_name + ' (' + res.no_breaks.hrm_id + ')';
                    $('.break_modal_title').text(full_name);
                    $('.icon-color i').removeClass('icon-warning');
                    $('.icon-color i').removeClass('not-available-color');
                    $('#current_break_type').text('No Breaks');
                }
            }
        });
        }
    }

    // $('.btn-detail').on('click',function() {

    //     if ($('#employee_id').val() == 0) {
    //         $('.modal-mark-status').hide();
    //     }
    //     else {
    //         $('.modal-mark-status').show();
    //     }
    //     window.break_time_table.fnDraw();
    //     $('#breaks_detail').modal('show');
    // })
    $('.dt-refresh').on('click',function() {
        window.break_time_table.fnDraw();
    })

    $(".emp-attendance-status").on('click' ,'.add-attendance-status',function() {

        if ($('#action-permition').val() != 'is_admin') {
            var employee_id = $(this).attr('data-employee_id');
            var employee_name = $(this).attr('data-employee_name');

            $('.absent_emp_title').text('Mark '+employee_name+' Attendance Status');
            $('#absent_emp_id').val(employee_id);
            $('#add_absent_emp_status').modal('show');
        }
    })

    $('.modal-mark-status-btn').on('click',function(e) {
            e.preventDefault();

            var type = $('#break_status').val();
            var employee_id = $('#employee_id').val();

            if (type == '') {
                $('.brek-type-error').show();
            }
            else {
                var data = {
                type: type,
                employee_id: employee_id,
                status: 'start' ,
                checkAction: 'start'
                }
                $.ajax({
                    type: "POST",
                    url: '<?= base_url('dashboard/home/punch_break_time') ?>',
                    data: data,
                    success: function (res) {
                        if(res.success) {
                            $('.brek-type-error').hide();
                            window.modal_break_time_table.fnDraw();
                        } else if(res.info) {
                            Swal.fire(
                                '<?= display('Info') ?>!',
                                res.info,
                                'info'
                            )
                        } else if (res.error) {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                res.error,
                                'error'
                            )
                        }
                    }
                });
            }
        })

    $('.save-attendance-status').on('click',function() {
        var data = {
            employee_id: $('#absent_emp_id').val(),
            status: $(this).attr('data-status'),
        }
        $.ajax({
                type: "POST",
                url: '<?= base_url('dashboard/home/attendance_status') ?>',
                data: data,
                success: function (res) {
                    if(res.success) {
                        Swal.fire(
                            '<?= display('success') ?>!',
                            res.success,
                            'success'
                        )
                    $('#add_absent_emp_status').modal('hide');
                    } else if(res.info) {
                        Swal.fire(
                            '<?= display('Info') ?>!',
                            res.info,
                            'info'
                        )
                    } else if (res.error) {
                        Swal.fire(
                            '<?= display('error') ?>!',
                            res.error,
                            'error'
                        )
                    }
                }
            });
    });

    //Leave Request Datatable
    $(document).ready(function () {
        window.leaves_table = $('table.table.applications').DataTable( {
            responsive: false,
            processing: true,
            serverSide: true,
            language: {
                processing: '<i class="fa fa-spinner fa-spin fa-3x fa-fw"></i><span class="sr-only">Loading...</span> '
            },
            ajax: {
                method: 'post',
                url: '<?= base_url('leave/Leave/getDatatable') ?>',
                data: function(d) {
                    d.request = 'dashboard'
                },
                beforeSend: () => {},
            },
            columns: [
                {
                    'data': 'leave_appl_id',
                }, {
                    'data': 'employee_name',
                }, {
                    'data': 'leave_type',
                }, {
                    'data': 'apply_strt_date',
                }, {
                    'data': 'apply_end_date'
                }, {
                    'data': 'leave_aprv_strt_date'
                }, {
                    'data': 'leave_aprv_end_date'
                }, {
                    'data': 'num_aprv_day',
                }, {
                    'data': 'apply_date',
                }, {
                    'data': 'hr_status',
                },{
                    'data': 'action',
                    'sortable': false,
                    'class': '<?= $this->session->userdata('supervisor') || $this->session->userdata('isAdmin') ? 'display-block' : 'display-none' ?> td-flex-row'
                }
            ],
            "columnDefs": [ {
                "targets": [3, 4, 5, 6, 8],
                "type": "date",
                "render": function ( data, type ) {
                    if(type === 'sort'){
                        return moment(data, 'DD-MM-YYYY')
                    }
                    return data;
                }
            
            } ],
            "order": [[ 0, "desc" ]]
        }, window.default_datatable_opts)
    });
    $('table.table').on('click', '.btn-delete', function(e) {
        e.preventDefault();
        $btn = $(this)
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $('.se-pre-con').show()
                location.href = "<?= base_url("leave/Leave/delete_application/") ?>" + $btn.data('id')
            }
        })
    });

    //Time Adjustment Request Datatable
    $(document).ready(function() {
        window.datatable = $('table.table.time_adjustment').DataTable({
            responsive: false,
            processing: true,
            language: {
                processing: '<i class="fa fa-spinner fa-spin fa-3x fa-fw"></i><span class="sr-only">Loading...</span> '
            },
            serverSide: true,
            ajax: {
                method: 'post',
                url: '<?= base_url('attendance/timeadjustment/all_requests') ?>',
                data: function(d) {
                    d.request = 'dashboard'
                },
                beforeSend: () => {},
            },
            columns: [{
                'data': 'id',
            }, {
                'data': 'employee_name',
            }, {
                'data': 'checkin',
                "width": "15%"
            }, {
                'data': 'checkout',
                "width": "15%"
            }, {
                'data': 'reason'
            }, {
                'data': 'hr_status',
            }, {
                'data': 'added_at',
            }, {
                'data': 'action',
                'sortable': false
            }],
            columnDefs: [{
                // "targets": [2, 3, 6],
                "type": "date",
                "render": function(data, type) {
                    if (type === 'sort') {
                        return moment(data, 'DD-MM-YYYY')
                    }
                    return data;
                }
            }],
            order: [
                [6, "desc"]
            ]
        }, window.default_datatable_opts)
    });
    $('table.table').on('click', '.time_action_btn button', function() {
        var div = $(this).closest('div')
        myajax({
            type: "POST",
            url: "<?= base_url('attendance/timeadjustment/process') ?>",
            data: {
                id: div.data('id'),
                process: $(this).data('action')
            },
            success: function(res) {
                if (res.success) {
                    window.datatable.ajax.reload();
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error,
                        'error'
                    )
                }
            }
        });
    });

    //========================Absent Employee Mark Status Modal End
    // window.unmarked_attendance = $('#unmarked_attendance').dataTable($.extend({}, {
    //     responsive: false,
    //     processing: true,
    //     serverSide: true,
    //     searching: false,
    //     ajax: {
    //         method: 'post',
    //         data: function(d) {
    //             d.emp_id = $('#employee_id').val()
    //             d.date = $('.filter_by_date').val()
    //         },
    //         url: '<?= base_url('dashboard/home/unmarked_attendance') ?>',
    //         beforeSend: () => {},
    //     },
    //     columns: [
    //         {
    //             'data': 'name',
    //         }, {
    //             'data': 'hrm_id',
    //         }, {
    //             'data': 'status',
    //         }, {
    //             'data': 'action',
    //             'sortable': false,
    //             'class': 'td-flex-row'
    //         }
    //     ],
    //     "columnDefs": [ {
    //         // "targets": [3, 4, 5, 6, 8],
    //         "type": "date",
    //         "render": function ( data, type ) {
    //             if(type === 'sort'){
    //                 return moment(data, 'DD-MM-YYYY')
    //             }
    //             return data;
    //         }
        
    //     } ],
    //     "order": [[ 0, "desc" ]]
    // }, window.default_datatable_opts));

    // $('#unmarked_attendance').on('click','.btn-attendance-status',function() {
        
    //     // var employe_id = $(this).attr('data-employee_id');
    //     // var status = $(this).attr('data-status');

    //     var data = {
    //         employee_id: $(this).attr('data-employee_id'),
    //         status:$(this).attr('data-status')
    //     };
    //     $.ajax({
    //         type: "POST",
    //         url: '<?= base_url('dashboard/home/attendance_status') ?>',
    //         data: data,
    //         success: function (res) {
    //             if(res.success) {
    //                 Swal.fire(
    //                     '<?= display('success') ?>!',
    //                     res.success,
    //                     'success'
    //                 )
    //                 window.unmarked_attendance.fnDraw();
    //             } else if(res.info) {
    //                 Swal.fire(
    //                     '<?= display('Info') ?>!',
    //                     res.info,
    //                     'info'
    //                 )
    //             } else if (res.error) {
    //                 Swal.fire(
    //                     '<?= display('error') ?>!',
    //                     res.error,
    //                     'error'
    //                 )
    //             }
    //         }
    //     });
    // });

</script>
