<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Setting_model extends CI_Model {
 
	private $table = "setting";
	private $job_sites_table = "job_sites";

	public $driveClient = null;
	public $driveInstance = null;
    public function __construct()
    {
		parent::__construct();
		$this->driveClient = new GoogleClient('https:' . preg_replace('#^[https|http]+\:#i', '', base_url('dashboard/setting/drive_login')), 'drive');
		if($this->driveClient->isLoggedIn()) {
			$this->driveInstance = new HRM_Drive($this->driveClient->getDriveInstance());
		}
    }
	public function create($data = [],$params)
	{	 
	    foreach($params['site_names'] as $site_name){
	        $this->db->where('site_name',$site_name)->update(
	            $this->job_sites_table,
	            array('site_username'=>$params['emails'][$site_name],'site_password'=>$params['passwords'][$site_name])
	            );
	    }
		$this->activity->set_url('dashboard/setting')->log([
			'setting_inserted',
			$data['title']
		]);
		return $this->db->insert($this->table,$data);
	}
 
	public function read()
	{
		return $this->db->select("*")
			->from($this->table)
			->get()
			->row();
	} 
	
  	public function update($data = [],$params)
	{
	    foreach($params['site_names'] as $site_name){
	        $this->db->where('site_name',$site_name)->update(
	            $this->job_sites_table,
	            array('site_username'=>$params['emails'][$site_name],'site_password'=>$params['passwords'][$site_name])
	            );
	    }
		$this->activity->set_url('dashboard/setting')->log([
			'setting_updated',
			$data['title']
		]);
		return $this->db->where('id',$data['id'])
			->update($this->table,$data); 
	} 
	
	public function job_sites_table()
	{
		return $this->db->select("*")
			->from($this->job_sites_table)
			->get()
			->result();
	} 
}
