<?php defined('BASEPATH') or exit('No direct script access allowed');
class Home_model extends CI_Model
{
    public function userPermission($id = null)
    {
        return $this->db->select("
			module.controller,
			module_permission.fk_module_id,
			module_permission.create,
			module_permission.read,
			module_permission.update,
			module_permission.delete
			")
            ->from('module_permission')
            ->join('module', 'module.id = module_permission.fk_module_id', 'left')
            ->where('module_permission.fk_user_id', $id)
            ->get()
            ->result();
    }
    public function last_login($id = null)
    {
        return $this->db->set('last_login', date('Y-m-d H:i:s'))
            ->set('ip_address', $this->input->ip_address())
            ->where('id', $this->session->userdata('id'))
            ->update('user');
    }
    public function last_logout($id = null)
    {
        return $this->db->set('last_logout', date('Y-m-d H:i:s'))
            ->where('id', $this->session->userdata('id'))
            ->update('user');
    }
    public function profile($id = null)
    {
        return $this->db->select("
			*,
				CONCAT_WS(' ', firstname, lastname) AS fullname,
				IF (user.is_admin=1, 'Admin', 'User') as user_level
			")
            ->from("user")
            ->where("id", $id)
            ->get()
            ->row();
    }
    public function setting($data = array())
    {
        $this->activity->log('user_updated_self');
        $id = $this->session->userdata('id');
        unset($data['id']);
        $res = $this->db->where('id', $id)
            ->update('user', $data);
        if($res && isset($data['password'])) {
            $this->sessionmanager->destroy($this->session->userdata('id'));
        }
        return $res;
    }
    public function empnumber()
    {
        $admin = $this->session->userdata('isAdmin');
        $is_supervisor = $this->session->userdata('supervisor');
        $direct_supervisor = $this->session->userdata('direct_supervisor');
        $indirect_supervisor = $this->session->userdata('indirect_supervisor');
        $this->db->select('COUNT(DISTINCT(employee_id)) AS employee_id');
        $this->db->from("employee_history");
        if ($admin != 1) {
            $employee_id = $this->session->userdata('employee_id');
            if ($is_supervisor == 1) {
                $this->db->where('super_visor_id', $employee_id);
                $this->db->or_where('employee_id', $employee_id);
                $this->db->or_where('indirect_super_visor_id', $employee_id);
            } else {
                $this->db->where('employee_id', $employee_id);
            }
        }
        return $this->db->get()->row();
    }
    public function atntd()
    {
        $date = date('Y-m-d');
        $admin = $this->session->userdata('isAdmin');
        $is_supervisor = $this->session->userdata('supervisor');
        $direct_supervisor = $this->session->userdata('direct_supervisor');
        $indirect_supervisor = $this->session->userdata('indirect_supervisor');
        $this->db->select('attendance_history.*,DATE(attendance_history.time) as mydate');
        $this->db->from('attendance_history');
        $this->db->join('employee_history eh', 'eh.employee_id=attendance_history.uid');
        if ($admin != 1) {
            $employee_id = $this->session->userdata('employee_id');
            if ($is_supervisor == 1) {
                $this->db->where('eh.super_visor_id', $employee_id);
                $this->db->or_where('eh.employee_id', $employee_id);
                $this->db->or_where('eh.indirect_super_visor_id', $employee_id);
            } else {
                $this->db->where('eh.employee_id', $employee_id);
            }
        }
        $this->db->like('attendance_history.time', $date, 'after');
        $this->db->group_by('attendance_history.uid');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->num_rows();
        }
        return false;
    }
    public function loanamnt()
    {
        return $this->db->select('SUM(amount) AS amount')
            ->from("grand_loan")
            ->get()
            ->row();
    }
    public function atnwork()
    {
        $d = date('Y-m-d');
        $admin = $this->session->userdata('isAdmin');
        $is_supervisor = $this->session->userdata('supervisor');
        $direct_supervisor = $this->session->userdata('direct_supervisor');
        $indirect_supervisor = $this->session->userdata('indirect_supervisor');
        $att_in = $this->db->select('MIN(ah.time) as intime,MAX(ah.time) as outtime,ah.uid');
        $this->db->from('attendance_history ah');
        $this->db->join('employee_history eh', 'eh.employee_id=ah.uid');
        if ($admin != 1) {
            $employee_id = $this->session->userdata('employee_id');
            if ($is_supervisor == 1) {
                $this->db->where('eh.super_visor_id', $employee_id);
                $this->db->or_where('eh.employee_id', $employee_id);
                $this->db->or_where('eh.indirect_super_visor_id', $employee_id);
            } else {
                $this->db->where('eh.employee_id', $employee_id);
            }
        }
        $this->db->like('ah.time', $d, 'after')
            ->group_by('ah.uid')
            ->get()
            ->result();
        $idx = 1;
        $totalhour = [];
        foreach ($att_in as $attendancedata) {
            $date_a = new DateTime($attendancedata->outtime);
            $date_b = new DateTime($attendancedata->intime);
            $interval = date_diff($date_a, $date_b);
            $totalwhour = $interval->format('%h:%i:%s');
            $totalhour[$idx] = $totalwhour;
            $idx++;
        }
        $seconds = 0;
        foreach ($totalhour as $t) {
            $timeArr = array_reverse(explode(":", $t));
            foreach ($timeArr as $key => $value) {
                if ($key > 2) {
                    break;
                }

                $seconds += pow(60, $key) * $value;
            }
        }
        $hours = floor($seconds / 3600);
        $mins = floor(($seconds - ($hours * 3600)) / 60);
        $secs = floor($seconds % 60);
        $totalworkinghours = $hours . ':' . $mins . ':' . $secs;
        $totalworkinghours = array(
            'hours' => $hours,
            'minutes' => $mins,
            'sec' => $secs,
        );
        return $totalworkinghours;
    }
    public function details($id)
    {
        return $this->db->select('*')
            ->from('notice_board')
            ->where('notice_id', $id)
            ->get()
            ->result();
    }
    public function monthlyincome($year, $month)
    {
        $head = $this->db->select('HeadCode')->from('acc_coa')->where('PHeadName', 'Income')->get()->result_array();
        $totalcredit = 0;
        foreach ($head as $headcode) {
            $income = $this->db->select('sum(Credit) as totalamount')->from('acc_transaction')->where('COAID', $headcode['HeadCode'])->where('YEAR(VDate)', $year)->where('MONTH(VDate)', $month)->get()->row();
            $totalcredit = $totalcredit + (!empty($income->totalamount) ? $income->totalamount : 0);
        }
        return (!empty($totalcredit) ? $totalcredit : 0);
    }
    //Expence
    public function monthlyexpense($year, $month)
    {
        $head = $this->db->select('HeadCode')->from('acc_coa')->where('PHeadName', 'Expence')->get()->result_array();
        $totalexpense = 0;
        foreach ($head as $headcode) {
            $expense = $this->db->select('sum(Debit) as totalamount')->from('acc_transaction')->where('COAID', $headcode['HeadCode'])->where('YEAR(VDate)', $year)->where('MONTH(VDate)', $month)->get()->row();
            $totalexpense = $totalexpense + (!empty($expense->totalamount) ? $expense->totalamount : 0);
        }
        return (!empty($totalexpense) ? $totalexpense : 0);
    }
    public function set_user_options($options)
    {
        $user_id = $this->session->userdata('id');
        foreach ($options as $values) {
            $this->options->set_user($values[0], $values[1]);
        }
        $this->load_user_opts();
    }
    public function load_user_opts()
    {
        $this->session->set_userdata('user_options', $this->options->get_all_user());
    }

    private function baseQueryBreakTime(){
        $post = $this->input->post();
        // $id = empty($post['emp_id']) ? $this->session->userdata('employee_id') : $post['emp_id'];
        // return $this->db->select('e.employee_id, e.first_name, e.last_name, e.hrm_id, b.break_type, b.date ,b.start_time, b.end_time, b.duration, e.first_name as started_by, e.first_name as ended_by')
        // ->join('break_time b','e.employee_id = b.employee_id')
        // ->join('break_time b','e.employee_id = b.started_by')
        // ->join('break_time b','e.employee_id = b.ended_by')->where(['b.employee_id' => $post['emp_id'], 'date' => $post['date']]);

        $query = $this->db->select('e.employee_id, e.first_name, e.last_name, e.hrm_id, e.super_visor_id, b.break_type, b.status, b.date, b.start_time, b.end_time, b.duration, CONCAT_WS(\' \',started_by.first_name,started_by.last_name) as started_by_name, CONCAT_WS(\' \',ended_by.first_name,ended_by.last_name) as ended_by_name')
        ->from('employee_history e')
        ->join('break_time b', 'e.employee_id = b.employee_id')
        ->join('employee_history started_by', 'b.started_by = started_by.employee_id','left')
        ->join('employee_history ended_by', 'b.ended_by = ended_by.employee_id','left');
        
        if ($this->input->post('emp_id') == 0 && ($this->session->userdata('position_id') == 101 || $this->session->userdata('isAdmin') == 1)) {
            return $query->where(['b.status' => 'start', 'b.date' => $post['date']]);
        }
        if ($this->input->post('emp_id') == 0 &&  $this->session->userdata('supervisor')) {
            return $query->where(['b.status' => 'start', 'e.super_visor_id' => $this->session->userdata('employee_id'), 'b.date' => $post['date']]);
        }
        if ($this->input->post('emp_id') != 0) {
            return $query->where(['b.employee_id' => $post['emp_id'], 'b.date' => $post['date']]);
        }
    }

    public function countAllRowsBreakTime(){
        return $this->baseQueryBreakTime()->get()->num_rows();
    }
    // public function countDatatableBreakTime(){
    //     return $this->baseQueryBreakTime()->get()->num_rows();
    // }
    public function getDatatableBreakTime($data = null){
        $post = $this->input->post();
        $this->baseQueryBreakTime();
        $this->db->order_by('b.id','DESC')
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);
        return $this->db->get()->result_array();
    }

    public function baseQueryUnmarkedAttendance()
    {
        $employee_id = $this->session->userdata('employee_id');
        $today = date('Y-m-d');

        if ($this->session->userdata('supervisor')) {
            $employee_list = $this->db
            ->select("e.employee_id, e.first_name, e.last_name, e.hrm_id,a.status")
            ->join('attendance_status a','a.employee_id=e.employee_id','left')
            ->where('super_visor_id',$employee_id)
            ->where("e.employee_id NOT IN (SELECT uid FROM attendance_history WHERE attendance_history.day = '".$today."' and attendance_history.status = 'in')");
            return $employee_list;
        }
    }

    public function countAllRowsUnmarkedAttendance(){
        return $this->baseQueryUnmarkedAttendance()->get('employee_history e')->num_rows();
    }

    public function getDatatableUnmarkedAttendance()
    {
        $post = $this->input->post();
        $this->baseQueryUnmarkedAttendance();

        $this->db->order_by('e.first_name','ASC')
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);
        return $this->db->get('employee_history e')->result_array();
    }
}
