<?php
defined('BASEPATH') or exit('No direct script access allowed');
class User extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library(array('MY_Form_validation'));
        $this->form_validation->run($this);
        $this->load->model(array(
            'user_model',
        ));
    }
    public function index()
    {
        $this->permission->method('user_list', 'read')->redirect();
        $data['title'] = display('user_list');
        $data['module'] = "dashboard";
        $data['page'] = "user/list";
        $data['user'] = $this->user_model->read();
        echo Modules::run('template/layout', $data);
    }
    public function form($id = null)
    {
        if ($this->input->post('id')) {
            $this->permission->method('user_list', 'update')->redirect();
        } else {
            $this->permission->method('add_role', 'create')->redirect();
        }
        $data['title'] = display('add_user');
        if ($this->input->post()) {
            $this->form_validation->set_rules('username', display('username'), 'required|max_length[50]');
            if (!empty($id)) {
                $this->form_validation->set_rules('email', 'Email Address', "required|valid_email|max_length[100]");
            } else {
                $this->form_validation->set_rules('email', display('email'), 'required|valid_email|max_length[100]|is_unique[user.email]');
            }
            if (empty($id)) {
                $this->form_validation->set_rules('password', display('password'), 'required|max_length[32]');
            }
            $this->form_validation->set_rules('about', display('about'), 'max_length[1000]');
            $this->form_validation->set_rules('status', display('status'), 'required|max_length[1]');
            /*-----------------------------------*/
            $config['upload_path'] = './assets/img/user/';
            $config['allowed_types'] = 'gif|jpg|png';
            $image = $this->input->post('image');
            /*-----------------------------------*/
            $name = trim($this->input->post('username'));
            $last_name = (strpos($name, ' ') === false) ? '' : preg_replace('#.*\s([\w-]*)$#', '$1', $name);
            $first_name = trim(preg_replace('#' . preg_quote($last_name, '#') . '#', '', $name));
            $data['user'] = (object) $userLevelData = array(
                'id' => $this->input->post('id'),
                'firstname' => $first_name,
                'lastname' => $last_name,
                'email' => $this->input->post('email'),
                'about' => $this->input->post('about', true),
                'image' => (!empty($image) ? $image : $this->input->post('old_image')),
                'last_login' => null,
                'last_logout' => null,
                'ip_address' => null,
                'status' => $this->input->post('status'),
                'is_admin' => 0,
            );
            if (!empty($this->input->post('password'))) {
                $userLevelData['password'] = password_hash($this->input->post('password'), PASSWORD_DEFAULT);
                $userLevelData['new_algo'] = 1;
            }
            /*-----------------------------------*/
            if ($this->form_validation->run()) {
                if (empty($userLevelData['id'])) {
                    if ($this->user_model->create($userLevelData)) {
                        $this->session->set_flashdata('message', display('save_successfully'));
                    } else {
                        $this->session->set_flashdata('exception', display('please_try_again'));
                    }
                    redirect("dashboard/user/form/");
                } else {
                    if ($this->db->from('user')->where(['email' => $userLevelData['email'], 'id <>' => $id])->count_all_results() !== 0) {
                        $this->session->set_flashdata('exception', display(['Email', 'is', 'already', 'registered', 'with', 'another', 'user'], true));
                        redirect("dashboard/user/form/$id");
                    }
                    if ($this->user_model->update($userLevelData)) {
                        $this->session->set_flashdata('message', display('update_successfully'));
                        redirect("dashboard/user/form/$id");
                    } else {
                        $this->session->set_flashdata('exception', display('please_try_again'));
                    }
                }
            }
        }
        $data['module'] = "dashboard";
        $data['page'] = "user/form";
        $data['empl'] = $this->user_model->employee();
        if (!empty($id)) {
            $data['user'] = $this->user_model->single($id);
        }
        $data['empinfo'] = $this->user_model->empinfo($data['user']->email);
        echo Modules::run('template/layout', $data);
    }
    public function delete($id = null)
    {
        $this->permission->method('user_list', 'delete')->redirect();
        if ($this->user_model->delete($id)) {
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("dashboard/user/index");
    }
    public function active_session($id = null)
    {
        if ($id) {
            $this->permission->method('user_list', 'update')->redirect();
        } else {
            $id = $this->session->userdata('id');
        }
        if (!$id) {
            return redirect();
        }
        if ($this->input->post()) {
            return $this->session_datatable($id);
        }
        $data['title'] = display(['active', 'sessions']);
        $data['id'] = $id;
        $data['module'] = 'dashboard';
        $data['page'] = 'user/active_sessions';
        echo Modules::run('template/layout', $data);
    }
    private function session_datatable($id)
    {
        $rows = $this->sessionmanager->get($id);
        $search_arr = [];
        $search_columns = [];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            foreach ($search_columns as $value) {
                $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
            }
        };
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $out_arr["recordsFiltered"] = count($rows);
        foreach ($rows as $index => $rec) {
            $rec = (array) $rec;
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'platform':{
                            $tdData = $rec[$col['data']];
                            if ($rec['is_mobile'] == 1) {
                                $tdData .= ' (Mobile)';
                            }
                            break;
                        }
                    case 'last_active':{
                            $tdData = formatted_date($rec[$col['data']], true);
                            break;
                        }
                    case 'action':{
                            $tdData = '';
                            if ($rec['nonce'] == $this->sessionmanager->currentId()) {
                                $tdData = display(['Current', 'Device']);
                                break;
                            } else {
                                $tdData = '<button type="button" class="btn btn-primary btn-logout" data-id="' . $rec['nonce'] . '" data-user="' . $this->session->userdata('id') . '">' . display(['sign', 'out'], true) . '</button>';
                                break;
                            }
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
    public function session_quit()
    {
        if ($this->input->post()) {
            $id = null;
            $nonce = $this->input->post('id');
            $except_nonce = null;
            if ($this->session->userdata('id') != $this->input->post('user') && $this->permission->method('user_list', 'update')->access()) {
                $id = $this->input->post('user');
            } else {
                $id = $this->session->userdata('id');
                $except_nonce = $this->sessionmanager->currentId();
            }
            if ($this->sessionmanager->destroy($id, $nonce, $except_nonce)) {
                return sendJson(['success' => display(['sign', 'out', 'successful'], true)]);
            }
            return sendJson(['error' => display(['unable', 'to', 'sign', 'out'], true)]);
        }
        return sendJson(['error' => display(['invalid', 'request'], true)]);
    }
    public function employeeData()
    {
        $employee_id = $this->input->post('employee_id');
        $data = $this->db->select('first_name,last_name,email,picture')->from('employee_history')->where('employee_id', $employee_id)->get()->row();
        $info = array(
            'first_name' => $data->first_name,
            'last_name' => $data->last_name,
            'emails' => (!empty($data->email) ? $data->email : null),
            'image' => $data->picture,
        );
        echo json_encode($info);
    }
}
