<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Home extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model([
            'evencal_model' => 'evencal',
            'home_model',
            'leave/Leave_model',
            'attendance/Csv_model',
            'stats_model' => 'stats',
        ]);
        $this->load->library('calendar', $this->_setting());
    }
    public function stats()
    {
        if (!$this->input->get('type')) {
            return sendJson([]);
        }
        $type = explode(',', $this->input->get('type'));
        $this->load->model(['stats_model' => 'stats']);
        $data = [];

        if (in_array('employees', $type)) {
            $data['employees'] = $this->stats->employees();
        }
        if (in_array('attendance', $type)) {
            $data['attendance'] = $this->stats->attendance();
            if (in_array('departments', $type)) {
                $data['departments'] = $data['attendance']['departments'];
                $data['departments'] = array_values(array_filter($data['departments'], function ($v) {
                    return array_reduce($v['attendance'], function ($sum, $v2) {
                        return $sum + $v2;
                    }, 0) > 0;
                }));
            }
            unset($data['attendance']['departments']);
        }
        if (in_array('departments', $type) && !isset($data['attendance'])) {
            $data['departments'] = $this->stats->attendance()['departments'];
            $data['departments'] = array_values(array_filter($data['departments'], function ($v) {
                return array_reduce($v['attendance'], function ($sum, $v2) {
                    return $sum + $v2;
                }, 0) > 0;
            }));
        }
        if (in_array('work_time', $type)) {
            $this->load->model('attendance/attendence_model');
            $data['work_time'] = $this->attendence_model->get_current_worktime();
        }
        if (in_array('this_month', $type)) {

            $date_filter = $this->input->get('date');
            $data['this_month'] = $this->stats->this_month($date_filter);
        }
        if (in_array('notices', $type)) {
            $this->load->model('noticeboard/notice_model', 'notices');
            $notice_page = $_GET['page'] >= 0 ? $_GET['page'] : 0;
            $notice_limit = $_GET['limit'] >= 0 ? $_GET['limit'] : 10;
            $data['notices'] = [
                'posts' => $this->notices->get($notice_page, $notice_limit),
                'next' => count($this->notices->get($notice_page + 1, $notice_limit)),
            ];
        }
        if (in_array('break_exceeeded_emps', $type)) {

            $employee_attendance_page = $_GET['page'] >= 0 ? $_GET['page'] : 0;
            $employee_attendance_limit = $_GET['limit'] >= 0 ? $_GET['limit'] : 10;
            $data['break_time'] = [
                'exceeeded_emps' => $this->stats->break_exceeeded_emps($employee_attendance_page, $employee_attendance_limit),
                'next' => count($this->stats->break_exceeeded_emps($employee_attendance_page + 1, $employee_attendance_limit)),
            ];
        }
        if (in_array('absent_employee_list', $type)) {

            $employee_attendance_page = $_GET['page'] >= 0 ? $_GET['page'] : 0;
            $employee_attendance_limit = $_GET['limit'] >= 0 ? $_GET['limit'] : 10;
            $data['attendance'] = [
                'absent' => $this->stats->employee_attendance_query('A',$employee_attendance_page, $employee_attendance_limit),
                'next' => count($this->stats->employee_attendance_query('A',$employee_attendance_page + 1, $employee_attendance_limit)),
            ];
        }
        if (in_array('present_employee_list', $type)) {

            $employee_attendance_page = $_GET['page'] >= 0 ? $_GET['page'] : 0;
            $employee_attendance_limit = $_GET['limit'] >= 0 ? $_GET['limit'] : 10;
            $data['attendance'] = [
                'present' => $this->stats->employee_attendance_query('P',$employee_attendance_page, $employee_attendance_limit),
                'next' => count($this->stats->employee_attendance_query('P',$employee_attendance_page + 1, $employee_attendance_limit)),
            ];
        }
        if (in_array('today_leaves', $type)) {

            $today_leaves_page = $_GET['page'] >= 0 ? $_GET['page'] : 0;
            $today_leaves_limit = $_GET['limit'] >= 0 ? $_GET['limit'] : 10;
            $today = date('Y-m-d H:i:s');
            $data['leave'] = [
                'today' => $this->stats->employees_leave_query($today,$today_leaves_page, $today_leaves_limit),
                'next' => count($this->stats->employees_leave_query($today,$today_leaves_page + 1, $today_leaves_limit)),
            ];
        }
        if (in_array('tomorrow_leaves', $type)) {

            $tomorrow_leaves_page = $_GET['page'] >= 0 ? $_GET['page'] : 0;
            $tomorrow_leaves_limit = $_GET['limit'] >= 0 ? $_GET['limit'] : 10;
            $tomorrow = date("Y-m-d H:i:s", strtotime('+1 day'));

            $data['leave'] = [
                'tomorrow' => $this->stats->employees_leave_query($tomorrow,$tomorrow_leaves_page, $tomorrow_leaves_limit),
                'next' => count($this->stats->employees_leave_query($tomorrow,$tomorrow_leaves_page + 1, $tomorrow_leaves_limit)),
            ];
        }
        if (in_array('this_week_leaves', $type)) {

            $this_week_leaves_page = $_GET['page'] >= 0 ? $_GET['page'] : 0;
            $this_week_leaves_limit = $_GET['limit'] >= 0 ? $_GET['limit'] : 10;
            $this_week = date("Y-m-d", strtotime('+1 day'));

            $leave_type = 'this_week';

            $returnData = $this->stats->employees_leave_query($this_week,$this_week_leaves_page, $this_week_leaves_limit,$leave_type);
            $data['leave'] = [
                'this_week' => $returnData,
                'this_week_count' => count($returnData),
                'next' => count($this->stats->employees_leave_query($this_week,$this_week_leaves_page + 1, $this_week_leaves_limit,$leave_type)),
            ];
        }
        if (in_array('attrition_rate', $type)) {
            $data['attrition_rate'] = $this->stats->get_attrition_rate();
        }
        sendJson($data);
    }
    public function details()
    {
        $post = json_decode($this->input->raw_input_stream, true);
        if ($post['type'] && $post['key']) {
            if (in_array($post['type'], ['employee', 'attendance', 'leave', 'this_month', 'hidden'])) {
                sendJson($this->stats->details($post['type'], $post['key'], $post['datefilter']));
            }
        }
        show_404();
    }
    public function exempt()
    {
        $post = json_decode($this->input->raw_input_stream, true);
        if ($post['key'] && $post['id']) {
            if ($this->stats->attendance_exempt($post['key'], $post['id'])) {
                sendJson(['success' => 1]);
            }
        }
        sendJson(['error' => 1]);
    }
    public function index($year = null, $month = null, $day = null)
    {
        if ($this->input->post()) {
            if ($this->input->post('month') && $this->input->post('year')) {
                $month = intval($this->input->post('month'));
                $year = intval($this->input->post('year'));
                $holidays = $this->evencal->get_events($month, $year);
                $calendar_data = [];
                foreach ($holidays as $holiday_key => $holiday) {
                    $calendar_data[date('d', strtotime($holiday_key))] = $holiday;
                }
                $html = $this->calendar->generate($year, $month, $calendar_data);
                sendJson(['success' => [
                    'month' => $month,
                    'year' => $year,
                    'full_month' => date('F', strtotime('01-' . $month . '-' . $year)),
                    'html' => preg_replace('@>[\\n\\t\\s]+<@', '><', $html),
                ]]);
            }
        }
        $year = (empty($year) || !is_numeric($year)) ? date('Y') : $year;
        $month = (is_numeric($month) && $month > 0 && $month < 13) ? $month : date('m');
        $day = (is_numeric($day) && $day > 0 && $day < 31) ? $day : date('d');

        $holidays = $this->evencal->get_events($month, $year);
        $calendar_data = [];
        foreach ($holidays as $holiday_key => $holiday) {
            $calendar_data[date('d', strtotime($holiday_key))] = $holiday;
        }
        $data = array(
            'latest_notice' => $this->db->select('notice_type as title, notice_descriptiion as description, notice_date as date')->order_by('notice_date', 'desc')->limit(1)->get('notice_board')->row(),
            'notes' => $this->calendar->generate($year, $month, $calendar_data),
            'year' => $year,
            'mon' => $month,
            'month' => $this->_month($month),
            'day' => $day,
            'module' => "dashboard",
            'page' => "home/index",
        );
        $data['unmarked_attendance'] = count($this->stats->today_unmarked_attendance());
        $emp_id = $this->session->userdata('employee_id');
        $total_break_time = $this->db->select_sum('duration')->where(['duration !=' => null, 'employee_id' =>  $emp_id, 'date' => date('Y-m-d')])->get('break_time')->row();
        $duration = secondsToTime($total_break_time->duration);
        $data['break_time'] = sprintf("%02d:%02d:%02d", $duration['hours'], $duration['minutes'], $duration['seconds']);

        $attendance_checkout = $this->db->select('duration')->where(['uid' => $emp_id, 'status' => 'out', 'day' => date('Y-m-d') ,'active' => 1])->get('attendance_history')->row();
        
        if (empty( $attendance_checkout)) {
            $attendance_checkIn = $this->db->select('punchin_time')->where(['uid' => $emp_id, 'status' => 'in', 'day' => date('Y-m-d') ,'active' => 1])->get('attendance_history')->row();
            $time = empty($attendance_checkIn->punchin_time) ? 0 :  strtotime(date('Y-m-d H:i:s')) - strtotime($attendance_checkIn->punchin_time);
        }
        else {
            $time = $attendance_checkout->duration;
        }
        $calc_time = $time == 0 ? 0 : $time - $total_break_time->duration;
        $totalWorkHours = secondsToTime($calc_time);
        $data['totalWorkHours'] = sprintf("%02d:%02d:%02d", $totalWorkHours['hours'], $totalWorkHours['minutes'], $totalWorkHours['seconds']);

        // if ($this->sessionuserdata('position_id') == 101 || $this->session->userdata('isAdmin') == 1) {
        //     $data['userlist'] = $this->on_break_emp_list();
        // }
        // else {
           $data['userlist'] = $this->Csv_model->userlist();

        // }
        if ($this->session->userdata('division_id')) {
            $data['promo_video'] = $this->_promo_vids[$this->session->userdata('division_id')];
        }
        echo Modules::run('template/layout', $data);
    }
    // for convert (int) month to (string) month in Indonesian
    public function _month($month)
    {
        $month = (int) $month;
        switch ($month) {
            case 1:$month = 'January';
                break;
            case 2:$month = 'February';
                break;
            case 3:$month = 'March';
                break;
            case 4:$month = 'April';
                break;
            case 5:$month = 'May';
                break;
            case 6:$month = 'Jun';
                break;
            case 7:$month = 'July';
                break;
            case 8:$month = 'August';
                break;
            case 9:$month = 'September';
                break;
            case 10:$month = 'October';
                break;
            case 11:$month = 'November';
                break;
            case 12:$month = 'December';
                break;
        }
        return $month;
    }
    public function punch_break_time()
    {
        if ($this->input->post()) {
            $check_break_time = $this->check_break_time($this->input->post('employee_id'));
            if (!empty($check_break_time) && $this->input->post('checkAction') == 'start') {
                sendJson(['info' => 'Please stop '.$check_break_time->break_type. ' time first']);
            }

            $status = $this->input->post('checkAction');
            $postData['employee_id'] = $this->input->post('employee_id');
            $postData['date'] = $status == 'start' ? date('Y-m-d') : $this->input->post('date');

            if ($this->input->post('checkAction') == 'start') {

                $postData['start_time'] = date('Y-m-d H:i:s');
                $postData['break_type'] = $this->input->post('type');
                $postData['status'] = 'start';
                $postData['started_by'] = $this->session->userdata('employee_id');
                $this->db->insert('break_time',$postData);
                sendJson(['success' => 'Timer start for '.$postData['break_type']]);
            }
            else {
                $start = strtotime($this->input->post('start_time'));
                $end = strtotime(date('Y-m-d H:i:s'));
                $calculate = $end - $start;
                $duration = $calculate;

                $postData['end_time'] = $status == 'end' ? date('Y-m-d H:i:s') : null;
                $postData['duration'] = $status == 'end' ? $duration : null;
                $postData['status'] = 'end';
                $postData['ended_by'] = $this->session->userdata('employee_id');

                $this->db->where('id',$this->input->post('id'))->update('break_time',$postData);
                sendJson(['success' => 'Timer stoped']);
            }
        }

        if ($this->input->get()) {
            $employee_id = $this->input->get('employee_id');
            $check_break_time = $this->check_break_time($employee_id);
            sendJson(['data' => $check_break_time]);
        } 
    }

    public function check_break_time($employee_id = null)
    {
        // $id = $employee_id ?? $this->session->userdata('employee_id');
        return $this->db->select('*')->where(['employee_id' => $employee_id, 'date' => date('Y-m-d'), 'status' => 'start'])->get('break_time')->row();

    }
    public function break_time_list()
    {
        $this->break_list_datatable();
    }

    public function break_list_datatable()
    {
        $search_arr = [];
        $search_columns = [
           
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            foreach ($search_columns as $value) {
                $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
            }
        };
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $this->home_model->countAllRowsBreakTime();
        //$out_arr["recordsFiltered"] = $this->home_model->countDatatableBreakTime($search_arr);
        $out_arr["recordsFiltered"] = $out_arr["recordsTotal"];
        $rows = $this->home_model->getDatatableBreakTime($search_arr);
        $status_arr = [
            'pending' => 'Pending',
        ];
        $label_class = [
            'pending' => 'primary',
        ];
        foreach ($rows as $index => $rec) {
            // dd($rec);
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'employee':{
                        $tdData = $rec['first_name'].' '.$rec['last_name'].' '.$rec['hrm_id'];
                        break;
                    }
                    case 'date':{
                        $tdData = $rec['date'];
                        break;
                    }
                    case 'start':{
                        $tdData = $rec['start_time'];
                        break;
                    }
                    case 'end':{
                        $tdData = $rec['end_time'];
                        break;
                    }
                    case 'duration':{

                        if (empty($rec['end_time'])) {
                            
                            $start_time =  strtotime($rec['start_time']);
                            $elapsed_time = time() - $start_time;
                            $hours = floor($elapsed_time / 3600);
                            $minutes = floor(($elapsed_time % 3600) / 60);
                            $seconds = round($elapsed_time % 60);
                            $formatted_time = sprintf('%02d:%02d:%02d', $hours, $minutes, $seconds);
                            $tdData = $formatted_time;
                            break;
                        }
                        else {
                            $duration = secondsToTime($rec['duration']);
                            $tdData = sprintf("%02d:%02d:%02d", $duration['hours'], $duration['minutes'], $duration['seconds']);
                            break;
                        }
                        
                    }
                    case 'break_type':{
                        
                        $tdData = $rec['status'] == 'start' ? '<h5 class="break-type"> <i class="fa fa-circle"></i> '.ucfirst($rec['break_type']).' Break</h5>' : ucfirst($rec['break_type']) . ' Break';
                        break;
                    }
                    case 'started_by':{
                        $tdData = $rec['started_by_name'];
                        break;
                    }
                    case 'ended_by':{
                        $tdData = $rec['ended_by_name'];
                        break;
                    }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
    public function unmarked_attendance()
    {
        $search_arr = [];
        $search_columns = [
           
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            foreach ($search_columns as $value) {
                $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
            }
        };
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $this->home_model->countAllRowsUnmarkedAttendance();
        //$out_arr["recordsFiltered"] = $this->home_model->countDatatableBreakTime($search_arr);
        $out_arr["recordsFiltered"] = $out_arr["recordsTotal"];
        $rows = $this->home_model->getDatatableUnmarkedAttendance();
        foreach ($rows as $index => $rec) {
            // dd($rec);
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'name':{
                        $tdData = $rec['first_name'].' '.$rec['last_name'];
                        break;
                    }
                    case 'hrm_id':{
                        $tdData = $rec['hrm_id'];
                        break;
                    }
                    case 'status':{
                        $status = ($rec['status'] == null) ? '---' : (($rec['status'] == '3') ? 'Informed' : (($rec['status'] == 1) ? 'NCNS' : 'Late Arrival'));
                        $tdData = $status;
                        break;
                    }
                    case 'action':{
                        $tdData = '<button type="submit" data-status="informed" data-employee_id="'.$rec['employee_id'].'" class="btn btn-primary btn-sm attendance-status-align btn-attendance-status">Informed</button>';
                        $tdData .= '<button type="submit" data-status="ncns" data-employee_id="'.$rec['employee_id'].'" class="btn btn-danger btn-sm attendance-status-align btn-attendance-status">NCNS</button>';
                        $tdData .= '<button type="submit" data-status="la" data-employee_id="'.$rec['employee_id'].'" class="btn btn-info btn-sm attendance-status-align btn-attendance-status">Late Arrival</button>';
                        break;
                    }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
    // get detail event for selected date
    public function detail_event()
    {
        $this->form_validation->set_rules('year', 'Year', 'trim|required|is_natural_no_zero');
        $this->form_validation->set_rules('mon', 'Month', 'trim|required|is_natural_no_zero|less_than[13]');
        $this->form_validation->set_rules('day', 'Day', 'trim|required|is_natural_no_zero|less_than[32]');
        if ($this->form_validation->run() == false) {
            echo json_encode(array('status' => false, 'title_msg' => 'Error', 'msg' => 'Please insert valid value'));
        } else {
            $data = $this->evencal->getEvent($this->input->post('year', true), $this->input->post('mon', true), $this->input->post('day', true));
            if ($data == null) {
                echo json_encode(array('status' => false, 'title_msg' => 'No Result', 'msg' => 'There\'s no result in this date'));
            } else {
                echo json_encode(array('status' => true, 'data' => $data));
            }
        }
    }
    public function detail_notice()
    {
        $this->form_validation->set_rules('year', 'Year', 'trim|required|is_natural_no_zero');
        $this->form_validation->set_rules('mon', 'Month', 'trim|required|is_natural_no_zero|less_than[13]');
        $this->form_validation->set_rules('day', 'Day', 'trim|required|is_natural_no_zero|less_than[32]');
        if ($this->form_validation->run() == false) {
            echo json_encode(array('status' => false, 'title_msg' => 'Error', 'msg' => 'Please insert valid value'));
        } else {
            $data = $this->evencal->getNotice($this->input->post('year', true), $this->input->post('mon', true), $this->input->post('day', true));
            if ($data == null) {
                echo json_encode(array('status' => false, 'title_msg' => 'No Result', 'msg' => 'There\'s no result in this date'));
            } else {
                echo json_encode(array('status' => true, 'data' => $data));
            }
        }
    }
    public function detail_leave()
    {
        $this->form_validation->set_rules('year', 'Year', 'trim|required|is_natural_no_zero');
        $this->form_validation->set_rules('mon', 'Month', 'trim|required|is_natural_no_zero|less_than[13]');
        $this->form_validation->set_rules('day', 'Day', 'trim|required|is_natural_no_zero|less_than[32]');
        if ($this->form_validation->run() == false) {
            echo json_encode(array('status' => false, 'title_msg' => 'Error', 'msg' => 'Please insert valid value'));
        } else {
            $data = $this->evencal->getLeave($this->input->post('year', true), $this->input->post('mon', true), $this->input->post('day', true));
            if ($data == null) {
                echo json_encode(array('status' => false, 'title_msg' => 'No Result', 'msg' => 'No results found for the selected day'));
            } else {
                echo json_encode(array('status' => true, 'data' => $data));
            }
        }
    }
    //loan detail on date
    public function detail_loan()
    {
        $this->form_validation->set_rules('year', 'Year', 'trim|required|is_natural_no_zero');
        $this->form_validation->set_rules('mon', 'Month', 'trim|required|is_natural_no_zero|less_than[13]');
        $this->form_validation->set_rules('day', 'Day', 'trim|required|is_natural_no_zero|less_than[32]');
        if ($this->form_validation->run() == false) {
            echo json_encode(array('status' => false, 'title_msg' => 'Error', 'msg' => 'Please insert valid value'));
        } else {
            $data = $this->evencal->getLoan($this->input->post('year', true), $this->input->post('mon', true), $this->input->post('day', true));
            if ($data == null) {
                echo json_encode(array('status' => false, 'title_msg' => 'No Result', 'msg' => 'There\'s no result in this date'));
            } else {
                echo json_encode(array('status' => true, 'data' => $data));
            }
        }
    }
    // same as index() function
    public function detail($year = null, $month = null, $day = null)
    {
        $year = (empty($year) || !is_numeric($year)) ? date('Y') : $year;
        $month = (is_numeric($month) && $month > 0 && $month < 13) ? $month : date('m');
        $day = (is_numeric($day) && $day > 0 && $day < 31) ? $day : date('d');
        $date = $this->evencal->getDateEvent($year, $month);
        $notice = $this->evencal->getNotice($year, $month, $day);
        $leave = $this->evencal->getLeave($year, $month, $day);
        $loan = $this->evencal->getLoan($year, $month, $day);
        $cur_event = $this->evencal->getEvent($year, $month, $day);
        $data = array(
            'notes' => $this->calendar->generate($year, $month, $date),
            'year' => $year,
            'mon' => $month,
            'month' => $this->_month($month),
            'day' => $day,
            'notice' => $notice,
            'loan' => $loan,
            'leave' => $leave,
            'events' => $cur_event,
            'module' => "dashboard",
            'page' => "home/index",
        );
        echo Modules::run('template/layout', $data);
    }
    //Notice details
    // setting for calendar
    public function _setting()
    {
        $weekend_col_group = '<col class="weekday" span="5"><col class="weekend_sat"><col class="weekend_sat">';
        if ($this->session->userdata('employee_id')) {
            $weekend_col_group = '';
            $weekends = get_weekend();
            if ($this->session->userdata('shift') && $weekend = $weekends[$this->session->userdata('shift')]) {
                $weekend = array_map(function ($day) {
                    return date('N', strtotime($day));
                }, $weekend);
                for ($i = 1; $i <= 7; $i++) {
                    $class_name = 'weekday';
                    if (in_array($i, $weekend)) {
                        $class_name = 'weekend_sat';
                    }
                    $weekend_col_group .= "<col class=\"{$class_name}\">";
                }
            }
        }
        return array(
            'start_day' => 'monday',
            'show_next_prev' => true,
            'next_prev_url' => '#',
            'month_type' => 'long',
            'day_type' => 'short',
            'template' =>
            '{table_open}<table class="date">{/table_open}
                {heading_row_start}&nbsp;{/heading_row_start}
                {heading_previous_cell}<caption><a href="{previous_url}" class="prev_date btn btn-success"Month">&lt;&lt;Prev</a>{/heading_previous_cell}
                {heading_title_cell}{heading}{/heading_title_cell}
                {heading_next_cell}<a href="{next_url}" class="next_date btn btn-success">Next&gt;&gt;</a></caption>{/heading_next_cell}
                {heading_row_end}' . $weekend_col_group . '{/heading_row_end}
                {week_row_start}<thead><tr>{/week_row_start}
                {week_day_cell}<th>{week_day}</th>{/week_day_cell}
                {week_row_end}</tr></thead><tbody>{/week_row_end}
                {cal_row_start}<tr>{/cal_row_start}
                {cal_cell_start}<td>{/cal_cell_start}
                {cal_cell_content}<div class="date_event detail" val="{day}"><span class="date">{day}</span><span class="event d{day}">{content}</span></div>{/cal_cell_content}
                {cal_cell_content_today}<div class="active_date_event detail" val="{day}"><span class="date">{day}</span><span class="event d{day}">{content}</span></div>{/cal_cell_content_today}
                {cal_cell_no_content}<div class="no_event detail" val="{day}"><span class="date">{day}</span><span class="event d{day}">&nbsp;</span></div>{/cal_cell_no_content}
                {cal_cell_no_content_today}<div class="active_no_event detail" val="{day}"><span class="date">{day}</span><span class="event d{day}">&nbsp;</span></div>{/cal_cell_no_content_today}
                {cal_cell_blank}&nbsp;{/cal_cell_blank}
                {cal_cell_end}</td>{/cal_cell_end}
                {cal_row_end}</tr>{/cal_row_end}
                {table_close}</tbody></table>{/table_close}',
        );
    }
    public function profile()
    {
        $data['title'] = "Profile";
        $data['module'] = "dashboard";
        $data['page'] = "home/profile";
        $id = $this->session->userdata('id'); //
        $data['user'] = $this->home_model->profile($id);
        echo Modules::run('template/layout', $data);
    }
    public function setting()
    {
        $data['title'] = "Profile Setting";
        $id = $this->session->userdata('id');
        /*-----------------------------------*/
        /* $this->form_validation->set_rules('firstname', 'First Name','required|max_length[50]');
        $this->form_validation->set_rules('lastname', 'Last Name','required|max_length[50]');
        #------------------------#
        $this->form_validation->set_rules('email', 'Email Address', "required|valid_email|max_length[100]"); */
        /*---#callback fn not supported#---*/
        // $this->form_validation->set_rules('email', 'Email Address', "required|valid_email|max_length[100]|callback_email_check[$id]|trim");
        #------------------------#
        $this->form_validation->set_rules('password', 'Password', 'max_length[32]');
        $this->form_validation->set_rules('conf_password', 'Confirm Password', 'matches[password]');
        $this->form_validation->set_rules('about', 'About', 'max_length[1000]');
        /*-----------------------------------*/
        $config['upload_path'] = './assets/img/user/';
        $config['allowed_types'] = 'gif|jpg|png';
        $this->load->library('upload', $config);
        if ($this->upload->do_upload('image')) {
            $data = $this->upload->data();
            $image = $config['upload_path'] . $data['file_name'];
            $config['image_library'] = 'gd2';
            $config['source_image'] = $image;
            $config['create_thumb'] = false;
            $config['maintain_ratio'] = true;
            $config['width'] = 115;
            $config['height'] = 90;
            $this->load->library('image_lib', $config);
            $this->image_lib->resize();
            $this->session->set_flashdata('message', "Image Upload Successfully!");
        }
        /*-----------------------------------*/
        $data['user'] = (object) $userData = array(
            'id' => $this->input->post('id'),
            'about' => $this->input->post('about', true),
            'image' => (!empty($image) ? $image : $this->input->post('old_image')),
        );
        if (!empty($this->input->post('password'))) {
            $userData['password'] = password_hash($this->input->post('password'), PASSWORD_DEFAULT);
            $userData['new_algo'] = 1;
        }
        /*-----------------------------------*/
        if ($this->form_validation->run()) {
            if (!empty($_FILES['image']['name']) && empty($userData['image'])) {
                $this->session->set_flashdata('exception', $this->upload->display_errors());
            }
            if ($this->home_model->setting($userData)) {
                $this->session->set_userdata(array(
                    'image' => (!empty($image) ? $image : $this->input->post('old_image')),
                ));
                $this->session->set_flashdata('message', display('update_successfully'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("dashboard/home/setting");
        } else {
            $data['module'] = "dashboard";
            $data['page'] = "home/profile_setting";
            if (!empty($id)) {
                $data['user'] = $this->home_model->profile($id);
            }

            echo Modules::run('template/layout', $data);
        }
    }
    ///// Notice
    public function view_details()
    {
        $id = $this->uri->segment(4);
        $data['module'] = "dashboard";
        $data['page'] = "home/notice_details";
        $data['detls'] = $this->evencal->details($id);
        echo Modules::run('template/layout', $data);
    }
    public function incomeinfo()
    {
        $year = $this->input->post('year');
        echo json_encode($year);
    }
    public function tmce_upload()
    {
        $name = @pathinfo(@$_FILES['file']['name'], PATHINFO_FILENAME);
        $name = str_slug($name);
        if (empty($name)) {
            $name = "file_" . uniqid();
        }
        $file_path = 'uploads/temp/' . date('Y-m-d') . '/';
        if (!is_dir(FCPATH . $file_path)) {
            mkdir(FCPATH . $file_path);
        }
        $config['upload_path'] = $file_path;
        $config['allowed_types'] = '*';
        $config['file_name'] = $name;
        $this->load->library('upload', $config);
        if ($this->upload->do_upload('file')) {
            $data = array('upload_data' => $this->upload->data());
            if (isset($data['upload_data']['full_path'])) {
                $this->output
                    ->set_status_header(200)
                    ->set_output(json_encode(['location' => $file_path . $data['upload_data']['file_name']]));
            }
        } else {
            $this->output
                ->set_status_header(500)
                ->set_output($this->upload->display_errors());
        }
    }
    public function changelogs()
    {
        $content = file_get_contents(FCPATH . 'CHANGELOG.md');
        $parser = new Parsedown();
        $parser->setSafeMode(true);
        $data['content'] = $parser->text($content);
        $data['title'] = 'HRM Changelogs';
        $data['page'] = 'home/changelog';
        $data['module'] = 'dashboard';
        echo Modules::run('template/layout', $data);
    }
    public function save_user_opts()
    {
        if (!empty(trim($this->session->userdata('id')))) {
            $this->home_model->set_user_options($_POST);
        }
    }

    public function attendance_status()
    {        
        // Status 
        // 0 is equal to ecl
        // 1 is equal to ncnc
        // 2 is equal to late arrival
        // 3 is equal to informed

        $status = $this->input->post('status');
        $postData['employee_id'] = $this->input->post('employee_id');
        $postData['day'] = date('Y-m-d');

        $check = $this->db->select('*')->where(['employee_id' => $postData['employee_id'], 'day' => $postData['day']])->get('attendance_status')->row();
        // dd($check);
        if (empty($check)) {
            $postData['status'] = ($status == 'informed' ? 3 : ($status == 'ncns' ? 1 : 2));
            $this->db->insert('attendance_status', $postData);

            if ($status == 'ncns') {
                $employee = $this->db->select('employee_id, ncns')->where(['employee_id' => $postData['employee_id'], 'termination_date =' => null])->get('employee_history')->row();
                if (!empty($employee)) {
                    $ncns = $employee->ncns + 1;
                    if ($ncns == 4) {
                        $updateEmpData['termination_date'] = date('Y-m-d');
                        $updateEmpData['termination_reason'] = 'above 3 ncns';
                    }
                    else {
                        $updateEmpData['ncns'] = $ncns;
                    }
                    $this->db->where('employee_id',$postData['employee_id'])->update('employee_history', $updateEmpData);
                } 
            }
            sendJson(['success' => 'Successfully Created']);
        }
        else {
            $status = ($check->status == null) ? '---' : (($check->status == '3') ? 'Informed' : (($check->status == 1) ? 'NCNS' : 'Late Arrival'));
            sendJson(['info' => 'Already marked '.$status]);
        }
    }
    public function employee_current_break_status()
    {
        $employee_id = $this->input->get('emp_id');
        $day = date('Y-m-d');

        $check_attendance = $this->db->select('e.employee_id, e.hrm_id, e.status, e.first_name, e.last_name, s.status')
        ->from('employee_details AS e')
        ->where('e.employee_id', $employee_id)
        ->join('attendance_history AS s', 's.uid = e.employee_id AND s.day = "'.date('Y-m-d').'"', 'left')->get()->row();

        if (empty($check_attendance->status)) {
            sendJson(['check_attendance' => $check_attendance]);
        }

        $break_detail = $this->db->select('e.employee_id, e.first_name, e.last_name, e.hrm_id, b.break_type, b.status, b.start_time, b.end_time')
        ->from('employee_details e')
        ->where('e.employee_id', $employee_id)
        ->join('break_time AS b', 'b.employee_id = e.employee_id AND b.date = "'.$day.'"', 'left')->order_by('start_time','DESC')->get()->row();
        
        if (!empty($break_detail->break_type)) {
            sendJson(['break_detail' => $break_detail]);
        }
        else {
            sendJson(['no_breaks' => $break_detail]);
        }
        // if ($break_detail->status == 'end') {
        //     $title = $break_detail->first_name .' '.$break_detail->last_name .' ('. $break_detail->hrm_id .')';
        // }
        // else {
        //     $title = $break_detail->first_name .' '.$break_detail->last_name .' ('. $break_detail->hrm_id .')'. ' - '.ucfirst($break_detail->break_type) .' Break';
        // }
        // sendJson(['title' => $title]);
    }

    public function check_current_attendance()
    {
        $employee_id = $this->session->userdata('employee_id');
        $day = date('Y-m-d');
        $check = $this->db->select('*')->where(['uid' => $employee_id, 'day' => $day, 'active' => 1])->group_by('status')->get('attendance_history')->result();
        if (empty($check) || count($check) == 2) {
            $status = 'not-available';
        }
        else {
            $status = 'available';
        }
        sendJson(['status' => $status]);
    }
}
