<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Award_controller extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(array(
            'Award_model',
        ));
    }
    public function awards($id = null)
    {
        $this->permission->method('awards', 'read')->redirect();
        if (isset($id)) {
            $data = $this->db->where('id', $id)->get('awards')->first_row();
            sendJson($data);
        } else {
            $data['title'] = "Awards";
            $data['mang'] = $this->db->get('awards')->result();
            $data['module'] = "award";
            $data['page'] = "awards";
            echo Modules::run('template/layout', $data);
        }
    }
    public function update_award($id = null)
    {
        if (isset($id)) {
            $award_rec = $this->db->where('id', $id)->get('awards')->row();
            if ($award_rec) {
                $this->activity->set_url('award/Award_controller/awards')->log([
                    'award_type_deleted',
                    $award_rec->name,
                ]);
            }
            $this->db->where('id', $id)->delete('awards');
            $this->session->set_flashdata('message', 'Data Delete Successfully');
            redirect("award/Award_controller/awards");
        } else {
            $post = $this->input->post();
            $data['name'] = trim($post['award']);
            if (isset($post['id']) && !empty($post['id'])) {
                $this->db->where('awards.id !=', $post['id']);
            }
            $this->db->where('awards.name', $data['name']);
            $checkAlreadyExists = $this->db->get('awards')->result();
            if (count($checkAlreadyExists) > 0) {
                $this->session->set_flashdata('message', 'Award Already Exists!');
                redirect("award/Award_controller/awards");
            }
            $data['description'] = $post['description'];
            if (!$post['id'] || empty($post['id'])) {
                $this->db->insert('awards', $data);
                $this->activity->set_url('award/Award_controller/awards')->log([
                    'award_type_inserted',
                    $data['name'],
                ]);
                $this->session->set_flashdata('message', display('successfully_created'));
                redirect("award/Award_controller/awards");
            } else {
                $this->db->where('id', $post['id'])->update('awards', $data);
                $this->activity->set_url('award/Award_controller/awards')->log([
                    'award_type_updated',
                    $data['name'],
                ]);
                $this->session->set_flashdata('message', display('successfully_created'));
                redirect("award/Award_controller/awards");
            }
        }
    }
    public function updateAwardStatus($id, $reject = null)
    {
        $empl_rec = $this->db->select('emph.*, CONCAT_WS(\' \', emph.first_name, emph.last_name) as fullname,award.AwardID')->join('award', 'award.employee_id=emph.employee_id')->where('award.award_id', $id)->get('employee_history as emph')->row();
        $Data['award_id'] = $id;
        $awards = $this->db->where('id', $empl_rec->AwardID)->get('awards')->first_row();
        $awardData = $this->db->where('award_id', $id)->get('award')->first_row();
        if (isset($reject)) {
            $Data['approved'] = 2;
            $Data['rejected_by'] = $this->session->userdata('id');
        } else {
            $Data['approved'] = 1;
            $Data['approved_by'] = $this->session->userdata('id');
            $Data['approved_date'] = date('Y-m-d');
        }
        $update = $this->Award_model->update_award($Data);
        if ($update) {
            if (isset($reject)) {
                $this->notify->employee($awardData->created_by)->send(
                    sprintf('%s (%s) award has been rejected ', $empl_rec->fullname, $empl_rec->hrm_id, $awards->name),
                    'award/Award_controller/view_award'
                );
            } else {
                $this->notify->employee($empl_rec->employee_id)->send(
                    sprintf('You have won an award "%s"', $awards->name),
                    'award/Award_controller/view_award'
                );
                $this->notify->employee($awardData->created_by)->send(
                    sprintf('%s (%s) award has been approved ', $empl_rec->fullname, $empl_rec->hrm_id, $awards->name),
                    'award/Award_controller/view_award'
                );
            }
            echo 1;
        } else {
            echo 0;
        }
    }
    public function award_view()
    {
        $this->permission->method('view_award', 'read')->redirect();
        $data['title'] = display('award');
        $data['mang'] = $this->Award_model->award_view();
        $data['module'] = "award";
        $data['page'] = "award_view";
        echo Modules::run('template/layout', $data);
    }
    public function create_award()
    {
        $this->form_validation->set_rules('award_name', display('award_name'));
        $this->form_validation->set_rules('aw_description', display('aw_description'));
        $this->form_validation->set_rules('awr_gift_item', display('awr_gift_item'), 'max_length[50]');
        $this->form_validation->set_rules('date', display('date'), 'max_length[50]');
        $this->form_validation->set_rules('employee_id', display('employee_id'), 'max_length[50]');
        $this->form_validation->set_rules('awarded_by', display('awarded_by'), 'max_length[50]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData = [
                'award_name' => $this->input->post('award_name', true),
                'aw_description' => $this->input->post('aw_description', true),
                'awr_gift_item' => $this->input->post('awr_gift_item', true),
                'date' => $this->input->post('date', true),
                'employee_id' => $this->input->post('employee_id', true),
                'awarded_by' => $this->input->post('awarded_by', true),
            ];
            if ($this->Award_model->award_create($postData)) {
                $this->session->set_flashdata('message', display('successfully_created'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("award/Award_controller/create_award");
        } else {
        }
        $data['title'] = display('award');
        $data['module'] = "award"; //
        $data['mang'] = $this->Award_model->award_view();
        $data['dropdown'] = $this->Award_model->dropdown();
        $data['awards'] = $this->db->get('awards')->result();
        $data['page'] = "create_award_form";
        echo Modules::run('template/layout', $data);
    }
    public function view_award()
    {
        $data['title'] = display('award');
        $data['module'] = "award"; //
        $data['mang'] = $this->Award_model->award_view();
        $data['subordinates'] = array_column($this->Award_model->get_subordinates(false, true), 'employee_id');
        $data['page'] = "award_form";
        echo Modules::run('template/layout', $data);
    }
    public function delete_award($id = null)
    {
        $this->permission->method('view_award', 'delete')->redirect();
        $award_rec = $this->db
            ->select('award.*, awards.name as type_name')
            ->where('award_id', $id)
            ->join('awards', 'award.AwardID=awards.id', 'left')
            ->get('award')
            ->row();
        if ($this->Award_model->award_delete($id)) {
            $this->activity
                ->set_employee($award_rec->employee_id)
                ->log([
                    'award_deleted',
                    $award_rec->type_name,
                    $id,
                ]);
            $this->session->set_flashdata('success', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("award/Award_controller/award_view");
    }
    public function update_award_form($id = null)
    {
        $data['title'] = display('award');
        #-------------------------------#
        $this->form_validation->set_rules('AwardID', display('AwardID'));
        $this->form_validation->set_rules('award_name', display('award_name'));
        $this->form_validation->set_rules('aw_description', display('aw_description'));
        $this->form_validation->set_rules('awr_gift_item', display('awr_gift_item'), 'max_length[50]');
        $this->form_validation->set_rules('date', display('date'), 'max_length[50]');
        $this->form_validation->set_rules('employee_id', display('employee_id'), 'max_length[50]');
        $this->form_validation->set_rules('awarded_by', display('awarded_by'), 'max_length[50]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $Data = [
                'AwardID' => $this->input->post('AwardID', true),
                // 'award_name'     => $this->input->post('award_name',true),
                // 'aw_description' => $this->input->post('aw_description',true),
                'awr_gift_item' => $this->input->post('awr_gift_item', true),
                'date' => date("Y-m-d", strtotime($this->input->post('date', true))),
                'employee_id' => $this->input->post('employee_id', true),
                'awarded_by' => $this->input->post('awarded_by', true),
            ];
            if (isset($id)) {
                // echo '<pre>';
                // print_r($Data);die;
                $Data['award_id'] = $this->input->post('award_id');
                $update = $this->Award_model->update_award($Data);
            } else {
                if ($this->session->userdata('isAdmin') == 1) {
                    $Data['approved'] = 1;
                    $Data['approved_by'] = $this->session->userdata('isAdmin');
                }
                $update = $this->Award_model->award_create($Data);
            }
            if ($update) {
                $this->session->set_flashdata('message', display('successfully_updated'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("award/Award_controller/view_award");
        } else {
            $data['title'] = display('update');
            $data['data'] = $this->Award_model->award_updateForm($id);
            $data['dropdown'] = $this->Award_model->dropdown();
            $data['bb'] = $this->Award_model->get_id($id);
            $data['awards'] = $this->db->get('awards')->result();
            $data['module'] = "award";
            $data['page'] = "update_award_form";
            echo Modules::run('template/layout', $data);
        }
    }
    public function view_details($id)
    {
        // $data['title']     = display('award');
        $data['module'] = "award";
        $data['page'] = "award_print";
        $data['mang'] = $this->Award_model->award_view($id);
        echo Modules::run('template/layout', $data);
    }
    public function download_award($id,$view=null)
    {
        $this->permission->method('view_award', 'read')->redirect();
        $data['row'] = $award = $this->Award_model->award_view($id)[0];
        if (!($this->permission->method('view_award', 'update')->access()
            || $this->permission->module('download_all_awards')->access())) {
            $subords = array_column($this->Award_model->get_subordinates(false), 'employee_id');
            if (!(in_array($this->session->userdata('employee_id'), [$award->employee_id, $award->created_by])
                && in_array($award->employee_id, $subords))
                || $award->approved > 1) {
                $this->session->set_flashdata('exception', 'You don\'t have permission to view this page');
                redirect($_SERVER['HTTP_REFERER']);
            }
        }
        $this->load->library('pdfgenerator');
        // Pdfgenerator
        $check_div = $this->db->select('employee_history.first_name, employee_history.last_name, employee_history.hrm_id, employee_history.employee_id,employee_history.division_id,employee_history.picture,d.department_name,p.position_name')
            ->join('department d', 'd.dept_id=employee_history.dept_id')
            ->join('position p', 'p.pos_id=employee_history.pos_id')
            ->where('employee_id', $data['row']->employee_id)
            ->get('employee_history')->first_row();
            
        $data['devs'] = $check_div;
        if(!$view){
         header('Content-Type: application/pdf');

      header('Content-Type: application/pdf');

    // Set the filename for the downloaded PDF
    header('Content-Disposition: inline; filename="' . sprintf('%s - %s %s (%s)', $award->name, $check_div->first_name, $check_div->last_name, $check_div->hrm_id) . '.pdf"');

    // Set cache control headers to prevent caching
    header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
    header('Cache-Control: post-check=0, pre-check=0', false);
    header('Pragma: no-cache');


        // $this->load->view('award_print_pro', $data);
        // echo $this->pdfgenerator->generate($this->load->view('award_print_pro', $data, true),'award.pdf',false,'A4');
        echo $this->pdfgenerator->generate($this->load->view('award_print_pro_new', $data, true), 'award.pdf', false, 'A4', 'landscape');
    } else {

        $this->load->view('award_print_pro_new', $data);
        }
    }
    public function getDivisionEmployee($id)
    {
        $this->db->select('divisions.name');
        $this->db->join('employee_history', 'employee_history.division_id = divisions.id');
        $this->db->where('employee_history.employee_id', $id);
        $result = $this->db->get('divisions')->first_row();
        echo json_encode($result);
    }
}
