<style>
    div.error {
        color: red;
    }
</style>
<div class="container-fluid">
    <?php if ($this->permission->method('attendance_devices', 'create')->access()): ?>
    <div class="row">
        <a class="btn btn-primary" data-toggle="modal" data-target="#modeladd" role="button"><i class="fa fa-plus"
                aria-hidden="true"></i> <?=display(['add', 'device'])?></a>
        <a class="btn btn-primary pull-right" title="<?= display(['create', 'all', 'active', 'and', 'missing', 'employees', 'on', 'biometric', 'machine'], true) ?>" href="<?= base_url() ?>attendance/home/create_all_users_for_devices" role="button"><?=display(['create', 'missing', 'users', 'on', 'devices'])?></a>
    </div>
    <br>
    <?php endif?>
    <div class="row">
        <table class="table">
            <thead>
                <tr>
                    <th>#</th>
                    <th><?=display('division')?></th>
                    <th><?=display('type')?></th>
                    <th><?=display('IP')?></th>
                    <th><?=display('status')?></th>
                    <th><?=display(['test', 'connection'])?></th>
                    <th><?=display('action')?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($devices as $device): ?>
                <tr>
                    <td scope="row"><?=$device->id?></td>
                    <td scope="row"><?=$device->division_name?></td>
                    <td><?=ucfirst($device->type)?></td>
                    <td><?=$device->device_ip?><?=$device->port ? ':' . $device->port : null?></td>
                    <td><?=$device->active ? display('active') : display('disabled')?></td>
                    <td><button type="button" class="btn btn-success btn-connection" data-id="<?= $device->id ?>"><?= display(['check', 'connection']) ?></button></td>
                    <td>
                        <?php if($this->permission->method('attendance_devices', 'update')->access()): ?>
                        <a class="btn btn-primary btn-edit" href="#" role="button" data-id="<?= $device->id ?>"><i class="fa fa-pencil" aria-hidden="true"></i></a>
                        <?php endif?>
                        <?php if($this->permission->method('attendance_devices', 'delete')->access()): ?>
                        <a class="btn btn-danger btn-delete" href="#" role="button" data-id="<?= $device->id ?>"><i class="fa fa-trash" aria-hidden="true"></i></a>
                        <?php endif?>
                    </td>
                </tr>
                <?php endforeach?>
            </tbody>
        </table>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="modeladd" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form action="#" method="post">
                <input type="hidden" name="id">
                <div class="modal-header">
                    <h5 class="modal-title"><?=display(['add', 'device'])?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for=""><?= display(['select', 'device', 'division']) ?></label>
                        <select class="form-control" name="division_id" style="width: 100%;">
                            <option value=""><?= display(['select', 'option']) ?></option>
                            <?php foreach ($divisions as $division) :?>
                            <option value="<?= $division->id ?>"><?= $division->name ?></option>
                            <?php endforeach?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for=""><?= display(['select', 'device', 'type']) ?></label>
                        <select class="form-control" name="type" style="width: 100%;">
                            <option value=""><?= display(['select', 'option']) ?></option>
                            <?php foreach ($device_types as $device_type) :?>
                            <option value="<?= strtolower($device_type) ?>"><?= $device_type ?></option>
                            <?php endforeach?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for=""><?= display(['enter', 'device', 'ip', 'address']) ?></label>
                        <input type="text" class="form-control" name="device_ip">
                    </div>
                    <div class="form-group">
                        <label for=""><?= display(['enter', 'device', 'port']) ?></label>
                        <input type="text" class="form-control" name="port">
                    </div>
                    <div class="form-group">
                        <label for=""><?= display(['enter', 'device', 'password']) ?></label>
                        <input type="text" class="form-control" name="password" value="">
                    </div>
                    <div class="form-group">
                        <label for=""><?= display(['select', 'device', 'status']) ?></label>
                        <select class="form-control" name="status" style="width: 100%;">
                            <option value=""><?= display(['select', 'option']) ?></option>
                            <option value="active"><?= display('active') ?></option>
                            <option value="inactive"><?= display('inactive') ?></option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>
<script>
$(document).ready(function() {
    $('table').DataTable();
    $('table').on('click', '.btn-connection', function() {
        let $btn = $(this)
        myajax({
            type: "POST",
            url: "<?= base_url() ?>attendance/home/check_device_connection",
            data: {id: $btn.data('id')},
            success: function (res) {
                if(res.success) {
                    Swal.fire(
                        '<?= display('success') ?>!',
                        res.success,
                        'success'
                    )
                } else if (res.error) {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error,
                        'error'
                    )
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        'Unknown server error, try again',
                        'error'
                    )
                }
            }
        });
    })
    $('table').on('click', '.btn-edit', function(e) {
        e.preventDefault()
        let $btn = $(this)
        let $modal = $('#modeladd');
        let $form = $('#modeladd form');
        myajax({
            type: "GET",
            url: "<?= base_url() ?>attendance/home/devices/" + $btn.data('id'),
            success: function (res) {
                if(res.success) {
                    $modal.find('[name=id]').val(res.success.id)
                    $modal.find('[name=division_id]').val(res.success.division_id).trigger('change');
                    $modal.find('[name=type]').val(res.success.type).trigger('change');
                    $modal.find('[name=device_ip]').val(res.success.device_ip);
                    $modal.find('[name=port]').val(res.success.port);
                    if(res.success.active == 1) {
                        $modal.find('[name=status]').val('active').trigger('change');
                    } else {
                        $modal.find('[name=status]').val('inactive').trigger('change');
                    }
                    $modal.modal('show')
                } else if (res.error) {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error,
                        'error'
                    )
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        'Unknown server error, try again',
                        'error'
                    )
                }
            }
        });
    })
    $('#modeladd form').on('submit', function(e) {
        e.preventDefault();
        let $form = $(this);
        myajax({
            type: "POST",
            data: $form.serialize(),
            beforeSend: function() {
                $form.find('div.error').remove();
            },
            success: function (res) {
                if(res.success) {
                    Swal.fire(
                        '<?= display('success') ?>!',
                        res.success,
                        'success'
                    )
                } else if (res.error) {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error,
                        'error'
                    )
                } else if (res.errors) {
                    res.errors.forEach(err => {
                        let elem = $form.find(`[name=${err[0]}]`).closest('div.form-group');
                        elem.append(`<div class="error">${err[1]}</div>`)
                    });
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        'Unknown server error, try again',
                        'error'
                    )
                }
                if(res.reload) {
                    location.reload()
                }
            }
        });
    })
    
    $('table.table').on('click', '.btn-delete', function(e) {
        e.preventDefault()
        $this = $(this);
        Swal.fire({
            title: `Are you sure?`,
            html: `Pressing 'Yes' will remove this device`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                myajax({
                    type: "GET",
                    url: "<?= base_url() ?>attendance/home/delete_device/" + $this.data('id'),
                    success: function (res) {
                        if(res.success) {
                            Swal.fire(
                                '<?= display('deleted') ?>!',
                                res.success,
                                'success'
                            )
                        } else if (res.error) {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                res.error,
                                'error'
                            )
                        } else {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                'Unknown server error, try again',
                                'error'
                            )
                        }
                        if(res.reload) {
                            location.reload()
                        }       
                    }
                });
            }
        })
    })
});
</script>