<?php $this->load->model('dashboard/stats_model') ?>
<div class="row">
    <div class="col-sm-12 col-md-12">
        <div class="panel panel-bd">
            <div class="panel-heading">
                <div class="panel-title">
                    <h4><?php echo (!empty($title) ? $title : null) ?></h4>
                </div>
            </div>
            <div class="panel-body">
                <?=form_open_multipart()?>
                <div class="form-group">
                  <label for="file">Upload File</label>
                  <input type="file" class="form-control-file" name="file" id="file" placeholder="Upload File" aria-describedby="fileHelpId">
                  <br>
                  <small id="fileHelpId" class="form-text"><a href="#" class="btn-download">Download Sample File</a></small>
                </div>
                <div class="form-group text-right">
                    <button type="submit" class="btn btn-success w-md m-b-5">Upload</button>
                </div>
                <?php echo form_close() ?>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-sm-4 col-md-4">
        <div class="panel panel-bd lobidrag">
            <div class="panel-heading">
                <div class="panel-title">
                    <h4>Allowed Values</h4>
                </div>
            </div>
            <div class="panel-body table-responsive">                    
                <table class="table">
                    <thead>
                        <tr>
                            <th>Attendance</th>
                            <th>Description</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($allowed_flags as $flag) :?>
                            <tr>
                                <td><?= $flag ?></td>
                                <td><?= $this->stats_model->flag_description($flag) ?></td>
                            </tr>
                        <?php endforeach?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-sm-8 col-md-8">
        <div class="panel panel-bd lobidrag">
            <div class="panel-heading">
                <div class="panel-title">
                    <h4>Example</h4>
                </div>
            </div>
            <div class="panel-body table-responsive">                    
                <table class="table">
                    <thead>
                        <tr>
                            <th>Employee ID</th>
                            <?php foreach ($columns as $column):?>
                                <th><?= $column ?></th>
                            <?php endforeach ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($employees as $employee) :?>
                        <tr>
                            <td><?= $employee ?></td>
                            <?php foreach ($columns as $column):?>
                                <td><?= $allowed_flags[array_rand($allowed_flags)] ?></td>
                            <?php endforeach ?>
                        </tr>
                        <?php endforeach?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="modelSample" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
    <div class="modal-dialog modal-sm" role="document">
        <form action="<?= base_url() ?>/attendance/bulk/sample" method="post">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Select Sample Sheet Period</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                      <label for="selMonth">Month</label>
                      <select class="form-control dont-select-me" name="month" id="selMonth" style="width: 100%;">
                            <?php foreach ($months as $key => $month) :?>
                                <option value="<?= $key ?>" <?= $key == date('m') ? 'selected' : null ?>><?= $month ?></option>
                            <?php endforeach?>
                      </select>
                    </div>
                    <div class="form-group">
                      <label for="selYear">Year</label>
                      <select class="form-control dont-select-me" name="year" id="selYear" style="width: 100%;">
                            <?php foreach ($years as $year) :?>
                                <option value="<?= $year ?>" <?= $year == date('Y') ? 'selected' : null ?>><?= $year ?></option>
                            <?php endforeach?>
                      </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Download</button>
                </div>
            </div>
        </form>
    </div>
</div>
<script>
    $(document).ready(function () {
        $('#modelSample select').select2({
            dropdownParent: $('#modelSample')
        })
    });
    $('.btn-download').on('click', function(e) {
        e.preventDefault();
        $('#modelSample').modal('show')
    })
    $('#modelSample form').on('submit', function(e) {
        $('#modelSample').modal('hide')
    })
</script>