<style>
    .punch-time {
        color: #fff;
        background-color: #de4e57;
        padding: 1px 2px;
    }
</style>
<div class="row">
    <?php if($this->permission->method('atn_time_adjustment_list', 'update')->access()): ?>
    <div class="col-sm-12">
        <form>
            <div class="form-group">
            <label for="selStatus"><?= display(['filter', 'by', 'status']) ?></label>
            <select class="form-control" name="status" id="selStatus" onchange="this.form.submit()">
                <option value=""></option>
                <option value="pending-supervisor" <?= $this->session->userdata('_filter_timeadjustment_status') == 'pending-supervisor' ? 'selected' : null ?>>Awaiting Supervisor Response</option>
                <option value="approved-supervisor" <?= $this->session->userdata('_filter_timeadjustment_status') == 'approved-supervisor' ? 'selected' : null ?>>Approved By Supervisor</option>
                <option value="denied-supervisor" <?= $this->session->userdata('_filter_timeadjustment_status') == 'denied-supervisor' ? 'selected' : null ?>>Denied By Supervisor</option>
                <option value="pending-hr" <?= $this->session->userdata('_filter_timeadjustment_status') == 'pending-hr' ? 'selected' : null ?>>Awaiting HR Response</option>
                <option value="approved-hr" <?= $this->session->userdata('_filter_timeadjustment_status') == 'approved-hr' ? 'selected' : null ?>>Approved By HR</option>
                <option value="denied-hr" <?= $this->session->userdata('_filter_timeadjustment_status') == 'denied-hr' ? 'selected' : null ?>>Denied By HR</option>
            </select>
            </div>
        </form>
    </div>
    <?php endif?>
    <div class="col-sm-12">
        <div class="panel panel-default thumbnail">
            <div class="panel-body" id="result_data">
                <table class="table table-striped table-bordered table-hover" width="100%">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>In Time</th>
                            <th>Out Time</th>
                            <th>Reason</th>
                            <th>Status</th>
                            <th>Submitted</th>
                            <th class="hideexport">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<script>
$(document).ready(function() {
    window.datatable = $('table.table').DataTable({
        responsive: false,
        processing: true,
        language: {
            processing: '<i class="fa fa-spinner fa-spin fa-3x fa-fw"></i><span class="sr-only">Loading...</span> '
        },
        serverSide: true,
        ajax: {
            method: 'post',
            beforeSend: () => {},
        },
        columns: [{
            'data': 'id',
        }, {
            'data': 'employee_name',
        }, {
            'data': 'checkin',
            "width": "15%"
        }, {
            'data': 'checkout',
            "width": "15%"
        }, {
            'data': 'reason'
        }, {
            'data': 'hr_status',
        }, {
            'data': 'added_at',
        }, {
            'data': 'action',
            'sortable': false
        }],
        columnDefs: [{
            // "targets": [2, 3, 6],
            "type": "date",
            "render": function(data, type) {
                if (type === 'sort') {
                    return moment(data, 'DD-MM-YYYY')
                }
                return data;
            }
        }],
        order: [
            [6, "desc"]
        ]
    }, window.default_datatable_opts)
});
$('table.table').on('click', '.time_action_btn button', function() {
    var div = $(this).closest('div')
    myajax({
        type: "POST",
        url: "<?= base_url('attendance/timeadjustment/process') ?>",
        data: {
            id: div.data('id'),
            process: $(this).data('action')
        },
        success: function(res) {
            if (res.success) {
                window.datatable.ajax.reload();
            } else {
                Swal.fire(
                    '<?= display('error') ?>!',
                    res.error,
                    'error'
                )
            }
        }
    });
})
</script>