<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Csv_model extends CI_Model
{
    public function get_addressbook()
    {
        // $this->db->order_by('att_id', 'desc');
        //     $query = $this->db->get('emp_attendance');
        $query = $this->db->select("count(DISTINCT(e.att_id)) as att_id,e.*,p.employee_id,p.first_name,p.last_name")->join('employee_history p', 'e.employee_id = p.employee_id', 'left')->group_by('e.att_id')->order_by('e.att_id', 'desc')->get('emp_attendance e');
        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }
    }
    public function insert_csv($data)
    {
        $this->db->insert('emp_attendance', $data);
    }
    public function delete_attn($id = null)
    {
        if ($this->db->delete('attendance_history', [
            'atten_his_id' => $id
        ])) {
            return true;
        } else {
            return false;
        }
    }
    public function attendance_delete($id = null)
    {
        $this->db->where('atten_his_id', $id)
            ->delete('attendance_history');
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }
    public function atten_create($data = array())
    {
        // return $this->db->insert('emp_attendance', $data);
        // $day = date('Y-m-d');
        // $query = $this->db->select('la.leave_appl_id,la.employee_id, la.hr_status, la.supervisor_status, lad.day, lad.type')
        //     ->from('leave_applied_days lad')
        //     ->join('leave_apply la', 'lad.leave_appl_id = la.leave_appl_id AND (la.hr_status = "approved" OR la.supervisor_status = "approved")')
        //     ->where([
        //         'lad.active' => 1,
        //         'lad.type' => 'full_day',
        //         'lad.day' => $day,
        //         'la.employee_id' => $data['uid'],
        //         'la.leave_aprv_strt_date <=' => $day,
        //         'la.leave_aprv_end_date >=' => $day,
        //     ])
        //     ->get()
        //     ->row();
        //     if (!empty($query)) {
        //         $postData = [
        //             'leave_appl_id' => $query->leave_appl_id,
        //             'leave_aprv_strt_date' => null,
        //             'leave_aprv_end_date' => null,
        //             'num_aprv_day' => 0,
        //             'approve_date' => null,
        //             'approved_by' => 0,
        //             'hr_status' => 'denied',
        //             'hr_approver' => 0,
        //             'supervisor_status' => 'denied'
        //         ];
        //         $this->load->model('Leave/Leave_model');
        //         $this->Leave_model->reject_application($postData);
        //     }
        return $this->db->insert('attendance_history', $data);
    }
    public function update_attn($data = array())
    {
        return $this->db->where('att_id', $data["att_id"])
            ->update("emp_attendance", $data);
    }
    public function attn_updateForm($id)
    {
        $this->db->where('att_id', $id);
        $query = $this->db->get('emp_attendance');
        return $query->row();
    }
    public function get_atn_dropdown($id)
    {
        $query = $this->db->get_where('emp_attendance', array('att_id' => $id));
        return $query->row_array();
    }
    public function Employeename()
    {
        $this->db->select('*');
        if(!$this->permission->module('show_inactive_employees')->access()) {
            $this->db->where('status', 'active');
        }
        $query = $this->db->order_by('first_name', 'asc')->get('employee_history');
        $data = $query->result();
        $list = array('' => 'Select One...');
        if (!empty($data)) {
            foreach ($data as $value) {
                $list[$value->employee_id] = $value->first_name . ' ' . $value->last_name . "(" . $value->hrm_id . ")";
            }
        }
        return $list;
    }
    /********* Repor Start  #################% ********/
    public function userReport($format_start_date, $format_end_date)
    {
        $this->db->select('e.*,p.employee_id,p.first_name,p.last_name');
        $this->db->from('emp_attendance e');
        $this->db->join('employee_history p', 'e.employee_id = p.employee_id', 'left');
        $this->db->where('e.date >=', $format_start_date);
        $this->db->where('e.date <=', $format_end_date);
        $this->db->group_by('e.att_id');
        $query = $this->db->get();
        $result = $query->result();
        return $result;
    }
    public function search($id, $start_date, $end_date)
    {
        if (!empty($id)) {
            $this->db->from('emp_attendance');
            $this->db->like('employee_id', $id);
            $this->db->where('date >=', $start_date);
            $this->db->where('date <=', $end_date);
            $query = $this->db->get();
            return $query->result();
        } else {echo 'Sorry Enter Employee Id';}
    }
    public function search_intime($date, $start_time, $end_time)
    {
        if (!empty($date)) {
            $this->db->select('count(DISTINCT(e.att_id)) as att_id,e.*,p.employee_id,p.first_name,p.last_name');
            $this->db->from('emp_attendance e');
            $this->db->join('employee_history p', 'e.employee_id = p.employee_id', 'left');
            $this->db->like('e.date', $date);
            $this->db->where('e.sign_in >=', $start_time);
            $this->db->where('e.sign_in <=', $end_time);
            $query = $this->db->get();
            return $query->result();
        } else {echo 'Sorry Enter Date';}
    }
    public function atnrp($id)
    {
        $this->db->select('*');
        $this->db->from('employee_history');
        $this->db->where('employee_id', $id);
        $ab = $this->db->get();
        return $ab->result();
    }
// Attendance Log info
    public function att_log($limit = null, $start = null)
    {
        $this->db->select('*');
        $this->db->from('attendance_history');
        $this->db->order_by('atten_his_id', 'desc');
        $this->db->limit($limit, $start);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        }
        return false;
    }
    // attendance count
    public function count_atn()
    {
        $this->db->select('*');
        $this->db->from('attendance_history');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->num_rows();
        }
        return false;
    }
// Attendance log report
    public function att_report($limit = null, $start = null)
    {
        $this->db->select('*,DATE(time) as mydate');
        $this->db->from('attendance_history');
        if ($this->session->userdata('isAdmin') != 1) {
            $employee_id = $this->session->userdata('employee_id');
            $this->db->where('uid', $employee_id);
        }
        $this->db->group_by('mydate');
        $this->db->order_by('time', 'desc');
        $this->db->limit($limit, $start);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        }
        return false;
    }
// count attendance log
    public function count_att_report()
    {
        $this->db->select('*,DATE(time) as mydate');
        $this->db->from('attendance_history');
        $this->db->group_by('mydate');
        $this->db->order_by('time', 'desc');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->num_rows();
        }
        return false;
    }
// Attendance log report user wise
    public function att_report_userwise($limit = null, $start = null, $id)
    {
// $att = "SELECT *, DATE(time) as mydate FROM `attendance_history` WHERE `uid`=$id GROUP BY mydate ORDER BY time desc";
        // $query = $this->db->limit($limit,$start)->query($att)->result();
        $this->db->select('*,DATE(time) as mydate');
        $this->db->from('attendance_history');
        $this->db->where('uid', $id);
        $this->db->group_by('group_no');
        $this->db->order_by('time', 'desc');
        $this->db->limit($limit, $start);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        }
        return false;
    }
// count attendance log
    public function count_atn_log($id)
    {
        $this->db->select('*,DATE(time) as mydate');
        $this->db->from('attendance_history');
        $this->db->where('uid', $id);
        $this->db->group_by('group_no');
        $this->db->order_by('time', 'desc');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->num_rows();
        }
        return false;
    }
// attendance log datebetween search
    public function att_log_datebetween($id, $from_date, $to_date)
    {
        $att = "SELECT *, DATE(time) as mydate FROM `attendance_history` WHERE `uid`=$id AND DATE(time) BETWEEN '" . $from_date . "' AND  '" . $to_date . "' GROUP BY mydate ORDER BY time desc";
        $query = $this->db->query($att)->result();
        $att_in = [];
        $i = 1;
// print_r($query);exit();
        //return $query;
        foreach ($query as $attendance) {
            $att_in[$i] = $this->db->select('a.time,MIN(a.time) as intime,MAX(a.time) as outtime,a.uid')
                ->from('attendance_history a')
                ->like('a.time', date("Y-m-d", strtotime($attendance->mydate)), 'after')
                ->where('a.uid', $attendance->uid)
                ->order_by('a.time', 'DESC')
                ->get()
                ->result();
            $i++;
        }
        // echo '<pre>';
        // print_r($att_in);exit();
        return $att_in;
    }
// User inforamtion
    public function deviceuser($id)
    {
        $this->db->select('*');
        $this->db->from('employee_history');
        $this->db->where('employee_id', $id);
        $ab = $this->db->get();
        return $ab->row();
    }

    public function all_supervisors(){
         $all = $this->db->select('employee_id,first_name,middle_name,last_name,hrm_id')->where('is_super_visor',1)->get('employee_history')->result();
        foreach ($all as $value) {
                $list[$value->employee_id] = sprintf('%s %s (%s)', $value->first_name, $value->last_name, $value->hrm_id);
        }
        return $list;
    }
    public function get_subordinates()
    {
        $this->load->model('employee/employees_model');
        return $this->employees_model->get_subordinates();
    }
    public function userlist($dept_ids = [], $employee_ids = null)
    {
        $data = [];
        if ($this->session->userdata('isAdmin') == 1 || $this->permission->full('attendance')->access() || $this->permission->method('atn_log_datewise', 'update')->access()) {
            $this->db->select('employee_id, first_name, last_name, hrm_id, termination_date');
            if(!$this->permission->module('show_inactive_employees')->access()) {
                $this->db->where('status', 'active');
            }
            else {
                $this->db->where_in('status', ['active','resigned']);
            }
            $query = $this->db->order_by('first_name', 'asc')->get('employee_history');
            $data = $query->result_array();
        }elseif($this->session->userdata('supervisor') == 1){
            $data = $this->get_subordinates();
        }else{
            $this->db->select('employee_id, first_name, last_name, hrm_id');
            $this->db->where('employee_id', $this->session->userdata('employee_id'));
            $query = $this->db->get('employee_history');
            $data = $query->result_array();
        }

        if (count($dept_ids) > 0) {
            // $ids = explode(',' , $dept_ids);
            $employee_ids = explode(',' , $employee_ids);
            $this->db->select('employee_id, first_name, last_name, hrm_id');
            $this->db->where_in('dept_id', $dept_ids);
            $this->db->where('status', 'active');
            $query = $this->db->get('employee_history');
            $data = $query->result_array();

            $html = "";
            if (empty($data)) {
                $html .="NoT Found !";
            }else{
                  foreach ($data as $value) {

                    $employee_info = sprintf('%s %s (%s)', $value['first_name'], $value['last_name'], $value['hrm_id']);

                    $is_check = "checked='checked'";
                    $checked = in_array($value['employee_id'],$employee_ids) ? $is_check : null;


                    $html .= "<div><label>";
                    $html .= "<input type='checkbox' class=\"employees\" id=\"employees\" name=\"employees[]\" value=".$value['employee_id']." $checked>";
                    $html .= ' '. $employee_info."</label></div>";

                  } 
                $data2['employee_list']    = $html;
                return $data2;
            }
        }
        $list = array('0' => 'Select Employee Name');
        if (!empty($data)) {
            foreach ($data as $value) {
                if (!isset($value['termination_date']) || empty($value['termination_date'])) {
                    $list[$value['employee_id']] = sprintf('%s %s (%s)', $value['first_name'], $value['last_name'], $value['hrm_id']);
                }
                else {
                        $termination_date=date_create($value['termination_date']);
                        $current_date=date_create(date('Y-m-d'));
                        $diff=date_diff($termination_date,$current_date);
                        if ($diff->days == 40) {
                            $list[$value['employee_id']] = sprintf('%s %s (%s)', $value['first_name'], $value['last_name'], $value['hrm_id']);
                        }
                }
                // $list[$value['employee_id']] = sprintf('%s %s (%s)', $value['first_name'], $value['last_name'], $value['hrm_id']);
            }
        }
        return $list;
    }
    public function departments_list()
    {
        $deptts = getByWhereAsArray('department', '*', [], ['department_name', 'ASC']);

        $return = [];
        foreach ($deptts as $deptt) {
            $return[$deptt['dept_id']] = $deptt['department_name'];
        }
        return $return;
    }
    // User inforamtion
    public function company_info()
    {
        $this->db->select('*');
        $this->db->from('setting');
        $ab = $this->db->get();
        return $ab->row();
    }
//Device Ip info
    public function create_device_ip($data = [])
    {
        return $this->db->insert('deviceinfo', $data);
    }
    public function devicinfoById($id = null)
    {
        return $this->db->select("*")
            ->from('deviceinfo')
            ->where('id', $id)
            ->get()
            ->row();
    }
    public function update_device_ip($postData = [])
    {
        return $this->db->where('id', $postData['id'])
            ->update('deviceinfo', $postData);
    }
    public function attendance_editdata($id)
    {
        $this->db->where('atten_his_id', $id);
        $query = $this->db->get('attendance_history');
        return $query->row();
    }
    public function atten_update($postData = [])
    {
        return $this->db->where('atten_his_id', $postData['atten_his_id'])
            ->update('attendance_history', $postData);
    }
// Attendance log report
    public function att_report_ajax($limit = null, $start = null, $users = null, $start_date = null, $end_date = null)
    {
        $this->db->select('*, SUM(duration) as duration, DATE(time) as mydate');
        $this->db->from('attendance_history');
        // if($this->session->userdata('isAdmin') != 1){
        //     $employee_id = $this->session->userdata('employee_id');
        //     $this->db->where('uid',$employee_id);
        // }
        if (isset($users)) {
            if ($users[0] != '0') {
                $this->db->where_in('uid', $users);
            }
        }
        if (isset($start_date) && isset($end_date)) {
            $this->db->where('date(time) BETWEEN "' . $start_date . '" and "' . $end_date . '"');
        }
        $this->db->group_by('mydate');
        $this->db->order_by('time', 'desc');
        $this->db->limit($limit, $start);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        }
        return false;
    }
}
