<?php
class Timeadjustment extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->helper('url');
        $this->load->model(['timeadjustment_model', 'Csv_model']);
    }
    public function add_request()
    {
        return;
        if ($this->input->post()) {
            $this->create();
        }
        $data['dropdownatn'] = $this->Csv_model->Employeename();
        $data['title'] = 'Time Adjustment: Add Request';
        $data['module'] = "attendance";
        $data['page'] = "adjustment/add_request";
        echo Modules::run('template/layout', $data);
    }
    public function all_requests()
    {
        if ($this->input->post()) {
            $this->getDatatable();
        }
        if ($this->permission->method('atn_time_adjustment_list', 'update')->access()) {
            if ($_GET['status']) {
                $this->session->set_userdata('_filter_timeadjustment_status', $_GET['status']);
            }
            if (isset($_GET['status']) && empty($_GET['status'])) {
                $this->session->unset_userdata('_filter_timeadjustment_status', $_GET['status']);
            }
        }
        $data['title'] = 'All Time Adjustment Requests';
        $data['module'] = "attendance";
        $data['page'] = "adjustment/requests_list";
        echo Modules::run('template/layout', $data);
    }
    public function process()
    {
        $res = false;
        if ($this->input->post('process') == 'approve') {
            $res = $this->timeadjustment_model->process($this->input->post('id'), true);
        } else {
            $res = $this->timeadjustment_model->process($this->input->post('id'), false);
        }
        if ($res) {
            sendJson(['success' => true]);
        } else {
            sendJson(['error' => 'Unable to update attendance record, try again']);
        }
    }
    private function create()
    {
        $this->form_validation->CI = &$this;
        $rules_config = array(
            array(
                'field' => 'checkin',
                'label' => 'Check In Time',
                'rules' => 'trim|required|callback_valid_datetime',
            ),
            array(
                'field' => 'checkout',
                'label' => 'Check Out Time',
                'rules' => 'trim|required|callback_valid_datetime',
            ),
            array(
                'field' => 'reason',
                'label' => 'Reason',
                'rules' => 'strip_tags|trim|required',
            ),
        );
        if ($this->session->userdata('isAdmin')) {
            $rules_config[] = [
                'field' => 'employee_id',
                'label' => 'Employee Name',
                'rules' => 'trim|required|is_natural',
            ];
        }
        if (strtotime($this->input->post('checkout')) - strtotime($this->input->post('checkin')) < 0) {
            $this->session->set_flashdata('exception', 'Checkin date should be smaller than Checkout date');return;
        }
        $this->form_validation->set_message('valid_datetime', '{field} must have valid date and time.');
        $this->form_validation->set_rules($rules_config);
        if ($this->form_validation->run() === true) {
            $checkout = date('Y-m-d',strtotime($this->input->post('checkout')));
            $employee_id = $this->input->post('employee_id');
            $check_last_timeout = $this->db->select('remarks_out')->where(['uid' => $employee_id, 'day' => $checkout, 'status' => 'out', 'remarks_out !=' => null ])->get('attendance_history')->row();
            if ($check_last_timeout->remarks_out != 'AUTO CHECKOUT BY HRM SYSTEM') {

                if ($this->timeadjustment_model->add($this->input->post())) {
                    $this->session->set_flashdata('message', 'Request added successfully');
                } else {
                    $this->session->set_flashdata('exception', 'Error while submitting request try again later!');
                }
            }
            else {
                $this->session->set_flashdata('message', 'Auto checkout time will not adjustable on time adjust request');
            }
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function valid_datetime($str)
    {
        $res = preg_match('/\b\d{2}-\d{2}-\d{4}\s\d{2}:\d{2}\b/', $str);
        return is_numeric($res) && $res > 0 ? true : false;
    }
    private function getDatatable()
    {
        $search_arr = [];
        $where_arr = [];
        $search_columns = [
            'tb1.id',
            'tb1.checkin',
            'tb1.checkout',
            'tb1.reason',
            'tb1.added_at',
            'CONCAT_WS(\' \', tb2.first_name, tb2.last_name)',
            'tb2.hrm_id',
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            $originalSearchVal = $searchVal;
            foreach ($search_columns as $value) {
                if (convert_excel_date($searchVal)) {
                    $search_arr[] = [$value, convert_excel_date($searchVal)];
                } else {
                    $keyword2 = preg_replace('@\s+@', '%', $searchVal);
                    $keyword2 .= '%';
                    $search_arr[] = [$value, $keyword2];
                }
            }
            if (preg_match('#\bsupervisor\b#i', $originalSearchVal) === 1) {
                if (preg_match('#\bawaiting\b#i', $originalSearchVal) === 1) {
                    $where_arr[] = ['tb1.supervisor_status', 'pending'];
                }
                if (preg_match('#\bapproved\b#i', $originalSearchVal) === 1) {
                    $where_arr[] = ['tb1.supervisor_status', 'approved'];
                }
                if (preg_match('#\bdenied\b#i', $originalSearchVal) === 1) {
                    $where_arr[] = ['tb1.supervisor_status', 'denied'];
                }
                $where_arr[] = ['tb1.hr_status', 'pending'];
                $search_arr = [];
            } elseif (preg_match('#\bhr\b#i', $originalSearchVal) === 1) {
                if (preg_match('#\bawaiting\b#i', $originalSearchVal) === 1) {
                    $where_arr[] = ['tb1.hr_status', 'pending'];
                }
                if (preg_match('#\bapproved\b#i', $originalSearchVal) === 1) {
                    $where_arr[] = ['tb1.hr_status', 'approved'];
                }
                if (preg_match('#\bdenied\b#i', $originalSearchVal) === 1) {
                    $where_arr[] = ['tb1.hr_status', 'denied'];
                }
                $search_arr = [];
                $search_arr[] = ['tb1.supervisor_status', 'approved'];
                $search_arr[] = ['tb1.supervisor_status', 'denied'];
            } elseif (preg_match('#\bapproved\b#i', $originalSearchVal) === 1) {
                $where_arr[] = ['tb1.supervisor_status', 'approved'];
                $where_arr[] = ['tb1.hr_status', 'approved'];
                $search_arr = [];
            } elseif (preg_match('#\bawaiting\b#i', $originalSearchVal) === 1) {
                $where_arr[] = ['tb1.supervisor_status', 'pending'];
                $where_arr[] = ['tb1.hr_status', 'pending'];
                $search_arr = [];
            } elseif (preg_match('#\bdenied\b#i', $originalSearchVal) === 1) {
                $where_arr[] = ['tb1.supervisor_status', 'denied'];
                $where_arr[] = ['tb1.hr_status', 'denied'];
                $search_arr = [];
            }
        };
        $search_arr = array_filter($search_arr, function ($v) {
            return !empty(trim($v[1]));
        });
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $out_arr["recordsFiltered"] = $this->timeadjustment_model->countDatatable($search_arr, $where_arr);
        $rows = $this->timeadjustment_model->getDatatable($search_arr, $where_arr);

        $subordinates = array_column($this->timeadjustment_model->get_subordinates(true), 'employee_id');
        foreach ($rows as $index => $rec) {
            // $punch_time = $this->db->select(
            //     '`day`,
            //     uid,
            //     MIN(punchin_time) AS punchin_time,
            //     MAX(punchout_time) AS punchout_time,
            //     GROUP_CONCAT(group_no) AS group_no'
            // )
            // ->where('uid', $rec['employee_id'])
            // ->where("day", date('Y-m-d',strtotime($rec['checkin'])))
            // ->group_by(['day', 'uid'])
            // ->order_by('punchin_time')
            // ->get('attendance_view')
            // ->row();
            $punch_time = $this->db->select("`day`,uid,
            MIN(punchin_time) AS punchin_time,
            MAX(punchout_time) AS punchout_time,
            GROUP_CONCAT(group_no) AS group_no")
            ->where('uid', $rec['employee_id'])
            ->where("day", date('Y-m-d',strtotime($rec['checkin'])))
            ->where("attendance_history.active", 1)
            ->group_by(['day', 'uid',`group_no`])
            ->order_by('punchin_time')
            ->get("attendance_history")
            ->row();
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'checkin': {

                        if (!empty($punch_time)) {
                            if ($punch_time->punchout_time || $rec['hr_status'] == 'approved' || $rec['supervisor_status'] == 'approved') {
                                if (!empty($punch_time->group_no)) {
                                    $check = $this->db->select('punchin_time')->where(['group_no' => $punch_time->group_no, 'active' => 0, 'status' => 'in' ])->get('attendance_history')->row();
                                    // $status_class = empty($check->punchin_time) ? " " : "punch-time";

                                    $checkin_time = empty($check) ? $punch_time->punchin_time : $check->punchin_time;
                                    $tdData = formatted_date($rec['checkin'],true) .'</br> <span class="punch-time">' . formatted_date($checkin_time,true) .'</span>';
                                }
                            }
                            else{
                                $tdData = formatted_date($rec['checkin'],true) .'</br> <span class="punch-time">' . formatted_date($punch_time->punchin_time,true) .'</span>';
                            }
                        }
                        else {
                            $tdData = formatted_date($rec['checkin'],true);
                        }
                        break;
                    }
                    case 'checkout': {

                        if (!empty($punch_time) && !empty($punch_time->punchout_time)) {
                            $tdData = formatted_date($punch_time->punchout_time,true);
                        }
                        // else {
                        //     $tdData = formatted_date($rec['checkout'],true);
                        // }
                        break;
                    }
                    case 'added_at':{
                            $tdData = formatted_date($rec[$col['data']], true);
                            break;
                        }
                    case 'hr_status':{

                        if (empty($punch_time->punchout_time)) {
                            // $punchout_time = date('Y-m-d H:i:s', strtotime($rec['checkin'] . ' +9 hours'));
                            $punchout_time = date('Y-m-d H:i:s', strtotime($rec['checkin']));
                        }
                        else {
                            $punchout_time = $punch_time->punchout_time;
                        }
                        $hours = $this->date_time_diff_bt_dates($punchout_time);

                            if ($rec['supervisor'] && $rec['hr_status'] == 'pending' && $rec['supervisor_status'] == 'pending') {

                                $timeStatus = $hours <= 0 ? '<p class="punch-time">0 Hours Left</p>' : '<p class="punch-time">'.$hours . ' Hours Left </p>';  
                                $tdData = 'Awaiting Supervisor Response <br/> '.$timeStatus;
                            } elseif ($rec['hr_status'] == 'pending' && $rec['supervisor_status'] == 'approved') {
                                $tdData = 'Approved By Supervisor';
                            } elseif ($rec['hr_status'] == 'pending' && $rec['supervisor_status'] == 'denied') {
                                $tdData = 'Denied By Supervisor';
                            } elseif ($rec['hr_status'] == 'pending' && $rec['supervisor_status'] == 'approved') {
                                $tdData = 'Approved By Supervisor';
                            } elseif (!$rec['supervisor'] && $rec['hr_status'] == 'pending') {
                                $tdData = 'Awaiting HR Response';
                            } elseif ($rec['hr_status'] == 'approved') {
                                $tdData = 'Approved By HR';
                            } elseif ($rec['hr_status'] == 'denied') {
                                $tdData = 'Denied By HR';
                            }
                            break;
                        }
                    case 'action':{

                            // if (empty($punch_time->punchout_time)) {
                            //     $punchout_time = date('Y-m-d H:i:s', strtotime($rec['checkin'] . ' +9 hours'));
                            // }
                            // else {
                            //     $punchout_time = $punch_time->punchout_time;
                            // }

                            // $date1=date_create($punchout_time);
                            // $date2=date_create(date('Y-m-02 H:i:s'));
                            // $diff=date_diff($date1,$date2);
                            // $days = $diff->format("%a");
                            if (empty($punch_time->punchout_time)) {
                                // $punchout_time = date('Y-m-d H:i:s', strtotime($rec['checkin'] . ' +9 hours'));
                                $punchout_time = date('Y-m-d H:i:s', strtotime($rec['checkin']));
                            }
                            else {
                                $punchout_time = $punch_time->punchout_time;
                            }
                            $hours = $this->date_time_diff_bt_dates($punchout_time);

                            if ($rec['hr_status'] == 'approved' || $rec['supervisor_status'] == 'approved') {
                                $tdData = '<span>' . display('approved') . '</span> ';
                                if ($this->session->userdata('isAdmin')==1 && $rec['supervisor_status'] == 'approved') {
                                    $tdData .= '<div class="time_action_btn" data-id="' . $rec['id'] . '"> <button type="button" class="btn btn-danger btn-sm" data-action="reject">Reject</button></div>';
                                }
                                break;
                            }
                            if ($rec['employee_id'] == $this->session->userdata('employee_id')) {
                                break;
                            }
                            $tdData = '<div class="time_action_btn" data-id="' . $rec['id'] . '">';

                            // in_array($rec['employee_id'], $subordinates) For Supervisor
                            
                            if ($this->session->userdata('isAdmin') && $rec['hr_status'] == 'pending' && $hours <= 0) {
                                $tdData .= '<button type="button" class="btn btn-success btn-sm" data-action="approve">Approve</button>';
                                $tdData .= '<button type="button" class="btn btn-danger btn-sm" data-action="reject">Reject</button>';
                            } elseif (($this->session->userdata('employee_id') == $rec['supervisor']) && $rec['supervisor_status'] == 'pending' && $rec['hr_status'] == 'pending' && $rec['employee_id'] != $this->session->userdata('employee_id') && $hours > 0) {
                                $tdData .= '<button type="button" class="btn btn-success btn-sm" data-action="approve">Approve</button>';
                                $tdData .= '<button type="button" class="btn btn-danger btn-sm" data-action="reject">Reject</button>';
                            } elseif ($this->permission->method('atn_time_adjustment_list', 'update')->access() && $rec['hr_status'] == 'pending' && $rec['employee_id'] != $this->session->userdata('employee_id') && $hours <= 0) {
                                $tdData .= '<button type="button" class="btn btn-success btn-sm" data-action="approve">Approve</button>';
                                $tdData .= '<button type="button" class="btn btn-danger btn-sm" data-action="reject">Reject</button>';
                            }

                            $tdData .= '</div>';
                            break;
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
    public function add_request_using_ajax()
    {
        $this->form_validation->CI = &$this;
        $rules_config = array(
            array(
                'field' => 'checkin',
                'label' => 'Check In Time',
                'rules' => 'trim|required|callback_valid_datetime',
            ),
            // array(
            //     'field' => 'checkout',
            //     'label' => 'Check Out Time',
            //     'rules' => 'trim|required|callback_valid_datetime',
            // ),
            array(
                'field' => 'reason',
                'label' => 'Reason',
                'rules' => 'strip_tags|trim|required',
            ),
        );
        if ($this->session->userdata('isAdmin')) {
            $rules_config[] = [
                'field' => 'employee_id',
                'label' => 'Employee Name',
                'rules' => 'trim|required|is_natural',
            ];
        }
        // if (strtotime($this->input->post('checkout')) - strtotime($this->input->post('checkin')) < 0) {
        //     sendJson(['exception' => 'Checkin date should be smaller than Checkout date']);
        // }
        if (empty($this->input->post('checkin'))) {
            sendJson(['exception' => '{field} must have valid date and time.']);
        }
        // $checkout = date('Y-m-d',strtotime($this->input->post('checkout')));
        $employee_id = $this->input->post('employee_id');
        // $check_last_timeout = $this->db->select('remarks_out')->where(['uid' => $employee_id, 'day' => $checkout, 'status' => 'out', 'remarks_out !=' => null ])->get('attendance_history')->row();
        // if ($check_last_timeout->remarks_out != 'AUTO CHECKOUT BY HRM SYSTEM') {
            $checkin = date('Y-m-d H:i:s',strtotime($this->input->post('checkin')));

            $check_request = $this->db->select('*')->where(['employee_id' => $employee_id, 'checkin' => $checkin])->get('time_adjustment')->row();
            if (empty($check_request)) {
                if ($this->timeadjustment_model->add($this->input->post())) {
                    sendJson(['success' => 'Request added successfully']);
    
                } else {
                    $this->session->set_flashdata('exception', 'Error while submitting request try again later!');
                    sendJson(['exception' => 'Error while submitting request try again later!']);
                }
            }
            else {
                sendJson(['exception' => 'You are already requested selected date time adjustment']);
            }
            
        // }
        // else {
        //     sendJson(['exception' => 'Auto checkout time will not adjustable on time adjust request']);

        // }
    }
    public function date_time_diff_bt_dates($dateTime)
    {
        $d = date('Y-m-d H:i:s');
        $punchout_time = date('Y-m-d H:i:s',strtotime($dateTime .'+48 hours'));
        $diff_in_seconds = strtotime($punchout_time) - strtotime($d);
        $hours = floor($diff_in_seconds / 3600);
        $minutes = floor(($diff_in_seconds % 3600) / 60);
        return $hours;
    }
}
