<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Home extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->helper('url');
        $this->load->model(array(
            'Csv_model',
            'attendence_model',
            'employee/employees_model',
            'leave/Leave_model',
        ));
        $this->load->library('excel');

    }
    public function index($id = null)
    {
        if ($this->session->userdata('isAdmin') == 1) {
            redirect('attendance/home/admin_attendance');
        } else {
            $data['active_on_machine'] = false;
            if ($this->bio_devices->isLive($this->session->userdata('division_id')) && $this->bio_devices->getUserByHrmId($this->session->userdata('hrm_id'), $this->session->userdata('division_id')) && (in_array($this->session->userdata('employee_id'), [275, 1278]) || $this->bio_devices->isUserEnrolled($this->session->userdata('hrm_id'), $this->session->userdata('division_id')))) {
                $data['active_on_machine'] = true;
            }
            $data['page'] = "user_checkin";
            $check_is_wfh = $this->db->where(['employee_id' => $this->session->userdata('employee_id'), 'work_from_home' => 1])->get('employee_history')->row();
            $data['is_wfh'] = empty($check_is_wfh) ? 0 : 1;
            // $data['is_wfh'] = $this->db->where(['employee_id' => $this->session->userdata('employee_id'), 'work_from_home' => 1])->count_all_results('employee_history') > 0;
            $data['has_shift_assigned'] = $this->employees_model->has_shift_assigned($this->session->userdata('employee_id'));
            $data['is_suspended'] = $this->employees_model->get_suspension($this->session->userdata('employee_id'));
            $data['last_attendence'] = $this->attendence_model->last_record();
            if ($data['last_attendence']) {
                switch ($data['last_attendence']->status) {
                    case "in":
                        $data['title'] = display('check_out');
                        break;
                    case "out":
                        $data['title'] = display('check_in');
                        break;
                    default:
                        $data['title'] = 'Attendence';
                }
            } else {
                $data['title'] = display('check_in');
            }
        }
        $data['module'] = "attendance";

        if ($this->session->userdata('division_id')) {
            $data['promo_video'] = $this->_promo_vids[$this->session->userdata('division_id')];
        }
        echo Modules::run('template/layout', $data);
    }
    public function admin_attendance($id = null, $date = null)
    {
        $this->permission->method('manage_attendance', 'read')->redirect();
        /**
         * Step 1: Select Employee and Date
         */
        $data['module'] = "attendance";
        $data['title'] = 'Attendence Management';
        if (!$id || !$date) {
            if ($this->input->post()) {
                $rules_config = array(
                    array(
                        'field' => 'id',
                        'label' => 'Employee',
                        'rules' => 'trim|required|is_natural',
                    ),
                    array(
                        'field' => 'date',
                        'label' => 'Date',
                        'rules' => 'trim|required',
                    ),
                );
                $this->form_validation->set_rules($rules_config);
                if ($this->form_validation->run() === false) {
                    $this->session->set_flashdata('exception', validation_errors());
                    redirect($_SERVER['HTTP_REFERER']);
                }
                $id = $this->input->post('id');
                $date = date('d-m-Y', strtotime($this->input->post('date')));
                redirect("attendance/home/admin_attendance/$id/$date");
            }
            $data['dropdownatn'] = $this->Csv_model->Employeename();
            $data['page'] = "attendance/select_employee";
        } elseif ($id && $date) {
            $daytimein = date('Y-m-d',strtotime($_POST['dates']['in']));
            $check = $this->db->where(['uid' => $id, 'day' => $daytimein])->get('attendance_history')->num_rows();
            if ($check == 0) {
                if ($this->input->post()) {
                    $this->permission->method('manage_attendance', 'create')->redirect();
                    $author = empty($this->session->userdata('employee_id')) ? $this->session->userdata('id') : $this->session->userdata('employee_id');
                    if ($_POST['dates']['in'] && $_POST['dates']['out']) {
                        if (strtotime($_POST['dates']['out']) - strtotime($_POST['dates']['in']) < 0) {
                            $this->session->set_flashdata('exception', 'Checkin date should be smaller than Checkout date');
                            redirect($_SERVER['HTTP_REFERER']);
                        }
                        $start = date('Y-m-d H:i:s', strtotime($_POST['dates']['in']));
                        $end = date('Y-m-d H:i:s', strtotime($_POST['dates']['out']));
                        $this->attendence_model->custom_punch($id, $start, $end, $author);
                    } else {
                        $att_insertdata = [
                            'uid' => $id,
                            'id' => 0,
                            'state' => 1,
                            'punch_author' => $author,
                            'active' => 1,
                            'flag' => '',
                        ];
                        $where = [];
                        $group_no = 0;
                        if ($_POST['dates']['in']) {
                            $att_insertdata['status'] = 'in';
                            $att_insertdata['punchin_time'] = date('Y-m-d H:i:s', strtotime($_POST['dates']['in']));
                        } elseif ($_POST['dates']['out']) {
                            $where['status'] = 'in';
                            $where['uid'] = $id;
                            $where['day <='] = date('Y-m-d', strtotime($date));
    
                            $att_insertdata['status'] = 'out';
                            $att_insertdata['punchout_time'] = date('Y-m-d H:i:s', strtotime($_POST['dates']['out']));
                        } else {
                            $this->session->set_flashdata('exception', 'At least one of the checkin or checkout field is required');
                            redirect($_SERVER['HTTP_REFERER']);
                        }
                        $shift = $this->attendence_model->get_shift_by_employee($id);
                        $last_rec = getByWhereAsArray('attendance_history', '*', $where, ['time', 'desc'], 1)[0];
                        if ($last_rec && $_POST['dates']['out']) {
                            if (strtotime($_POST['dates']['out']) - strtotime($last_rec['punchin_time']) < 0) {
                                $this->session->set_flashdata('exception', 'Checkin date should be smaller than checkout date');
                                redirect($_SERVER['HTTP_REFERER']);
                            }
                            $group_no = $last_rec['group_no'];
                            $flag = $this->attendence_model->get_current_status(
                                $shift->id,
                                'in',
                                $last_rec['punchin_time'],
                                $att_insertdata['punchout_time'],
                                $id
                            );
                            $att_insertdata['day'] = $last_rec['day'];
                            $att_insertdata['duration'] = strtotime($_POST['dates']['out']) - strtotime($last_rec['punchin_time']);
                            $att_insertdata['flag'] = $flag['flag'];
                        } else {
                            $flag = $this->attendence_model->get_current_status(
                                $shift->id,
                                'out',
                                $att_insertdata['punchin_time'],
                                null,
                                $id
                            );
                            $att_insertdata['flag'] = $flag['flag'];
                            $att_insertdata['day'] = current_working_day($att_insertdata['punchin_time']);
                            $group_no = $this->attendence_model->generate_group_no();
                        }
                        $att_insertdata['group_no'] = $group_no;
                        $att_insertdata['time'] = date('Y-m-d H:i:s', strtotime(($att_insertdata['punchin_time'] ?? $att_insertdata['punchout_time']) . ($att_insertdata['status'] == 'out' ? ' +30 seconds' : null)));
                        $this->db->insert('attendance_history', $att_insertdata);
    
                        $this->activity->set_employee($id)->set_url(sprintf('attendance/home/admin_attendance/%s/%s', $id, date('d-m-Y', strtotime($att_insertdata['punchin_time'] ?? $att_insertdata['punchout_time']))))->log([
                            'attendance_inserted',
                            strtoupper($att_insertdata['status']),
                            formatted_date($att_insertdata['punchin_time'] ?? $att_insertdata['punchout_time'], true),
                        ]);
                    }
                    $this->session->set_flashdata('message', display('save_successfull'));
                    redirect($_SERVER['HTTP_REFERER']);
                }
            }
            else {
                    $this->session->set_flashdata('message', 'This day already existed');
                    redirect($_SERVER['HTTP_REFERER']);
            }



            
            $date = date('Y-m-d', strtotime($date));
            $data['date'] = $date;
            $data['emp_id'] = $id;
            $data['previous_day'] = formatted_date($date . ' -1 day');
            $data['next_day'] = formatted_date($date . ' +1 day');
            $data['attendence'] = $this->attendence_model->get_user_day_report2($id, $date);
            $data['page'] = "attendance/update_attendance";
        }
        echo Modules::run('template/layout', $data);
    }
    public function add_admin_attendance_ajax_request()
    {
        // dd($this->input->post());
        $this->permission->method('manage_attendance', 'read')->redirect();
        /**
         * Step 1: Select Employee and Date
         */
        $id = $this->input->post('empl_id');
        $day = $this->input->post('employee_full_day');
        // $group_no = $this->input->post('employee_group_no');
        if ($id && $day) {
            // $daytimein = date('Y-m-d',strtotime($this->input->post('checkin')));
            $check = $this->db->select('group_no')->where(['uid' => $id, 'day' => $day, 'active' => 1])->order_by('atten_his_id','desc')->get('attendance_history')->row();
            if (!empty($check)) {
                $this->db->where(['uid' => $id, 'day' => $day, 'group_no' => $check->group_no, 'active' => 1])->update('attendance_history', [
                    'active' => 0,
                ]);
            }
            if ($this->input->post()) {
                $this->permission->method('manage_attendance', 'create')->redirect();
                $author = empty($this->session->userdata('employee_id')) ? $this->session->userdata('id') : $this->session->userdata('employee_id');
                if ($this->input->post('checkin') && $this->input->post('checkout')) {
                    if (strtotime($this->input->post('checkout')) - strtotime($this->input->post('checkin')) < 0) {
                        sendJson(['exception' => 'Checkin date should be smaller than Checkout date']);

                        // $this->session->set_flashdata('exception', 'Checkin date should be smaller than Checkout date');
                        // redirect($_SERVER['HTTP_REFERER']);
                    }
                    $start = date('Y-m-d H:i:s', strtotime($this->input->post('checkin')));
                    $end = date('Y-m-d H:i:s', strtotime($this->input->post('checkout')));
                    $this->attendence_model->custom_punch($id, $start, $end, $author);
                } else {
                    $att_insertdata = [
                        'uid' => $id,
                        'id' => 0,
                        'state' => 1,
                        'punch_author' => $author,
                        'active' => 1,
                        'flag' => '',
                    ];
                    $where = [];
                    $group_no = 0;
                    if ($this->input->post('checkin')) {
                        $att_insertdata['status'] = 'in';
                        $att_insertdata['punchin_time'] = date('Y-m-d H:i:s', strtotime($this->input->post('checkin')));
                    } elseif ($this->input->post('checkout')) {
                        $where['status'] = 'in';
                        $where['uid'] = $id;
                        $where['day <='] = date('Y-m-d', strtotime($day));

                        $att_insertdata['status'] = 'out';
                        $att_insertdata['punchout_time'] = date('Y-m-d H:i:s', strtotime($this->input->post('checkout')));
                    } else {
                        // $this->session->set_flashdata('exception', 'At least one of the checkin or checkout field is required');
                        // redirect($_SERVER['HTTP_REFERER']);
                        sendJson(['exception' => 'At least one of the checkin or checkout field is required']);

                    }
                    $shift = $this->attendence_model->get_shift_by_employee($id);
                    $last_rec = getByWhereAsArray('attendance_history', '*', $where, ['time', 'desc'], 1)[0];
                    if ($last_rec && $this->input->post('checkout')) {
                        if (strtotime($this->input->post('checkout')) - strtotime($last_rec['punchin_time']) < 0) {
                            // $this->session->set_flashdata('exception', 'Checkin date should be smaller than checkout date');
                            // redirect($_SERVER['HTTP_REFERER']);
                            sendJson(['exception' => 'Checkin date should be smaller than Checkout date']);

                        }
                        $group_no = $last_rec['group_no'];
                        $flag = $this->attendence_model->get_current_status(
                            $shift->id,
                            'in',
                            $last_rec['punchin_time'],
                            $att_insertdata['punchout_time'],
                            $id
                        );
                        $att_insertdata['day'] = $last_rec['day'];
                        $att_insertdata['duration'] = strtotime($this->input->post('checkout')) - strtotime($last_rec['punchin_time']);
                        $att_insertdata['flag'] = $flag['flag'];
                    } else {
                        $flag = $this->attendence_model->get_current_status(
                            $shift->id,
                            'out',
                            $att_insertdata['punchin_time'],
                            null,
                            $id
                        );
                        $att_insertdata['flag'] = $flag['flag'];
                        $att_insertdata['day'] = current_working_day($att_insertdata['punchin_time']);
                        $group_no = $this->attendence_model->generate_group_no();
                    }
                    $att_insertdata['group_no'] = $group_no;
                    $att_insertdata['time'] = date('Y-m-d H:i:s', strtotime(($att_insertdata['punchin_time'] ?? $att_insertdata['punchout_time']) . ($att_insertdata['status'] == 'out' ? ' +30 seconds' : null)));
                    $this->db->insert('attendance_history', $att_insertdata);

                    // $this->activity->set_employee($id)->set_url(sprintf('attendance/home/admin_attendance/%s/%s', $id, date('d-m-Y', strtotime($att_insertdata['punchin_time'] ?? $att_insertdata['punchout_time']))))->log([
                    //     'attendance_inserted',
                    //     strtoupper($att_insertdata['status']),
                    //     formatted_date($att_insertdata['punchin_time'] ?? $att_insertdata['punchout_time'], true),
                    // ]);
                }
                sendJson(['success' => display('save_successfull')]);
                // $this->session->set_flashdata('message', display('save_successfull'));
                // redirect($_SERVER['HTTP_REFERER']);
            }
        }
    }
    public function manageatn()
    {
        $data['title'] = display('attendance_list');
        $data['addressbook'] = $this->Csv_model->get_addressbook();
        $data['module'] = "attendance";
        $data['page'] = "manage_attendance";
        echo Modules::run('template/layout', $data);
    }
    public function importcsv()
    {
        redirect('attendance/home/report');return;
        if (isset($_FILES["upload_csv_file"]["name"])) {
            $path = $_FILES["upload_csv_file"]["tmp_name"];
            $object = PHPExcel_IOFactory::load($path);
            foreach ($object->getWorksheetIterator() as $sale) {
                $highestRow = $sale->getHighestRow();
                $highestColumn = $sale->getHighestColumn();
                for ($row = 2; $row <= $highestRow; $row++) {
                    $employee_id = $sale->getCellByColumnAndRow(0, $row)->getValue();
                    $date = $sale->getCellByColumnAndRow(1, $row)->getValue();
                    // print_r($date);exit();
                    $atn_time = date('Y-m-d H:i:s', strtotime($date));
                    $attendance = array(
                        'uid' => $employee_id,
                        'time' => $date,
                        'id' => 0,
                        'state' => 1,
                    );
                    $this->db->insert('attendance_history', $attendance);
                }
            }
            $this->session->set_flashdata('message', display('successfully_uploaded'));
            redirect('attendance/home/report');
        }
    }
    public function create_atten()
    {
        $is_wfh = $this->db->where(['employee_id' => $this->session->userdata('employee_id'), 'work_from_home' => 1])->count_all_results('employee_history') > 0;
        if (!$is_wfh && $this->bio_devices->isLive($this->session->userdata('division_id')) && $this->bio_devices->getUserByHrmId($this->session->userdata('hrm_id'), $this->session->userdata('division_id')) && (in_array($this->session->userdata('employee_id'), [275, 1278]) || $this->bio_devices->isUserEnrolled($this->session->userdata('hrm_id'), $this->session->userdata('division_id')))) {
            redirect("attendance/Home/index?a=on_machine");
        }
        date_default_timezone_set("Asia/karachi");
        $data['title'] = display('employee');
        $in = $this->input->post('in');
        $out = $this->input->post('out');
        #-------------------------------#intime
        $this->form_validation->set_rules('employee_id', display('employee_id'), 'required');
        if ($this->session->userdata('isAdmin')) {
            $this->form_validation->set_rules('inday', 'Day', 'required');
            $this->form_validation->set_rules('intime', display(['Punch', 'Time']), 'required');
        } else {
            $data['last_attendence'] = $this->attendence_model->last_record();
            $attendence_status = [];
            if ($data['last_attendence']) {
                switch ($data['last_attendence']->status) {
                    case "in":
                        $attendence_status[] = $this->attendence_model->get_current_status($this->session->userdata('shift'), $data['last_attendence']->status, $data['last_attendence']->punchin_time);
                        break;
                    case "out":
                        $attendence_status[] = $this->attendence_model->get_current_status($this->session->userdata('shift'), $data['last_attendence']->status, date('Y-m-d H:i:s'), $data['last_attendence']->punchout_time);
                        break;
                }
            } else {
                $as = $this->attendence_model->get_current_status($this->session->userdata('shift'), 'out', date('Y-m-d h:i:s A'));
                if ($as) {
                    $attendence_status[] = $as;
                }
            }
        }
        //
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            if ($this->session->userdata('isAdmin')) {
                redirect("attendance/Home/index");
            } else {
                $att_time = date('Y-m-d H:i:s');
                $userId = $this->session->userdata('employee_id');
                $attendance_history = [
                    'uid' => $userId,
                    'state' => 1,
                    'id' => 0,
                ];
                $result = $this->attendence_model->last_record();
                if ($result && $result->status == 'in') {
                    $shift_percentage = $this->attendence_model->shift_percentage($this->attendence_model->get_shift($this->session->userdata('shift')), $result->punchin_time);

                    if ($shift_percentage < 55.556) {
                        $attendence_status[] = ['flag' => 'A'];
                    }
                    if ($shift_percentage >= 55.556 && $shift_percentage < 91.667) {
                        $attendence_status[] = ['flag' => 'UH-D'];
                    }
                    if ($shift_percentage >= 91.667) {
                        $attendence_status[] = ['flag' => 'FD'];
                    }
                    $attendance_history['day'] = $result->day;
                    $attendance_history['punchout_time'] = $att_time;
                    $attendance_history['status'] = 'out';
                    $attendance_history['group_no'] = (int) $result->group_no;
                    $attendance_history['time'] = $att_time;
                    $attendance_history['remarks_out'] = strip_tags($this->input->post('remarks'));
                    $attendance_history['duration'] = strtotime($att_time) - strtotime($result->punchin_time);
                    $attendance_history['punch_author'] = $userId;
                    $attendance_history['flag'] = $attendence_status ? implode(',', array_column($attendence_status, 'flag')) : null;
                    $last_status = $result->atten_his_id;
                } else {
                    $attendance_history['day'] = current_working_day(date('Y-m-d H:i:s', strtotime('+2 hours')));
                    $attendance_history['status'] = 'in';
                    $attendance_history['punchin_time'] = $att_time;
                    $attendance_history['time'] = $att_time;
                    $attendance_history['uid'] = $userId;
                    $attendance_history['remarks_in'] = strip_tags($this->input->post('remarks'));
                    $attendance_history['punch_author'] = $userId;
                    $attendance_history['group_no'] = $this->attendence_model->generate_group_no();
                    $attendance_history['flag'] = $attendence_status ? implode(',', array_column($attendence_status, 'flag')) : null;
                }
                if ($this->Csv_model->atten_create($attendance_history, $last_status)) {
                    $this->session->set_flashdata('message', display('save_successfull'));
                } else {
                    $this->session->set_flashdata('exception', display('please_try_again'));
                }
                redirect('attendance/Home/index?a=' . $attendance_history['status']);
            }
        } elseif ($this->form_validation->run() === false) {
            $this->session->set_flashdata('exception', validation_errors(' ', ' '));
            redirect("attendance/Home/index");
        } else {
            $data['title'] = display('create');
            $data['module'] = "attendance";
            $data['page'] = "attendance_form";
            $data['dropdownatn'] = $this->Csv_model->Employeename();
            echo Modules::run('template/layout', $data);
        }
    }
    public function delete_group($emp_id, $gid)
    {
        $this->permission->method('manage_attendance', 'delete')->redirect();
        if ($this->attendence_model->delete_group($emp_id, $gid)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function edit_group($emp_id, $gid)
    {
        $this->permission->method('manage_attendance', 'update')->redirect();
        if ($this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'checkin',
                    'label' => 'Checkin',
                    'rules' => 'trim|required',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === false) {
                $this->session->set_flashdata('exception', display('please_try_again'));
            } 
            else {
                if ($this->input->post('checkout') && strtotime($this->input->post('checkout')) - strtotime($this->input->post('checkin')) < 0) {
                    $this->session->set_flashdata('exception', 'Checkin time should be smaller than checkout time');
                    redirect("attendance/home/admin_attendance/$emp_id/" . date('d-m-Y', strtotime($this->input->post('checkin'))));
                }
                $res = $this->attendence_model->update_group(
                    $gid,
                    $this->input->post('checkin'),
                    $this->input->post('checkout'),
                    $emp_id
                );
                if ($res) {
                    $this->session->set_flashdata('message', display('successfully_updated'));
                } else {
                    $this->session->set_flashdata('exception', display('please_try_again'));
                }
            }
            redirect("attendance/home/admin_attendance/$emp_id/" . date('d-m-Y', strtotime($this->input->post('checkin'))));
        }
        $data['module'] = "attendance";
        $data['title'] = 'Attendence Management';
        $data['page'] = "attendance/update_group";
        $data['group'] = $this->attendence_model->get_group($gid);
        echo Modules::run('template/layout', $data);
    }
    public function delete_atn($id = null)
    {
        redirect();
        $this->permission->method('attendance', 'delete')->redirect();
        if ($this->Csv_model->delete_attn($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function edit_group_ajax_request($emp_id = null, $gid = null)
    {
        // $this->permission->method('manage_attendance', 'update')->redirect();
        if ($this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'checkin',
                    'label' => 'Checkin',
                    'rules' => 'trim|required',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === false) {
                sendJson(['error' => 'At least one of the checkin or checkout field is required']);
            } 
            else {
                if ($this->input->post('checkout') && strtotime($this->input->post('checkout')) - strtotime($this->input->post('checkin')) < 0) {
                    sendJson(['error' => 'Checkin time should be smaller than checkout time']);
                }
                $res = $this->attendence_model->update_group(
                    $this->input->post('employee_group_no'),
                    $this->input->post('checkin'),
                    $this->input->post('checkout'),
                    $this->input->post('empl_id')
                );
                if ($res) {
                    sendJson(['success' => display('successfully_updated')]);
                } else {
                    sendJson(['exception' => display('please_try_again')]);
                }
            }
        }
        $data['group'] = $this->attendence_model->get_group($gid);
        sendJson($data['group']);
    }
    public function update_atn_form($id = null)
    {
        redirect();
        $this->permission->method('attendance', 'update')->redirect();
        $this->form_validation->set_rules('att_id', null, 'required|max_length[11]');
        $this->form_validation->set_rules('employee_id', display('employee_id'), 'required');
        $this->form_validation->set_rules('date', display('date'), 'required');
        $this->form_validation->set_rules('sign_in', display('sign_in'), 'required');
        $this->form_validation->set_rules('sign_out', display('sign_out'));
        $this->form_validation->set_rules('staytime', display('staytime'));
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData = [
                'att_id' => $this->input->post('att_id', true),
                'employee_id' => $this->input->post('employee_id', true),
                'date' => $this->input->post('date', true),
                'sign_in' => $this->input->post('sign_in', true),
                'sign_out' => $this->input->post('sign_out', true),
                'staytime' => $this->input->post('staytime', true),
            ];
            if ($this->Csv_model->update_attn($postData)) {
                $this->session->set_flashdata('message', display('successfully_updated'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("attendance/Home/index");
        } else {
            $data['data'] = $this->Csv_model->attn_updateForm($id);
            $data['module'] = "attendance";
            $data['dropdownatn'] = $this->Csv_model->Employeename();
            $data['query'] = $this->Csv_model->get_atn_dropdown($id);
            $data['page'] = "update_atn";
            echo Modules::run('template/layout', $data);
        }
    }
    //// checkout atn ///
    public function checkout()
    {
        redirect();
        $timezone = get_settings();
        date_default_timezone_set($timezone->timezone);
        $sign_out = date("h:i:s a", time());
        $sign_in = $this->input->post('sign_in', true);
        $in = new DateTime($sign_in);
        $Out = new DateTime($sign_out);
        $interval = $in->diff($Out);
        $stay = $interval->format('%H:%I:%S');
        $postData = [
            'att_id' => $this->input->post('att_id', true),
            'sign_out' => $sign_out,
            'staytime' => $stay,
        ];
        $update = $this->db->where('att_id', $this->input->post('att_id', true))
            ->update("emp_attendance", $postData);
        if ($update) {
            $this->session->set_flashdata('message', display('successfully_checkout'));
            redirect("attendance/Home/index");
        }
    }
/* ########## Report Start ####################*/
    public function report_user()
    {
        $data['title'] = display('attendance_list');
        $data['module'] = "attendance";
        $data['page'] = "user_views_report";
        echo Modules::run('template/layout', $data);
    } //
    public function report_byId()
    {
        $data['title'] = display('attendance_list');
        $data['module'] = "attendance";
        $data['page'] = "attn_Id_report";
        echo Modules::run('template/layout', $data);
    } //
    public function report_view()
    {
        $this->permission->module('attendance', 'read')->redirect();
        $format_start_date = $this->input->post('start_date');
        $format_end_date = $this->input->post('end_date');
        $data['date'] = $format_start_date;
        $data['date'] = $format_end_date;
        $data['query'] = $this->Csv_model->userReport($format_start_date, $format_end_date);
        $data['module'] = "attendance";
        $data['page'] = "user_views_report";
        echo Modules::run('template/layout', $data);
    }
    public function AtnReport_view()
    {
        $this->permission->module('attendance', 'read')->redirect();
        $data['title'] = display('attendance_repor');
        $id = $this->input->post('employee_id');
        $start_date = $this->input->post('s_date');
        $end_date = $this->input->post('e_date');
        $data['employee_id'] = $id;
        $data['date'] = $start_date;
        $data['date'] = $end_date;
        $data['ab'] = $this->Csv_model->atnrp($id);
        $data['query'] = $this->Csv_model->search($id, $start_date, $end_date);
        $data['module'] = "attendance";
        $data['page'] = "att_reportview";
        echo Modules::run('template/layout', $data);
    }
    public function atntime_report()
    {
        $data['title'] = display('attendance_list');
        $data['module'] = "attendance";
        $data['page'] = "Date_time_report";
        echo Modules::run('template/layout', $data);
    } //
    public function AtnTimeReport_view()
    {
        $this->permission->module('attendance', 'read')->redirect();
        $data['title'] = display('attendance_repor');
        $date = $this->input->post('date');
        $start_time = $this->input->post('s_time');
        $end_time = $this->input->post('e_time');
        $data['date'] = $date;
        $data['sign_in'] = $start_time;
        $data['sign_in'] = $end_time;
        $data['query'] = $this->Csv_model->search_intime($date, $start_time, $end_time);
        $data['module'] = "attendance";
        $data['page'] = "Date_time_report";
        echo Modules::run('template/layout', $data);
    }
    /**** ###### Id checking ######### */
    public function attenlist()
    {
        $data['title'] = display('attendance_report');
        $data['addressbook'] = $this->Csv_model->get_addressbook();
        $data['module'] = "attendance";
        $data['page'] = "attendance_list";
        $data['dropdownatn'] = $this->Csv_model->Employeename();
        echo Modules::run('template/layout', $data);
    }
    /*  atn edit */
    public function edit_atn_form($id = null)
    {
        redirect();
        $this->permission->method('attendance', 'delete')->redirect();
        $this->form_validation->set_rules('att_id', null, 'required|max_length[11]');
        $this->form_validation->set_rules('employee_id', display('employee_id'), 'required');
        $this->form_validation->set_rules('date', display('date'), 'required');
        $this->form_validation->set_rules('sign_in', display('sign_in'), 'required');
        $this->form_validation->set_rules('sign_out', display('sign_out'));
        $this->form_validation->set_rules('staytime', display('staytime'));
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData = [
                'att_id' => $this->input->post('att_id', true),
                'employee_id' => $this->input->post('employee_id', true),
                'date' => $this->input->post('date', true),
                'sign_in' => $this->input->post('sign_in', true),
                'sign_out' => $this->input->post('sign_out', true),
                'staytime' => $this->input->post('staytime', true),
            ];
            if ($this->Csv_model->update_attn($postData)) {
                $this->session->set_flashdata('message', display('successfully_updated'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("attendance/Home/index");
        } else {
            $data['data'] = $this->Csv_model->attn_updateForm($id);
            $data['module'] = "attendance";
            $data['dropdownatn'] = $this->Csv_model->Employeename();
            $data['query'] = $this->Csv_model->get_atn_dropdown($id);
            $data['page'] = "edit_attendance";
            echo Modules::run('template/layout', $data);
        }
    }
    /*
    |-----------------------------------------------------------
    |   Device Connectivity
    |
    |------------------------------------------------------------
     */
    public function device_connection()
    {
        $div_data = $this->db->count_all('deviceinfo');
        if (!empty($div_data)) {
            $id = 1;
        } else {
            $id = null;
        }
        $this->form_validation->set_rules('device_ip', display('device_ip'), 'required|max_length[50]');
        $data['device_data'] = (Object) $postData = [
            'id' => $this->input->post('id'),
            'device_ip' => $this->input->post('device_ip'),
        ];
        #-------------------------------#
        if ($this->form_validation->run()) {
            if (empty($postData['id'])) {
                $this->permission->method('attendance', 'create')->redirect();
                if ($this->Csv_model->create_device_ip($postData)) {
                    $this->session->set_flashdata('message', display('save_successfully'));
                } else {
                    $this->session->set_flashdata('exception', display('please_try_again'));
                }
                redirect("attendance/home/device_connection");
            } else {
                $this->permission->method('attendance', 'update')->redirect();
                if ($this->Csv_model->update_device_ip($postData)) {
                    $this->session->set_flashdata('message', display('update_successfully'));
                } else {
                    $this->session->set_flashdata('exception', display('please_try_again'));
                }
                redirect("attendance/home/device_connection/" . $postData['id']);
            }
        } else {
            if (!empty($id)) {
                $data['title'] = display('update');
                $data['deviceinfo'] = $this->Csv_model->devicinfoById($id);
            }
            $data['module'] = "attendance";
            $data['page'] = "device_connect_form";
            echo Modules::run('template/layout', $data);
        }
    }
    /*
    |--------------------------------------------------------
    | Finger print Device information
    |--------------------------------------------------------
     */
    public function deviceData()
    {
        return $this->db->select('*')->from('deviceinfo')->get()->row();
    }
    //Attendance Log report
    public function att_log_report()
    {
        redirect('attendance/Home/report');
    }
    public function report()
    {
        $start_date = $this->input->get('start_date');
        $end_date = $this->input->get('end_date');
        $start_date_timed = strtotime($start_date);
        $end_date_timed = strtotime($end_date);
        $current_month = $this->input->get('current_month');

        if (!(empty($start_date) && empty($end_date))) {

                //&& empty($this->input->get('dept_id')) && empty($this->input->get('supervisorid')) FOR DEPT and SUPERVISOR
            if (empty($this->input->get('employee_id')) && empty($this->input->get('dept_id'))) {
                $this->session->set_flashdata('exception', 'Employee field is required');
                redirect($_SERVER['HTTP_REFERER']);
            } else if (!empty($this->input->get('employee_id')) && !empty($this->input->get('dept_id'))) {
                $this->session->set_flashdata('exception', 'Can not search employee wise when searching department wise');
                redirect($_SERVER['HTTP_REFERER']);
            } else {
                if (empty($end_date)) {
                    $this->session->set_flashdata('exception', 'Invalid date rage, End date field isrequired');
                    redirect($_SERVER['HTTP_REFERER']);
                }
                if ($end_date_timed < $start_date_timed) {
                    $this->session->set_flashdata('exception', 'Invalid date rage, Start date must be smaller than end date.');
                    redirect($_SERVER['HTTP_REFERER']);
                }
                $limit = '31 days';
                if ($this->permission->method('atn_log_datewise', 'update')->access()) {
                    $limit = '3 years';
                } elseif ($this->session->userdata('supervisor') && empty($this->input->get('dept_id')) && empty($this->input->get('supervisorid')) && count($this->input->get('employee_id')) == 1) {
                    $limit = '7 months';
                }
                if ($end_date_timed - $start_date_timed > strtotime($limit, 0)) {
                    $this->session->set_flashdata('exception', "Only {$limit} of attendance range is allowed.");
                    redirect($_SERVER['HTTP_REFERER']);
                }
                if ($this->permission->method('atn_log_datewise', 'update')->access() && (empty($this->input->get('employee_id')) && empty($this->input->get('dept_id')) && empty($this->input->get('supervisorid'))) && ($end_date_timed - $start_date_timed > strtotime('2 months', 0))) {
                    $this->session->set_flashdata('exception', "Department selection is required for report period greater than 2 months");
                    redirect($_SERVER['HTTP_REFERER']);
                }
            }
        }
        if (!empty($current_month)) {
            if (empty($this->input->get('employee_id')) && empty($this->input->get('dept_id'))) {
                $this->session->set_flashdata('exception', 'Employee field is required');
                redirect($_SERVER['HTTP_REFERER']);
            }
            if (!empty($this->input->get('employee_id')) && !empty($this->input->get('dept_id'))) {
                $this->session->set_flashdata('exception', 'Can not search employee wise when searching department wise');
                redirect($_SERVER['HTTP_REFERER']);
            }
            if ($current_month > date('Y-m')) {
                $this->session->set_flashdata('exception', 'Invalid month, Month must be smaller than current month.');
                redirect($_SERVER['HTTP_REFERER']);
            }
        }

        if ($this->input->get('download')) {
            $this->download_report($this->input->get('download'));return;
        }
        $data['title'] = 'Attendance Log';
        $data['module'] = "attendance";
        $users = $this->input->get('employee_id');
        $current_month = $this->input->get('current_month');
        $data['selected_dept'] = $this->input->get('dept_id');
        // $data['selected_supervisor'] = $this->input->get('supervisorid');
        $users = $this->input->get('employee_id');
        $data['days_selected'] = empty($current_month) ? daysBetween($start_date, $end_date) : date("t", strtotime($current_month));

        $data['start'] = $start_date;
        $data['end'] = $end_date;
        if ($current_month) {
            $data['current_month'] = $current_month;
            $data['start'] = $current_month.'-1';
            $data['end'] = $current_month.'-'.$data['days_selected'];
        }
        $data['user_id'] = $users;
        $data['users'] = is_array($users) && !empty($users) ? implode(',', $users) : '';
        $data['userlist'] = $this->Csv_model->userlist();
        // $data['supervisors'] = $this->Csv_model->all_supervisors();
        $data['departments'] = $this->Csv_model->departments_list();

        if ((!(empty($start_date) && empty($end_date))) || !empty($current_month)) {
            $emp_ids = $this->attendence_model->employeeAttendanceCheck($this->input->get());
            $data['attendence_data'] = $this->attendence_model->get_report($emp_ids, $start_date, $end_date, $current_month);
            $data['weekend_days'] = get_weekend();
        }

        $data['type'] = $this->Leave_model->get_leave_type();
        $data['dropdown'] = $this->Leave_model->dropdown();
        $data['supr'] = $this->Leave_model->supervisorList();

        $shifts = $this->db->select('employee_id, shift')->where_in('employee_id', array_keys($data['dropdown']))->get('employee_history')->result_array();
        $data['employee_shifts'] = [];
        foreach ($shifts as $shift_rec) {
            $data['employee_shifts'][$shift_rec['employee_id']] = $shift_rec['shift'];
        }
        $weekend_arr = $this->db->get('weekly_holiday')->result_array();
        $data['weekend_arr'] = [];
        foreach ($weekend_arr as $wk_ar) {
            $data['weekend_arr'][$wk_ar['shift_id']] = $wk_ar['dayname'];
        }

        // dd($data);
        $data['annual_holidays_arr'] = $this->Leave_model->get_annual_holidays(array_column($shifts, 'shift'));
        $data['page'] = "attendance_log_datewise";
        echo Modules::run('template/layout', $data);
    }
    //Attendance Log report userwise
    public function user_attendanc_details($id, $date)
    {
        $data['title'] = 'Attendance Log';
        $data['module'] = "attendance";
        $data['id'] = $id;
        $data['company'] = $this->Csv_model->company_info();
        $data['day'] = $date;
        $data['attendence'] = $this->attendence_model->get_user_day_report($id, $date);
        $data['leave'] = $this->attendence_model->get_day_leave($id, $date);
        $data['page'] = "attendance_log_userdetails";
        echo Modules::run('template/layout', $data);
    }
    // Date between and user wise attendance log
    public function datebetween_attendance()
    {
        $id = $this->input->get('employee_id');
        $from_date = $this->input->get('start_date');
        $to_date = $this->input->get('end_date');
        $data['module'] = "attendance";
        $data['atten_in'] = $this->Csv_model->att_log_datebetween($id, $from_date, $to_date);
        $data['userlist'] = $this->Csv_model->userlist();
        $data['supervisors'] = $this->Csv_model->all_supervisors();
        $data['start'] = $from_date;
        $data['end'] = $to_date;
        $data['user'] = $this->Csv_model->deviceuser($id);
        $data['company'] = $this->Csv_model->company_info();
        $this->load->library('pdfgenerator');
        $dompdf = new DOMPDF();
        $page = $this->load->view('attendance/individual_att_history_pdf', $data, true);
        $dompdf->load_html($page);
        $dompdf->render();
        $output = $dompdf->output();
        file_put_contents('assets/data/pdf/attendance/Attendance History of ' . $id . ' ' . $from_date . ' To ' . $to_date . '.pdf', $output);
        $data['pdf'] = 'assets/data/pdf/attendance/Attendance History of ' . $id . ' ' . $from_date . ' To ' . $to_date . '.pdf';
        $data['page'] = "attendance_log_datebetween";
        echo Modules::run('template/layout', $data);
    }
    public function delete_attendance($id, $user_id)
    {
        redirect();
        if ($this->Csv_model->attendance_delete($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("attendance/home/user_attendanc_details/" . $user_id);
    }
    public function searchEmployee()
    {
        redirect('attendance/Home/report');
    }
    private function download_report($type)
    {

        $this->load->library('excel');

        $this->excel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'Employee ID')
            ->setCellValue('B1', 'Employee Name')
            ->setCellValue('C1', 'Department')
            ->setCellValue('D1', 'Shift');

        $emp_ids = $this->attendence_model->employeeAttendanceCheck($this->input->get());

        $days = daysBetween($this->input->get('start_date'), $this->input->get('end_date'));
        if ($days == 0) {
            $days++;
        }

        $data = $this->attendence_model->get_report($emp_ids, $this->input->get('start_date'), $this->input->get('end_date'));
        $alpha_header = range('A', 'Z');

        //Generate cross multiplication of columns if data is bigger than 25 columns
        $alp_i = 0;
        while ($days + 3 > count($alpha_header)) {
            $alphabet = $alpha_header[$alp_i];
            $new_range = range('A', 'Z');
            foreach ($new_range as $alp) {
                $alpha_header[] = $alphabet . $alp;
            }
            $alp_i++;
        }

        $weekend_days = get_weekend();
        foreach ($data as $key => $emp_data) {
            $this->excel->setActiveSheetIndex(0)
                ->setCellValue('A' . ($key + 2), $emp_data['hrm_id'])
                ->setCellValue('B' . ($key + 2), $emp_data['firstname'] . ' ' . $emp_data['lastname'])
                ->setCellValue('C' . ($key + 2), $emp_data['department'])
                ->setCellValue('D' . ($key + 2), $emp_data['shift_name']);
        }

        $column_offset = 3;
        for ($i = 1; $i <= $days; $i++) {
            $current_column = $column_offset + $i;
            $full_date = date('Y-m-d', strtotime('+' . ($i - 1) . ' day', strtotime($this->input->get('start_date'))));
            $this->excel->setActiveSheetIndex(0)
                ->setCellValue($alpha_header[$current_column] . '1', date('d/m/Y', strtotime($full_date)));

            $Today = date('l', strtotime('+' . ($i - 1) . ' day', strtotime($this->input->get('start_date'))));

            foreach ($data as $key => $emp_data) {
                if (strtotime($full_date) < strtotime($emp_data['hire_date'])) {
                    $this->excel->setActiveSheetIndex(0)->setCellValue($alpha_header[$current_column] . ($key + 2), '');
                    continue;
                }
                if ($emp_data['is_resigned'] && strtotime($full_date) >= strtotime($emp_data['termination_date'])) {
                    $this->excel->setActiveSheetIndex(0)->setCellValue($alpha_header[$current_column] . ($key + 2), $emp_data['status'] == 'terminated' ? 'TER' : 'RES');
                    continue;
                }
                $payroll_holiday = get_public_holiday($full_date, $emp_data['shift'], $emp_data['department'], $emp_data['employee_id']);

                $leave = $this->db->query(
                    'CALL get_day_leave(?, ?);',
                    [$emp_data['employee_id'], $full_date]
                )->row();
                $this->db->next_result();
                $suspended = $this->employees_model->get_suspension($emp_data['employee_id'], $full_date);

                $wk_hdays = $weekend_days[$emp_data['shift']];
                $col_text = null;
                if ($suspended) {
                    $col_text = 'SUS';
                } elseif (in_array($Today, $wk_hdays)) {
                    $col_text = $Today;
                } elseif ($payroll_holiday) {
                    $col_text = $payroll_holiday->holiday_name;
                } elseif ($leave && $leave->type == 'full_day') {
                    $col_text = 'PL';
                } elseif ($leave && $leave->type == 'half_day') {
                    $status = $emp_data['attendence'][$full_date]['status'];
                    if (in_array('FD', $status) || in_array('OT', $status) || in_array('UH-D', $status)) {
                        $col_text = 'H-D';
                    } else {
                        $col_text = 'HPL';
                    }
                } elseif (isset($emp_data['attendence'][$full_date])) {
                    $status = $emp_data['attendence'][$full_date]['status'];
                    if (in_array('FD', $status) || in_array('OT', $status)) {
                        $col_text = 'P';
                    } elseif (in_array('UH-D', $status)) {
                        $col_text = 'UH-D';
                    } elseif (in_array('A', $status)) {
                        $col_text = 'A';
                    } elseif (in_array('P', $status)) {
                        $col_text = 'P';
                    }
                    if (in_array('LA', $status) && ($col_text == 'P' || !$col_text)) {
                        $col_text = 'LA';
                    }
                } else {
                    $col_text = 'A';
                }
                $this->excel->setActiveSheetIndex(0)->setCellValue($alpha_header[$current_column] . ($key + 2), $col_text);
            }
        }
        if ($type == 'csv') {
            $this->excel->download_csv('attendance_' . $this->input->get('start_date'));
        } else {
            $this->excel->download_excel('attendance_' . $this->input->get('start_date'));
        }
    }
    public function resultData()
    {
        $data['title'] = 'Attendance Log';
        $config["base_url"] = base_url('attendance/home/att_log_report/');
        $config["total_rows"] = $this->Csv_model->count_att_report();
        $config["per_page"] = 10;
        $config["uri_segment"] = 4;
        $config["last_link"] = "Last";
        $config["first_link"] = "First";
        $config['next_link'] = 'Next';
        $config['prev_link'] = 'Prev';
        $config['full_tag_open'] = "<ul class='pagination col-xs pull-right'>";
        $config['full_tag_close'] = "</ul>";
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";
        $config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
        $config['next_tag_open'] = "<li>";
        $config['next_tag_close'] = "</li>";
        $config['prev_tag_open'] = "<li>";
        $config['prev_tagl_close'] = "</li>";
        $config['first_tag_open'] = "<li>";
        $config['first_tagl_close'] = "</li>";
        $config['last_tag_open'] = "<li>";
        $config['last_tagl_close'] = "</li>";
        /* ends of bootstrap */
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
        $data["links"] = $this->pagination->create_links();
        $data['module'] = "attendance";
        $users = $this->input->post('employee_id');
        // print_r($this->input->post());exit;
        $start_date = $this->input->post('start_date');
        $end_date = $this->input->post('end_date');
        $data['start'] = $start_date;
        $data['end'] = $end_date;
        $data['user_id'] = $users;
        $data['users'] = implode(',', $users);
        $data['queryd'] = $this->Csv_model->att_report_ajax($config["per_page"], $page, $users, $start_date, $end_date);
        $data['supervisors'] = $this->Csv_model->all_supervisors();
        $data['userlist'] = $this->Csv_model->userlist();
        $data['page'] = "result_data";
        echo Modules::run($data);
    }
    public function migrate()
    {
        if (!isset($_GET['rz'])) {
            show_404();
        }
        $recs = $this->db
            ->select('group_no, uid, min(punchin_time) as punchin_time')
            ->where(['punchin_time <>' => null, 'day' => null])
            ->group_by('group_no, uid')
            ->limit(10000)
            ->get('attendance_history')
            ->result();
        $this->db->trans_start();
        foreach ($recs as $rec) {
            $this->db->query('CALL test_attendance(?,?,?);', [
                $rec->uid,
                $rec->group_no,
                sql_date($rec->punchin_time),
            ]);
        }
        $this->db->trans_complete();
        echo $this->db->trans_status() ? '10000 done<br>' : 'failed<br>';
        echo 'Remaining: ' . $this->db->where(['punchin_time <>' => null, 'day' => null])->count_all_results('attendance_history');
    }
    public function old_checkins()
    {
        $this->permission->method('old_checkins', 'read')->redirect();
        if ($this->input->post()) {
            $this->getCheckinsDatatable();return;
        }
        $data['title'] = display('old_checkins');
        $data['module'] = "attendance";
        $data['page'] = "attendance/old_checkins";
        echo Modules::run('template/layout', $data);
    }
    public function checkout_manual()
    {
        if (!$this->permission->method('old_checkins', 'update')->access()) {
            sendJson(['error' => display(['not', 'enough', 'permissions', 'to', 'perform', 'this', 'action'])]);
        }
        if ($this->input->post('eid') && $this->input->post('id')) {
            if ($this->attendence_model->checkout_manual($this->input->post('eid'), $this->input->post('id'))) {
                sendJson(['success' => display(['Attendance', 'checked', 'out', 'successfully'], true)]);
            } else {
                sendJson(['error' => display(['unable', 'to', 'checkout', 'at', 'this', 'time', 'try', 'again'], true)]);
            }
        }
        sendJson(['error' => display(['invalid', 'request'])]);
    }
    private function getCheckinsDatatable()
    {
        $search_arr = [];
        $search_columns = [
            'CONCAT_WS(\' \', employee_history.first_name, employee_history.last_name)',
            'employee_history.hrm_id',
            'DATE_FORMAT(attendance_view.punchin_time, \'%d-%m-%Y %h:%i:%s %p\')',
            'attendance_view.group_no',
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            foreach ($search_columns as $value) {
                $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
            }
        };
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $this->attendence_model->countAllRows_checkins();
        $out_arr["recordsFiltered"] = $this->attendence_model->countDatatable_checkins($search_arr);
        $rows = $this->attendence_model->getDatatable_checkins($this->input->post(), $search_arr);
        foreach ($rows as $index => $rec) {
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'first_name':{
                            $tdData = $rec['full_name'];
                            break;
                        }
                    case 'punchin_time':{
                            $tdData = formatted_date($rec[$col['data']], true);
                            break;
                        }
                    case 'action':{
                            if ($this->permission->method('old_checkins', 'update')->access()) {
                                $tdData = '<a class="btn btn-primary btn-checkout" data-name="' . addslashes($rec['full_name']) . '" data-id="' . $rec['group_no'] . '" data-eid="' . $rec['uid'] . '" href="#" role="button">' . display(['check', 'out']) . '</a>';
                                break;
                            }
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
    public function devices($id = null)
    {
        $this->permission->method('attendance_devices', 'read')->redirect();
        $this->load->model('device_model');
        if (!is_null($id)) {
            $rec = $this->device_model->getDevice($id);
            sendJson([($rec ? 'success' : 'error') => $rec ? $rec : display(['no', 'device', 'found'])]);
        }
        $device_types = $this->device_model->getDeviceTypes();
        if ($this->input->post()) {
            if ($this->input->post('id') && !$this->permission->method('attendance_devices', 'update')->access()) {
                sendJson(['error' => display(['action', 'not', 'allowed'])]);
            } elseif (!$this->permission->method('attendance_devices', 'create')->access()) {
                sendJson(['error' => display(['action', 'not', 'allowed'])]);
            }
            $rules_config = array(
                array(
                    'field' => 'division_id',
                    'label' => display('division'),
                    'rules' => 'required|is_natural_no_zero',
                ),
                array(
                    'field' => 'type',
                    'label' => display(['device', 'type']),
                    'rules' => 'required|in_list[' . strtolower(implode(',', $device_types)) . ']',
                ),
                array(
                    'field' => 'device_ip',
                    'label' => display(['device', 'ip']),
                    'rules' => 'required|valid_ip',
                ),
                array(
                    'field' => 'port',
                    'label' => display(['device', 'port']),
                    'rules' => 'required|is_natural_no_zero|greater_than[0]|less_than[65536]',
                ),
                array(
                    'field' => 'password',
                    'label' => display(['password']),
                    'rules' => 'required|max_length[10]',
                ),
                array(
                    'field' => 'status',
                    'label' => display(['device', 'status']),
                    'rules' => 'required|in_list[active,inactive]',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === false) {
                $fields = array_column($rules_config, 'field');
                $errors = [];
                foreach ($fields as $field) {
                    if ($err = form_error($field)) {
                        $errors[] = [$field, $err];
                    }
                }
                sendJson(['errors' => $errors]);
            }
            if ($this->device_model->save($this->input->post())) {
                sendJson(['success' => display(['device', 'saved', 'successfully']), 'reload' => 1]);
            } else {
                sendJson(['error' => display(['unable', 'to', 'save', 'device', 'try', 'again'])]);
            }
        }
        $data['divisions'] = $this->db->select('id, name')->order_by('name')->get('divisions')->result();
        $data['devices'] = $this->device_model->getDevices();
        $data['device_types'] = $device_types;
        $data['module'] = 'attendance';
        $data['page'] = "devices/main";
        echo Modules::run('template/layout', $data);
    }
    public function check_device_connection()
    {
        $this->permission->method('attendance_devices', 'read')->redirect();
        if ($this->input->post('id')) {
            $this->load->model('device_model');
            if ($this->device_model->check_connection($this->input->post('id'))) {
                sendJson(['success' => display(['device', 'is', 'connected'], true)]);
            } else {
                sendJson(['error' => display(['device', 'is', 'unreachable'], true)]);
            }
        }
    }
    public function delete_device($id)
    {
        $this->permission->method('attendance_devices', 'delete')->redirect();
        $this->load->model('device_model');
        if ($this->device_model->delete($id)) {
            sendJson(['success' => display(['device', 'deleted', 'successfully']), 'reload' => 1]);
        } else {
            sendJson(['error' => display(['unable', 'to', 'delete', 'device', 'try', 'again'])]);
        }
    }
    public function create_all_users_for_devices()
    {
        $this->permission->method('attendance_devices', 'create')->redirect();
        $this->bio_devices->createAllUser();
        $this->session->set_flashdata('success', display(['all', 'users', 'are', 'created', 'on', 'machines', 'by', 'their', 'division']));
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function check_emp_shift()
    {
        $id = $this->input->get('id');
        $shift = $this->db->select('*')->where('id',$id)->get('shift')->row();
        sendJson(['shift_timing' => $shift]);
    }
    public function attendance_mark_absent()
    {
        $emp_id = $this->input->post('empl_id');
        $group_no = $this->input->post('employee_group_no');
        $day = $this->input->post('employee_full_day');

        $change_status = $this->db->select('*')->where(['uid' => $emp_id, 'group_no' => $group_no, 'day' => $day, 'active' => 1])->get('attendance_history')->result();
        if (count($change_status) > 0) {
            $this->db->where(['uid' => $emp_id, 'day' => $day, 'group_no' => $group_no, 'active' => 1])->update('attendance_history', [
                'active' => 0,
            ]);
            sendJson(['success' => 'Successfully marked absent']);
        }
        else {
            sendJson(['info' => 'Already absent']);
        }
    }
}
