<?php

class Api_model extends CI_Model
{
    public function employee_by_id($hrm_id)
    {
        $result = $this->db->select('employee_id,full_name,email,business_email,status')
            ->where('hrm_id', $hrm_id)
            ->where('status', 'active')
            ->get('employee_details')->row();
        return $result;
    }

    public function registerUser($data)
    {
        $this->db->insert('users', $data);
    }
    public function checkUser($data)
    {

        $this->db->select('*');
        $this->db->from('user');
        $this->db->join('employee_details', 'user.id = employee_details.user_id', 'inner');
        $this->db->where('employee_details.email', $data['email']);
        // $this->db->where('password', md5($data['password']));
        $rec = $this->db->get();
        
        if ($rec->num_rows() > 1) {
            echo "null";
            die;
        }
        $row = $rec->row();
        
        if ($row->new_algo && password_verify($data['password'], $row->password)) {
            return $rec;
        } else if (md5($data['password']) == $row->password) {
            return $rec;
        }
        return null;
    }

    function get_empID($data){
        // $query = $this->db->where("business_email", $data["email"]);
        // $query = $this->db->get('employee_details');;
        // $query = $this->db->query("Select * from employee_details where business_email = '$data'");
        // $query = $this->db->get_where('employee_details', array('last_name' => "Razzaq"));
        $this->db->select('*');
        $this->db->where(['business_email' => $data]);
        $query = $this->db->get('employee_details');
        if($query->row()){
            return $query->row();
        }else{
            return false;
        }

    }

    public function checkLogin($data)
    {
        // $query = $this->db->query("SELECT * FROM employee_details WHERE ");
        $this->db->where("email", $data["email"]);
        $query = $this->db->get('employee_details');
        if ($query->num_rows() == 1) {
            return $query->row();
        } else {
            return false;
        }
    }
    
    public function getProfile($userId)
    {
        $this->db->select('*');
        $this->db->from('user');
        $this->db->join('employee_details', 'user.id = employee_details.user_id', 'inner');
        $this->db->where('user.id', $userId);
        $rec = $this->db->get();
        return $rec->row();
    }
    public function get_permissions($user_id)
    {
        $role_ids = array_column($this->db->select('*')->from('sec_user_access_tbl')->where('fk_user_id', $user_id)->get()->result(), 'fk_role_id');
        $checkPermission = $this->userPermission2($role_ids);
        $full_permissions = $this->full_access_permissions($role_ids);
        $permission = array();
        $permission1 = array();
        $full_perms = array();
        if ($checkPermission) {
            if (!empty($checkPermission)) {
                foreach ($checkPermission as $value) {
                    if ($value->menu_title == $value->module || !$permission[$value->module]) {
                        $permission[$value->module] = array(
                            'create' => $value->create,
                            'read' => $value->read,
                            'update' => $value->update,
                            'delete' => $value->delete,
                        );
                    }
                    $permission[$value->menu_title] = array(
                        'create' => $value->create,
                        'read' => $value->read,
                        'update' => $value->update,
                        'delete' => $value->delete,
                    );
                    $permission1[$value->menu_title] = array(
                        'create' => $value->create,
                        'read' => $value->read,
                        'update' => $value->update,
                        'delete' => $value->delete,
                    );
                    //print_r($checkPermission);exit;
                }
            }
        }
        if (!empty($full_permissions)) {
            foreach ($full_permissions as $full_permission) {
                if (in_array($full_permission->menu_title, $this->exclude_full_permission)) {
                    continue;
                }
                if (!isset($full_perms[$full_permission->module])) {
                    $full_perms[$full_permission->module] = [
                        'create' => $full_permission->create == 1,
                        'read' => $full_permission->read == 1,
                        'update' => $full_permission->update == 1,
                        'delete' => $full_permission->delete == 1,
                    ];
                }
                if ($full_permission->menu_title) {
                    $full_perms[$full_permission->menu_title] = [
                        'create' => $full_permission->create == 1,
                        'read' => $full_permission->read == 1,
                        'update' => $full_permission->update == 1,
                        'delete' => $full_permission->delete == 1,
                    ];
                }
            }
        }
        return [
            'roles' => $role_ids,
            'permission' => $permission,
            'permission1' => $permission1,
            'full_permissions' => $full_perms,
        ];
    }
    public function userPermission2($role_ids = null)
    {
        if ($role_ids) {
            return $this->db->select("
				sec_role_permission.role_id,
				sec_role_permission.menu_id,
				IF(SUM(sec_role_permission.can_create)>=1,1,0) AS 'create',
				IF(SUM(sec_role_permission.can_access)>=1,1,0) AS 'read',
				IF(SUM(sec_role_permission.can_edit)>=1,1,0) AS 'update',
				IF(SUM(sec_role_permission.can_delete)>=1,1,0) AS 'delete',
				sec_menu_item.menu_title,
				sec_menu_item.page_url,
				sec_menu_item.module
				")
                ->from('sec_role_permission')
                ->join('sec_menu_item', 'sec_menu_item.menu_id = sec_role_permission.menu_id', 'left')
                ->where_in('sec_role_permission.role_id', $role_ids)
                ->group_by('sec_role_permission.menu_id')
                ->group_start()
                ->where('can_create', 1)
                ->or_where('can_access', 1)
                ->or_where('can_edit', 1)
                ->or_where('can_delete', 1)
                ->group_end()
                ->get()
                ->result();
        } else {
            return 0;
        }
    }
    public function full_access_permissions($role_ids)
    {
        if ($role_ids) {
            return $this->db->select("
				sec_full_access_permission.module,
				sec_menu_item.menu_title,
				IF(SUM(sec_full_access_permission.can_create)>=1,1,0) AS 'create',
				IF(SUM(sec_full_access_permission.can_access)>=1,1,0) AS 'read',
				IF(SUM(sec_full_access_permission.can_edit)>=1,1,0) AS 'update',
				IF(SUM(sec_full_access_permission.can_delete)>=1,1,0) AS 'delete'
				")
                ->from('sec_full_access_permission')
                ->join('sec_menu_item', 'sec_menu_item.module = sec_full_access_permission.module', 'left')
                ->where_in('sec_full_access_permission.role_id', $role_ids)
                ->group_by('sec_menu_item.menu_title')
                ->group_start()
                ->where('can_create', 1)
                ->or_where('can_access', 1)
                ->or_where('can_edit', 1)
                ->or_where('can_delete', 1)
                ->group_end()
                ->get()
                ->result();
        } else {
            return null;
        }
    }
}
