<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Auth_Controller extends RestApi_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('api_auth');
        $this->load->model('api_model');
        // if($this->api_auth->isNotAuthenticated())
        {
            $err = array(
                'status'=>false,
                'message'=>'unauthorised',
                'data'=>[]
            );
            $this->response($err);
        }
    }

    public function register()
    {
        $username = $this->input->post('name');
        $email = $this->input->post('email');
        $password = $this->input->post('password');

        $this->form_validation->set_rules('name', 'Name', 'required');
        $this->form_validation->set_rules('email', 'Email', 'required');
        $this->form_validation->set_rules('password', 'Pasword', 'required');
        if ($this->form_validation->run()) {
            $data = array(
                'name' => $username,
                'email' => $email,
                'password' => sha1($password),
            );
            $this->api_model->registerUser($data);
            $responseData = array(
                'status' => true,
                'message' => 'Successfully Registered',
                'data' => []
            );
            return $this->response($responseData, 200);
        } else {
            $responseData = array(
                'status' => false,
                'message' => 'fill all the required fields',
                'data' => []
            );
            return $this->response($responseData);
        }
    }

    public function login()
    {

        $email = $this->input->post('email');
        $password = $this->input->post('password');

        $this->form_validation->set_rules('email', 'Email', 'required');
        $this->form_validation->set_rules('password','Pasword','required');
        if ($this->form_validation->run()) {
            // $data = array('email'=>$email,'password'=> sha1($password));
            $data = array('email'=>$email,'password'=> $password);
            
            // $loginStatus = $this->api_model->checkLogin($data);
            $loginStatus = $this->api_model->checkUser($data);
            // print_r($loginStatus->row()->user_id);
            // die;
            if ($loginStatus != false) {
                // $userId = $loginStatus->user_id;
                $userId = $loginStatus->row()->user_id;
                $bearerToken = $this->api_auth->generateToken($userId);
                $responseData = array(
                    'status' => true,
                    'message' => 'Successfully Logged In',
                    'UserRequestToken' => $bearerToken,
                    'applicationType' => 1
                );
                return $this->response($responseData, 200);
            } else {
                $responseData = array(
                    'status' => false,
                    'message' => 'Invalid Crendentials',
                    'data' => []
                );
                return $this->response($responseData);
            }
        } else {
            $responseData = array(
                'status' => false,
                'message' => 'Email Id and password is required',
                'data' => []
            );
            return $this->response($responseData);
        }
    }

}
