<?php 

class Api_Controller extends RestApi_Controller 
{
    function __construct()
    {
        parent::__construct();
        $this->load->library('api_auth');
        $this->load->model('api_model');
        $this->load->library('session');
        // if($this->api_auth->isNotAuthenticated())
        {
            $err = array(
                'status'=>false,
                'message'=>'unauthorised',
                'data'=>[]
            );
            $this->response($err);
        }
    }

    function profile()
    {
         $userId = $this->api_auth->getUserId();
         $profileData = $this->api_model->getProfile($userId);
        $image = null;
        if (!empty($profileData->picture)) {
            $image = 'employee/employees/image';
        }
        if (!empty($profileData->image)) {
            $image = $profileData->image;
        }
        $permission = $this->api_model->get_permissions($profileData->id);

        $sData = array(
            'isLogIn' => true,
            'isAdmin' => (($profileData->is_admin == 1) ? true : false),
            'user_type' => $profileData->is_admin,
            'id' => $profileData->id,
            'client_id' => 1,
            'fullname' => $profileData->fullname,
            'user_level' => $profileData->user_level,
            'email' => $profileData->email,
            'image' => $image,
            'last_login' => $profileData->last_login,
            'last_logout' => $profileData->last_logout,
            'ip_address' => $profileData->ip_address,
            'employee_id' => $profileData->employee_id,
            'shift' => $profileData->shift,
            'dept_id' => $profileData->dept_id,
            'division_id' => $profileData->division_id,
            'division_name' => $profileData->app_name,
            'division_logo' => $profileData->app_logo,
            'dept_name' => $profileData->department_name,
            'designation' => $profileData->designation,
            'position_id' => $profileData->pos_id,
            'hrm_id' => $profileData->hrm_id,
            'first_name' => $profileData->first_name,
            'last_name' => $profileData->last_name,
            'supervisor' => $profileData->is_super_visor,
            'direct_supervisor' => $profileData->super_visor_id,
            'indirect_supervisor' => $profileData->indirect_super_visor_id,
            'permission' => json_encode(@$permission['permission']),
            'label_permission' => json_encode(@$permission['permission1']),
            'full_permissions' => json_encode(@$permission['full_permissions']),
            'roles' => $permission['roles'],
            'loaded' => date('Y-m-d H:i:s'),
        );
        $this->session->set_userdata($sData);
        $err = array(
            'status'=>true,
            'message'=>'successfully fetched profile',
            'data'=>$sData
        );
        // $this->response($err,200);
        redirect('dashboard/home');
    }

    function email_employee_id(){
        $userId = $this->api_auth->getUserId();
        $bussiness_email =$this->input->post('bussiness_email');
        $profileData = $this->api_model->get_empID($bussiness_email);
        if($profileData){
            $err = array(
                'status'=> 'success',
                'status_code' => 302,
                'result'=> [
                    'hrm_id' => $profileData->hrm_id,
                    'full_name' => $profileData->full_name
                    ]
            );
        }else{
            $err = array(
                'status'=> 'failure',
                'status_code' => 404,
                'message'=> 'Employee ID not found against given employee bussiness email',
            );
        }
        $this->response($err,$err['status_code']);
    }

}
