<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;

class OauthMailer
{
    private $mail_from = '';
    private $client;
    private $mail;
    private $logpath = __DIR__ . '/logs/mail/';
    public function __construct(&$client)
    {
        $this->client = $client;
        $this->mail = new PHPMailer();

        $this->mail->SMTPDebug = SMTP::DEBUG_OFF;
        $this->mail->Debugoutput = function($msg, $level) {
            $this->log($msg, $level);
        };

        $this->mail->AuthType = 'XOAUTH2';
        $this->mail->XMailer = ' ';
        if (!is_dir($this->logpath)) {
            mkdir($this->logpath);
        }

        $this->mail_from = $this->client->userinfo()->getEmail();
    }
    public function config($config = 0)
    {
        $this->mail->isSMTP(); //Send using SMTP
        $this->mail->SMTPAuth = true; //Enable SMTP authentication
        $this->mail->AuthType = 'XOAUTH2';

        $this->mail->Host = 'smtp.gmail.com';
        $this->mail->Port = 465;
        $this->mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;

        $this->mail->setOAuth($this->client->mail_oauth());

        $this->mail->isHTML(true);
        return $this;
    }
    public function send($to, $subject, $body, $cc = [], $bcc = [], $attachments = [])
    {
        $this->mail->setFrom($this->mail_from, $this->client->userinfo()->getName());
        if (is_array($cc)) {
            foreach ($cc as $ccc) {
                $this->mail->addCC($ccc);
            }
        } else {
            $this->mail->addCC($cc);
        }

        if (is_array($bcc)) {
            foreach ($bcc as $bccc) {
                $this->mail->addBCC($bccc);
            }
        } else {
            $this->mail->addBCC($bcc);
        }

        if (is_array($to)) {
            foreach ($to as $tat) {
                $this->mail->addAddress($tat);
            }
        } else {
            $this->mail->addAddress($to);
        }

        foreach ($attachments as $key => $attachment) {
            $this->mail->AddAttachment($attachment, is_numeric($key) ? '' : $key);
        }

        $this->mail->Subject = $subject;
        $this->mail->Body = $body;
        try {
            $res = $this->mail->send();
            if ($res) {
                $this->log('Email sent successfully');
                return ['status' => 'success'];
            } else {
                throw new Exception($this->mail->ErrorInfo);
            }
        } catch (\Throwable $e) {
            $this->log($e->getMessage());
            return ['status' => 'error', 'message' => $e->getMessage()];
        } finally {
            $this->mail = new PHPMailer();
        }
    }
    private function log($message, $level = null)
    {
        @file_put_contents(
            $this->logpath . date('Ymd') . '.log',
            $level ? sprintf("%s| [%s] %s\n", date('c'), $level, $message) : sprintf("%s| %s\n", date('c'), $message),
            FILE_APPEND
        );
    }
}
