<?php
class Options
{
    private $CI;
    private $table = 'system_options';
    public function __construct()
    {
        $this->CI = &get_instance();
    }
    public function get_system($name)
    {
        $query = $this->CI->db->select('value')->where(['option_key' => $name, 'type' => 'system'])->get($this->table);
        if ($query) {
            $data = $query->row();
            if ($data) {
                return $data->value;
            }
        }
        return false;
    }
    public function set_system($name, $value)
    {
        $exists = $this->CI->db->where(['option_key' => $name, 'type' => 'system'])->count_all_results($this->table);

        if ($exists) {
            return $this->CI->db->where(['option_key' => $name, 'type' => 'system'])->update($this->table, [
                'value' => $value,
            ]);
        } else {
            return $this->CI->db->insert($this->table, [
                'option_key' => $name,
                'value' => $value,
                'type' => 'system',
            ]);
        }
    }
    public function delete_system($name)
    {
        return $this->CI->db->where(['option_key' => $name, 'type' => 'system'])->delete($this->table);
    }
    public function get_user($name, $user_id = null)
    {
        if (!$user_id) {
            $user_id = $this->CI->session->userdata('id');
        }
        $query = $this->CI->db->select('value')->where(['option_key' => $name, 'type' => 'user', 'user_id' => $user_id])->get($this->table);
        if ($query) {
            $data = $query->row();
            if ($data) {
                return $data->value;
            }
        }
        return false;
    }
    public function get_all_user($user_id = null)
    {
        if (!$user_id) {
            $user_id = $this->CI->session->userdata('id');
        }
        $query = $this->CI->db->select('option_key, value')->where(['type' => 'user', 'user_id' => $user_id])->get($this->table);

        $opts = [];

        if ($query) {
            $recs = $query->result_array();
            foreach ($recs as $opt) {
                $opts[$opt['option_key']] = $opt['value'];
            }
        }

        return $opts;
    }
    public function set_user($name, $value, $user_id = null)
    {
        if (!$user_id) {
            $user_id = $this->CI->session->userdata('id');
        }
        $exists = $this->CI->db->where(['option_key' => $name, 'type' => 'user', 'user_id' => $user_id])->count_all_results($this->table);

        if ($exists) {
            return $this->CI->db->where(['option_key' => $name, 'type' => 'user', 'user_id' => $user_id])->update($this->table, [
                'value' => $value,
            ]);
        } else {
            return $this->CI->db->insert($this->table, [
                'option_key' => $name,
                'value' => $value,
                'user_id' => $user_id,
                'type' => 'user',
            ]);
        }
    }
}
