<?php
class Mysql_type
{
    const TYPE_DECIMAL = 0;
    const TYPE_BYTE = 1;
    const TYPE_INT16 = 2;
    const TYPE_INT32 = 3;
    const TYPE_FLOAT = 4;
    const TYPE_DOUBLE = 5;
    const TYPE_TIMESTAMP = 7;
    const TYPE_INT64 = 8;
    const TYPE_INT24 = 9;
    const TYPE_NEWDECIMAL = 246;
    const TYPE_UBYTE = 501;
    const TYPE_UINT16 = 502;
    const TYPE_UINT32 = 503;
    const TYPE_UINT64 = 508;
    const TYPE_UINT24 = 509;

    const TYPE_DATE = 10;
    const TYPE_TIME = 11;
    const TYPE_DATETIME = 12;
    const TYPE_YEAR = 13;
    const TYPE_NEWDATE = 14;

    const TYPE_VARSTRING = 15;
    const TYPE_BIT = 16;
    const TYPE_JSON = 245;
    const TYPE_ENUM = 247;
    const TYPE_SET = 248;
    const TYPE_TINYBLOB = 249;
    const TYPE_MEDIUMBLOB = 250;
    const TYPE_LONGBLOB = 251;
    const TYPE_BLOB = 252;
    const TYPE_VARCHAR = 253;
    const TYPE_STRING = 254;
    const TYPE_GEOMETRY = 255;
    const TYPE_TINYTEXT = 749;
    const TYPE_MEDIUMTEXT = 750;
    const TYPE_LONGTEXT = 751;
    const TYPE_TEXT = 752;
    const TYPE_VARBINARY = 753;
    const TYPE_BINARY = 754;
    const TYPE_GUID = 854;

    //custom
    const TYPE_URL = 888;

    const IS_INT = 0;
    const IS_STRING = 1;
    const IS_DATETIME = 2;
    const IS_DATE = 3;
    const IS_TIME = 4;
    const IS_URL = 5;

    public function check_type($type)
    {
        if (is_numeric($type)) {
            return $this->check_numeric_type($type);
        } else {
            return $this->check_string_type($type);
        }
    }
    private function check_numeric_type($num)
    {
        $num = intval($num);
        if (in_array($num, [self::TYPE_DECIMAL, self::TYPE_BYTE, self::TYPE_INT16, self::TYPE_INT32, self::TYPE_FLOAT, self::TYPE_DOUBLE, self::TYPE_TIMESTAMP, self::TYPE_INT64, self::TYPE_INT24, self::TYPE_NEWDECIMAL, self::TYPE_UBYTE, self::TYPE_UINT16, self::TYPE_UINT32, self::TYPE_UINT64, self::TYPE_UINT24])) {
            return self::IS_INT;
        }
        if (in_array($num, [self::TYPE_VARSTRING, self::TYPE_BIT, self::TYPE_JSON, self::TYPE_ENUM, self::TYPE_SET, self::TYPE_TINYBLOB, self::TYPE_MEDIUMBLOB, self::TYPE_LONGBLOB, self::TYPE_BLOB, self::TYPE_VARCHAR, self::TYPE_STRING, self::TYPE_GEOMETRY, self::TYPE_TINYTEXT, self::TYPE_MEDIUMTEXT, self::TYPE_LONGTEXT, self::TYPE_TEXT, self::TYPE_VARBINARY, self::TYPE_BINARY, self::TYPE_GUID])) {
            return self::IS_STRING;
        }
        if (in_array($num, [self::TYPE_DATE, self::TYPE_YEAR, self::TYPE_NEWDATE])) {
            return self::IS_DATE;
        }
        if ($num == self::TYPE_TIME) {
            return self::IS_TIME;
        }
        if ($num == self::TYPE_DATETIME) {
            return self::IS_DATETIME;
        }
        if ($num == self::TYPE_URL) {
            return self::IS_URL;
        }
        return $num;
    }
    private function check_string_type($str)
    {
        $str = strtolower($str);
        if (in_array($str, ['decimal', 'byte', 'int16', 'int32', 'float', 'double', 'timestamp', 'int64', 'int24', 'newdecimal', 'ubyte', 'uint16', 'uint32', 'uint64', 'uint24'])) {
            return self::IS_INT;
        }
        if (in_array($str, ['varstring', 'bit', 'json', 'enum', 'set', 'tinyblob', 'mediumblob', 'longblob', 'blob', 'varchar', 'char', 'string', 'geometry', 'tinytext', 'mediumtext', 'longtext', 'text', 'varbinary', 'binary', 'guid'])) {
            return self::IS_STRING;
        }
        if (in_array($str, ['date', 'year', 'newdate'])) {
            return self::IS_DATE;
        }
        if ($str == 'time') {
            return self::IS_TIME;
        }
        if ($str == 'datetime') {
            return self::IS_DATETIME;
        }
        if ($str == 'url') {
            return self::IS_URL;
        }
        return $str;
    }
}
