<?php
class MyNotifier
{
    private $CI;
    private $config;
    private $_users = [];
    private $lang = [];
    private $_global = false;
    private $roles = [
        'recruitment_manager' => 'review_requisition_list',
        'requisition_reviewer' => 'create_ad_from_requisition',
        'hr' => 'receive_hr_notifications',
        'admin' => 'receive_admin_notifications',
        'it' => 'receive_it_notifications',
        'social_media' => 'receive_social_notifications',
        'cfo' => 'receive_cfo_notifications',
        'birthdays' => 'receive_birthday_notifications',
        'anniversary' => 'receive_anniversary_notifications',
    ];
    public function __construct()
    {
        $this->CI = &get_instance();
        $this->config = $this->CI->load->config('department_ids', true, true);
        $this->lang = $this->CI->lang->load('notifier_lang', true);
    }
    function global () {
        $this->_global = true;
        return $this;
    }
    public function department($depts, $division_id = null)
    {
        if ($this->_global) {
            return $this;
        }
        if (!is_array($depts)) {
            $depts = [$depts];
        }
        foreach ($depts as $dept) {
            $this->user($this->get_users_by_dept($dept, $division_id));
        }
        return $this;
    }
    public function user($user)
    {
        if ($this->_global) {
            return $this;
        }
        if (!is_array($user)) {
            $user = [$user];
        }
        $this->_users = array_merge($user, $this->_users);
        $this->_users = array_unique($this->_users);
        return $this;
    }
    public function role($roles, $division_id = null)
    {
        if (!is_array($roles)) {
            $roles = [$roles];
        }
        $menu_titles = [];
        foreach ($roles as $role) {
            $role = strtolower(str_replace([' ', '-'], '_', $role));
            $menu_titles[] = $this->roles[$role];
        }
        return $this->user($this->get_users_by_role_permission($menu_titles, $division_id));
    }
    public function get_all_users()
    {
        return $this->_users;
    }
    public function employee($employee_id)
    {
        if (!is_array($employee_id)) {
            $employee_id = [$employee_id];
        }
        return $this->user($this->get_user_by_employee_id($employee_id));
    }
    public function send($text, $url = null)
    {
        $this->_users = array_filter($this->_users, function ($user) {
            return !empty($user);
        });
        if (is_array($text)) {
            $_text_str = array_shift($text);
            $_translation = $this->CI->lang->line($_text_str, false);
            if ($_translation) {
                $text = vsprintf($_translation, $text);
            }
        } else {
            $_translation = $this->CI->lang->line($text, false);
            if ($_translation) {
                $text = $_translation;
            }
        }
        $res = $this->write_to_db($text, $url, $this->_users, $this->_global);
        if ($res) {
            $this->clear();
        }
        return $res;
    }
    public function round_robin_role($roles, $last_userId)
    {
        if (empty($last_userId)) {
            $last_userId = 0;
        }
        $this->role($roles);
        $this->sort();
        $ret_id = null;
        foreach ($this->_users as $user) {
            if ($user > $last_userId) {
                $ret_id = $user;
                break;
            }
        }
        if (empty($ret_id)) {
            $ret_id = $this->_users[0];
        }
        $this->clear();
        return $ret_id;
    }
    public function clear()
    {
        $this->_users = [];
        $this->_global = false;
    }
    private function sort()
    {
        sort($this->_users);
    }
    private function get_users_by_role_permission($role_permission, $division_id = null)
    {
        if (!is_array($role_permission)) {
            $role_permission = [$role_permission];
        }
        $this->CI->db->select('user.id')
            ->from('sec_role_permission')
            ->join('sec_menu_item', 'sec_role_permission.menu_id = sec_menu_item.menu_id', 'left')
            ->join('sec_user_access_tbl', 'sec_user_access_tbl.fk_role_id = sec_role_permission.role_id', 'left')
            ->join('user', 'sec_user_access_tbl.fk_user_id=user.id', 'left')
            ->join('employee_history', 'user.email=employee_history.email', 'left')
            ->group_start()
            ->or_where([
                'sec_role_permission.can_access' => 1,
                'sec_role_permission.can_create' => 1,
                'sec_role_permission.can_edit' => 1,
                'sec_role_permission.can_delete' => 1,
            ])
            ->group_end();
        if (!empty($division_id)) {
            $this->CI->db->where('employee_history.division_id', $division_id);
        }
        $recs = $this->CI->db
            ->where('employee_history.status', 'active')
            ->where_in('sec_menu_item.menu_title', $role_permission)
            ->order_by('sec_user_access_tbl.fk_user_id', 'asc')
            ->get()
            ->result_array();

        $this->CI->db->select('sec_user_access_tbl.fk_user_id as id')
            ->from('sec_menu_item')
            ->join('sec_full_access_permission', 'sec_menu_item.module = sec_full_access_permission.module', 'left')
            ->join('sec_user_access_tbl', 'sec_full_access_permission.role_id = sec_user_access_tbl.fk_role_id', 'left')
            ->join('user', 'sec_user_access_tbl.fk_user_id=user.id', 'left')
            ->join('employee_history', 'user.email=employee_history.email', 'left')
            ->group_start()
            ->or_where([
                'sec_full_access_permission.can_access' => 1,
                'sec_full_access_permission.can_create' => 1,
                'sec_full_access_permission.can_edit' => 1,
                'sec_full_access_permission.can_delete' => 1,
            ])
            ->group_end();
        if (!empty($division_id)) {
            $this->CI->db->where('employee_history.division_id', $division_id);
        }
        $recs = array_merge($recs, $this->CI->db
                ->where('employee_history.status', 'active')
                ->where_in('sec_menu_item.menu_title', $role_permission)
                ->order_by('sec_user_access_tbl.fk_user_id', 'asc')
                ->get()
                ->result_array());
        return array_unique(array_filter(array_column($recs, 'id')));
    }
    private function get_user_by_employee_id($employee_ids)
    {
        if (!is_array($employee_ids)) {
            $employee_ids = [$employee_ids];
        }
        $recs = $this->CI->db->select('user.id')
            ->from('employee_history')
            ->join('user', 'employee_history.email = user.email', 'left')
            ->where_in('employee_history.employee_id', $employee_ids)
            ->get()
            ->result_array();
        return array_column($recs, 'id');
    }
    private function get_department_id($name)
    {
        return $this->config[strtolower($name)];
    }
    private function get_users_by_dept($dept, $division_id = null)
    {
        $this->role($dept, $division_id);
        return $dept == 'hr' ? [1] : [];
    }
    private function write_to_db($text, $url, $users = [], $global = false)
    {
        if (!$global && empty($users)) {
            return false;
        }
        $this->CI->db->trans_begin();
        $res = $this->CI->db->insert('notification', [
            'text' => $text,
            'url' => $url,
            'date' => date('Y-m-d H:i:s'),
            'created_by' => $this->CI->session->userdata('id') ?? 0,
            'global' => $global,
        ]);
        if ($res && !$global) {
            $res = $this->CI->db->insert_id();
            foreach ($users as $user) {
                $this->CI->db->insert('rel_notification_user', [
                    'notification_id' => $res,
                    'user_id' => $user,
                ]);
            }
        } else {
            $res = $this->CI->db->insert_id();
            $user_ids = $this->CI->db->select('id')->get('user')->result();
            foreach ($user_ids as $user) {
                $this->CI->db->insert('rel_notification_user', [
                    'notification_id' => $res,
                    'user_id' => $user->id,
                ]);
            }
        }
        if ($this->CI->db->trans_status() === false) {
            $this->CI->db->trans_rollback();
            return false;
        } else {
            $this->CI->db->trans_commit();
            return true;
        }
    }
}
