<?php
use Google\Client;
use Google\Service\Drive;
use Google\Service\Forms;
use Google\Service\Oauth2;

class GoogleClient
{
    private $token_string = 'system.form.tkn';
    private $CI = null;
    public $client = null;
    public $redirectUri = null;

    public function __construct($uri = null, $client = 'form')
    {
        $this->CI = &get_instance();
        $this->client = new Client();

        $this->client->setAuthConfig(WRITEPATH . '/gtok/s');
        $this->client->setAccessType('offline');
        $this->client->setPrompt('select_account consent');

        if ($client == 'form') {
            $this->token_string = 'system.form.tkn';
            $this->client->setScopes([
                \Google\Service\Drive::DRIVE,
                \Google\Service\Oauth2::USERINFO_PROFILE,
                \Google\Service\Oauth2::USERINFO_EMAIL,
            ]);
        } elseif ($client == 'form_email') {
            $this->token_string = 'system.form.email.tkn';
            $this->client->setScopes([
                \Google\Service\Oauth2::USERINFO_PROFILE,
                \Google\Service\Oauth2::USERINFO_EMAIL,
                \Google\Service\Gmail::MAIL_GOOGLE_COM,
            ]);
        } elseif ($client == 'drive') {
            $this->token_string = 'system.drive.tkn';
            $this->client->setScopes([
                \Google\Service\Drive::DRIVE,
                \Google\Service\Oauth2::USERINFO_PROFILE,
                \Google\Service\Oauth2::USERINFO_EMAIL,
            ]);
        }
        if ($uri) {
            $this->client->setRedirectUri($uri);
        }

        if ($token = $this->CI->options->get_system($this->token_string)) {
            $accessToken = json_decode($this->CI->encryption->decrypt($token), true);
            $this->client->setAccessToken($accessToken);
        }
    }
    public function isLoggedIn()
    {
        return !!$this->CI->options->get_system($this->token_string);
    }
    public function auth()
    {
        if ($this->client->isAccessTokenExpired()) {
            if ($this->client->getRefreshToken()) {
                try {
                $this->client->fetchAccessTokenWithRefreshToken($this->client->getRefreshToken());
                } catch (\Throwable $e) {
                    $this->log($e->getMessage());
                    return false;
                }
            } else {
                $this->redirectUri = $this->client->createAuthUrl();
                return false;
            }
        }
        return true;
    }
    public function unauth()
    {
        return $this->CI->options->delete_system($this->token_string);
    }
    public function saveFromAuthCode($code)
    {
        $accessToken = $this->client->fetchAccessTokenWithAuthCode($code);

        if (array_key_exists('error', $accessToken)) {
            $this->log(join(', ', $accessToken));
            return false;
        }

        $this->client->setAccessToken($accessToken);

        $this->CI->options->set_system($this->token_string, $this->CI->encryption->encrypt(json_encode($this->client->getAccessToken())));
        return true;
    }
    public function getDriveInstance()
    {
        return new Drive($this->client);
    }
    public function getFormInstance()
    {
        return new Forms($this->client);
    }
    public function userinfo()
    {
        return (new Oauth2($this->client))->userinfo->get();
    }
    public function mail_oauth()
    {
        return new MainAuthTokenProvider($this->userinfo()->getEmail(), $this->client->getAccessToken()['access_token']);
    }
    public function log($message)
    {
        log_message('error', $message);
    }
}
