<?php

/**
 * Class library made to freeze HTML table columns like in MS Excel
 * 
 * @author Ahmed Raza ahmed.raza@proglobaltechnologies.com
 */
class FixedTable
{
    /**
     * Generate fixed column css
     * 
     * ```
     * Example 1: $fixed->left([10,30,40]);
     * Example 2: $fixed->left([10,30,40], '#mytable');
     * Example 3: $fixed->left([10,30,40], null, '.nav-tabs');
     * ```
     * 
     * @param array $columns width array
     * @param string $table Unique table selector
     * @param string $parent Parent element of table 
     */
    function left($columns, $table = null, $parent = null)
    {
        $sum = 0;?>
        <style>
        <?= $parent ?> table<?= $table ?> {
            border-collapse: separate;
        }
        <?= $parent ?> table<?= $table ?> thead th:nth-child(n+1):nth-child(-n+<?= count($columns) ?>) {
            position: sticky;
            background-color: white;
            z-index: 3;
        }
        <?= $parent ?> table<?= $table ?> tbody th:nth-child(n+1):nth-child(-n+<?= count($columns) ?>),
        <?= $parent ?> table<?= $table ?> tbody td:nth-child(n+1):nth-child(-n+<?= count($columns) ?>){
            position: sticky;
            z-index: 2;
        }
        <?= $parent ?> table<?= $table ?> tbody tr:not(.selected-row) th:nth-child(n+1):nth-child(-n+<?= count($columns) ?>),
        <?= $parent ?> table<?= $table ?> tbody tr:not(.selected-row) td:nth-child(n+1):nth-child(-n+<?= count($columns) ?>){
            background-color: white;
        }
        <?= $parent ?> table<?= $table ?> tbody tr.selected-row th:nth-child(n+1):nth-child(-n+<?= count($columns) ?>),
        <?= $parent ?> table<?= $table ?> tbody tr.selected-row td:nth-child(n+1):nth-child(-n+<?= count($columns) ?>){
            background-color: #ecd;
        }
        <?= $parent ?> table<?= $table ?> tbody th:nth-child(n+1):nth-child(-n+<?= count($columns) ?>):hover,
        <?= $parent ?> table<?= $table ?> tbody td:nth-child(n+1):nth-child(-n+<?= count($columns) ?>):hover{
            background-color: #eee;
        }
        <?php foreach ($columns as $key => $value): ?>
            <?= $parent ?> table<?= $table ?> thead th:nth-child(<?= $key + 1 ?>),
            <?= $parent ?> table<?= $table ?> tbody th:nth-child(<?= $key + 1 ?>),
            <?= $parent ?> table<?= $table ?> tbody td:nth-child(<?= $key + 1 ?>) {
            min-width: <?= $value ?>px;
            left: <?= $sum ?>px;
        }
        <?php
        $sum += $value;
        endforeach;
        echo '</style>';
    }
    
    /**
     * Generate fixed header css
     * 
     * ```
     * Example 1: $fixed->top([10,30,40]);
     * Example 2: $fixed->top([10,30,40], '#mytable');
     * Example 3: $fixed->top([10,30,40], null, '.nav-tabs');
     * ```
     * 
     * @param array $rows width array
     * @param string $table Unique table selector
     * @param string $parent Parent element of table 
     */
    public function top($rows = [0], $table = null, $parent = null)
    {
        $sum = 0; ?>
        <style>
        <?= $parent ?> .table-responsive {
            min-height: 30vh;
            max-height: 90vh;
        }
        <?= $parent ?> table<?= $table ?> thead th {
            background: white;
            position: sticky;
            border-top: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
        }
        <?php foreach ($rows as $key => $value):?>
            <?= $parent ?> table<?= $table ?> thead th {
                top: <?= $sum ?>px;
                <?php if($value > 0): ?>
                min-height: <?= $value ?>px;
                <?php endif?>
            }
        <?php
        $sum += $value;
        endforeach;
        echo '</style>';
    }
}