<?php

require_once FCPATH . 'vendor/autoload.php';

use \PhpOffice\PhpWord\IOFactory;
use \PhpOffice\PhpWord\Settings;
use \PhpOffice\PhpWord\Writer\HTML;
use \PhpOffice\PhpWord\Writer\PDF;

class Doc_reader
{
    public function read($path)
    {
        $data = IOFactory::load($path);
        return $data;
    }
    public function pdf($obj, $filname)
    {
        Settings::setPdfRendererPath(FCPATH . 'vendor/mpdf/mpdf');
        Settings::setPdfRendererName(Settings::PDF_RENDERER_MPDF);
        $htmlWriter = new PDF($obj);
        $htmlWriter->save($filname);
    }
    public function html($obj, $filname)
    {
        $htmlWriter = new HTML($obj);
        $htmlWriter->save($filname);
    }
    public function convert_to_pdf($path, $filname)
    {
        return $this->pdf($this->read($path), $filname);
    }
    public function convert_to_html($path, $filname)
    {
        return $this->html($this->read($path), $filname);
    }
}
