<?php
require_once APPPATH . 'libraries/biomatric_devices/MyZK.php';
require_once APPPATH . 'libraries/biomatric_devices/BioDeviceInterface.php';

class Bio_devices
{
    private $devices = null;
    private $CI = null;
    public function __construct()
    {
        $this->CI = &get_instance();
        $config = $this->CI->db->where([
            'active' => 1,
        ])
            ->get('deviceinfo')
            ->result();
        if (!$config) {
            return;
        }
        foreach ($config as $cfg) {
            if (!isset($this->devices[$cfg->division_id])) {
                $this->devices[$cfg->division_id] = [];
            }
            $this->devices[$cfg->division_id][$cfg->id] = $this->getInstanceFromType($cfg->type, $cfg->device_ip, $cfg->port, $cfg->password);
        }
    }
    public function getInstanceFromType($type, $ip, $port, $password)
    {
        switch ($type) {
            case 'zkteco':{
                    return new MyZK($ip, $port, $this->CI->encryption->decrypt($password));
                }
        }
        return null;
    }
    public function connect($division_id = null)
    {
        $connected = true;
        if ($division_id && $this->devices[$division_id]) {
            foreach ($this->devices[$division_id] as $id => &$device) {
                $connected = $connected && $device->connect();
            }
        } else {
            foreach ($this->devices as $division_id => &$devices) {
                foreach ($devices as $id => &$device) {
                    $connected = $connected && $device->connect();
                }
            }
        }
        return $connected;
    }
    public function isLive($division_id = null)
    {
        if (!$this->devices || !$this->devices[$division_id]) {
            return false;
        }
        $connected = false;
        if ($division_id && $this->devices[$division_id]) {
            foreach ($this->devices[$division_id] as $id => &$device) {
                if (!$device->connect()) {
                    continue;
                }
                return true;
            }
        } else {
            foreach ($this->devices as $division_id => &$devices) {
                foreach ($devices as $id => &$device) {
                    if (!$device->connect()) {
                        continue;
                    }
                    $connected = $connected && $device->isLive();
                }
            }
        }
        return $connected;
    }
    public function getUserByHrmId($hrm_id, $division_id = null)
    {
        if (!$this->devices) {
            return null;
        }
        if ($division_id && $this->devices[$division_id]) {
            foreach ($this->devices[$division_id] as $id => &$device) {
                if (!$device->connect()) {
                    continue;
                }
                $user = $device->getUserByHrmId($hrm_id);
                if ($user) {
                    return $user;
                }
            }
        } else {
            foreach ($this->devices as $division_id => &$devices) {
                foreach ($devices as $id => &$device) {
                    if (!$device->connect()) {
                        continue;
                    }
                    $user = $device->getUserByHrmId($hrm_id);
                    if ($user) {
                        return $user;
                    }
                }
            }
        }
    }
    public function UserExistsAll($hrm_id, $division_id = null)
    {
        if (!$this->devices) {
            return null;
        }
        $exists = true;
        $machine_on = 0;
        $devices = [];
        if ($division_id && $this->devices[$division_id]) {
            $devices = &$this->devices[$division_id];
        } else {
            foreach ($this->devices as &$_devices) {
                $devices = array_merge($devices, $_devices);
            }
        }
        foreach ($devices as $id => &$device) {
            if (!$device->connect()) {
                continue;
            }
            $machine_on++;
            $user = $device->getUserByHrmId($hrm_id);
            if ($user) {
                $exists = $exists && true;
            } else {
                return false;
            }
        }
        return $machine_on > 0 ? $exists : false;
    }
    public function isUserEnrolled($hrm_id, $division_id): bool
    {
        if (!$this->devices) {
            return false;
        }
        if ($this->devices[$division_id]) {
            foreach ($this->devices[$division_id] as $id => &$device) {
                if (!$device->connect()) {
                    continue;
                }
                return $device->isUserEnrolled($hrm_id);
            }
        }
        return false;
    }
    public function createUser($employee_id, $pin = '1234')
    {
        $employee = $this->CI->db->select('employee_id, division_id, hrm_id, first_name, last_name')
            ->where(['employee_id' => $employee_id])
            ->get('employee_history')->row();
        if ($employee->division_id && $this->devices[$employee->division_id]) {
            foreach ($this->devices[$employee->division_id] as $id => &$device) {
                if (!$device->connect()) {
                    continue;
                }
                $device->disableDevice();
                $name = $employee->first_name . ' ' . $employee->last_name;
                if (strlen($name) > 15) {
                    $name = $employee->first_name;
                }
                $device->createUser($employee->employee_id, $employee->hrm_id, $name, $pin);
                $device->enableDevice();
            }
        }
    }
    public function removeUser($employee_id)
    {
        $employee = $this->CI->db->select('employee_id, hrm_id')
            ->where(['employee_id' => $employee_id])
            ->get('employee_history')->row();

        foreach ($this->devices as $division_id => &$devices) {
            foreach ($devices as $id => &$device) {
                if (!$device->connect()) {
                    continue;
                }
                $device->disableDevice();
                $device->removeUser($employee->employee_id, $employee->hrm_id);
                $device->enableDevice();
            }
        }
    }
    public function createAllUser()
    {
        foreach ($this->devices as $division_id => &$devices) {
            foreach ($devices as $id => &$device) {
                if (!$device->connect()) {
                    continue;
                }
                $enrolled_employees = $device->getUsers();
                $separated_employees = $this->CI->db->select('employee_id, division_id, hrm_id, first_name, last_name')
                    ->where(['division_id' => $division_id])
                    ->where_in('hrm_id', array_column($enrolled_employees, 'hrm_id'))
                    ->where_in('status', ['released', 'terminated', 'resigned', 'not-joined'])
                    ->get('employee_history')->result();
                foreach ($separated_employees as $employee) {
                    $device->removeUser($employee->employee_id, $employee->hrm_id);
                }
                $employees = $this->CI->db->select('employee_id, division_id, hrm_id, first_name, last_name')
                    ->where(['division_id' => $division_id])
                    ->where_not_in('hrm_id', array_column($enrolled_employees, 'hrm_id'))
                    ->where_in('status', ['on-hold', 'active'])
                    ->get('employee_history')->result();
                $device->disableDevice();
                foreach ($employees as $employee) {
                    $name = $employee->first_name . ' ' . $employee->last_name;
                    if (strlen($name) > 15) {
                        $name = $employee->first_name;
                    }
                    
                    $pin = random_string('nozero', 4);
                    $device->createUser($employee->employee_id, $employee->hrm_id, $name, $pin, $employee->employee_id == 1 ? 'admin' : 'user');
                }
                $device->enableDevice();
            }
        }
    }
    public function getDevices()
    {
        return $this->devices;
    }
    public function syncDevicesTime()
    {
        foreach ($this->devices as $division_id => &$devices) {
            foreach ($devices as $id => &$device) {
                if (!$device->connect()) {
                    continue;
                }
                $machine_time = $device->getTime();
                if ((time() - $machine_time) >= 60) {
                    $device->disableDevice();
                    $device->setTime(time());
                    $device->enableDevice();
                }
            }
        }
    }
}
