<?php
class ActivityLogger
{
    private $CI;
    private $db_name;
    private $_current_emp;
    private $_current_user;
    private $_current_shift;
    private $_current_candidate;
    private $_current_job;
    private $_current_division;
    private $_current_department;
    private $_current_payroll;
    private $_url;
    public function __construct($lang_file = 'activity_log', $database = 'employee_update_log')
    {
        $this->CI = &get_instance();
        $this->CI->lang->load($lang_file);
        $this->db_name = $database;
        $this->_current_emp = 0;
        $this->_current_user = 0;
        $this->_current_shift = 0;
        $this->_current_candidate = 0;
        $this->_current_job = 0;
        $this->_current_division = 0;
        $this->_current_department = 0;
        $this->_current_payroll = 0;
        $this->_url = null;
    }
    public function set_db($db)
    {
        $this->db_name = $db;
    }
    public function set_employee($id)
    {
        $this->_current_emp = $id;
        return $this;
    }
    public function set_user($id)
    {
        $this->_current_user = $id;
        return $this;
    }
    public function set_shift($id)
    {
        $this->_current_shift = $id;
        return $this;
    }
    public function set_candidate($id)
    {
        $this->_current_candidate = $id;
        return $this;
    }
    public function set_job($id)
    {
        $this->_current_job = $id;
        return $this;
    }
    public function set_division($id)
    {
        $this->_current_division = $id;
        return $this;
    }
    public function set_department($id)
    {
        $this->_current_department = $id;
        return $this;
    }
    public function set_payroll($id)
    {
        $this->_current_payroll = $id;
        return $this;
    }
    public function set_url($url)
    {
        $this->_url = $url;
        return $this;
    }
    private function url()
    {
        return empty($this->_url) ? str_replace(base_url(), '', $_SERVER['HTTP_REFERER']) : $this->_url;
    }
    private function employee()
    {
        if (empty($this->_current_emp) && empty($this->_current_user)) {
            return [];
        }
        $select = 'employee_history.first_name, employee_history.last_name, employee_history.hrm_id';
        if (!empty($this->_current_emp)) {
            $this->CI->db->where('employee_history.employee_id', $this->_current_emp);
        } elseif (!empty($this->_current_user)) {
            $this->CI->db->join('user', 'employee_history.email=user.email', 'right')
                ->where('user.id', $this->_current_user);
            $select .= ', user.firstname as user_first_name, user.lastname as user_last_name, user.id as user_id';
        }
        $emp_rec = $this->CI->db->select($select)
            ->get('employee_history')->row();
        if (empty($emp_rec)) {
            return [];
        }
        return [
            'name' => sprintf(
                '%s %s (%s)',
                empty($emp_rec->first_name) ? $emp_rec->user_first_name : $emp_rec->first_name,
                empty($emp_rec->last_name) ? $emp_rec->user_last_name : $emp_rec->last_name,
                empty($emp_rec->hrm_id) ? $emp_rec->user_id : $emp_rec->hrm_id
            ),
        ];
    }
    private function shift()
    {
        if (empty($this->_current_shift)) {
            return [];
        }
        $shift_rec = $this->CI->db->select('shift.id, shift.name')
            ->where('id', $this->_current_shift)
            ->get('shift')->row();
        if (empty($shift_rec)) {
            return [];
        }
        return [
            'id' => $shift_rec->id,
            'name' => $shift_rec->name,
        ];
    }
    private function candidate()
    {
        if (empty($this->_current_candidate)) {
            return [];
        }
        $can_rec = $this->CI->db->select('can_id, first_name, last_name')
            ->where('can_id', $this->_current_candidate)
            ->get('candidate_basic_info')->row();
        if (empty($can_rec)) {
            return [];
        }
        return [
            'id' => $can_rec->can_id,
            'name' => sprintf('%s %s (%s)', $can_rec->first_name, $can_rec->last_name, $can_rec->can_id),
        ];
    }
    private function job()
    {
        if (empty($this->_current_job)) {
            return [];
        }
        $job_rec = $this->CI->db->select('job_posting.jp_id as id, position.position_name as title')
            ->where('job_posting.jp_id', $this->_current_job)
            ->join('position', 'job_posting.pos_id=position.pos_id', 'left')
            ->get('job_posting')->row();
        if (empty($job_rec)) {
            return [];
        }
        return [
            'name' => sprintf('(#%s) %s', $job_rec->id, $job_rec->title),
        ];
    }
    private function division()
    {
        if (empty($this->_current_division)) {
            return [];
        }
        $division_rec = $this->CI->db->select('name')
            ->where('id', $this->_current_division)
            ->get('divisions')->row_array();
        if (empty($division_rec)) {
            return [];
        }
        return $division_rec;
    }
    private function department()
    {
        if (empty($this->_current_department)) {
            return [];
        }
        $department_rec = $this->CI->db->select('dept_id id, department_name name')
            ->where('dept_id', $this->_current_department)
            ->get('department')->row();
        if (empty($department_rec)) {
            return [];
        }
        return [
            'name' => sprintf('%s (#%s)', $department_rec->name, $department_rec->id),
        ];
    }
    private function payroll()
    {
        if (empty($this->_current_payroll)) {
            return [];
        }
        $payroll_rec = $this->CI->db->select('id, month, year, start, end')
            ->where('id', $this->_current_payroll)
            ->get('payroll')->row();
        if (empty($payroll_rec)) {
            return [];
        }
        return [
            'id' => $payroll_rec->id,
            'month' => ucfirst($payroll_rec->month),
            'year' => $payroll_rec->year,
            'start' => $payroll_rec->start,
            'end' => $payroll_rec->end,
        ];
    }
    private function process_body($body)
    {
        $data = [];
        $model = $this;
        $body = preg_replace_callback(
            "|{{\S+?}}|",
            function ($matches) use ($model, $data) {
                $matches_arr = strtolower(trim(trim(strip_tags($matches[0]), '{}')));
                $matches_arr = explode(':', strtolower($matches_arr));

                if ($matches_arr && count($matches_arr) == 2) {
                    if (!isset($data[$matches_arr[0]])) {
                        $data[$matches_arr[0]] = call_user_func([$model, $matches_arr[0]]);
                    }
                    if (isset($data[$matches_arr[0]]) && isset($data[$matches_arr[0]][$matches_arr[1]])) {
                        return $data[$matches_arr[0]][$matches_arr[1]];
                    }
                }
                return $matches[0];
            },
            $body);
        return $body;
    }
    public function log($message, $row_id = null, $module = null, $table = null, $field = null, $level = '', $userId = null, $username = null, $extra = '')
    {
        if (!$userId) {
            $userId = $this->CI->session->userdata('id');
            if (!$userId) {
                $userId = 0;
            }
        }
        if (!$username) {
            $username = $this->CI->session->userdata('email');
            if (!$username) {
                $username = '';
            }
        }
        $msg = '';
        if (is_array($message)) {
            $message[1] = trim($message[1], '"');
            $msg = vsprintf($this->CI->lang->line(array_shift($message)), $message);
        } else {
            $msg = $this->CI->lang->line($message);
        }
        $msg = $this->process_body($msg);
        if ($extra) {
            $msg .= ' ' . $extra;
        }
        $this->write_to_db($userId, $row_id, $username, $msg, $module, $table, $field, $level);
        $this->clear();
    }
    private function get_ip_address()
    {
        $ipaddress = '';
        if (isset($_SERVER["HTTP_CF_CONNECTING_IP"])) {
            $ipaddress = $_SERVER["HTTP_CF_CONNECTING_IP"];
        } elseif (isset($_SERVER['HTTP_CLIENT_IP'])) {
            $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
        } else if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else if (isset($_SERVER['HTTP_X_FORWARDED'])) {
            $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
        } else if (isset($_SERVER['HTTP_FORWARDED_FOR'])) {
            $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
        } else if (isset($_SERVER['HTTP_FORWARDED'])) {
            $ipaddress = $_SERVER['HTTP_FORWARDED'];
        } else if (isset($_SERVER['REMOTE_ADDR'])) {
            $ipaddress = $_SERVER['REMOTE_ADDR'];
        } else {
            $ipaddress = 'UNKNOWN';
        }

        return $ipaddress;
    }
    public function clear()
    {
        $this->_current_emp = 0;
        $this->_current_user = 0;
        $this->_current_shift = 0;
        $this->_current_candidate = 0;
        $this->_current_job = 0;
        $this->_current_division = 0;
        $this->_current_department = 0;
        $this->_url = null;
    }
    private function write_to_db($userId, $row_id, $name, $message, $module, $table, $field, $level)
    {
        $encrypted = false;
        $encrypted_columns = $this->CI->config->item('encrypted_columns');
        if (!is_null($table) && !is_null($field) && $table == $table && isset($encrypted_columns[$table]) && in_array($field, $encrypted_columns[$table])) {
            $encrypted = true;
        }
        $this->CI->db->insert($this->db_name, [
            'module' => $module ?? get_module_name(),
            'row_id' => $row_id,
            'table_name' => $table,
            'field' => $field,
            'message' => $encrypted ? $this->CI->encryption->encrypt($message) : $message,
            'encrypted' => $encrypted ? 1 : 0,
            'url' => $this->url(),
            'userId' => $userId,
            'username' => $name,
            'ip_address' => $this->get_ip_address(),
            'level' => $level,
            'logged' => date("Y-m-d H:i:s"),
        ]);
    }
}
