<?php
defined('BASEPATH') or exit('No direct script access allowed');

/*
 *
 * ---------------how to use-----------------
 * ------------------------------------------
 * Developed by <sourav.diubd@gmail.com>
 *
 * $autoload['helper'] =  array('lang');

 * display a language
 * echo display('helloworld');

 * display language list
 * $lang = languageList();
 * ------------------------------------------
 *
 */

if (!function_exists('display')) {

    function display($text = null, $normalize = true, $separator = ' ')
    {
        if (empty($text)) {
            return false;
        }
        $ci = &get_instance();
        $ci->load->database();
        $table = 'language';
        $phrase = 'phrase';
        $default_lang = 'english';

        //set language
        $data = get_settings();
        if (!empty($data->language)) {
            $language = $data->language;
        } else {
            $language = $default_lang;
        }
        if (!is_array($text)) {
            $text = [$text];
        }
        $res = [];
        foreach ($text as $txt) {
            $txt_low = strtolower($txt);
            if (!$data = $ci->cache->get("language.{$language}.{$txt_low}")) {
                if ($ci->db->table_exists($table)) {

                    if ($ci->db->field_exists($phrase, $table)) {

                        if ($ci->db->field_exists($language, $table)) {
                            $row = $ci->db->select($language)
                                ->from($table)
                                ->where($phrase, $txt_low)
                                ->get()
                                ->row();
                            if (empty($row->$language)) {
                                $ci->db->insert($table, [
                                    $phrase => $txt_low,
                                    $language => $txt,
                                ]);
                                $data = $txt;
                            } else {
                                $ci->cache->save("language.{$language}.{$txt_low}", $row->$language, 7200);
                                $data = $row->$language;
                            }
                        }
                    }
                }
            }
            $res[] = $data;
        }
        $res = implode($separator, $res);
        return $normalize ? ucfirst(strtolower($res)) : ucwords($res);
    }
}
