<?php
class MY_Controller extends MX_Controller
{
    private $_side__bar_items = [];
    public $_side__bar = [];
    public $_css__files = [];
    public $_js__files = [];
    public $_promo_vids = [
        /* '3' => [
            'file' => 'Seadale.mp4',
            'size' => 'large'
        ], */
        /* '4' => [
            'file' => 'PG2F.mp4',
            'size' => 'small'
        ] */
    ];
    public function __construct()
    {
        parent::__construct();
        if (!defined('WRITEPATH')) {
            exit('Invalid index.php file.');
        }
        if (!is_really_writable(WRITEPATH)) {
            throw new Exception('WRITEPATH is not writable. Check directory permissions');
        }
        if (uri_string() != 'dashboard/cron') {
            $this->__get___system___files();
            $this->__generate___sidebar();
        }
    }
    private function __get___system___files()
    {
        if (!$system_items = $this->cache->get('system.layout.items')) {
            $HmvcMenu = [];
            $css_files = [];
            $js_files = [];

            $path = 'application/modules/';
            $map = array_diff(scandir($path), ['.', '..']);
            foreach ($map as $value) {
                if (!file_exists($path . $value . '/assets/data/env')) {
                    continue;
                }
                $menu = $path . $value . '/config/menu.php';
                @include $menu;
                $css = $path . $value . '/assets/css/style.css';
                if (file_exists($css)) {
                    $css_files[] = $css;
                }
                $js = $path . $value . '/assets/js/script.js';
                if (file_exists($js)) {
                    $js_files[] = $js;
                }
            }
            ksort($HmvcMenu);
            $this->_side__bar_items = $HmvcMenu;
            $this->_css__files = $css_files;
            $this->_js__files = $js_files;
            $this->cache->save('system.layout.items', ['menu' => $HmvcMenu, 'css' => $css_files, 'js' => $js_files], 2000);
        } else {
            $this->_side__bar_items = $system_items['menu'];
            $this->_css__files = $system_items['css'];
            $this->_js__files = $system_items['js'];
        }
    }
    private function __generate___sidebar()
    {
        $this->_side__bar[] = [
            'icon' => '<i class="ti-dashboard"></i>',
            'module' => 'dashboard',
            'items' => [
                'controller' => 'home',
                'permission' => 'all',
            ],
        ];
        if ($this->session->userdata('missing_documents') > 0) {
            $this->_side__bar[] = [
                'label' => 'upload_documents',
                'icon' => '<i class="fa fa-exclamation-triangle"></i>',
                'module' => 'employee',
                'items' => [
                    'controller' => 'employees_documents',
                    'method' => 'upload',
                    'permission' => 'all',
                ],
            ];
        }
        foreach ($this->_side__bar_items as $module => $menu_item) {
            $icon = $menu_item['icon'];
            unset($menu_item['icon']);
            $this->_side__bar[] = [
                'icon' => $icon,
                'module' => $module,
                'items' => $menu_item,
            ];
        }
        $this->_side__bar[] = [
            'label' => 'setting',
            'icon' => '<i class="ti-settings"></i>',
            'module' => 'dashboard',
            'items' => [
                'user' => [
                    'add_user' => [
                        'controller' => 'user',
                        'method' => 'form',
                        'permission' => 'create',
                    ],
                    'user_list' => [
                        'controller' => 'user',
                        'permission' => 'read',
                    ],
                ],
                'role_permission' => [
                    'add_role' => [
                        'controller' => 'role',
                        'method' => 'create_system_role',
                        'permission' => 'create',
                    ],
                    'role_list' => [
                        'controller' => 'role',
                        'method' => 'role_list',
                        'permission' => 'read',
                    ],
                    'user_access_role' => [
                        'controller' => 'role',
                        'method' => 'user_access_role',
                        'permission' => 'update',
                    ],
                ],
                'application_setting' => [
                    'controller' => 'setting',
                    'permission' => 'update',
                ],
                'email_settings' => [
                    'controller' => 'email_settings',
                    'method' => 'email_templates',
                    'permission' => 'read',
                ],
                'language' => [
                    'controller' => 'language',
                    'permission' => 'read',
                ],
                'google_logins' => [
                    'controller' => 'setting',
                    'method' => 'google'
                ],
                /* 'backup_and_restore' => [
                    'controller' => 'backup_restore',
                    'permission' => 'read',
                ], */
                'document_templates_head' => [
                    'document_templates' => [
                        'controller' => 'temp',
                        'method' => 'templates',
                        'permission' => 'read',
                    ],
                    'document_categories' => [
                        'controller' => 'temp',
                        'method' => 'category',
                        'permission' => 'read',
                    ],
                ],
            ],
        ];
    }
}
class Loggedin_Controller extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();
        if (!$this->session->userdata('isLogIn')) {
            if ($this->input->is_ajax_request()) {
                sendJson(['error' => 'You are not logged in', 'reload' => 1], 401);
            }
            $this->session->set_flashdata('exception', 'You are not logged in');
            redirect('login?rback=' . uri_string(), 'refresh', 401);
        }
        $tracked_uris = [
            'dashboard/home',
            'dashboard/home/index',
            'attendance/home',
            'attendance/home/index',
            'attendance/home/create_atten',
        ];
        $current_uri = strtolower(uri_string());
        if (in_array($current_uri, $tracked_uris) && !$this->input->is_ajax_request()) {
            if (isset($_GET['a'])) {
                $current_uri .= '?a=' . htmlspecialchars($_GET['a']);
            }
            @file_put_contents(
                APPPATH . 'logs/visits/' . date('Y-m-d') . '.csv',
                sprintf('"%s","%s","%s","%s","%s"', $_SESSION['hrm_id'] ?? $_SESSION['id'], $current_uri, is_mobile_device() ? 'Phone' : 'Computer', get_ip_address(), date('Y-m-d H:i:s')) . PHP_EOL,
                FILE_APPEND
            );
        }
    }
}
class Admin_Controller extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();
        if (!($this->session->userdata('isLogIn') && $this->session->userdata('isAdmin'))) {
            if ($this->input->is_ajax_request()) {
                sendJson(['error' => 'You are not logged in', 'reload' => 1], 401);
            }
            redirect('login?rback=' . uri_string(), 'refresh', 401);
        }
    }
}

class RestApi_Controller extends MX_Controller 
{
    function __construct()
    {
        parent::__construct();
    }

    public function response($response,$code=401)
    {
        $this->output 
        ->set_status_header($code)
        ->set_content_type('application/json','utf-8')
        ->set_output(json_encode($response,JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE |JSON_UNESCAPED_SLASHES))
        ->_display();
        exit;
    }

}