<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'dashboard/auth';

$route['login']  = "dashboard/auth/index";
$route['login_verify']  = "dashboard/auth/verify";
$route['login_verify_user']  = "Login_verify/index";
$route['logout'] = "dashboard/auth/logout";
$route['forgot-password']  = "dashboard/auth/forgot_password";
$route['reset-password/(:any)']  = "dashboard/auth/reset_password/$1";
$route['game-night/(:num)'] = "dashboard/auth/game_night/$1";


$route['job/(:any)']  = "dashboard/auth/shroten_work/$1";

$route['careers'] = 'recruitment/careers/open';
$route['careers/our-talent-network'] = 'recruitment/careers/our_talent_network';

$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;


//set modules/config/routes.php
$modules_path = APPPATH.'modules/';     
$modules = scandir($modules_path);
foreach($modules as $module)
{
    if($module === '.' || $module === '..') {continue;}
    @include($modules_path . $module . '/config/routes.php');
}
$route['recruitment'] = 'recruitment/careers/open';

$route['api'] = 'api/api/index';