<?php
require_once APPPATH . 'libraries/Mysql_type.php';
$mysql_types = new Mysql_type();
$config = [
    'encrypted_columns' => [
        'employee_history' => [
            'alter_phone',
            'cell_phone',
            'cnic',
            'dob',
            'emerg_contct',
            'home_email',
            'home_phone',
            'hourly_rate2',
            'hourly_rate3',
            'parmanent_address',
            'phone',
            'present_address',
            'rate',
            'current_salary',
            'hired_salary',
            'first_salary',
            'second_salary',
            'third_salary',
            'account_number',
            'account_iban',
            'increment_amount',
            'domain_password',
        ],
        'employee_increments' => [
            'amount',
        ],
        'payroll_employee' => [
            'cnic',
            'actual_gross_salary',
            'actual_basic_salary',
            'gross_salary',
            'basic_salary',
            'income_tax',
            'provident_fund',
            'account_number',
            'account_iban',
        ],
        'under_training_amounts' => [
            'amount',
        ],
        'report_remarks' => [
            'remarks',
        ],
        'evaluation_report_instance' => [
            'manager_comments',
            'employee_comments',
        ],
    ],
    'encrypted_columns_types' => [
        'employee_history' => [
            'alter_phone' => $mysql_types::TYPE_STRING,
            'cell_phone' => $mysql_types::TYPE_STRING,
            'cnic' => $mysql_types::TYPE_STRING,
            'dob' => $mysql_types::TYPE_DATE,
            'emerg_contct' => $mysql_types::TYPE_STRING,
            'home_email' => $mysql_types::TYPE_STRING,
            'home_phone' => $mysql_types::TYPE_STRING,
            'hourly_rate2' => $mysql_types::TYPE_INT24,
            'hourly_rate3' => $mysql_types::TYPE_INT24,
            'parmanent_address' => $mysql_types::TYPE_STRING,
            'phone' => $mysql_types::TYPE_STRING,
            'present_address' => $mysql_types::TYPE_STRING,
            'rate' => $mysql_types::TYPE_INT24,
            'current_salary' => $mysql_types::TYPE_INT24,
            'hired_salary' => $mysql_types::TYPE_INT24,
            'first_salary' => $mysql_types::TYPE_INT24,
            'second_salary' => $mysql_types::TYPE_INT24,
            'third_salary' => $mysql_types::TYPE_INT24,
            'account_number' => $mysql_types::TYPE_STRING,
            'account_iban' => $mysql_types::TYPE_STRING,
            'increment_amount' => $mysql_types::TYPE_INT24,
            'domain_password' => $mysql_types::TYPE_STRING,
        ],
        'employee_increments' => [
            'amount' => $mysql_types::TYPE_INT24,
        ],
        'payroll_employee' => [
            'dob' => $mysql_types::TYPE_DATE,
            'cnic' => $mysql_types::TYPE_STRING,
            'actual_gross_salary' => $mysql_types::TYPE_INT24,
            'actual_basic_salary' => $mysql_types::TYPE_INT24,
            'gross_salary' => $mysql_types::TYPE_INT24,
            'basic_salary' => $mysql_types::TYPE_INT24,
            'actual_salary' => $mysql_types::TYPE_INT24,
            'income_tax' => $mysql_types::TYPE_INT24,
            'provident_fund' => $mysql_types::TYPE_INT24,
            'account_number' => $mysql_types::TYPE_STRING,
            'account_iban' => $mysql_types::TYPE_STRING,
        ],
        'under_training_amounts' => [
            'amount' => $mysql_types::TYPE_INT24,
        ],
        'report_remarks' => [
            'remarks' => $mysql_types::TYPE_STRING,
        ],
        'evaluation_report_instance' => [
            'manager_comments' => $mysql_types::TYPE_STRING,
            'employee_comments' => $mysql_types::TYPE_STRING,
        ],
    ],
    'encrypted_salary_columns' => [
        'employee_history' => [
            'hourly_rate2',
            'hourly_rate3',
            'rate',
            'current_salary',
            'hired_salary',
            'first_salary',
            'second_salary',
            'third_salary',
            'increment_amount',
        ],
        'employee_increments' => [
            'amount',
        ],
        'payroll_employee' => [
            'actual_gross_salary',
            'actual_basic_salary',
            'gross_salary',
            'basic_salary',
            'actual_salary',
            'income_tax',
            'provident_fund',
        ],
        'under_training_amounts' => [
            'amount',
        ],
        'report_remarks' => [
        ],
        'evaluation_report_instance' => [
        ],
    ],
];
