<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\Collections;
use App\Models\ActivecollectorspisettlementModel;
// Import Excel Package
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Csv;
use App\Libraries\CSVReader;
class Activecollectorspisettlement extends BaseController
{


    /**
     * Returns the amount of weeks into the month a date is
     * @param $date a YYYY-MM-DD formatted date
     * @param $rollover The day on which the week rolls over
     */
       
    function workingDays($year,$month){
    
    	$days = cal_days_in_month(CAL_GREGORIAN, $month, $year); // 31
    	$j = 1;
    		$countWorkingDays = 0;
    		for($i =0;$i<$days;$i++){
    			$newDate = date('Y-m-d', strtotime(date('Y-m-d'). ' + '.$j.' days'));
    			if(date("D", strtotime($newDate)) !='Sat' && date("D", strtotime($newDate)) !='Sat'){
    					$countWorkingDays+=1;
    			}
    			$j++;
    		}
    		return $countWorkingDays;
    }
    
    public function all_record($month = null){
        if(isset($month)){
            $records = $this->db->table('pi_settlement_data')->where('date',$month)->select('*')->get()->getResult();    
        }else{
            $records = $this->db->table('pi_settlement_data')->select('*')->get()->getResult();    
        }
        $data['record'] = $records;
        return $data;
    }
    
    public function lastID(){
        $result =   $this->db->query('select * from pi_settlement_data order by ID desc limit 1')->getResult();
        if($result){
            echo $result[0]->ID+1;
        }else{
            echo 1;
        }
        
    }
    
    
    public function index()
    {
        
        $model = new ActivecollectorspisettlementModel();
        
        if(isset($_GET['month'])){
            $month = $_GET['month'];    
        }else{
            $month = date('Y-m');    
        }
        
        $model->where('date',$month);
        $data = [
            'record' => $model->paginate(100),
            'pager' => $model->pager
        ];
        $data['months'] = $month;
      	return view('active_collectors_pi_settlement_data/index',$data);
    }
    
        public function update($table){
    	    if ($this->request->getMethod() == 'post') {
    	    		$post = $this->request->getPost();
                    $result = $this->db->table('pi_settlement_data')->select('*')->where('ID',$post['ID'])->get()->getResult();
                    $model = new ActivecollectorspisettlementModel();   
                    if($result){
                        $update = $model->update($post['ID'], $post);        
                    }else{
              
                        $this->db->transStart();
    				    // $update = $this->db->table('Daily_Quality_Workbook_ML_CR')->insertBatch($post);
    				    $update = $model->insert($post);
    				    $this->db->transComplete();
    				            
                    }
                    
                    if($update){
                        echo 1;
                    }else{
                        echo 0;
                    }
            }    
        }
    
        public function delete($table){
             if ($this->request->getMethod() == 'post') {
                	$post = $this->request->getPost();
     
                    $model = new ActivecollectorspisettlementModel();   
                    $this->db->query('delete from pi_settlement_data where ID = '.$post['ID'])->getResult();
                    // if($update == 1){
                    //     echo 1;
                    // }else{
                    //     echo 0;
                    // }
                 
             }
        }
        
    
        public function importSheet(){
                $post = $this->request->getPost();
              
                                        $session = session();
        if ($this->request->getMethod() == "post") {

                                        $file_mimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                                        $arr_file = explode('.', $_FILES['upload_file']['name']);
                                        $extension = end($arr_file);

                                        if($extension !='csv'){
                                            $session->setFlashdata('error', 'Only Csv File You Can Import');
                                            return redirect()->to(base_url('active_collectors_pi_settlement_data/'));
                                        }

                                        if('csv' == $extension){
                                                $reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
                                        } else {
                                                $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
                                        }
                                        
                                        $spreadsheet = $reader->load($_FILES['upload_file']['tmp_name']);
                                        $sheetData = $spreadsheet->getActiveSheet()->toArray();
                                        if($sheetData){
                                                $total_array = [];
                                                $table_descriptions = $this->db->query('describe pi_settlement_data')->getResult();
                        
                                                if($table_descriptions){
                                                    if(end($sheetData[0]) == 'Date' || end($sheetData[0]) == 'date'){
                                                         $table_fields = count($table_descriptions);
                                                         $sheet_columns = count($sheetData[0]);
                                                    }else{
                                                        echo $table_fields = count($table_descriptions)-1;
                                                        echo $sheet_columns = count($sheetData[0]);
                                                    }
                                                  
                                                    if($sheet_columns > $table_fields || $sheet_columns < $table_fields){
                                                        $session->setFlashdata('error', 'Something Went Wrong Sheet Not Imported Successfully Check The Fields Carefully');
                                                        return redirect()->to(base_url('active_collectors_pi_settlement_data/'));
                                                    }
                                                }    
                                                if(isset($post['month'])){
                                                    $month = trim($post['month']);
                                                }else{
                                                    $month = date('Y-m');
                                                }
                   
                                                
                                                $this->db->transStart();
                                                
                                                $delete_query = "delete from pi_settlement_data where date = '{$month}'";
                                                
                                                $this->db->query($delete_query)->getResult();
                                               
                                                foreach($sheetData as $key=>$value){
                                                    
                                                        if($key>0){ 
                                                            
                                                            $mult_array['Settled_On']  = trim($value[1]);
                                                            $mult_array['Settled_By']  = trim($value[2]);
                                                            $mult_array['MRN']  = trim($value[3]);
                                                            $mult_array['Case_Id']  = trim($value[4]);
                                                            $mult_array['Provider']  = trim($value[5]);
                                                            $mult_array['Provider_ID']  = trim($value[6]);
                                                            $mult_array['Patients_Name']  = trim($value[7]);
                                                            $mult_array['Paper'] = trim($value[8]);
                                                            $mult_array['First_DOS'] = trim($value[9]);
                                                            $mult_array['Last_DOS'] = trim($value[10]);
                                                            $mult_array['MLM_Billed'] = trim($value[11]);
                                                            $mult_array['Settlement_Amount']= trim($value[12]);
                                                            $mult_array['Settlement_Age']= trim($value[13]);
                                                            $mult_array['C_R_Amount']       = trim($value[14]);
                                                            $mult_array['Total_Medical_Bills']     = trim($value[15]);
                                                            $mult_array['Pro_Share']       = trim($value[16]);
                                                            $mult_array['Settlement_Payment_Received']        = trim($value[17]);
                                                            $mult_array['Settlement_Payment']  = trim($value[18]);
                                                            $mult_array['Settlement_Payment_Date']        = trim($value[19]);
                                                            $mult_array['File_Status']        = trim($value[20]);
                                                            //$mult_array['date']             = date("Y-m", strtotime(trim($value[1])));
							    $mult_array['date']             = trim($month);	
							    $this->db->table('pi_settlement_data')->insert($mult_array);    
                                                       
                                                        }
                                               
                                                }
                                                $this->db->transComplete();
                                              	if($this->db->transStatus() === true){
                                                       $session->setFlashdata('success', 'Data Imported Successfully');
                                                        return redirect()->to(base_url('active_collectors_pi_settlement_data?month='.$month));
                                                    }else{
                                                        $session->setFlashdata('error', 'Something went wrong');
                                                    return redirect()->to(base_url('active_collectors_pi_settlement_data?month='.$month));
                                                }

                                        }else{

                                        }
                                        }


        }

    
    public function importSheetNew(){
    	$post = $this->request->getPost();
    	$session = session();
    	if ($this->request->getMethod() == "post") {
					
					$file_mimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
					$arr_file = explode('.', $_FILES['upload_file']['name']);
					$extension = end($arr_file);
								
					if($extension !='xlsx' && $extension !='csv'){
                        $session->setFlashdata('error', 'Only Xlsx and Csv File You Can Import');
                        return redirect()->to(base_url('active_collectors_daily_quality_work_book_mlcr/'));
                    }
					
					$qoute = '"';
					
					$path = $_FILES['upload_file']['tmp_name'];
					
					$file = $this->request->getFile('upload_file');
					
					$newName = $file->getRandomName();
				
					$file->move(FCPATH . 'settlment',$newName);
				 
					$path = $_SERVER['DOCUMENT_ROOT'].str_replace(basename($_SERVER["SCRIPT_NAME"]), "", $_SERVER["SCRIPT_NAME"]);
				
					$file_path =  $path.'settlment/'.$newName;
					
					$next = '"\n"';
			
					echo $query = "					
								LOAD DATA LOCAL INFILE '{$file_path}' 
								INTO TABLE `mlcr_settlement_data`
								FIELDS TERMINATED BY ','
								ENCLOSED BY '{$qoute}'
								LINES TERMINATED BY {$next}
								IGNORE 1 ROWS
								(
    								Settlement_Date,
    								Collector_Real_Name,
    								Pseudo,
    								Team_Manager,
    								Provider,
    								Settlement_Type,
    								MRN,
    								Orders,
    								Bill_ID_Invoice,
    								Patient_Name,
    								Billed_Amount,
    								Paid_Amount,
    								Outstanding_Amount,
    								Settlement_Amount,
    								Settlement,
    								Check_Number,
    								Check_Date,
    								Post_Date,
    								Available_on_SP,
    								QA_Status,
    								Timestamp);
					";
                
    					$this->db->transStart();
        				$this->db->query($query)->getResult();
    					$this->db->transComplete();
            
						if($this->db->transStatus() === true){
						  //  unlink($file_path);
						    $session->setFlashdata('success', 'Data Imported Successfully');
				            return redirect()->to(base_url('active_collectors_daily_quality_work_book_mlcr/'));
						}else{
						    $session->setFlashdata('error', 'Something went wrong');
				            return redirect()->to(base_url('active_collectors_daily_quality_work_book_mlcr/'));
						}
					}
        }

	
	
	function generate_csv($data,$fileName)
    {
        // $data = generate($tables, $columns, $where);
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename='.$fileName);
        header('Content-Transfer-Encoding: binary');
    
        $f = fopen('php://output', 'w');
        fwrite($f, chr(0xEF).chr(0xBB).chr(0xBF));
        fputcsv($f, $data['header']);
        $sr_no = 1;
        foreach ($data['rows'] as $row) {
            // unset($row->id);
            $row->ID = $sr_no;
            
            $sr_no++;
            fputcsv($f, (array)$row); 
        }
        
        exit;
    }
	
	public function downloadExcelReport()
	{
	    ini_set('memory_limit','5000M');
        ini_set('max_execution_time','500000');
 
 
        if(isset($_GET['all_sheet'])){
            $result = $this->all_record();
        }else{
            if(isset($_GET['month'])){
                $month = $_GET['month'];
            }else{
                $month = date('Y-m');
            }
            $result = $this->all_record($month);
        }
        
		$fileName = 'active_colletion_sheet_'.date('Y-m-d').'.csv'; // File is to create
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();
// 		$spreadsheet = new Spreadsheet();
// 		$sheet = $spreadsheet->getActiveSheet();

    	$data['header'][] = 'Sr. #';
        $data['header'][] = 'Settled On';
        $data['header'][] = 'Settled By';
        $data['header'][] = 'MRN';
        $data['header'][] = 'Case Id';
        $data['header'][] = 'Provider';
        $data['header'][] = 'Provider ID';
        $data['header'][] = 'Patients Name';
        $data['header'][] = 'Paper';
        $data['header'][] = 'First DOS';
        $data['header'][] = 'Last DOS';
        $data['header'][] = 'MLM - Billed';
        $data['header'][] = 'Settlement Amount';
        $data['header'][] = 'Settlement %Age';
        $data['header'][] = 'C & R Amount';
        $data['header'][] = 'Total Medical Bills';
        $data['header'][] = 'Pro Share';
        $data['header'][] = 'Settlement Payment Received?';
        $data['header'][] = 'Settlement Payment';
        $data['header'][] = 'Settlement Payment Date';
        $data['header'][] = 'File Status';
    	$data['header'][] = 'Date';
		$data['rows']     = $result['record'];

		 return $this->generate_csv($data,$fileName);
	}


}
