<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\Collections;
use App\Models\ActivecollectorsmlmsettlementdeltarunningModel;
// Import Excel Package
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Csv;
use App\Libraries\CSVReader;
class Activecollectorsmlmsettlementdeltarunning extends BaseController
{


    /**
     * Returns the amount of weeks into the month a date is
     * @param $date a YYYY-MM-DD formatted date
     * @param $rollover The day on which the week rolls over
     */
       
    function workingDays($year,$month){
    
    	$days = cal_days_in_month(CAL_GREGORIAN, $month, $year); // 31
    	$j = 1;
    		$countWorkingDays = 0;
    		for($i =0;$i<$days;$i++){
    			$newDate = date('Y-m-d', strtotime(date('Y-m-d'). ' + '.$j.' days'));
    			if(date("D", strtotime($newDate)) !='Sat' && date("D", strtotime($newDate)) !='Sat'){
    					$countWorkingDays+=1;
    			}
    			$j++;
    		}
    		return $countWorkingDays;
    }
    
    public function all_record($month = null){
        if(isset($month)){
            $records = $this->db->table('mlm_settlement_delta_running')->where('date_month',$month)->select('*')->get()->getResult();    
        }else{
            $records = $this->db->table('mlm_settlement_delta_running')->select('*')->get()->getResult();    
        }
        $data['record'] = $records;
        return $data;
    }
    
    public function lastID(){
        $result =   $this->db->query('select * from mlm_settlement_delta_running order by ID desc limit 1')->getResult();
        if($result){
            echo $result[0]->ID+1;
        }else{
            echo 1;
        }
        
    }
    
    
    public function index()
    {
        
        $model = new ActivecollectorsmlmsettlementdeltarunningModel();
        
        if(isset($_GET['month'])){
            $month = $_GET['month'];    
        }else{
            $month = date('Y-m');    
        }
        
        $model->where('date_month',$month);
        $data = [
            'record' => $model->paginate(100),
            'pager' => $model->pager
        ];
        $data['months'] = $month;
        
      	return view('active_collectors_mlm_settlement_delta_running/index',$data);
    }
    
        public function update($table){
    	    if ($this->request->getMethod() == 'post') {
    	    		$post = $this->request->getPost();
                    $result = $this->db->table('mlm_settlement_delta_running')->select('*')->where('ID',$post['ID'])->get()->getResult();
                    $model = new ActivecollectorsmlmsettlementdeltarunningModel();   
                    if($result){
                        $update = $model->update($post['ID'], $post);        
                    }else{
              
                        $this->db->transStart();
    				    // $update = $this->db->table('Daily_Quality_Workbook_ML_CR')->insertBatch($post);
    				    $update = $model->insert($post);
    				    $this->db->transComplete();
    				            
                    }
                    
                    if($update){
                        echo 1;
                    }else{
                        echo 0;
                    }
            }    
        }
    
        public function delete($table){
             if ($this->request->getMethod() == 'post') {
                	$post = $this->request->getPost();
                    $model = new ActivecollectorsmlmsettlementdeltarunningModel();   
                    $this->db->query('delete from mlm_settlement_delta_running where ID = '.$post['ID'])->getResult();
                   }
        }
        
    
        public function importSheet(){
            
                $post = $this->request->getPost();
              
                                        $session = session();
                            if ($this->request->getMethod() == "post") {

                                        $file_mimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                                        $arr_file = explode('.', $_FILES['upload_file']['name']);
                                        $extension = end($arr_file);

                                        if($extension !='csv'){
                                            $session->setFlashdata('error', 'Only Csv File You Can Import');
                                            return redirect()->to(base_url('active_collectors_pi_settlement_data/'));
                                        }

                                        if('csv' == $extension){
                                                $reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
                                        } else {
                                                $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
                                        }
                                        
                                        $spreadsheet = $reader->load($_FILES['upload_file']['tmp_name']);
                                        $sheetData = $spreadsheet->getActiveSheet()->toArray();
                                        if($sheetData){
                                                $total_array = [];
                                                $table_descriptions = $this->db->query('describe mlm_settlement_delta_running')->getResult();
                        
                                                if($table_descriptions){
                                                    if(end($sheetData[0]) == 'Date' || end($sheetData[0]) == 'date'){
                                                         $table_fields = count($table_descriptions);
                                                         $sheet_columns = count($sheetData[0]);
                                                    }else{
                                                         $table_fields = count($table_descriptions)-1;
                                                         $sheet_columns = count($sheetData[0]);
                                                    }
                                                  
                                                    if($sheet_columns > $table_fields || $sheet_columns < $table_fields){
                                                        $session->setFlashdata('error', 'Something Went Wrong Sheet Not Imported Successfully Check The Fields Carefully');
                                                        return redirect()->to(base_url('active_collectors_mlm_settlement_delta_running/'));
                                                    }
                                                }    
                                                if(isset($post['month'])){
                                                    $month = trim($post['month']);
                                                }else{
                                                    $month = date('Y-m');
                                                }
                   
                                                
                                                $this->db->transStart();
                                                
                                                $delete_query = "delete from mlm_settlement_delta_running where date_month = '{$month}'";
                                                
                                                $this->db->query($delete_query)->getResult();
                                               
                                                foreach($sheetData as $key=>$value){
                                                    
                                                        if($key>0){ 
                                                              
                                                            $mult_array['Date'] = trim($value[1]);
                                                            $mult_array['Lag_Time'] = trim($value[2]);
                                                            $mult_array['Location'] = trim($value[3]);
                                                            $mult_array['MRN'] = trim($value[4]);
                                                            $mult_array['Case_Id'] = trim($value[5]);
                                                            $mult_array['Patients_Name'] = trim($value[6]);
                                                            $mult_array['Billed'] = trim($value[7]);
                                                            $mult_array['Paid'] = trim($value[8]);
                                                            $mult_array['Outstanding'] = trim($value[9]);
                                                            $mult_array['Settlement_Amount'] = trim($value[10]);
                                                            $mult_array['Settlement_Age'] = trim($value[11]);
                                                            $mult_array['Provider_ID'] = trim($value[12]);
                                                            $mult_array['Provider'] = trim($value[13]);
                                                            $mult_array['Paper'] = trim($value[14]);
                                                            $mult_array['Stay_Issue'] = trim($value[15]);
                                                            $mult_array['Consolidation_Issue'] = trim($value[16]);
                                                            $mult_array['Insurance_Company'] = trim($value[17]);
                                                            $mult_array['Confirmation_Letter_Received'] = trim($value[18]);
                                                            $mult_array['Confirmation_Letter_Received_Date'] = trim($value[19]);
                                                            $mult_array['File_Status'] = trim($value[20]);
                                                            $mult_array['Action'] = trim($value[21]);
                                                            $mult_array['File_Assigned_To'] = trim($value[22]);
                                                            $mult_array['Assigned_Date'] = trim($value[23]);
                                                            $mult_array['Status'] = trim($value[24]);
                                                            $mult_array['Status_Date'] = trim($value[25]);
                                                            $mult_array['Status_Updated_By'] = trim($value[26]);
                                                            $mult_array['Owner'] = trim($value[27]);
                                                            // $mult_array['date_month'] = date("Y-m", strtotime(trim($value[1])));
                                                             $mult_array['date_month'] = $month;
                                                            // echo '<pre>';
                                                            // print_r($mult_array);
                                                            $this->db->table('mlm_settlement_delta_running')->insert($mult_array);    
                                                           }
                                                }
                                                $this->db->transComplete();
                                              	if($this->db->transStatus() === true){
                                                        $session->setFlashdata('success', 'Data Imported Successfully');
                                                        return redirect()->to(base_url('active_collectors_mlm_settlement_delta_running?month='.$month));
                                                }else{
                                                        $session->setFlashdata('error', 'Something went wrong');
                                                        return redirect()->to(base_url('active_collectors_mlm_settlement_delta_running?month='.$month));
                                                }

                                
                                        }

        }

        }

	function generate_csv($data,$fileName)
    {
        // $data = generate($tables, $columns, $where);
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename='.$fileName);
        header('Content-Transfer-Encoding: binary');
    
        $f = fopen('php://output', 'w');
        fwrite($f, chr(0xEF).chr(0xBB).chr(0xBF));
        fputcsv($f, $data['header']);
        $sr_no = 1;
        foreach ($data['rows'] as $row) {
            // unset($row->id);
            $row->ID = $sr_no;
            
            $sr_no++;
            fputcsv($f, (array)$row); 
        }
        
        exit;
    }
	
	public function downloadExcelReport()
	{
	    ini_set('memory_limit','5000M');
        ini_set('max_execution_time','500000');
 
 
        if(isset($_GET['all_sheet'])){
            $result = $this->all_record();
        }else{
            if(isset($_GET['month'])){
                $month = $_GET['month'];
            }else{
                $month = date('Y-m');
            }
            $result = $this->all_record($month);
        }
        
		$fileName = 'active_colletion_sheet_'.date('Y-m-d').'.csv'; // File is to create
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();

                                   

                                        $data['header'][] = 'SR. #';
                                        $data['header'][] = 'Date';
                                        $data['header'][] = 'Lag Time';
                                        $data['header'][] = 'Location';
                                        $data['header'][] = 'MRN';
                                        $data['header'][] = 'Case Id';
                                        $data['header'][] = 'Patients Name';
                                        $data['header'][] = 'Billed';
                                        $data['header'][] = 'Paid';
                                        $data['header'][] = 'Outstanding';
                                        $data['header'][] = 'Settlement Amount';
                                        $data['header'][] = 'Settlement %Age';
                                        $data['header'][] = 'Provider ID';
                                        $data['header'][] = 'Provider';
                                        $data['header'][] = 'Paper';
                                        $data['header'][] = 'Stay Issue?';
                                        $data['header'][] = 'Consolidation Issue?';
                                        $data['header'][] = 'Insurance Company';
                                        $data['header'][] = 'Confirmation Letter Received?';
                                        $data['header'][] = 'Confirmation Letter Received Date';
                                        $data['header'][] = 'File Status';
                                        $data['header'][] = 'Action';
                                        $data['header'][] = 'File Assigned To';
                                        $data['header'][] = 'Assigned Date';
                                        $data['header'][] = 'Status';
                                        $data['header'][] = 'Status Date';
                                        $data['header'][] = 'Status Updated By';
                                        $data['header'][] = 'Owner';
                                        $data['header'][] = 'date';
                                		$data['rows']     = $result['record'];
                                
                                		 return $this->generate_csv($data,$fileName);
	}


}
