<?php

namespace App\Models;

use CodeIgniter\Model;

class ProviderListModel extends Model
{
    // Provider_List
	protected $DBGroup              = 'default';
	protected $table                = 'provider_list';
	protected $primaryKey           = 'id';
	protected $useAutoIncrement     = true;
	protected $insertID             = 0;
	protected $returnType           = 'array';
	protected $useSoftDelete        = false;
	protected $protectFields        = true;
	protected $allowedFields        =  ["id",
                                        "BusinessID_Current",
                                        "BUSINESS_NAME",
                                        "BusinessRegID",
                                        "Collection_Status",
                                        "Provider_Group",
                                        "Client"];

	// Dates
	protected $useTimestamps        = false;
	protected $dateFormat           = 'datetime';
	protected $createdField         = 'created_at';
	protected $updatedField         = 'updated_at';
	protected $deletedField         = 'deleted_at';

	// Validation
	protected $validationRules      = [];
	protected $validationMessages   = [];
	protected $skipValidation       = false;
	protected $cleanValidationRules = true;

	// Callbacks
	protected $allowCallbacks       = true;
	protected $beforeInsert         = [];
	protected $afterInsert          = [];
	protected $beforeUpdate         = [];
	protected $afterUpdate          = [];
	protected $beforeFind           = [];
	protected $afterFind            = [];
	protected $beforeDelete         = [];
	protected $afterDelete          = [];

	var $column_order = array('id', 'week_start', 'week_end', 'employee_id', 'employee_status');
	var $order = array('id' => 'desc');

	function get_datatables(){

		// search
		if($_POST['search']['value']){
			$search = $_POST['search']['value'];
			$where_query = "real_name LIKE '%$search%' OR alias LIKE '%$search%' OR alias LIKE '%$search%' OR designation LIKE '%$search%' OR department LIKE '%$search%'";
		} else {
			$where_query = "id != ''";
		}

		// order
		if(isset($_POST['order'])){
			$result_order = $this->column_order[$_POST['order']['0']['column']];
			$result_dir = $_POST['order']['0']['dir'];
		} else if ($this->order){
			$order = $this->order;
			$result_order = key($order);
			$result_dir = $order[key($order)];
		}


		if($_POST['length']!=-1);
		$db = db_connect();
		$builder = $db->table('employee_collection_details');
		$query = $builder->select('*')
				->where($where_query)
				->orderBy($result_order, $result_dir)
				->limit($_POST['length'], $_POST['start'])
				->get();
		return $query->getResult();

	}


	function total_records(){
		$sQuery = "SELECT COUNT(id) as id FROM  employee_collection_details";
		$db = db_connect();
		$query = $db->query($sQuery)->getRow();
		return $query;
	}

	function record_filter(){
		// kondisi_search
		if($_POST['search']['value']){
			$search = $_POST['search']['value'];
			$where_query = " AND (real_name LIKE '%$search%' OR alias LIKE '%$search%' OR alias LIKE '%$search%')";
		} else {
			$where_query = "";
		}
		$sQuery = "SELECT COUNT(id) as id FROM  employee_collection_details WHERE id != '' $where_query";
		$db = db_connect();
		$query = $db->query($sQuery)->getRow();
		return $query;
	}
}
