<?php
namespace App\Controllers;
use App\Controllers\BaseController;
use App\Models\Collections;
use App\Models\TargetAllotmentsModel;
use App\Models\SettingsModel;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Csv;
use App\Libraries\CSVReader;
use App\Libraries\ImportSheet;
use App\Traits\EmailTrait;
use App\Traits\TargetTrait;

class TargetAllotments extends BaseController
{
    use EmailTrait;
    use TargetTrait;
    
    public $settings;
    public $target_model;
    
    public function __construct(){
        parent::__construct();
        $setting_results = new SettingsModel();
        $this->settings = $setting_results->get()->getResult()[0];
        $this->target_model = new TargetAllotmentsModel();
    }
    
public function index()
{
   	return view('target_allotments/index');
}

public function file_verification(){
 return $this->target_details($_GET,__FUNCTION__);
}

public function gsb(){
    return $this->target_details($_GET,__FUNCTION__);
}

public function mlcr_collection(){
    return $this->target_details($_GET,__FUNCTION__);
}

public function mlcr_support(){
    return $this->target_details($_GET,__FUNCTION__);
}

public function wc_collection(){
    return $this->target_details($_GET,__FUNCTION__);
}

public function getEmployeeRecord($post){
        $Departments  = $post['Department'];
        $table        = 'allot_'.$Departments;
        $ID           = $post['ID'];
        $EmpID        = $post['EmpID'];
        $results      = $this->db2->table('employee_history eh')
                             ->select('eh.employee_id,eh.hrm_id,eh.first_name,eh.middle_name,
                                       eh.last_name,eh.business_email as email,eh.maiden_name,eh.hire_date,
                                       eh.original_hire_date,divisions.name div_name,divisions.id div_id,eh.pseudo,
                                       eh.shift,`eh`.`super_visor_id`,
                                       ( SELECT
                                             CONCAT(first_name, " ", last_name)
                                           FROM
                                             employee_history
                                             WHERE employee_history.employee_id= eh.`super_visor_id`
    
                                         ) AS manager,
                                         ( SELECT
                                             employee_history.business_email
                                           FROM
                                             employee_history
                                             WHERE employee_history.employee_id= eh.`super_visor_id`
    
                                         ) AS manager_email 
                                         ')
                                         
                             ->join('user','eh.email = user.email')
                             ->join('divisions','eh.division_id = divisions.id')
                             ->where(['eh.hrm_id'=>$EmpID,'user.status'=>1])
                             ->get()
                             ->getResult();

        $data['status']          = 'fail';
        $data['status_code']          = false;
        $data['message']         = 'data not found successfully';
        $data['employee_detail'] = [];
        $data['monthly_target']  = [];
        $data['ID']              = "";
        $data['Departments']     = '';
        $data['EmpID']           = '';
        $data['shift']           = [];
        $status_code             = '302';
        $data['table']           = '';
        $message                 = 'No data found';

        if($results){
//   phs.*,
            if($results[0]->shift){
                    $shift_holiday = $this->db2->query("
                                                        SELECT
                                                      
                                                        (SELECT
                                                        CONCAT(ph.`start_date`,',',ph.`end_date`)
                                                        FROM
                                                        payroll_holiday ph
                                                        WHERE ph.payrl_holi_id = phs.`payrl_holi_id`) AS holiday_date
                                                
                                                        FROM
                                                        `payroll_holiday_shift_wise` phs
                                                        WHERE phs.`shift_id` = {$results[0]->shift};
                                                ")->getResult();   
            }else{
                $shift_holiday = [];
            }

            $data['status']          = 'success';
            
            $data['status_code']          =true;
            $data['message']         = 'data found successfully';
            $data['employee_detail'] = $results;
            $data['table']           = $table;
            $data['ID']              = $ID;
            $data['EmpID']           = $EmpID;
            $data['shift']           = $shift_holiday;
            $data['Departments']     = $Departments;
            $data['monthly_target']  = $this->db->table($table)->where('ID',$ID)->get()->getResult();
            $data['settings']        = $this->db->table('settings')->get()->getResult()[0];
            $status_code             = '200';
            $message                 = 'Data found';
        }
        return $data;
}

public function allotment_forms($data,$post){
    if($data['status'] == 'success'){
        $Departments = $post['Department'];
        return view('target_allotments/templates/'.$Departments.'_temp',$data);
    }else{
        $Departments = $post['Department'];
        return view('target_allotments/templates/error_temp',$data);
    }
}

public function showTargetForm(){
    if ($this->request->getMethod() == 'post') {
        $post        = $this->request->getPost();
    }
    $data = $this->getEmployeeRecord($post);
    return $this->allotment_forms($data,$post);
}


public function approvedAndSend(){
    if ($this->request->getMethod() == 'post') {
        $post        = $this->request->getPost();
        $Departments = $post['Department'];
        $table       = 'allot_'.$Departments;
        $data = $this->getEmployeeRecord($post);
        // echo '<pre>';
        // print_r($data['status']);die;
        $rdata['status'] = 'fail';
        $rdata['message'] = 'data not found successfully';
        $status_code = '302';
        $message     = 'No data found';
        $rdata['email_status'] = 0;
        // print_r($rdata);die;
        if($data['status']=='success'){

            $target_allotment_id = $post["ID"];
            $Email_Token  = md5($post['EmpID']);
            //$emailmessage = 'You have target allotment form please check your target form <a href="'.base_url("employee_target_form?empID={$post['EmpID']}&id={$target_allotment_id}&department={$Departments}&token={$Email_Token}").'">click here</a>';
            // $email_text = "")."";
              $md['username'] = $data['employee_detail'][0]->first_name. ' ' .$data['employee_detail'][0]->last_name;
              $md['date'] = $data['monthly_target'][0]->Date;
            //   ,['username'=>$username,'date'=>$date_target]
            $md['link'] = base_url("employee_target_form?empID={$post['EmpID']}&id={$target_allotment_id}&department={$Departments}&token={$Email_Token}");
              $email_text     = view('target_allotments/email_template/approve_and_send',$md);
              
            //   $emailmessage = htmlspecialchars_decode($this->settings[0]->App_Url.'app/Views/target_allotments/email_template/approve_and_send');
            // $response =  1;
            // $response =  $this->sendMail($data['employee_detail'][0]->email,$email_text,$this->settings);
            $response =  $this->send_email_data($data['employee_detail'][0]->email,$email_text,$this->settings);
            if($response >=1){
                $rdata['status'] = 'success';
                $rdata['message'] = 'email successfully Sent';
                $status_code = '200';
                $message     = 'Data Transfered Successfully';
                $Email_Sent  = $this->target_model->updateEmailStatus($Departments,$target_allotment_id,$post['EmpID']);
                $rdata['Email_Sent'] =
                ($Email_Sent[0]->Email_Sent > 1 ? 'Sent ('.$Email_Sent[0]->Email_Sent.')' : 'Sent');
            }else{
                $rdata['status'] = 'fail';
                $rdata['message'] = $response;
                $status_code = '502';
                $message     = 'bad_gateway';
                $Email_Sent  = 0;
                $rdata['Email_Sent'] = $Email_Sent;
            }
        }
        return $this->response->setStatusCode($status_code,$message)->setJSON($rdata);
    }
}

    public function add_table_example(){
    	$post    = $this->request->getPost();
        if ($this->request->getMethod() == "post") {
            if(isset($post['department']) && !empty($post['department'])){
                $department         = $post['department'];
                $table_name         = 'allot_'.$department;
                $exl_header         = tables_fields_count($table_name,['Date','Email_Sent','Target_Status','ID','Rejected_Date','Accepted_Date']);
                $data               = [];
                $result             = $this->db->table($table_name)->select('*')->get()->getResult()[0];
                foreach($exl_header as $key=>$value){
                    $data['header'][] = implode(" ",explode("_",$value));
                    for($i=0;$i<1;$i++){
                        $data['row'][$i][] = $result->{$value};
                    }
                }
                $mult_array['table'] = $table_name;
                $mult_array['data']  = json_encode($data);
                $this->db->table('example_table')->insert($mult_array);	
             }
        }
    }   

    

    public function download_example(){
        $post    = $this->request->getPost();
        if ($this->request->getMethod() == "post") {
            if(isset($post['department']) && !empty($post['department'])){
                $department         = $post['department'];
                $table_name         = 'allot_'.$department;
                $result             = $this->db->table('example_table')->select('*')->where('table',$table_name)->get()->getResult()[0];
                generate_csv(json_decode($result->data),$department.'.csv');
                return redirect()->to(base_url('target_allotments/'.$department));
            }
        }    
    }


    public function importSheet(){
    	$post    = $this->request->getPost();
    	$session = session();
    	if ($this->request->getMethod() == "post") {
			$department = $post['department'];
            $table = 'allot_'.$department;
			$file_mimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			$arr_file = explode('.', $_FILES['upload_file']['name']);
			 $extension = end($arr_file);
			if($extension !='csv'){
                $session->setFlashdata('error', 'Only Csv File You Can Import');
                return redirect()->to(base_url('target_allotments/'.$department));
            }

            if('csv' == $extension){
				$reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
			} else {
				$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
			}   
            
			$spreadsheet = $reader->load($_FILES['upload_file']['tmp_name']);
     
			$sheetData   = $spreadsheet->getActiveSheet()->toArray();
 
			if($sheetData){
			
                $total_array        = [];
            
                $table_fields       = tables_fields_count($table,['Date','Email_Sent','Target_Status','ID','Rejected_Date','Accepted_Date','Email_Token'],'count');
            
                $table_fields_data  = tables_fields_count($table,['Date','Email_Sent','Target_Status','ID','Rejected_Date','Accepted_Date','Email_Token']);
            
                $sheet_columns      = sheet_fields_count($sheetData[0]);
            
                if($sheet_columns > $table_fields || $sheet_columns < $table_fields){
            
                    $session->setFlashdata('error', 'Something Went Wrong Sheet Not Imported Successfully Check The Fields Carefully');
            
                    return redirect()->to(base_url('target_allotments/'.$department));
            
                }
            
            }
            $selected_date = date('Y-m',strtotime($post['date']));
            $this->db->transStart();
            foreach($sheetData as $key=>$value){
				if($key>0){
				    // echo check_import_month($department,$value,$selected_date);die;
                    if(check_import_month($department,$value,$selected_date)){
                        $session->setFlashdata('error', 'Date Start and Date End is not matching with selected month');
                        return redirect()->to(base_url('target_allotments/'.$department.'?month='.$post['date']));
                    }
                    foreach($table_fields_data as $t_key=>$t_value){
                        $mult_array[$t_value] = $value[$t_key];
                    }
                    $mult_array['Date'] = $post['date'];
                    $this->target_model->insert_records($table,$mult_array);	
				}
	    	}
            $this->db->transComplete();
            if($this->db->transStatus() === true){
                $session->setFlashdata('success', 'Data Imported Successfully');
                return redirect()->to(base_url('target_allotments/'.$department.'?month='.$post['date']));
            }else{
                $session->setFlashdata('error', 'Something went wrong');
                return redirect()->to(base_url('target_allotments/'.$department.'?month='.$post['date']));
            }
	}else{
        $session->setFlashdata('error', 'Something went wrong');
        return redirect()->to(base_url('target_allotments/'.$department));
    }

}
    
    public function employee_target_form(){
            $success = 1;
            $post['EmpID'] = "";
            $post['ID']= "";
            $post['Department']= "";
            if(isset($_GET['empID']) && isset($_GET['id']) && isset($_GET['department']) && isset($_GET['token'])){
                $post['EmpID'] = $_GET['empID'];
                $post['ID'] = $_GET['id'];
                $post['Department'] = $_GET['department'];
                $post['Email_Token'] = $_GET['token'];
                $departments = ['file_verification','gsb','mlcr_collection','mlcr_support','wc_collection'];
                if(in_array($post['Department'],$departments))
                {    
                    $data = $this->getEmployeeRecord($post);
                    $data['is_employee'] =  1; 
                    $match_data_with_token = $this->db->table('allot_'.$post['Department'])->select('*')->where(['id'=>$post['ID'],'Email_Token'=>$post['Email_Token']])->get()->getResult();
                    if($match_data_with_token){
                        return $this->allotment_forms($data,$post);
                    }else{
                        return view('target_allotments/templates/error_temp');
                    }
                    
                }else{
                    return view('target_allotments/templates/error_temp');
                }
            }else{
                return view('target_allotments/templates/error_temp');
            }
            
       
    }
    
    public function send_email_data($email,$message,$setting){
          return $this->sendMail($email,$message,$setting);
    }

    public function target_assigned_employee(){
        if ($this->request->getMethod() == "post") {
        
            $post    = $this->request->getPost();
      
            $department = $post['Department'];
         
            $table = 'allot_'.$department;
         
            $id = $post['ID'];
            $date = date('Y-m-d');
            if(!empty($post['ID']) &&
               !empty($post['Department']) &&
               !empty($post['EmpID']) && 
               !empty($post['status'])
               ){
                 
            
                    if($post['status'] == 2){
                        
                        $data = $this->getEmployeeRecord($post);
                        // ,'Rejected_Date','Accepted_Date'
                        
                        $this->db->query('update '.$table.' set Target_Status = 2,Rejected_Date='.date('Y-m-d').' where ID = '.$id)->getResult();

                        // $message = $post['EmpID'] . '('.$data['Departments'].') Rejected the ' . $data['monthly_target'][0]->Date . ' Target ';
                      
                        // $message .= 'Reason: '.$post['reason'];
                        
                        // $emailmessage = htmlspecialchars_decode($message);
                        
                        // $this->sendMail($data['employee_detail'][0]->manager_email,$message,$this->settings);
                        
                        $md['username'] = $data['employee_detail'][0]->first_name. ' ' .$data['employee_detail'][0]->last_name;
                        $md['manager'] = $data['employee_detail'][0]->manager;
                        $md['date'] = $data['monthly_target'][0]->Date;
                        $md['reason'] = $post['reason'];
                        $message = view('target_allotments/email_template/target_rejected',$md);
                        
                        $this->sendMail($data['employee_detail'][0]->manager_email,$message,$this->settings);
                        
                        $rdata['message'] = 'Target is rejected by employee, email sent to the supervisor';

                        $rdata['target']  = 'Rejected';

                        $rdata['status']  = 'fail';

                        return $this->response->setJSON($rdata); 

                    }

                    $upload_document['document_type'] = 51;
                  
                    $upload_document['employee_id'] = $post['employee_id'];
                  
                    $upload_document['documents']   = $post['EmpID'].'-'.date('Ymdhis').'.pdf';
                    
                    $upload_document['created_date'] = date('Y-m-d');
                    
                    $this->db->query('update '.$table.' set Target_Status = 1, Accepted_Date="'.$date.'" where ID = '.$id)->getResult();
                    
                    $status_check = $this->db->query("select * from {$table} where ID = {$id}")->getResult();

                    if($status_check[0]->Target_Status == 1){

                        $data = $this->getEmployeeRecord($post);

                        $dompdf = new \Dompdf\Dompdf(); 
                   
                        $data['pdf_extra_style']  = 1;
                        
                        $dompdf->loadHtml($this->allotment_forms($data,$post));
                      
                        $dompdf->setPaper('legal', 'portrait');
      
                        $dompdf->render();
    
                        // $dompdf->stream('download.pdf', array("Attachment" => 0));die;
                        
                        // $pdfroot    = FCPATH.'/target_folders/';
                        $pdfroot    = $this->settings->Hrm_Path;
                        
                        $pdf_string = $dompdf->output();
                        
                        $moved = file_put_contents($pdfroot.$upload_document['documents'], $dompdf->output()); 
                           
                        $this->db2->table('upload_documents')->insert($upload_document);
                        
                        // $emp_message = 'Great! your target allotment document is saved in your HRM profile in pdf form';
                        
                        // $send_emp_email = $this->send_email_data($data['employee_detail'][0]->email,$emp_message,$this->settings);
                        
                        // if($send_emp_email){
                            
                            // $manager_message = $post['EmpID'] . '('.$data['Departments'].') Accepted the ' . $data['monthly_target'][0]->Date . ' Target ';
                            
                            // $this->send_email_data($data['employee_detail'][0]->manager_email,$manager_message,$this->settings);
                            
                        // }
                        
                        //
                        
                        $md['username'] = $data['employee_detail'][0]->first_name. ' ' .$data['employee_detail'][0]->last_name;
                        // $md['date'] = $data['monthly_target'][0]->Date;
                        
                        $message = view('target_allotments/email_template/target_accepted',$md);
                        
                        $this->send_email_data($data['employee_detail'][0]->email,$message,$this->settings);
                        
                        
                        
                        $rdata['message'] = 'Accepted document moved successfully';
                        
                        $rdata['target']  = 'Accepted';
                           
                        $rdata['status']  = 'success';

                    }else{
                       
                        $rdata['message'] = 'Something went wrong';
                        
                        $rdata['target']  = 'Error';
                        
                        $rdata['status']  = 'fail';

                    }
            }else{

                $rdata['message'] = 'Something went wrong';
                
                $rdata['target']  = 'Error';
                
                $rdata['status']  = 'fail';

            }

            return $this->response->setJSON($rdata); 
          
        }
    }

    public function checkEmailExists(){
        $post    = $this->request->getPost();
    
        if ($this->request->getMethod() == "post") {
            $rdata['status']  = 'fail';
            $rdata['message'] = 'data not found successfully';
            $status_code      = '302';
            $message          = 'No data found';
            $rdata['data']    = [];
            $rdata['emailCount'] = 0;

            if(!isset($post['ids'])){
                $rdata['status'] = 'post_error';
                return $this->response->setJSON($rdata);
            }
            
            $ID = explode(', ',$post['ids']);
            $department = $post['department'];
            $table = 'allot_'.$department;
            $table_data =  $this->target_model->target_pending_cancelled($table,$post['date'],$ID);
            $empIDs = [];
            foreach($table_data as $key=>$value){
                $empIDs[] = $value->EMP_ID;
            }
  
           if($empIDs){
                $rdata['status']  = 'success';
                $rdata['message'] = 'data found successfully';
                $status_code      = '200';
                $message          = 'data found';
                foreach($empIDs as $r_key=>$r_value){
                    $results = $this->db2->table('employee_history eh')
                                         ->select('eh.hrm_id,eh.business_email as email')
                                         ->join('user','eh.email=user.email')
                                         ->join('divisions','eh.division_id=divisions.id')
                                         ->where('hrm_id',$r_value)
                                         ->where(['user.status'=>1])
                                         ->get()->getResultArray();
                    $empIDS_found= [];
                    $i = 0;
                    if($results){
                        $empIDS_found['empID'] = $results[0]['hrm_id'];
                        $empIDS_found['empEmail'] = $results[0]['email'];
                        $empIDS_found['department'] = $department;
                        $empIDS_found['allotment_id'] = $ID[$r_key];
                        $empIDS_found['Date'] = $ID[$r_key];
                        $empIDS_found['message'] = 'Found';
                        $i++;
                    }else{
                        $empIDS_found['empID']  = $r_value;
                        $empIDS_found['empEmail'] = '';
                        $empIDS_found['department'] = $department;
                        $empIDS_found['allotment_id'] = $ID[$r_key];
                        $empIDS_found['message'] = 'Email Not Found';
                    }
                    $rdata['data'][]    = $empIDS_found;   
                }
                $rdata['emailCount'] = count($empIDs);
                
           }else{
                $rdata['status']  = 'fail';
                $rdata['message'] = 'data not found successfully';
                $status_code      = '302';
                $message          = 'data found';
                $rdata['emailCount'] = 0;
                $rdata['data']      = [];
           }
           return $this->response->setJSON($rdata);  
        }
    }

    public function delete_targets(){
        $post    = $this->request->getPost();
        if ($this->request->getMethod() == "post") {
            $ID = explode(",",$post['ids']);
            $department = $post['department'];
            $table = 'allot_'.$department;
            $status_code = 302;
            $message = 'Fail Deletes';
            $data['status'] = 'failed';
            $delete_links = $this->target_model->delete_targets($table,$ID);
            if($delete_links){
                $status_code = 200;
                $message = 'Deleted';
                $data['status'] = 'success';
            }
            return $this->response->setStatusCode($status_code,$message)->setJSON($data);
        }
    }


}

