<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\Collections;
use App\Models\IncentiveTrackerSampleModel;
// Import Excel Package
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Csv;
use App\Libraries\CSVReader;
class IncentiveTrackerSample extends BaseController
{


    /**
     * Returns the amount of weeks into the month a date is
     * @param $date a YYYY-MM-DD formatted date
     * @param $rollover The day on which the week rolls over
     */
   
function workingDays($year,$month){

	$days = cal_days_in_month(CAL_GREGORIAN, $month, $year); // 31
	$j = 1;
		$countWorkingDays = 0;
		for($i =0;$i<$days;$i++){
			$newDate = date('Y-m-d', strtotime(date('Y-m-d'). ' + '.$j.' days'));
			if(date("D", strtotime($newDate)) !='Sat' && date("D", strtotime($newDate)) !='Sat'){
					$countWorkingDays+=1;
			}
			$j++;
		}
		return $countWorkingDays;
}

public function all_record(){
    $result = $this->db->table('incentive_tracker')->select('*');
    if(isset($_GET['month']) && !empty($_GET['month'])){
      $date_month = trim($_GET['month']);
      $result = $result->where("DATE_FORMAT(STR_TO_DATE(Date_Start,'%m/%d/%Y'),'%Y-%m') >=", $date_month);
    }else{
      $result = $result->where("DATE_FORMAT(STR_TO_DATE(Date_Start,'%m/%d/%Y'),'%Y-%m') >=", date('Y-m'));
    }
    
    if(isset($_GET['month_end']) && !empty($_GET['month_end'])){
      $month_end = trim($_GET['month_end']);
      $result = $result->where("DATE_FORMAT(STR_TO_DATE(Date_Start,'%m/%d/%Y'),'%Y-%m') <=", $month_end);
    }else{
      $result = $result->where("DATE_FORMAT(STR_TO_DATE(Date_Start,'%m/%d/%Y'),'%Y-%m') <=", date('Y-m'));
    }
    $result = $result->get()->getResult();
    $data['result'] = $result;
    return $data;
}

public function lastID(){
    $result =   $this->db->query('select * from incentive_tracker order by Id desc limit 1')->getResult();
    if(!$result){
        echo 1;
    }else{
    echo $result[0]->Id+1;    
    }
    
}


public function index()
{
    $result = $this->db->table('incentive_tracker')->select('*');
    if(isset($_GET['month']) && !empty($_GET['month'])){
      $date_month = trim($_GET['month']);
      $result = $result->where("DATE_FORMAT(STR_TO_DATE(Date_Start,'%m/%d/%Y'),'%Y-%m') >=", $date_month);
    }else{
      $result = $result->where("DATE_FORMAT(STR_TO_DATE(Date_Start,'%m/%d/%Y'),'%Y-%m') >=", date('Y-m'));
    }
    
    if(isset($_GET['month_end']) && !empty($_GET['month_end'])){
      $month_end = trim($_GET['month_end']);
      $result = $result->where("DATE_FORMAT(STR_TO_DATE(Date_Start,'%m/%d/%Y'),'%Y-%m') <=", $month_end);
    }else{
      $result = $result->where("DATE_FORMAT(STR_TO_DATE(Date_Start,'%m/%d/%Y'),'%Y-%m') <=", date('Y-m'));
    }
    
    $result = $result->get()->getResult();
    $data['result'] = $result;
  	return view('incentive_tracker_sample/index',$data);
}

    public function update(){
	    if ($this->request->getMethod() == 'post') {
	        try{
	            $post  = $this->request->getPost();
                $result= $this->db->table('incentive_tracker')->select('*')->where('Id',$post['Id'])->get()->getResult();
                $model = new IncentiveTrackerSampleModel();   
                $error = 0;
                if($result){
                    if(!empty(trim($post['Month_Year']))){
                  
                        $post['Month_Year'] = date("F Y", strtotime(trim($post['Month_Year'])));
                        $update = $model->update($post['Id'], $post);   
                             $error= 1;
                    }else{
                             
                             $error= 0;
                    }
                }else{
                    $this->db->transStart();
                    // $post['Month_Year'] = trim($post['Month_Year']);
                    $post['Month_Year'] = date("F Y", strtotime(trim($post['Month_Year'])));
				    $update = $model->insert($post);
				    $this->db->transComplete();
				    $error= 1;
                }
                echo $error;
	        }catch(Exception $e){
	            echo $e->getMessage();
	        }
	    		
        }    
    }

    public function delete($table){
         if ($this->request->getMethod() == 'post') {
            	$post = $this->request->getPost();
                $this->db->query('delete from incentive_tracker where Id = '.$post['Id'])->getResult();
                // if($update == 1){
                //     echo 1;
                // }else{
                //     echo 0;
                // }
         }
    }
    
    public function importSheet(){
             ini_set('memory_limit','5000M');
            ini_set('max_execution_time','500000');
    		$post = $this->request->getPost();

    		$session = session();
    	if ($this->request->getMethod() == "post") {
					
					$file_mimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
					$arr_file = explode('.', $_FILES['upload_file']['name']);
					$extension = end($arr_file);
								
					if($extension !='xlsx' && $extension !='csv'){
                        $session->setFlashdata('error', 'Only Xlsx and Csv File You Can Import');
                        return redirect()->to(base_url('incentive_tracker_sample/'));
                    }
                    
					if('csv' == $extension){
						$reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
					} else {
						$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
					}
					$spreadsheet = $reader->load($_FILES['upload_file']['tmp_name']);
					$sheetData = $spreadsheet->getActiveSheet()->toArray();
					if($sheetData){
						$total_array = [];
                        $table_descriptions = $this->db->query('describe incentive_tracker')->getResult();
                    
                        if($table_descriptions){
                            $table_fields = count($table_descriptions)-1;
                            $sheet_columns = count($sheetData[0])-1;
                    
                            if($sheet_columns > $table_fields || $sheet_columns < $table_fields){
                                $session->setFlashdata('error', 'Something Went Wrong Sheet Not Imported Successfully Check The Fields Carefully');
                                return redirect()->to(base_url('incentive_tracker_sample/'));
                            }
                        }
                        
                            $model  = new IncentiveTrackerSampleModel();  
                            $result =  $model->table('incentive_tracker')->select('*');
                            
                            if(isset($post['month']) && !empty($post['month'])){
                              $date_month = trim($post['month']);
                              $result = $result->where("DATE_FORMAT(STR_TO_DATE(Date_Start,'%m/%d/%Y'),'%Y-%m') >=", $date_month);
                            }else{
                              $result = $result->where("DATE_FORMAT(STR_TO_DATE(Date_Start,'%m/%d/%Y'),'%Y-%m') >=", date('Y-m'));
                            }
                            
                            if(isset($post['month_end']) && !empty($post['month_end'])){
                              $month_end = trim($post['month_end']);
                              $result = $result->where("DATE_FORMAT(STR_TO_DATE(Date_Start,'%m/%d/%Y'),'%Y-%m') <=", $month_end);
                            }else{
                              $result = $result->where("DATE_FORMAT(STR_TO_DATE(Date_Start,'%m/%d/%Y'),'%Y-%m') <=", date('Y-m'));
                            }
                            
                            $result   = $result->delete();
                            
                            
                            
                            
                          $this->db->transStart();
						foreach($sheetData as $key=>$value){
							if($key>0){
							    if(!empty(trim($value[2]))){
							        
							          $mult_array['Incentive_Type'] = trim($value[1]);
							          $day_month = date("F Y", strtotime(trim($value[2])));
                                       $mult_array['Month_Year'] = $day_month;
                                    //   $foo = preg_replace('/\s+/', ' ', $value[2]);
                                       $mult_array['Date_Range'] = trim($value[3]);
                                       $mult_array['Date_Start'] = trim($value[4]);
                                       $mult_array['Date_End'] = trim($value[5]);
                                       $mult_array['Employment_ID'] = trim($value[6]);
                                       $mult_array['Employee_Name'] = trim($value[7]);
                                       $mult_array['Alias'] = trim($value[8]);
                                       $mult_array['Center'] = trim($value[9]);
                                       $mult_array['Department'] = trim($value[10]);
                                       $mult_array['Designation'] = trim($value[11]);
                                       $mult_array['Incentive_PKR'] = trim($value[12]);
                                       $mult_array['Status'] = trim($value[13]);
                                       $mult_array['RECEIVED_FROM_AUDIT'] = trim($value[14]);
                                       $mult_array['SUBMITED_TO_FINANCE'] = trim($value[15]);
                                       $mult_array['PROCESSED_BY_FINANCE'] = trim($value[16]);
                                       $mult_array['TRANSACTION_TYPE'] = trim($value[17]);
                                       
                                      $employe_id = trim($value[6]);
                                      $date_start = trim($value[4]);
                                      $date_end   = trim($value[5]);
                                      $data_found = $this->db->query("select * from incentive_tracker where Date_Start = '$date_start' and Employment_ID = '$employe_id'  ")->getResult();
                                    //   if($data_found){
                                  
                                    //     $update = $model->update($data_found[0]->Id, $mult_array);
                                    //   }else{
                                        $this->db->table('incentive_tracker')->insert($mult_array);    
                                    //   }
                                      
                                      
                                       
							    }  
							}
							
						}
				
			            $this->db->transComplete();
			            
  
						if($this->db->transStatus() === true){
						  //  $this->db->query('delete from incentive_tracker_sample')->getResult();
				
				    //         $collection = new Collections;
	
				    
				            $session->setFlashdata('success', 'Data Imported Successfully');
				            // date("Y-m", strtotime($_GET['month']));
				            return redirect()->to(base_url('incentive_tracker_sample?month='.$post['month'].'&month_end='.$post['month_end']));
						}else{
						    $session->setFlashdata('error', 'Something went wrong');
                    	  return redirect()->to(base_url('incentive_tracker_sample?month='.$post['month'].'&month_end='.$post['month_end']));
						}
							
					}else{

					}
					}

   			
        }

	
	public function downloadExcelReport()
	{
	    
		$result = $this->all_record();
// 		print_r($result);die;
		$fileName = 'active_colletion_sheet_'.date('Y-m-d').'.csv'; // File is to create
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A1', 'SR');
        $sheet->setCellValue('B1', 'Incentive Type');
        $sheet->setCellValue('C1', 'Month Year');
        $sheet->setCellValue('D1', 'Date Range');
        $sheet->setCellValue('E1', 'Date Start');
        $sheet->setCellValue('F1', 'Date End');
        $sheet->setCellValue('G1', 'Employment ID');
        $sheet->setCellValue('H1', 'Employee Name');
        $sheet->setCellValue('I1', 'Alias');
        $sheet->setCellValue('J1', 'Center');
        $sheet->setCellValue('K1', 'Department');
        $sheet->setCellValue('L1', 'Designation');
        $sheet->setCellValue('M1', 'Incentive PKR');
        $sheet->setCellValue('N1', 'Status');
        $sheet->setCellValue('O1', 'RECEIVED FROM AUDIT');
        $sheet->setCellValue('P1', 'SUBMITED TO FINANCE');
        $sheet->setCellValue('Q1', 'PROCESSED BY FINANCE');
        $sheet->setCellValue('R1', 'TRANSACTION TYPE');

		$rows = 2;
		$rows2 = 2;
		$j = 1; 
		$k = 1;

		foreach ($result['result'] as $key=>$value) {
			$start = 0;
			$days_increment = 5; 
			$end = 3; 
			$weeks = intval(date("t")/5);
			
			    $sheet->setCellValue('A' . $rows, $k);
        		$sheet->setCellValue('B' . $rows, $value->Incentive_Type);
                $sheet->setCellValue('C' . $rows, date("F Y", strtotime(trim($value->Month_Year))));
                $sheet->setCellValue('D' . $rows, $value->Date_Range);
                $sheet->setCellValue('E' . $rows, $value->Date_Start);
                $sheet->setCellValue('F' . $rows, $value->Date_End);
                $sheet->setCellValue('G' . $rows, $value->Employment_ID);
                $sheet->setCellValue('H' . $rows, $value->Employee_Name);
                $sheet->setCellValue('I' . $rows, $value->Alias);
                $sheet->setCellValue('J' . $rows, $value->Center);
                $sheet->setCellValue('K' . $rows, $value->Department);
                $sheet->setCellValue('L' . $rows, $value->Designation);
                $sheet->setCellValue('M' . $rows, $value->Incentive_PKR);
                $sheet->setCellValue('N' . $rows, $value->Status);
                $sheet->setCellValue('O' . $rows, $value->RECEIVED_FROM_AUDIT);
                $sheet->setCellValue('P' . $rows, $value->SUBMITED_TO_FINANCE);
                $sheet->setCellValue('Q' . $rows, $value->PROCESSED_BY_FINANCE);
                $sheet->setCellValue('R' . $rows, $value->TRANSACTION_TYPE);
			$k++;
			$rows++;
		}


		$writer = new Csv($spreadsheet);

		// file inside /public folder
		$filepath = $fileName;

		$writer->save($filepath);

// 		header("Content-Type: application/vnd.ms-excel");
        header("Content-Type: application/csv; ");
		header('Content-Disposition: attachment; filename="' . basename($filepath) . '"');

		header('Expires: 0');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		header('Content-Length: ' . filesize($filepath));
		
		flush(); // Flush system output buffer
		readfile($filepath);

		exit;
	}



}
