<?php
namespace App\Controllers;
use App\Controllers\BaseController;
use App\Models\Collections;
use App\Models\TargetAllotmentsModel;
use App\Models\SettingsModel;
use App\Traits\EmailTrait;
class CollectionJobs extends BaseController
{

    use EmailTrait;
    public $settings;
    public $target_model;

    public function __construct(){
        parent::__construct();
        $setting_results = new SettingsModel();
        $this->settings = $setting_results->get()->getResult()[0];
        $this->target_model = new TargetAllotmentsModel();
    }

    public function check_collectors_target_status(){
        $departments = ['file_verification','gsb','mlcr_collection','mlcr_support','wc_collection'];

        for($i = 0;$i<count($departments);$i++){
            $result = $this->checkEmailExists('allot_'.$departments[$i],$departments[$i]);
            if($result){
                $email_sents = [];
                foreach($result as $key=>$value){

                    $target_allotment_id = $value['allotment_id'];

                    $Email_Token         = md5($value['empID']);

                    $md['username']      = $value['emp_details']['first_name']. ' ' .$value['emp_details']['last_name'];

                    $md['date']          = $value['Date'];

                    $Departments         = $value['department'];

                    $md['link']          = base_url("employee_target_form?empID={$value['empID']}&id={$target_allotment_id}&department={$Departments}&token={$Email_Token}");

                    $email_text          = view('target_allotments/email_template/approve_and_send',$md);

                    $response =  $this->sendMail($value['empEmail'],$email_text,$this->settings);

                    $this->target_model->updateEmailStatus($value['department'],$value['allotment_id'],$value['empID']);

                    echo "result found and updated\n";
                }
            }else{
                echo "no result found\n";
            }
        }
    }

    public function checkEmailExists($table,$department){
            $rdata = [];
            $current_date = date('Y-m');
            // $table_data =  $this->target_model->target_pending_cancelled($table,$current_date);
            $table_data = $this->db->table($table)->select('*')->where('Date',$current_date)->whereIn('Target_Status',['2'])->get()->getResult();
            $empIDs = [];
            foreach($table_data as $key=>$value){
                    $results = $this->db2->table('employee_history eh')
                                         ->select('eh.employee_id,eh.hrm_id,eh.first_name,eh.middle_name,
                                         eh.last_name,eh.business_email as email,eh.maiden_name,eh.hire_date,
                                         eh.original_hire_date,divisions.name div_name,eh.pseudo,
                                         eh.shift,`eh`.`super_visor_id`,
                                         ( SELECT
                                                 CONCAT(first_name, " ", last_name)
                                             FROM
                                                 employee_history
                                                 WHERE employee_history.employee_id= eh.`super_visor_id`

                                             ) AS manager,
                                             ( SELECT
                                                 employee_history.business_email
                                             FROM
                                                 employee_history
                                                 WHERE employee_history.employee_id= eh.`super_visor_id`

                                             ) AS manager_email
                                             ')
                                         ->join('user','eh.email=user.email')
                                         ->join('divisions','eh.division_id=divisions.id')
                                         ->where('hrm_id',$value->EMP_ID)
                                         ->where(['user.status'=>1])
                                         ->get()->getResultArray();
                    $i = 0;
                    $empIDS_found= [];
                    if($results){
                        $target_allotment_id = $value->ID;
                        $hrm_id = $results[0]['hrm_id'];
                        $empIDS_found['empID'] = $results[0]['hrm_id'];
                        $empIDS_found['empEmail'] = $results[0]['email'];
                        $empIDS_found['department'] = $department;
                        $empIDS_found['allotment_id'] = $target_allotment_id;
                        $empIDS_found['Date'] = $value->Date;
                        $empIDS_found['emp_details'] = $results[0];
                        $empIDS_found['message'] = 'Found';
                        if($results[0]['email']){
                            // $response =  $this->sendMail($results[0]['email'],$emailmessage,$this->settings);
                            $empIDS_found['message'] = 'Email Found';
                        }else{
                            // $response =  $this->sendMail($results[0]['email'],$emailmessage,$this->settings);
                            $empIDS_found['message'] = 'email not found';
                        }
                    }

                    if($empIDS_found){
                        $rdata[] = $empIDS_found;
                    }
            }
            return $rdata;
    }

}
